/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.app.FXGLApplication;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.audio.AudioKt;
import com.almasb.fxgl.audio.AudioType;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.audio.impl.DesktopAudioService;
import com.almasb.fxgl.core.asset.AssetLoaderService;
import com.almasb.fxgl.core.asset.AssetType;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.cutscene.dialogue.DialogueGraph;
import com.almasb.fxgl.cutscene.dialogue.DialogueGraphSerializer;
import com.almasb.fxgl.cutscene.dialogue.DialogueNode;
import com.almasb.fxgl.cutscene.dialogue.SerializableGraph;
import com.almasb.fxgl.cutscene.dialogue.StartNode;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.entity.level.LevelLoader;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.ui.FontFactory;
import com.almasb.fxgl.ui.UI;
import com.almasb.fxgl.ui.UIController;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.UninitializedPropertyAccessException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0004J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J#\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u00100\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u00102\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\u0004J\u0016\u00103\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u0002082\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u00109\u001a\u00020:2\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010;\u001a\u00020<2\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010=\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020\u0004J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00040@2\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010A\u001a\u00020B2\u0006\u0010\u001f\u001a\u00020\u0004J\u001e\u0010A\u001a\u00020B2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DJ\u0016\u0010F\u001a\u00020G2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010H\u001a\u00020IJ\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040@2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u0017j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/almasb/fxgl/app/services/FXGLAssetLoaderService;", "Lcom/almasb/fxgl/core/asset/AssetLoaderService;", "()V", "AI_DIR", "", "ASSETS_DIR", "CSS_DIR", "CURSORS_DIR", "DIALOGUES_DIR", "FONTS_DIR", "JSON_DIR", "LEVELS_DIR", "MUSIC_DIR", "PROPERTIES_DIR", "SCRIPTS_DIR", "SOUNDS_DIR", "TEXTURES_DIR", "TEXT_DIR", "TMX_DIR", "UI_DIR", "audioService", "Lcom/almasb/fxgl/audio/impl/DesktopAudioService;", "cachedAssets", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "log", "Lcom/almasb/fxgl/logging/Logger;", "clearCache", "", "getAssetFromCache", "name", "getStream", "Ljava/io/InputStream;", "getURL", "Ljava/net/URL;", "load", "T", "assetType", "Lcom/almasb/fxgl/core/asset/AssetType;", "fileName", "(Lcom/almasb/fxgl/core/asset/AssetType;Ljava/lang/String;)Ljava/lang/Object;", "loadCSS", "Lcom/almasb/fxgl/scene/CSS;", "loadCursorImage", "Ljavafx/scene/image/Image;", "loadDialogueGraph", "Lcom/almasb/fxgl/cutscene/dialogue/DialogueGraph;", "loadFont", "Lcom/almasb/fxgl/ui/FontFactory;", "loadImage", "loadLevel", "Lcom/almasb/fxgl/entity/level/Level;", "levelLoader", "Lcom/almasb/fxgl/entity/level/LevelLoader;", "loadMusic", "Lcom/almasb/fxgl/audio/Music;", "loadPropertyMap", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "loadResourceBundle", "Ljava/util/ResourceBundle;", "loadSound", "Lcom/almasb/fxgl/audio/Sound;", "loadText", "", "loadTexture", "Lcom/almasb/fxgl/texture/Texture;", "width", "", "height", "loadUI", "Lcom/almasb/fxgl/ui/UI;", "controller", "Lcom/almasb/fxgl/ui/UIController;", "readAllLines", "fxgl"})
public final class FXGLAssetLoaderService
extends AssetLoaderService {
    private final String ASSETS_DIR = "/assets/";
    private final String TEXTURES_DIR = this.ASSETS_DIR + "textures/";
    private final String SOUNDS_DIR = this.ASSETS_DIR + "sounds/";
    private final String MUSIC_DIR = this.ASSETS_DIR + "music/";
    private final String TEXT_DIR = this.ASSETS_DIR + "text/";
    private final String JSON_DIR = this.ASSETS_DIR + "json/";
    private final String TMX_DIR = this.ASSETS_DIR + "tmx/";
    private final String SCRIPTS_DIR = this.ASSETS_DIR + "scripts/";
    private final String PROPERTIES_DIR = this.ASSETS_DIR + "properties/";
    private final String AI_DIR = this.ASSETS_DIR + "ai/";
    private final String LEVELS_DIR = this.ASSETS_DIR + "levels/";
    private final String DIALOGUES_DIR = this.ASSETS_DIR + "dialogues/";
    private final String UI_DIR = this.ASSETS_DIR + "ui/";
    private final String CSS_DIR = this.UI_DIR + "css/";
    private final String FONTS_DIR = this.UI_DIR + "fonts/";
    private final String CURSORS_DIR = this.UI_DIR + "cursors/";
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    private final DesktopAudioService audioService = new DesktopAudioService();
    private final HashMap<String, Object> cachedAssets;

    public <T> T load(@NotNull AssetType assetType, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)assetType, (String)"assetType");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        if (assetType == AssetType.DIALOGUE) {
            return (T)this.loadDialogueGraph(fileName);
        }
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadImage(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXTURES_DIR + name);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return (Image)t;
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Image image = new Image(it);
                this.cachedAssets.put(this.TEXTURES_DIR + name, image);
                Image image2 = image;
                return image2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load texture " + name, (Throwable)e);
            return ImagesKt.getDummyImage();
        }
    }

    @NotNull
    public final Texture loadTexture(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new Texture(this.loadImage(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Texture loadTexture(@NotNull String name, double width, double height) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String cacheKey = this.TEXTURES_DIR + name + "@" + width + "x" + height;
        Object asset = this.getAssetFromCache(cacheKey);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return new Texture((Image)t);
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Texture texture = new Texture(new Image(it, width, height, false, true));
                this.cachedAssets.put(cacheKey, texture.getImage());
                Texture texture2 = texture;
                return texture2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load texture " + name, (Throwable)e);
            return new Texture(ImagesKt.getDummyImage());
        }
    }

    @NotNull
    public final Sound loadSound(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.SOUNDS_DIR + name);
        if (asset != null) {
            Object t = Sound.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Sound::class.java.cast(asset)");
            return (Sound)t;
        }
        try {
            Sound sound = new Sound(this.audioService.loadAudio(AudioType.SOUND, this.getURL(this.SOUNDS_DIR + name)));
            this.cachedAssets.put(this.SOUNDS_DIR + name, sound);
            return sound;
        }
        catch (Exception e) {
            this.log.warning("Failed to load sound " + name, (Throwable)e);
            return new Sound(AudioKt.getDummyAudio());
        }
    }

    @NotNull
    public final Music loadMusic(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.MUSIC_DIR + name);
        if (asset != null) {
            Object t = Music.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Music::class.java.cast(asset)");
            return (Music)t;
        }
        try {
            Music music = new Music(this.audioService.loadAudio(AudioType.MUSIC, this.getURL(this.MUSIC_DIR + name)));
            this.cachedAssets.put(this.MUSIC_DIR + name, music);
            return music;
        }
        catch (Exception e) {
            this.log.warning("Failed to load music " + name, (Throwable)e);
            return new Music(AudioKt.getDummyAudio());
        }
    }

    @NotNull
    public final List<String> loadText(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXT_DIR + name);
        if (asset != null) {
            return (List)asset;
        }
        List<String> text = this.readAllLines(this.TEXT_DIR + name);
        this.cachedAssets.put(this.TEXT_DIR + name, text);
        return text;
    }

    @NotNull
    public final Level loadLevel(@NotNull String name, @NotNull LevelLoader levelLoader) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)levelLoader, (String)"levelLoader");
        return levelLoader.load(this.getURL(this.LEVELS_DIR + name), FXGL.Companion.getGameWorld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DialogueGraph loadDialogueGraph(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.DIALOGUES_DIR + name);
        if (asset != null) {
            return DialogueGraphSerializer.INSTANCE.fromSerializable((SerializableGraph)asset);
        }
        try {
            Closeable closeable = this.getStream(this.DIALOGUES_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                SerializableGraph graph = (SerializableGraph)new ObjectMapper().readValue(it, SerializableGraph.class);
                Map map = this.cachedAssets;
                String string = this.DIALOGUES_DIR + name;
                SerializableGraph serializableGraph = graph;
                Intrinsics.checkExpressionValueIsNotNull((Object)serializableGraph, (String)"graph");
                map.put(string, serializableGraph);
                DialogueGraph dialogueGraph = DialogueGraphSerializer.INSTANCE.fromSerializable(graph);
                return dialogueGraph;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load dialogue graph " + name, (Throwable)e);
            DialogueGraph dummyGraph = new DialogueGraph(0, 1, null);
            dummyGraph.addNode((DialogueNode)new StartNode("Failed to load dialogue graph " + name + " : " + e));
            return dummyGraph;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ResourceBundle loadResourceBundle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.PROPERTIES_DIR + name);
        if (asset != null) {
            return (ResourceBundle)asset;
        }
        try {
            Closeable closeable = this.getStream(this.PROPERTIES_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream = it;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                boolean bl3 = false;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset2);
                Reader reader = inputStreamReader;
                PropertyResourceBundle bundle = new PropertyResourceBundle(reader);
                this.cachedAssets.put(this.PROPERTIES_DIR + name, bundle);
                ResourceBundle resourceBundle = bundle;
                return resourceBundle;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load resource bundle " + name, (Throwable)e);
            return new ListResourceBundle(){

                @NotNull
                protected Object[][] getContents() {
                    return new Object[0][];
                }
            };
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PropertyMap loadPropertyMap(@NotNull String name) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.ASSETS_DIR + name);
        if (asset != null) {
            return (PropertyMap)asset;
        }
        Iterable $this$filter$iv = this.readAllLines(this.ASSETS_DIR + name);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it, (char)'=', (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List tokens = StringsKt.split$default((CharSequence)it, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            String string = (String)tokens.get(0);
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = (String)tokens.get(1);
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            bl2 = false;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            Pair pair = TuplesKt.to((Object)string3, (Object)string5);
            collection.add(pair);
        }
        Map map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        PropertyMap pMap = PropertyMap.Companion.fromStringMap(map);
        ((Map)this.cachedAssets).put(this.ASSETS_DIR + name, pMap);
        return pMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadCursorImage(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            Closeable closeable = this.getStream(this.CURSORS_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Image image = new Image(it);
                return image;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load cursor image " + name, (Throwable)e);
            return ImagesKt.getDummyImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UI loadUI(@NotNull String name, @NotNull UIController controller2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)controller2, (String)"controller");
        try {
            Closeable closeable = this.getStream(this.UI_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                FXMLLoader loader = new FXMLLoader();
                loader.setController((Object)controller2);
                Parent root = (Parent)loader.load(it);
                controller2.init();
                Parent parent = root;
                Intrinsics.checkExpressionValueIsNotNull((Object)parent, (String)"root");
                UI uI = new UI(parent, controller2);
                return uI;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load FXML " + name, (Throwable)e);
            this.log.warning("Failed to load UI, so controller.init() will not be called");
            return new UI((Parent)new Pane(), controller2);
        }
    }

    @NotNull
    public final CSS loadCSS(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            String string = this.getURL(this.CSS_DIR + name).toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getURL(CSS_DIR + name).toExternalForm()");
            return new CSS(string);
        }
        catch (Exception e) {
            this.log.warning("Failed to load css " + name, (Throwable)e);
            return new CSS("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FontFactory loadFont(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.FONTS_DIR + name);
        if (asset != null) {
            Object t = FontFactory.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"FontFactory::class.java.cast(asset)");
            return (FontFactory)t;
        }
        try {
            Closeable closeable = this.getStream(this.FONTS_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Font font = Font.loadFont((InputStream)it, (double)12.0);
                if (font == null) {
                    throw (Throwable)new IllegalArgumentException("Font.loadFont(" + name + ") returned null");
                }
                Font font2 = font;
                FontFactory fontFactory = new FontFactory(font2);
                ((Map)this.cachedAssets).put(this.FONTS_DIR + name, fontFactory);
                FontFactory fontFactory2 = fontFactory;
                return fontFactory2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load font " + name, (Throwable)e);
            Font font = Font.font((double)12.0);
            Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"Font.font(12.0)");
            return new FontFactory(font);
        }
    }

    @NotNull
    public final InputStream getStream(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        InputStream inputStream = this.getURL(name).openStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"getURL(name).openStream()");
        return inputStream;
    }

    private final URL getURL(String name) {
        GameApplication app;
        Object object;
        Object object2;
        this.log.debug("Loading from file system: " + name);
        try {
            object2 = FXGLApplication.Companion.getApp();
        }
        catch (UninitializedPropertyAccessException e) {
            object2 = null;
        }
        if ((object = (app = object2)) == null || (object = object.getClass()) == null || (object = ((Class)object).getResource(name)) == null) {
            object2 = name;
            int n = 1;
            StringBuilder stringBuilder = new StringBuilder().append("/fxgl");
            Class<?> clazz = ((Object)((Object)this)).getClass();
            boolean bl = false;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object3).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String string2 = string;
            object = clazz.getResource(stringBuilder.append(string2).toString());
        }
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("Asset \"" + name + "\" was not found!");
        }
        return object;
    }

    private final Object getAssetFromCache(String name) {
        Object asset = this.cachedAssets.get(name);
        if (asset != null) {
            this.log.debug("Loading from cache: " + name);
            return asset;
        }
        return null;
    }

    private final List<String> readAllLines(String name) {
        try {
            InputStream inputStream = this.getStream(name);
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            return TextStreamsKt.readLines((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        }
        catch (Exception e) {
            this.log.warning("Failed to load plain text file " + name, (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    public final void clearCache() {
        this.log.debug("Clearing assets cache");
        this.cachedAssets.clear();
    }

    public FXGLAssetLoaderService() {
        FXGLAssetLoaderService fXGLAssetLoaderService = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        fXGLAssetLoaderService.cachedAssets = hashMap;
    }
}

