/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.RuntimeInfo;
import com.almasb.fxgl.app.services.IOTaskExecutorService;
import com.almasb.fxgl.app.services.UpdaterService;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.NetService;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/app/services/UpdaterService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "appMode", "Lcom/almasb/fxgl/app/ApplicationMode;", "log", "Lcom/almasb/fxgl/logging/Logger;", "netService", "Lcom/almasb/fxgl/net/NetService;", "runtimeInfo", "Lcom/almasb/fxgl/app/RuntimeInfo;", "taskService", "Lcom/almasb/fxgl/app/services/IOTaskExecutorService;", "urlPOM", "", "checkForUpdates", "", "getLatestVersionTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "getLatestVersionTask$fxgl", "needCheckForUpdate", "", "needCheckForUpdate$fxgl", "onInit", "fxgl"})
public final class UpdaterService
extends EngineService {
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    private NetService netService;
    private IOTaskExecutorService taskService;
    @Inject(value="applicationMode")
    private ApplicationMode appMode;
    @Inject(value="runtimeInfo")
    private RuntimeInfo runtimeInfo;
    @Inject(value="urlPOM")
    private String urlPOM;

    public void onInit() {
        if (this.needCheckForUpdate$fxgl()) {
            this.checkForUpdates();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean needCheckForUpdate$fxgl() {
        ApplicationMode applicationMode = this.appMode;
        if (applicationMode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appMode");
        }
        if (applicationMode == ApplicationMode.RELEASE) return false;
        RuntimeInfo runtimeInfo = this.runtimeInfo;
        if (runtimeInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeInfo");
        }
        if (StringsKt.contains$default((CharSequence)runtimeInfo.getVersion(), (CharSequence)"project.version", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final void checkForUpdates() {
        this.log.debug("Checking for updates");
        IOTask task2 = this.getLatestVersionTask$fxgl().onSuccess((Consumer)new Consumer<String>(this){
            final /* synthetic */ UpdaterService this$0;

            public final void accept(String latestVersion) {
                if (Intrinsics.areEqual((Object)UpdaterService.access$getRuntimeInfo$p(this.this$0).getVersion(), (Object)latestVersion) ^ true) {
                    UpdaterService.access$getLog$p(this.this$0).info("Your current version:  " + UpdaterService.access$getRuntimeInfo$p(this.this$0).getVersion());
                    UpdaterService.access$getLog$p(this.this$0).info("Latest stable version: " + latestVersion);
                }
            }
            {
                this.this$0 = updaterService;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ UpdaterService this$0;

            public final void accept(Throwable error) {
                UpdaterService.access$getLog$p(this.this$0).warning("Failed to find updates: " + error);
            }
            {
                this.this$0 = updaterService;
            }
        });
        IOTaskExecutorService iOTaskExecutorService = this.taskService;
        if (iOTaskExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"taskService");
        }
        IOTask iOTask = task2;
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"task");
        iOTaskExecutorService.runAsync(iOTask);
    }

    @NotNull
    public final IOTask<String> getLatestVersionTask$fxgl() {
        NetService netService = this.netService;
        if (netService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"netService");
        }
        String string = this.urlPOM;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"urlPOM");
        }
        IOTask iOTask = netService.openStreamTask(string).thenWrap((Function)getLatestVersionTask.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"netService\n            .\u2026          }\n            }");
        return iOTask;
    }

    public static final /* synthetic */ RuntimeInfo access$getRuntimeInfo$p(UpdaterService $this) {
        RuntimeInfo runtimeInfo = $this.runtimeInfo;
        if (runtimeInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeInfo");
        }
        return runtimeInfo;
    }

    public static final /* synthetic */ void access$setRuntimeInfo$p(UpdaterService $this, RuntimeInfo runtimeInfo) {
        $this.runtimeInfo = runtimeInfo;
    }

    public static final /* synthetic */ Logger access$getLog$p(UpdaterService $this) {
        return $this.log;
    }
}

