/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dev.profiling;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactoryService;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 A2\u00020\u0001:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00109\u001a\u00020\u0012H\u0002J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020;H\u0016J\u0010\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020;2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u00106\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0018\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\nR\u0011\u0010\"\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000eR\u000e\u0010$\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\nR\u0011\u0010*\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000eR\u000e\u0010,\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u00060.j\u0002`/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\f05X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/almasb/fxgl/dev/profiling/ProfilerService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "avgFPS", "", "getAvgFPS", "()I", "avgMemoryUsage", "", "getAvgMemoryUsage", "()F", "avgMemoryUsageRounded", "", "getAvgMemoryUsageRounded", "()J", "avgTimeTook", "getAvgTimeTook", "avgTimeTookRounded", "", "getAvgTimeTookRounded", "()Ljava/lang/String;", "currentFPS", "currentMemoryUsage", "getCurrentMemoryUsage", "currentMemoryUsageRounded", "getCurrentMemoryUsageRounded", "currentTimeTook", "fps", "<set-?>", "frames", "getFrames", "gcRuns", "maxMemoryUsage", "getMaxMemoryUsage", "maxMemoryUsageRounded", "getMaxMemoryUsageRounded", "memoryUsage", "memoryUsageCurrent", "memoryUsageMax", "memoryUsageMin", "minMemoryUsage", "getMinMemoryUsage", "minMemoryUsageRounded", "getMinMemoryUsageRounded", "prevNanoTime", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "text", "Ljavafx/scene/text/Text;", "timeBuffer", "Ljava/util/LinkedList;", "timeTook", "uiService", "Lcom/almasb/fxgl/ui/UIFactoryService;", "buildInfoText", "onExit", "", "onInit", "onUpdate", "tpf", "", "update", "Companion", "fxgl"})
public final class ProfilerService
extends EngineService {
    private SceneService sceneService;
    private UIFactoryService uiService;
    private int frames = 1;
    private int fps;
    private int currentFPS;
    private long currentTimeTook;
    private final LinkedList<Long> timeBuffer = new LinkedList();
    private long timeTook;
    private long memoryUsage;
    private long memoryUsageMin = Long.MAX_VALUE;
    private long memoryUsageMax;
    private long memoryUsageCurrent;
    private int gcRuns;
    private long prevNanoTime;
    private Text text;
    private final StringBuilder sb = new StringBuilder(128);
    private static final Runtime runtime;
    private static final float MB = 1048576.0f;
    private static final int TIME_BUFFER_CAPACITY = 120;
    public static final Companion Companion;

    public final int getFrames() {
        return this.frames;
    }

    public final int getAvgFPS() {
        return this.fps / this.frames;
    }

    public final long getAvgTimeTook() {
        return this.timeTook / (long)this.frames;
    }

    @NotNull
    public final String getAvgTimeTookRounded() {
        String string = "%.2f";
        Object[] objectArray = new Object[]{(double)this.getAvgTimeTook() / 1000000.0};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    public final float getAvgMemoryUsage() {
        return (float)(this.memoryUsage / (long)this.frames) / 1048576.0f;
    }

    public final long getAvgMemoryUsageRounded() {
        return MathKt.roundToLong((float)this.getAvgMemoryUsage());
    }

    public final float getMaxMemoryUsage() {
        return (float)this.memoryUsageMax / 1048576.0f;
    }

    public final long getMaxMemoryUsageRounded() {
        return MathKt.roundToLong((float)this.getMaxMemoryUsage());
    }

    public final float getMinMemoryUsage() {
        return (float)this.memoryUsageMin / 1048576.0f;
    }

    public final long getMinMemoryUsageRounded() {
        return MathKt.roundToLong((float)this.getMinMemoryUsage());
    }

    public final float getCurrentMemoryUsage() {
        return (float)this.memoryUsageCurrent / 1048576.0f;
    }

    public final long getCurrentMemoryUsageRounded() {
        return MathKt.roundToLong((float)this.getCurrentMemoryUsage());
    }

    public void onInit() {
        UIFactoryService uIFactoryService = this.uiService;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiService");
        }
        Text text = uIFactoryService.newText("", Color.RED, FontType.MONO, 22.0);
        Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"uiService.newText(\"\", Co\u2026RED, FontType.MONO, 22.0)");
        Text text2 = this.text = text;
        if (text2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        text2.setText(this.buildInfoText());
        Text text3 = this.text;
        if (text3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        text3.setTranslateY(25.0);
        Text text4 = this.text;
        if (text4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        Bounds bounds = text4.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"text.layoutBounds");
        double d = bounds.getWidth();
        Text text5 = this.text;
        if (text5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        Bounds bounds2 = text5.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds2, (String)"text.layoutBounds");
        Rectangle bg = new Rectangle(d, bounds2.getHeight(), (Paint)Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.7));
        Node[] nodeArray = new Node[2];
        nodeArray[0] = (Node)bg;
        Text text6 = this.text;
        if (text6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        nodeArray[1] = (Node)text6;
        Pane pane = new Pane(nodeArray);
        pane.setMouseTransparent(true);
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
        }
        double d2 = sceneService.getAppHeight();
        Text text7 = this.text;
        if (text7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        Bounds bounds3 = text7.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds3, (String)"text.layoutBounds");
        pane.setTranslateY(d2 - bounds3.getHeight());
        SceneService sceneService2 = this.sceneService;
        if (sceneService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
        }
        Collection collection = (Collection)sceneService2.getOverlayRoot().getChildren();
        boolean bl = false;
        collection.add(pane);
    }

    public void onUpdate(double tpf) {
        if (this.prevNanoTime == 0L) {
            this.prevNanoTime = System.nanoTime();
            return;
        }
        int fps = MathKt.roundToInt((double)(1.0 / tpf));
        long curNanoTime = System.nanoTime();
        long timeTook = curNanoTime - this.prevNanoTime;
        this.prevNanoTime = curNanoTime;
        this.timeBuffer.addLast(timeTook);
        if (this.timeBuffer.size() > 120) {
            this.timeBuffer.removeFirst();
        }
        this.update(fps, (long)CollectionsKt.averageOfLong((Iterable)this.timeBuffer));
        Text text = this.text;
        if (text == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"text");
        }
        text.setText(this.buildInfoText());
    }

    private final void update(int fps, long timeTook) {
        int n = this.frames;
        this.frames = n + 1;
        this.currentFPS = fps;
        this.currentTimeTook = timeTook;
        this.fps += fps;
        this.timeTook += timeTook;
        long used = runtime.totalMemory() - runtime.freeMemory();
        if (used < 0L) {
            return;
        }
        if (used < this.memoryUsageCurrent) {
            int n2 = this.gcRuns;
            this.gcRuns = n2 + 1;
        }
        this.memoryUsageCurrent = used;
        this.memoryUsage += this.memoryUsageCurrent;
        if (this.memoryUsageCurrent > this.memoryUsageMax) {
            this.memoryUsageMax = this.memoryUsageCurrent;
        }
        if (this.memoryUsageCurrent < this.memoryUsageMin) {
            this.memoryUsageMin = this.memoryUsageCurrent;
        }
    }

    private final String buildInfoText() {
        this.sb.setLength(0);
        String string = "%.1f";
        Object[] objectArray = new Object[]{(double)this.currentTimeTook / 1000000.0};
        StringBuilder stringBuilder = this.sb.append("FPS: ").append(this.currentFPS).append("\nLast Frame (ms): ");
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        String string3 = string2;
        stringBuilder.append(string3).append("\nNow Mem (MB): ").append(this.getCurrentMemoryUsageRounded()).append("\nAvg Mem (MB): ").append(this.getAvgMemoryUsageRounded()).append("\nMin Mem (MB): ").append(this.getMinMemoryUsageRounded()).append("\nMax Mem (MB): ").append(this.getMaxMemoryUsageRounded());
        String string4 = this.sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sb.toString()");
        return string4;
    }

    public void onExit() {
        Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
        log.info("Processed Frames: " + this.frames);
        log.info("Average FPS: " + this.getAvgFPS());
        log.info("Avg Frame Took: " + this.getAvgTimeTookRounded() + " ms");
        log.info("Avg Memory Usage: " + this.getAvgMemoryUsageRounded() + " MB");
        log.info("Min Memory Usage: " + this.getMinMemoryUsageRounded() + " MB");
        log.info("Max Memory Usage: " + this.getMaxMemoryUsageRounded() + " MB");
        log.info("Estimated GC runs: " + this.gcRuns);
    }

    static {
        Companion = new Companion(null);
        runtime = Runtime.getRuntime();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/almasb/fxgl/dev/profiling/ProfilerService$Companion;", "", "()V", "MB", "", "TIME_BUFFER_CAPACITY", "", "runtime", "Ljava/lang/Runtime;", "kotlin.jvm.PlatformType", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

