/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.multiplayer;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.dsl.multiplayer.MultiplayerService;
import com.almasb.fxgl.dsl.multiplayer.NetworkComponent;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.MouseTrigger;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.TriggerListener;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.Connection;
import com.almasb.fxgl.net.MessageHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010\u001c\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0005\u001a6\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006j\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/almasb/fxgl/dsl/multiplayer/MultiplayerService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "replicatedEntitiesMap", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/net/Connection;", "Lcom/almasb/fxgl/core/serialization/Bundle;", "", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/HashMap;", "addEntityReplicationReceiver", "", "connection", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "addInputReplicationReceiver", "input", "Lcom/almasb/fxgl/input/Input;", "addInputReplicationSender", "onGameUpdate", "tpf", "", "spawn", "entity", "entityName", "", "updateReplicatedEntities", "entities", "fxgl"})
public final class MultiplayerService
extends EngineService {
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    private final HashMap<Connection<Bundle>, List<Entity>> replicatedEntitiesMap;

    public void onGameUpdate(double tpf) {
        if (this.replicatedEntitiesMap.isEmpty()) {
            return;
        }
        this.replicatedEntitiesMap.forEach(new BiConsumer<Connection<Bundle>, List<Entity>>(this){
            final /* synthetic */ MultiplayerService this$0;

            public final void accept(@NotNull Connection<Bundle> conn, @NotNull List<Entity> entities) {
                Intrinsics.checkParameterIsNotNull(conn, (String)"conn");
                Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
                Collection collection = entities;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    MultiplayerService.access$updateReplicatedEntities(this.this$0, conn, entities);
                }
            }
            {
                this.this$0 = multiplayerService;
            }
        });
    }

    private final void updateReplicatedEntities(Connection<Bundle> connection, List<Entity> entities) {
        Bundle updateBundle = new Bundle("ENTITY_UPDATES_EVENT");
        Bundle removeBundle = new Bundle("ENTITY_REMOVALS_EVENT");
        boolean bl = false;
        ArrayList removeIDs = new ArrayList();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl2 = false;
            Component component = it.getComponent(NetworkComponent.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"it.getComponent(NetworkComponent::class.java)");
            int networkID = ((NetworkComponent)component).getId();
            if (it.isActive()) {
                updateBundle.put(String.valueOf(networkID), (Serializable)new Vec2(it.getPosition()));
                continue;
            }
            Collection collection = removeIDs;
            Integer n = networkID;
            boolean bl3 = false;
            collection.add(n);
        }
        Object object = updateBundle.getData();
        boolean bl4 = false;
        if (!object.isEmpty()) {
            connection.send((Object)updateBundle);
        }
        object = removeIDs;
        bl4 = false;
        if (!object.isEmpty()) {
            removeBundle.put("removeIDs", (Serializable)removeIDs);
            connection.send((Object)removeBundle);
        }
        entities.removeIf(updateReplicatedEntities.2.INSTANCE);
    }

    public final void spawn(@NotNull Connection<Bundle> connection, @NotNull Entity entity, @NotNull String entityName) {
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)entityName, (String)"entityName");
        if (!entity.hasComponent(NetworkComponent.class)) {
            this.log.warning("Attempted to network-spawn entity " + entityName + ", but it does not have NetworkComponent");
            return;
        }
        NetworkComponent networkComponent = (NetworkComponent)entity.getComponent(NetworkComponent.class);
        StringBuilder stringBuilder = new StringBuilder().append("ENTITY_SPAWN_EVENT_");
        NetworkComponent networkComponent2 = networkComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)networkComponent2), (String)"networkComponent");
        Bundle bundle = new Bundle(stringBuilder.append(networkComponent2.getId()).toString());
        bundle.put("entityName", (Serializable)((Object)entityName));
        bundle.put("x", (Serializable)Double.valueOf(entity.getX()));
        bundle.put("y", (Serializable)Double.valueOf(entity.getY()));
        ArrayList arrayList = this.replicatedEntitiesMap.getOrDefault(connection, new ArrayList());
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"replicatedEntitiesMap.ge\u2026(connection, ArrayList())");
        List list = arrayList;
        Collection collection = list;
        boolean bl = false;
        collection.add(entity);
        ((Map)this.replicatedEntitiesMap).put(connection, list);
        connection.send((Object)bundle);
    }

    public final void addEntityReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull GameWorld gameWorld) {
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)gameWorld, (String)"gameWorld");
        connection.addMessageHandlerFX((MessageHandler)new MessageHandler<Bundle>(gameWorld){
            final /* synthetic */ GameWorld $gameWorld;

            /*
             * WARNING - void declaration
             */
            public final void onReceive(Connection<Bundle> $noName_0, Bundle message) {
                if (StringsKt.startsWith$default((String)message.getName(), (String)"ENTITY_SPAWN_EVENT", (boolean)false, (int)2, null)) {
                    String string = StringsKt.removePrefix((String)message.getName(), (CharSequence)"ENTITY_SPAWN_EVENT_");
                    boolean bl = false;
                    int id = Integer.parseInt(string);
                    String entityName = (String)message.get("entityName");
                    double x = ((Number)message.get("x")).doubleValue();
                    double y = ((Number)message.get("y")).doubleValue();
                    Entity e = this.$gameWorld.spawn(entityName, x, y);
                    e.getComponentOptional(NetworkComponent.class).ifPresent((Consumer)new Consumer<NetworkComponent>(id){
                        final /* synthetic */ int $id;

                        public final void accept(@NotNull NetworkComponent it) {
                            Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                            it.setId(this.$id);
                        }
                        {
                            this.$id = n;
                        }
                    });
                }
                if (StringsKt.startsWith$default((String)message.getName(), (String)"ENTITY_UPDATES_EVENT", (boolean)false, (int)2, null)) {
                    message.getData().forEach((BiConsumer)new BiConsumer<String, Serializable>(this){
                        final /* synthetic */ addEntityReplicationReceiver.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void accept(@NotNull String idString, @NotNull Serializable vec2) {
                            void $this$filterTo$iv$iv;
                            Intrinsics.checkParameterIsNotNull((Object)idString, (String)"idString");
                            Intrinsics.checkParameterIsNotNull((Object)vec2, (String)"vec2");
                            String string = idString;
                            boolean bl = false;
                            int id = Integer.parseInt(string);
                            Vec2 position = (Vec2)vec2;
                            Iterable $this$filter$iv = this.this$0.$gameWorld.getEntitiesByComponent(NetworkComponent.class);
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                Entity it = (Entity)element$iv$iv;
                                boolean bl2 = false;
                                Component component = it.getComponent(NetworkComponent.class);
                                Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"it.getComponent(NetworkComponent::class.java)");
                                if (!(((NetworkComponent)component).getId() == id)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$forEach$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                Entity it = (Entity)element$iv;
                                boolean bl3 = false;
                                it.setPosition(position);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                if (StringsKt.startsWith$default((String)message.getName(), (String)"ENTITY_REMOVALS_EVENT", (boolean)false, (int)2, null)) {
                    List removeIDs = (List)message.get("removeIDs");
                    Iterable $this$forEach$iv = removeIDs;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        void $this$filterTo$iv$iv;
                        int id = ((Number)element$iv).intValue();
                        boolean bl = false;
                        Iterable $this$filter$iv = this.$gameWorld.getEntitiesByComponent(NetworkComponent.class);
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            Entity it = (Entity)element$iv$iv;
                            boolean bl2 = false;
                            Component component = it.getComponent(NetworkComponent.class);
                            Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"it.getComponent(NetworkComponent::class.java)");
                            if (!(((NetworkComponent)component).getId() == id)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$forEach$iv2 = (List)destination$iv$iv;
                        boolean $i$f$forEach2 = false;
                        for (E element$iv2 : $this$forEach$iv2) {
                            Entity it = (Entity)element$iv2;
                            boolean bl3 = false;
                            it.removeFromWorld();
                        }
                    }
                }
            }
            {
                this.$gameWorld = gameWorld;
            }
        });
    }

    public final void addInputReplicationSender(@NotNull Connection<Bundle> connection, @NotNull Input input) {
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        input.addTriggerListener(new TriggerListener(connection){
            final /* synthetic */ Connection $connection;

            protected void onActionBegin(@NotNull Trigger trigger) {
                Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
                Bundle bundle = new Bundle("ActionBegin");
                if (trigger.isKey()) {
                    bundle.put("key", (Serializable)((KeyTrigger)trigger).getKey());
                } else {
                    bundle.put("btn", (Serializable)((MouseTrigger)trigger).getButton());
                }
                this.$connection.send((Object)bundle);
            }

            protected void onActionEnd(@NotNull Trigger trigger) {
                Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
                Bundle bundle = new Bundle("ActionEnd");
                if (trigger.isKey()) {
                    bundle.put("key", (Serializable)((KeyTrigger)trigger).getKey());
                } else {
                    bundle.put("btn", (Serializable)((MouseTrigger)trigger).getButton());
                }
                this.$connection.send((Object)bundle);
            }
            {
                this.$connection = $captured_local_variable$0;
            }
        });
    }

    public final void addInputReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull Input input) {
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        connection.addMessageHandlerFX((MessageHandler)new MessageHandler<Bundle>(input){
            final /* synthetic */ Input $input;

            /*
             * Unable to fully structure code
             */
            public final void onReceive(Connection<Bundle> $noName_0, Bundle message) {
                var3_3 = message.getName();
                switch (var3_3.hashCode()) {
                    case -1070586893: {
                        if (!var3_3.equals("ActionBegin")) break;
                        ** GOTO lbl8
                    }
                    case -2092728667: {
                        if (!var3_3.equals("ActionEnd")) break;
lbl8:
                        // 2 sources

                        isKeyTrigger = message.exists("key");
                        v0 = trigger = isKeyTrigger != false ? (Trigger)new KeyTrigger((KeyCode)message.get("key"), null, 2, null) : (Trigger)new MouseTrigger((MouseButton)message.get("btn"), null, 2, null);
                        if (Intrinsics.areEqual((Object)message.getName(), (Object)"ActionBegin")) {
                            this.$input.mockTriggerPress(trigger);
                            break;
                        }
                        this.$input.mockTriggerRelease(trigger);
                    }
                }
            }
            {
                this.$input = input;
            }
        });
    }

    public MultiplayerService() {
        MultiplayerService multiplayerService = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        multiplayerService.replicatedEntitiesMap = hashMap;
    }

    public static final /* synthetic */ void access$updateReplicatedEntities(MultiplayerService $this, Connection connection, List entities) {
        $this.updateReplicatedEntities((Connection<Bundle>)connection, entities);
    }
}

