/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.achievement.Achievement;
import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.GameController;
import com.almasb.fxgl.app.scene.FXGLMenu;
import com.almasb.fxgl.app.scene.MenuType;
import com.almasb.fxgl.app.services.IOTaskExecutorService;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.util.InputPredicates;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.input.view.TriggerView;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.profile.SaveFile;
import com.almasb.fxgl.profile.SaveLoadService;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.ui.FXGLScrollPane;
import com.almasb.fxgl.ui.FontType;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.Duration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0016\b&\u0018\u0000 `2\u00020\u0001:\u0003`abB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0004J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010'\u001a\u000204H$J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002052\u0006\u0010'\u001a\u000204H$J\u0018\u00106\u001a\u00020/2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H$J\b\u0010:\u001a\u00020\u0006H\u0004J\b\u0010;\u001a\u00020\u0006H\u0004J\u001e\u0010<\u001a\u0002012\u0006\u00102\u001a\u0002032\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0004J\u001e\u0010<\u001a\u0002012\u0006\u00102\u001a\u0002052\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060>H\u0004J\b\u0010?\u001a\u00020\u0006H\u0004J\b\u0010@\u001a\u00020\u0006H\u0004J\b\u0010A\u001a\u00020\u0006H\u0004J\b\u0010B\u001a\u00020\u0006H\u0004J\b\u0010C\u001a\u00020\u0006H\u0004J\b\u0010D\u001a\u00020\u0006H\u0004J\u0010\u0010E\u001a\u00020/2\u0006\u0010F\u001a\u000205H$J\u0010\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u000205H$J\u0010\u0010I\u001a\u00020/2\u0006\u0010J\u001a\u000205H$J\u0010\u0010K\u001a\u00020&2\u0006\u0010L\u001a\u00020MH\u0002J\b\u0010N\u001a\u00020&H\u0004J\u0010\u0010O\u001a\u00020&2\u0006\u0010L\u001a\u00020MH\u0004J\b\u0010P\u001a\u00020&H\u0004J\b\u0010Q\u001a\u00020&H\u0004J\u0010\u0010R\u001a\u00020&2\u0006\u0010L\u001a\u00020MH\u0004J\b\u0010S\u001a\u00020&H\u0004J\b\u0010T\u001a\u00020&H\u0004J\b\u0010U\u001a\u00020&H\u0004J\u0010\u0010V\u001a\u0002052\u0006\u0010W\u001a\u000205H\u0002J\b\u0010X\u001a\u000205H\u0002J\u0010\u0010Y\u001a\u00020&2\u0006\u0010Z\u001a\u000208H\u0014J\b\u0010[\u001a\u00020&H\u0004J\u0010\u0010\\\u001a\u00020&2\u0006\u0010]\u001a\u00020/H\u0014J\u0010\u0010^\u001a\u00020&2\u0006\u0010_\u001a\u00020/H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\n8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u001b\u0010\u0012\u001a\u00020\u00138DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0012\u0010\u001d\u001a\u00060\u001eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006c"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLMenu;", "Lcom/almasb/fxgl/scene/SubScene;", "type", "Lcom/almasb/fxgl/app/scene/MenuType;", "(Lcom/almasb/fxgl/app/scene/MenuType;)V", "EMPTY", "Lcom/almasb/fxgl/app/scene/FXGLMenu$MenuContent;", "getEMPTY$fxgl", "()Lcom/almasb/fxgl/app/scene/FXGLMenu$MenuContent;", "appHeight", "", "getAppHeight", "()I", "appHeight$delegate", "Lkotlin/Lazy;", "appWidth", "getAppWidth", "appWidth$delegate", "controller", "Lcom/almasb/fxgl/app/GameController;", "getController", "()Lcom/almasb/fxgl/app/GameController;", "controller$delegate", "menuContentRoot", "Ljavafx/scene/layout/Pane;", "getMenuContentRoot", "()Ljavafx/scene/layout/Pane;", "menuRoot", "getMenuRoot", "pressAnyKeyState", "Lcom/almasb/fxgl/app/scene/FXGLMenu$PressAnyKeyState;", "saveLoadService", "Lcom/almasb/fxgl/profile/SaveLoadService;", "getSaveLoadService", "()Lcom/almasb/fxgl/profile/SaveLoadService;", "getType", "()Lcom/almasb/fxgl/app/scene/MenuType;", "addNewInputBinding", "", "action", "Lcom/almasb/fxgl/input/UserAction;", "trigger", "Lcom/almasb/fxgl/input/Trigger;", "grid", "Ljavafx/scene/layout/GridPane;", "addUINode", "node", "Ljavafx/scene/Node;", "createActionButton", "Ljavafx/scene/control/Button;", "name", "Ljavafx/beans/binding/StringBinding;", "Ljava/lang/Runnable;", "", "createBackground", "width", "", "height", "createContentAchievements", "createContentAudio", "createContentButton", "contentSupplier", "Ljava/util/function/Supplier;", "createContentControls", "createContentCredits", "createContentFeedback", "createContentGameplay", "createContentLoad", "createContentVideo", "createProfileView", "profileName", "createTitleView", "title", "createVersionView", "version", "doSave", "saveFile", "Lcom/almasb/fxgl/profile/SaveFile;", "fireContinue", "fireDelete", "fireExit", "fireExitToMainMenu", "fireLoad", "fireNewGame", "fireResume", "fireSave", "makeSaveFileName", "rawName", "makeVersionString", "onUpdate", "tpf", "showProfileDialog", "switchMenuContentTo", "content", "switchMenuTo", "menuBox", "Companion", "MenuContent", "PressAnyKeyState", "fxgl"})
public abstract class FXGLMenu
extends SubScene {
    @NotNull
    private final SaveLoadService saveLoadService;
    @NotNull
    private final Lazy controller$delegate;
    @NotNull
    private final Lazy appWidth$delegate;
    @NotNull
    private final Lazy appHeight$delegate;
    @NotNull
    private final Pane menuRoot;
    @NotNull
    private final Pane menuContentRoot;
    @NotNull
    private final MenuContent EMPTY;
    private final PressAnyKeyState pressAnyKeyState;
    @NotNull
    private final MenuType type;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final SaveLoadService getSaveLoadService() {
        return this.saveLoadService;
    }

    @NotNull
    protected final GameController getController() {
        Lazy lazy = this.controller$delegate;
        FXGLMenu fXGLMenu = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GameController)lazy.getValue();
    }

    protected final int getAppWidth() {
        Lazy lazy = this.appWidth$delegate;
        FXGLMenu fXGLMenu = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    protected final int getAppHeight() {
        Lazy lazy = this.appHeight$delegate;
        FXGLMenu fXGLMenu = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    protected final Pane getMenuRoot() {
        return this.menuRoot;
    }

    @NotNull
    protected final Pane getMenuContentRoot() {
        return this.menuContentRoot;
    }

    @NotNull
    public final MenuContent getEMPTY$fxgl() {
        return this.EMPTY;
    }

    protected void onUpdate(double tpf) {
        if (this.type == MenuType.MAIN_MENU && FXGLForKtKt.getSettings().isUserProfileEnabled() && Intrinsics.areEqual((Object)FXGLForKtKt.getSettings().getProfileName().getValue(), (Object)"DEFAULT")) {
            this.showProfileDialog();
        }
    }

    protected void switchMenuTo(@NotNull Node menuBox) {
        Intrinsics.checkNotNullParameter((Object)menuBox, (String)"menuBox");
    }

    protected void switchMenuContentTo(@NotNull Node content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    @NotNull
    protected abstract Button createActionButton(@NotNull String var1, @NotNull Runnable var2);

    @NotNull
    protected abstract Button createActionButton(@NotNull StringBinding var1, @NotNull Runnable var2);

    @NotNull
    protected final Button createContentButton(@NotNull String name, @NotNull Supplier<MenuContent> contentSupplier) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(contentSupplier, (String)"contentSupplier");
        return this.createActionButton(name, new Runnable(this, contentSupplier){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ Supplier $contentSupplier;

            public final void run() {
                T t = this.$contentSupplier.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"contentSupplier.get()");
                this.this$0.switchMenuContentTo((Node)t);
            }
            {
                this.this$0 = fXGLMenu;
                this.$contentSupplier = supplier;
            }
        });
    }

    @NotNull
    protected final Button createContentButton(@NotNull StringBinding name, @NotNull Supplier<MenuContent> contentSupplier) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(contentSupplier, (String)"contentSupplier");
        return this.createActionButton(name, new Runnable(this, contentSupplier){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ Supplier $contentSupplier;

            public final void run() {
                T t = this.$contentSupplier.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"contentSupplier.get()");
                this.this$0.switchMenuContentTo((Node)t);
            }
            {
                this.this$0 = fXGLMenu;
                this.$contentSupplier = supplier;
            }
        });
    }

    private final String makeVersionString() {
        return "v" + FXGLForKtKt.getSettings().getVersion() + (FXGLForKtKt.getSettings().getApplicationMode() == ApplicationMode.RELEASE ? "" : "-" + (Object)((Object)FXGLForKtKt.getSettings().getApplicationMode()));
    }

    @NotNull
    protected abstract Node createBackground(double var1, double var3);

    @NotNull
    protected abstract Node createTitleView(@NotNull String var1);

    @NotNull
    protected abstract Node createVersionView(@NotNull String var1);

    @NotNull
    protected abstract Node createProfileView(@NotNull String var1);

    @NotNull
    protected final MenuContent createContentLoad() {
        log.debug("createContentLoad()");
        ListView list = FXGLForKtKt.getUIFactoryService().newListView();
        double FONT_SIZE = 16.0;
        list.setCellFactory((Callback)new Callback<ListView<SaveFile>, ListCell<SaveFile>>(FONT_SIZE){
            final /* synthetic */ double $FONT_SIZE;

            public final ListCell<SaveFile> call(ListView<SaveFile> param) {
                return (ListCell)new ListCell<SaveFile>(this){
                    final /* synthetic */ createContentLoad.1 this$0;

                    protected void updateItem(@Nullable SaveFile item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty || item == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            String string = "%-25.25s %s";
                            Object[] objectArray = new Object[]{item.getName(), item.getDateTime().format(DateTimeFormatter.ofPattern("dd-MM-yyyy HH-mm"))};
                            boolean bl = false;
                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                            String nameDate = string2;
                            Text text = FXGLForKtKt.getUIFactoryService().newText(nameDate, Color.WHITE, FontType.MONO, this.this$0.$FONT_SIZE);
                            this.setGraphic((Node)text);
                        }
                    }
                    {
                        this.this$0 = this$0;
                    }
                };
            }
            {
                this.$FONT_SIZE = d;
            }
        });
        IOTask task2 = this.saveLoadService.readSaveFilesTask("./", FXGLForKtKt.getSettings().getSaveFileExt()).onSuccess((Consumer)new Consumer<List<? extends SaveFile>>(list){
            final /* synthetic */ ListView $list;

            public final void accept(List<SaveFile> it) {
                ListView listView = this.$list;
                Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"list");
                ObservableList observableList = listView.getItems();
                List<SaveFile> list = it;
                Intrinsics.checkNotNullExpressionValue(list, (String)"it");
                observableList.addAll((Collection)list);
            }
            {
                this.$list = listView;
            }
        });
        IOTaskExecutorService iOTaskExecutorService = FXGL.Companion.getTaskService();
        IOTask iOTask = task2;
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"task");
        iOTaskExecutorService.runAsyncFXWithDialog(iOTask, FXGLForKtKt.localize("menu.load"));
        DoubleProperty doubleProperty = list.prefHeightProperty();
        ListView listView = list;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"list");
        doubleProperty.bind((ObservableValue)Bindings.size((ObservableList)listView.getItems()).multiply(FONT_SIZE).add(16));
        Button btnLoad = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.load"));
        BooleanProperty booleanProperty = btnLoad.disableProperty();
        ReadOnlyObjectProperty readOnlyObjectProperty = list.getSelectionModel().selectedItemProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyObjectProperty, (String)"list.selectionModel.selectedItemProperty()");
        booleanProperty.bind((ObservableValue)readOnlyObjectProperty.isNull());
        btnLoad.setOnAction((EventHandler)new EventHandler<ActionEvent>(this, list){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ ListView $list;

            public final void handle(ActionEvent e) {
                SaveFile saveFile;
                ListView listView = this.$list;
                Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"list");
                MultipleSelectionModel multipleSelectionModel = listView.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)multipleSelectionModel, (String)"list.selectionModel");
                SaveFile saveFile2 = saveFile = (SaveFile)multipleSelectionModel.getSelectedItem();
                Intrinsics.checkNotNullExpressionValue((Object)saveFile2, (String)"saveFile");
                this.this$0.fireLoad(saveFile2);
            }
            {
                this.this$0 = fXGLMenu;
                this.$list = listView;
            }
        });
        Button btnDelete = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.delete"));
        BooleanProperty booleanProperty2 = btnDelete.disableProperty();
        ReadOnlyObjectProperty readOnlyObjectProperty2 = list.getSelectionModel().selectedItemProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyObjectProperty2, (String)"list.selectionModel.selectedItemProperty()");
        booleanProperty2.bind((ObservableValue)readOnlyObjectProperty2.isNull());
        btnDelete.setOnAction((EventHandler)new EventHandler<ActionEvent>(this, list){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ ListView $list;

            public final void handle(ActionEvent e) {
                SaveFile saveFile;
                ListView listView = this.$list;
                Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"list");
                MultipleSelectionModel multipleSelectionModel = listView.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)multipleSelectionModel, (String)"list.selectionModel");
                SaveFile saveFile2 = saveFile = (SaveFile)multipleSelectionModel.getSelectedItem();
                Intrinsics.checkNotNullExpressionValue((Object)saveFile2, (String)"saveFile");
                this.this$0.fireDelete(saveFile2);
            }
            {
                this.this$0 = fXGLMenu;
                this.$list = listView;
            }
        });
        HBox hbox = new HBox(50.0, new Node[]{(Node)btnLoad, (Node)btnDelete});
        hbox.setAlignment(Pos.CENTER);
        return new MenuContent((Node)list, (Node)hbox);
    }

    @NotNull
    protected final MenuContent createContentGameplay() {
        log.debug("createContentGameplay()");
        return new MenuContent(new Node[0]);
    }

    @NotNull
    protected final MenuContent createContentControls() {
        log.debug("createContentControls()");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(200.0, 200.0, 200.0, Priority.ALWAYS, HPos.LEFT, true));
        grid.getRowConstraints().add((Object)new RowConstraints(40.0, 40.0, 40.0, Priority.ALWAYS, VPos.CENTER, true));
        grid.setUserData((Object)0);
        FXGLForKtKt.getInput().getAllBindings().forEach((BiConsumer)new BiConsumer<UserAction, Trigger>(this, grid){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ GridPane $grid;

            public final void accept(@NotNull UserAction action, @NotNull Trigger trigger) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
                FXGLMenu.access$addNewInputBinding(this.this$0, action, trigger, this.$grid);
            }
            {
                this.this$0 = fXGLMenu;
                this.$grid = gridPane;
            }
        });
        FXGLScrollPane scroll = new FXGLScrollPane((Node)grid);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        scroll.setMaxHeight((double)FXGLForKtKt.getAppHeight() / 2.5);
        HBox hbox = new HBox(new Node[]{(Node)scroll});
        hbox.setAlignment(Pos.CENTER);
        return new MenuContent((Node)hbox);
    }

    private final void addNewInputBinding(UserAction action, Trigger trigger, GridPane grid) {
        Text actionName = FXGLForKtKt.getUIFactoryService().newText(action.getName(), Color.WHITE, 18.0);
        TriggerView triggerView = new TriggerView(trigger, null, 0.0, 6, null);
        triggerView.triggerProperty().bind((ObservableValue)FXGLForKtKt.getInput().triggerProperty(action));
        triggerView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(this, action){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ UserAction $action;

            public final void handle(MouseEvent it) {
                FXGLMenu.access$getPressAnyKeyState$p(this.this$0).setActionContext$fxgl(this.$action);
                FXGL.Companion.getSceneService().pushSubScene((SubScene)FXGLMenu.access$getPressAnyKeyState$p(this.this$0));
            }
            {
                this.this$0 = fXGLMenu;
                this.$action = userAction;
            }
        });
        HBox hBox = new HBox();
        hBox.setPrefWidth(100.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().add((Object)triggerView);
        Object object = grid.getUserData();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        int controlsRow = (Integer)object;
        grid.addRow(controlsRow++, new Node[]{(Node)actionName, (Node)hBox});
        grid.setUserData((Object)controlsRow);
    }

    @NotNull
    protected final MenuContent createContentVideo() {
        ChoiceBox languageBox;
        log.debug("createContentVideo()");
        ChoiceBox choiceBox = languageBox = FXGLForKtKt.getUIFactoryService().newChoiceBox(FXCollections.observableArrayList((Collection)FXGLForKtKt.getSettings().getSupportedLanguages()));
        Intrinsics.checkNotNullExpressionValue((Object)choiceBox, (String)"languageBox");
        choiceBox.setValue(FXGLForKtKt.getSettings().getLanguage().getValue());
        FXGLForKtKt.getSettings().getLanguage().bindBidirectional((Property)languageBox.valueProperty());
        VBox vbox = new VBox();
        if (FXGLForKtKt.getSettings().isFullScreenAllowed()) {
            CheckBox cbFullScreen = FXGLForKtKt.getUIFactoryService().newCheckBox();
            cbFullScreen.selectedProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().getFullScreen());
            vbox.getChildren().add((Object)new HBox(25.0, new Node[]{(Node)FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localize("menu.fullscreen") + ": "), (Node)cbFullScreen}));
        }
        return new MenuContent((Node)new HBox(25.0, new Node[]{(Node)FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.language").concat((Object)":")), (Node)languageBox}), (Node)vbox);
    }

    @NotNull
    protected final MenuContent createContentAudio() {
        log.debug("createContentAudio()");
        Slider sliderMusic = new Slider(0.0, 1.0, 1.0);
        sliderMusic.valueProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().globalMusicVolumeProperty());
        Text textMusic = FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.music.volume").concat((Object)": "));
        Text percentMusic = FXGLForKtKt.getUIFactoryService().newText("");
        percentMusic.textProperty().bind((ObservableValue)sliderMusic.valueProperty().multiply(100).asString("%.0f"));
        Slider sliderSound = new Slider(0.0, 1.0, 1.0);
        sliderSound.valueProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().globalSoundVolumeProperty());
        Text textSound = FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.sound.volume").concat((Object)": "));
        Text percentSound = FXGLForKtKt.getUIFactoryService().newText("");
        percentSound.textProperty().bind((ObservableValue)sliderSound.valueProperty().multiply(100).asString("%.0f"));
        HBox hboxMusic = new HBox(15.0, new Node[]{(Node)textMusic, (Node)sliderMusic, (Node)percentMusic});
        HBox hboxSound = new HBox(15.0, new Node[]{(Node)textSound, (Node)sliderSound, (Node)percentSound});
        hboxMusic.setAlignment(Pos.CENTER_RIGHT);
        hboxSound.setAlignment(Pos.CENTER_RIGHT);
        return new MenuContent((Node)hboxMusic, (Node)hboxSound);
    }

    @NotNull
    protected final MenuContent createContentCredits() {
        log.debug("createContentCredits()");
        FXGLScrollPane pane = new FXGLScrollPane();
        pane.setPrefWidth(500.0);
        pane.setPrefHeight((double)(FXGLForKtKt.getAppHeight() / 2));
        pane.setStyle("-fx-background:black;");
        VBox vbox = new VBox();
        vbox.setAlignment(Pos.CENTER_LEFT);
        vbox.setPrefWidth(pane.getPrefWidth() - (double)15);
        ArrayList<String> credits = new ArrayList<String>((Collection)FXGLForKtKt.getSettings().getCredits());
        credits.add("");
        credits.add("Powered by FXGL " + FXGL.Companion.getVersion());
        credits.add("Author: Almas Baimagambetov");
        credits.add("https://github.com/AlmasB/FXGL");
        credits.add("");
        for (String credit : credits) {
            if (credit.length() > 45) {
                log.warning("Credit name length > 45: " + credit);
            }
            vbox.getChildren().add((Object)FXGLForKtKt.getUIFactoryService().newText(credit));
        }
        pane.setContent((Node)vbox);
        return new MenuContent((Node)pane);
    }

    @NotNull
    protected final MenuContent createContentFeedback() {
        log.debug("createContentFeedback()");
        return new MenuContent((Node)new VBox());
    }

    @NotNull
    protected final MenuContent createContentAchievements() {
        log.debug("createContentAchievements()");
        MenuContent content = new MenuContent(new Node[0]);
        Iterable $this$forEach$iv = FXGLForKtKt.getAchievementService().getAchievementsCopy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement a = (Achievement)element$iv;
            boolean bl = false;
            CheckBox checkBox = new CheckBox();
            checkBox.setDisable(true);
            checkBox.selectedProperty().bind((ObservableValue)a.achievedProperty());
            Text text = FXGLForKtKt.getUIFactoryService().newText(a.getName());
            Tooltip tooltip = new Tooltip(a.getDescription());
            tooltip.setShowDelay(Duration.seconds((double)0.1));
            Tooltip.install((Node)((Node)text), (Tooltip)tooltip);
            HBox box = new HBox(25.0, new Node[]{(Node)text, (Node)checkBox});
            box.setAlignment(Pos.CENTER_RIGHT);
            content.getChildren().add((Object)box);
        }
        return content;
    }

    protected final void addUINode(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.menuContentRoot.getChildren().add((Object)node);
    }

    protected final void fireNewGame() {
        log.debug("fireNewGame()");
        this.getController().startNewGame();
    }

    protected final void fireContinue() {
        log.debug("fireContinue()");
    }

    protected final void fireLoad(@NotNull SaveFile saveFile) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        log.debug("fireLoad()");
        String text = FXGLForKtKt.localize("menu.loadSave") + " [" + saveFile.getName() + "]?\n" + FXGLForKtKt.localize("menu.unsavedProgress");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, (Consumer)new Consumer<Boolean>(this, saveFile){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ SaveFile $saveFile;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().loadGame(this.$saveFile.getData());
                }
            }
            {
                this.this$0 = fXGLMenu;
                this.$saveFile = saveFile;
            }
        });
    }

    protected final void fireSave() {
        log.debug("fireSave()");
        FXGLForKtKt.getDisplay().showInputBoxWithCancel(FXGLForKtKt.localize("menu.enterSaveName"), InputPredicates.ALPHANUM, (Consumer)new Consumer<String>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(String saveFileName) {
                String string = saveFileName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"saveFileName");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return;
                }
                SaveFile saveFile = new SaveFile(FXGLMenu.access$makeSaveFileName(this.this$0, saveFileName + "." + FXGLForKtKt.getSettings().getSaveFileExt()), null, null, 6, null);
                if (this.this$0.getSaveLoadService().saveFileExists(saveFile.getName())) {
                    FXGLForKtKt.getDisplay().showConfirmationBox(FXGLForKtKt.localize("menu.overwrite") + " [" + saveFileName + "]?", (Consumer)new Consumer<Boolean>(this, saveFile){
                        final /* synthetic */ fireSave.1 this$0;
                        final /* synthetic */ SaveFile $saveFile;

                        public final void accept(Boolean yes) {
                            Boolean bl = yes;
                            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                            if (bl.booleanValue()) {
                                FXGLMenu.access$doSave(this.this$0.this$0, this.$saveFile);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$saveFile = saveFile;
                        }
                    });
                } else {
                    FXGLMenu.access$doSave(this.this$0, saveFile);
                }
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    private final void doSave(SaveFile saveFile) {
        this.getController().saveGame(saveFile.getData());
        FXGL.Companion.getTaskService().runAsyncFXWithDialog(this.saveLoadService.writeTask(saveFile.getName(), saveFile.getData()), FXGLForKtKt.localize("menu.savingData") + ": " + saveFile.getName());
    }

    protected final void fireDelete(@NotNull SaveFile saveFile) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        log.debug("fireDelete()");
    }

    protected final void fireResume() {
        log.debug("fireResume()");
        FXGL.Companion.getSceneService().popSubScene();
    }

    protected final void fireExit() {
        log.debug("fireExit()");
        String text = FXGLForKtKt.localize("dialog.exitGame");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, (Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().exit();
                }
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    protected final void fireExitToMainMenu() {
        log.debug("fireExitToMainMenu()");
        String text = FXGLForKtKt.localize("menu.exitMainMenu") + "\n" + FXGLForKtKt.localize("menu.unsavedProgress");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, (Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().gotoMainMenu();
                }
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    protected final void showProfileDialog() {
        ChoiceBox profilesBox = FXGLForKtKt.getUIFactoryService().newChoiceBox(FXCollections.observableArrayList());
        Button btnNew = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("multiplayer.new"));
        Button btnSelect = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("multiplayer.select"));
        BooleanProperty booleanProperty = btnSelect.disableProperty();
        ObjectProperty objectProperty = profilesBox.valueProperty();
        Intrinsics.checkNotNullExpressionValue((Object)objectProperty, (String)"profilesBox.valueProperty()");
        booleanProperty.bind((ObservableValue)objectProperty.isNull());
        Button btnDelete = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.delete"));
        BooleanProperty booleanProperty2 = btnDelete.disableProperty();
        ObjectProperty objectProperty2 = profilesBox.valueProperty();
        Intrinsics.checkNotNullExpressionValue((Object)objectProperty2, (String)"profilesBox.valueProperty()");
        booleanProperty2.bind((ObservableValue)objectProperty2.isNull());
        btnNew.setOnAction((EventHandler)showProfileDialog.1.INSTANCE);
        btnSelect.setOnAction((EventHandler)new EventHandler<ActionEvent>(profilesBox){
            final /* synthetic */ ChoiceBox $profilesBox;

            public final void handle(ActionEvent it) {
                ChoiceBox choiceBox = this.$profilesBox;
                Intrinsics.checkNotNullExpressionValue((Object)choiceBox, (String)"profilesBox");
                String name = (String)choiceBox.getValue();
                FXGLForKtKt.getSettings().getProfileName().set(name);
            }
            {
                this.$profilesBox = choiceBox;
            }
        });
    }

    private final String makeSaveFileName(String rawName) {
        return rawName;
    }

    @NotNull
    protected final MenuType getType() {
        return this.type;
    }

    public FXGLMenu(@NotNull MenuType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.saveLoadService = FXGL.Companion.getSaveLoadService();
        this.controller$delegate = LazyKt.lazy((Function0)controller.2.INSTANCE);
        this.appWidth$delegate = LazyKt.lazy((Function0)appWidth.2.INSTANCE);
        this.appHeight$delegate = LazyKt.lazy((Function0)appHeight.2.INSTANCE);
        this.menuRoot = new Pane();
        this.menuContentRoot = new Pane();
        this.EMPTY = new MenuContent(new Node[0]);
        this.pressAnyKeyState = new PressAnyKeyState();
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{this.createBackground(FXGLForKtKt.getAppWidth(), FXGLForKtKt.getAppHeight()), this.createTitleView(FXGLForKtKt.getSettings().getTitle()), this.createVersionView(this.makeVersionString()), (Node)this.menuRoot, (Node)this.menuContentRoot});
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("Menu");
    }

    public static final /* synthetic */ void access$addNewInputBinding(FXGLMenu $this, UserAction action, Trigger trigger, GridPane grid) {
        $this.addNewInputBinding(action, trigger, grid);
    }

    public static final /* synthetic */ PressAnyKeyState access$getPressAnyKeyState$p(FXGLMenu $this) {
        return $this.pressAnyKeyState;
    }

    public static final /* synthetic */ String access$makeSaveFileName(FXGLMenu $this, String rawName) {
        return $this.makeSaveFileName(rawName);
    }

    public static final /* synthetic */ void access$doSave(FXGLMenu $this, SaveFile saveFile) {
        $this.doSave(saveFile);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLMenu$PressAnyKeyState;", "Lcom/almasb/fxgl/scene/SubScene;", "(Lcom/almasb/fxgl/app/scene/FXGLMenu;)V", "actionContext", "Lcom/almasb/fxgl/input/UserAction;", "getActionContext$fxgl", "()Lcom/almasb/fxgl/input/UserAction;", "setActionContext$fxgl", "(Lcom/almasb/fxgl/input/UserAction;)V", "fxgl"})
    private final class PressAnyKeyState
    extends SubScene {
        @Nullable
        private UserAction actionContext;

        @Nullable
        public final UserAction getActionContext$fxgl() {
            return this.actionContext;
        }

        public final void setActionContext$fxgl(@Nullable UserAction userAction) {
            this.actionContext = userAction;
        }

        public PressAnyKeyState() {
            Input input = this.getInput();
            EventType eventType = KeyEvent.KEY_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"KeyEvent.KEY_PRESSED");
            input.addEventHandler(eventType, (EventHandler)new EventHandler<KeyEvent>(){

                public final void handle(KeyEvent e) {
                    KeyCode keyCode = e.getCode();
                    Intrinsics.checkNotNullExpressionValue((Object)keyCode, (String)"e.getCode()");
                    if (Input.Companion.isIllegal(keyCode)) {
                        return;
                    }
                    Input input = FXGLForKtKt.getInput();
                    UserAction userAction = this.getActionContext$fxgl();
                    Intrinsics.checkNotNull((Object)userAction);
                    KeyCode keyCode2 = e.getCode();
                    Intrinsics.checkNotNullExpressionValue((Object)keyCode2, (String)"e.getCode()");
                    KeyEvent keyEvent = e;
                    Intrinsics.checkNotNullExpressionValue((Object)keyEvent, (String)"e");
                    boolean rebound = input.rebind(userAction, keyCode2, InputModifier.Companion.from(keyEvent));
                    if (rebound) {
                        FXGL.Companion.getSceneService().popSubScene();
                    }
                }
            });
            Input input2 = this.getInput();
            EventType eventType2 = MouseEvent.MOUSE_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType2, (String)"MouseEvent.MOUSE_PRESSED");
            input2.addEventHandler(eventType2, (EventHandler)new EventHandler<MouseEvent>(){

                public final void handle(MouseEvent e) {
                    Input input = FXGLForKtKt.getInput();
                    UserAction userAction = this.getActionContext$fxgl();
                    Intrinsics.checkNotNull((Object)userAction);
                    MouseButton mouseButton = e.getButton();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseButton, (String)"e.getButton()");
                    MouseEvent mouseEvent = e;
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"e");
                    boolean rebound = input.rebind(userAction, mouseButton, InputModifier.Companion.from(mouseEvent));
                    if (rebound) {
                        FXGL.Companion.getSceneService().popSubScene();
                    }
                }
            });
            Rectangle rect = new Rectangle(250.0, 100.0);
            rect.setStroke((Paint)Color.color((double)0.85, (double)0.9, (double)0.9, (double)0.95));
            rect.setStrokeWidth(10.0);
            rect.setArcWidth(15.0);
            rect.setArcHeight(15.0);
            Text text = FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localize("menu.pressAnyKey"), 24.0);
            StackPane pane = new StackPane(new Node[]{(Node)rect, (Node)text});
            pane.setTranslateX((double)(FXGLForKtKt.getAppWidth() / 2 - 125));
            pane.setTranslateY((double)(FXGLForKtKt.getAppHeight() / 2 - 50));
            this.getContentRoot().getChildren().add((Object)pane);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u000fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLMenu$MenuContent;", "Ljavafx/scene/layout/VBox;", "items", "", "Ljavafx/scene/Node;", "([Ljavafx/scene/Node;)V", "maxW", "", "getMaxW", "()I", "setMaxW", "(I)V", "onClose", "Ljava/lang/Runnable;", "onOpen", "", "setOnClose", "onCloseAction", "setOnOpen", "onOpenAction", "fxgl"})
    public static final class MenuContent
    extends VBox {
        private Runnable onOpen;
        private Runnable onClose;
        private int maxW;

        public final int getMaxW() {
            return this.maxW;
        }

        public final void setMaxW(int n) {
            this.maxW = n;
        }

        public final void setOnOpen(@NotNull Runnable onOpenAction) {
            Intrinsics.checkNotNullParameter((Object)onOpenAction, (String)"onOpenAction");
            this.onOpen = onOpenAction;
        }

        public final void setOnClose(@NotNull Runnable onCloseAction) {
            Intrinsics.checkNotNullParameter((Object)onCloseAction, (String)"onCloseAction");
            this.onClose = onCloseAction;
        }

        private final void onOpen() {
            if (this.onOpen != null) {
                Runnable runnable = this.onOpen;
                Intrinsics.checkNotNull((Object)runnable);
                runnable.run();
            }
        }

        private final void onClose() {
            if (this.onClose != null) {
                Runnable runnable = this.onClose;
                Intrinsics.checkNotNull((Object)runnable);
                runnable.run();
            }
        }

        public MenuContent(Node ... items) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            Node[] nodeArray = items;
            int n = 0;
            Node[] nodeArray2 = nodeArray;
            int n2 = 0;
            if (!(nodeArray2.length == 0)) {
                Bounds bounds = items[0].getLayoutBounds();
                Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"items[0].layoutBounds");
                this.maxW = (int)bounds.getWidth();
                for (Node n3 : items) {
                    Bounds bounds2 = n3.getLayoutBounds();
                    Intrinsics.checkNotNullExpressionValue((Object)bounds2, (String)"n.layoutBounds");
                    int w = (int)bounds2.getWidth();
                    if (w <= this.maxW) continue;
                    this.maxW = w;
                }
                for (Node item : items) {
                    this.getChildren().addAll((Object[])new Node[]{item});
                }
            }
            this.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

                public final void changed(ObservableValue<? extends Scene> $noName_0, Scene $noName_1, Scene newScene) {
                    if (newScene != null) {
                        this.onOpen();
                    } else {
                        this.onClose();
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLMenu$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

