/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dev;

import com.almasb.fxgl.app.scene.GameView;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.dev.Console;
import com.almasb.fxgl.dev.DevPane;
import com.almasb.fxgl.dev.DevService;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.LoggerLevel;
import com.almasb.fxgl.logging.LoggerOutput;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.BoxShapeData;
import com.almasb.fxgl.physics.ChainShapeData;
import com.almasb.fxgl.physics.CircleShapeData;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PolygonShapeData;
import com.almasb.fxgl.scene.SceneService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001bJ\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u001bH\u0016J\u0006\u0010$\u001a\u00020\u001bJ\u0006\u0010%\u001a\u00020\u001bJ\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/almasb/fxgl/dev/DevService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "console", "Lcom/almasb/fxgl/dev/Console;", "getConsole", "()Lcom/almasb/fxgl/dev/Console;", "console$delegate", "Lkotlin/Lazy;", "consoleOutput", "com/almasb/fxgl/dev/DevService$consoleOutput$1", "Lcom/almasb/fxgl/dev/DevService$consoleOutput$1;", "debugViews", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/entity/Entity;", "Lcom/almasb/fxgl/app/scene/GameView;", "Lkotlin/collections/HashMap;", "devPane", "Lcom/almasb/fxgl/dev/DevPane;", "isConsoleOpen", "", "()Z", "isDevEnabled", "isDevPaneOpen", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "addDebugView", "", "entity", "closeConsole", "closeDevPane", "onGameReady", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "onInit", "onMainLoopStarting", "openConsole", "openDevPane", "pushDebugMessage", "message", "", "removeDebugView", "fxgl"})
public final class DevService
extends EngineService {
    private SceneService sceneService;
    private DevPane devPane;
    private final Lazy console$delegate = LazyKt.lazy((Function0)console.2.INSTANCE);
    private final consoleOutput.1 consoleOutput = new LoggerOutput(this){
        final /* synthetic */ DevService this$0;

        public void append(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            DevService.access$getConsole$p(this.this$0).pushMessage(message);
        }

        public void close() {
        }
        {
            this.this$0 = this$0;
        }
    };
    private final HashMap<Entity, GameView> debugViews;

    private final Console getConsole() {
        Lazy lazy = this.console$delegate;
        DevService devService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Console)((Object)lazy.getValue());
    }

    public final boolean isConsoleOpen() {
        return this.getConsole().isOpen();
    }

    public final boolean isDevPaneOpen() {
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"devPane");
        }
        return devPane.isOpen();
    }

    private final boolean isDevEnabled() {
        return !FXGLForKtKt.isReleaseMode() && FXGL.Companion.getSettings().isDeveloperMenuEnabled();
    }

    public void onInit() {
        if (!this.isDevEnabled()) {
            return;
        }
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
        }
        this.devPane = new DevPane(sceneService, FXGL.Companion.getSettings());
    }

    public final void openConsole() {
        if (!this.isDevEnabled()) {
            return;
        }
        this.getConsole().open();
    }

    public final void closeConsole() {
        if (!this.isDevEnabled()) {
            return;
        }
        this.getConsole().close();
    }

    public final void openDevPane() {
        if (!this.isDevEnabled()) {
            return;
        }
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"devPane");
        }
        devPane.open();
    }

    public final void closeDevPane() {
        if (!this.isDevEnabled()) {
            return;
        }
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"devPane");
        }
        devPane.close();
    }

    public final void pushDebugMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.isDevEnabled()) {
            return;
        }
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"devPane");
        }
        devPane.pushMessage(message);
    }

    public void onMainLoopStarting() {
        if (!this.isDevEnabled()) {
            return;
        }
        Logger.Companion.addOutput((LoggerOutput)this.consoleOutput, LoggerLevel.DEBUG);
        FXGL.Companion.getSettings().devShowBBoxProperty().addListener((ChangeListener)new ChangeListener<Boolean>(this){
            final /* synthetic */ DevService this$0;

            public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean isSelected) {
                Boolean bl = isSelected;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isSelected");
                if (bl.booleanValue()) {
                    Iterable $this$forEach$iv = FXGL.Companion.getGameWorld().getEntities();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl2 = false;
                        DevService.access$addDebugView(this.this$0, it);
                    }
                } else {
                    Iterable $this$forEach$iv = FXGL.Companion.getGameWorld().getEntities();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl3 = false;
                        DevService.access$removeDebugView(this.this$0, it);
                    }
                }
            }
            {
                this.this$0 = devService;
            }
        });
        FXGL.Companion.getGameWorld().addWorldListener(new EntityWorldListener(this){
            final /* synthetic */ DevService this$0;

            public void onEntityAdded(@NotNull Entity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Boolean bl = FXGL.Companion.getSettings().devShowBBoxProperty().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"FXGL.getSettings().devShowBBox.value");
                if (bl.booleanValue()) {
                    DevService.access$addDebugView(this.this$0, entity);
                }
            }

            public void onEntityRemoved(@NotNull Entity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Boolean bl = FXGL.Companion.getSettings().devShowBBoxProperty().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"FXGL.getSettings().devShowBBox.value");
                if (bl.booleanValue()) {
                    DevService.access$removeDebugView(this.this$0, entity);
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void addDebugView(Entity entity) {
        Group group = new Group();
        Iterable $this$forEach$iv = (Iterable)entity.getBoundingBoxComponent().hitBoxesProperty();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list;
            Iterable list$iv$iv;
            Point2D it;
            Point2D element$iv$iv;
            int n;
            int n2;
            Point2D[] point2DArray;
            Point2D[] $this$flatMapTo$iv$iv;
            boolean $i$f$flatMapTo;
            Collection destination$iv$iv;
            boolean $i$f$flatMap;
            Shape shape;
            HitBox it2 = (HitBox)element$iv;
            boolean bl = false;
            HitBox hitBox = it2;
            Intrinsics.checkNotNullExpressionValue((Object)hitBox, (String)"it");
            BoundingShape data = hitBox.getShape();
            if (data instanceof CircleShapeData) {
                shape = (Shape)new Circle(((CircleShapeData)data).getRadius(), ((CircleShapeData)data).getRadius(), ((CircleShapeData)data).getRadius());
            } else if (data instanceof BoxShapeData) {
                Rectangle bboxView = new Rectangle();
                DoubleProperty doubleProperty = bboxView.widthProperty();
                Intrinsics.checkNotNullExpressionValue((Object)doubleProperty, (String)"bboxView.widthProperty()");
                doubleProperty.setValue((Number)((BoxShapeData)data).getWidth());
                DoubleProperty doubleProperty2 = bboxView.heightProperty();
                Intrinsics.checkNotNullExpressionValue((Object)doubleProperty2, (String)"bboxView.heightProperty()");
                doubleProperty2.setValue((Number)((BoxShapeData)data).getHeight());
                bboxView.visibleProperty().bind((ObservableValue)bboxView.widthProperty().greaterThan(0).and((ObservableBooleanValue)bboxView.heightProperty().greaterThan(0)));
                shape = (Shape)bboxView;
            } else if (data instanceof PolygonShapeData) {
                Point2D[] $this$flatMap$iv = ((PolygonShapeData)data).getPoints();
                $i$f$flatMap = false;
                Point2D[] point2DArray2 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                point2DArray = $this$flatMapTo$iv$iv;
                n2 = point2DArray.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv$iv = point2DArray[n];
                    boolean bl2 = false;
                    list$iv$iv = CollectionsKt.listOf((Object[])new Double[]{it.getX(), it.getY()});
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
                double[] dArray = CollectionsKt.toDoubleArray((Collection)list);
                double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
                shape = (Shape)new Polygon(dArray2);
            } else if (data instanceof ChainShapeData) {
                Point2D[] $this$flatMap$iv = ((ChainShapeData)data).getPoints();
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                point2DArray = $this$flatMapTo$iv$iv;
                n2 = point2DArray.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv$iv = point2DArray[n];
                    boolean bl3 = false;
                    list$iv$iv = CollectionsKt.listOf((Object[])new Double[]{it.getX(), it.getY()});
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
                double[] dArray = CollectionsKt.toDoubleArray((Collection)list);
                double[] dArray3 = Arrays.copyOf(dArray, dArray.length);
                shape = (Shape)new Polyline(dArray3);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Shape shape2 = shape;
            shape2.setFill((Paint)null);
            shape2.setTranslateX(it2.getMinX());
            shape2.setTranslateY(it2.getMinY());
            shape2.setStrokeWidth(2.0);
            shape2.strokeProperty().bind((ObservableValue)FXGL.Companion.getSettings().devBBoxColorProperty());
            Collection collection = (Collection)group.getChildren();
            boolean bl4 = false;
            collection.add(shape2);
        }
        ViewComponent.addChild$default((ViewComponent)entity.getViewComponent(), (Node)((Node)group), (boolean)false, (int)2, null);
        GameView view2 = new GameView((Node)group, Integer.MAX_VALUE);
        ((Map)this.debugViews).put(entity, view2);
    }

    private final void removeDebugView(Entity entity) {
        block0: {
            GameView gameView = this.debugViews.remove(entity);
            if (gameView == null) break block0;
            GameView gameView2 = gameView;
            boolean bl = false;
            boolean bl2 = false;
            GameView view2 = gameView2;
            boolean bl3 = false;
            entity.getViewComponent().removeChild(view2.getNode());
        }
    }

    public void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkNotNullParameter((Object)vars, (String)"vars");
        if (!this.isDevEnabled()) {
            return;
        }
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"devPane");
        }
        devPane.onGameReady(vars);
    }

    public DevService() {
        boolean bl = false;
        this.debugViews = new HashMap();
    }

    public static final /* synthetic */ void access$addDebugView(DevService $this, Entity entity) {
        $this.addDebugView(entity);
    }

    public static final /* synthetic */ void access$removeDebugView(DevService $this, Entity entity) {
        $this.removeDebugView(entity);
    }

    public static final /* synthetic */ Console access$getConsole$p(DevService $this) {
        return $this.getConsole();
    }
}

