/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.app.GameController;
import com.almasb.fxgl.app.scene.FXGLMenu;
import com.almasb.fxgl.app.scene.MenuType;
import com.almasb.fxgl.app.services.IOTaskExecutorService;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.util.InputPredicates;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.profile.SaveFile;
import com.almasb.fxgl.profile.SaveLoadService;
import com.almasb.fxgl.scene.SubScene;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0004J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\b\u0010\u001f\u001a\u00020\u001aH\u0004J\b\u0010 \u001a\u00020\u001aH\u0004J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\b\u0010\"\u001a\u00020\u001aH\u0004J\b\u0010#\u001a\u00020\u001aH\u0004J\b\u0010$\u001a\u00020\u001aH\u0004J\b\u0010%\u001a\u00020\u001aH\u0004R\u001b\u0010\u0005\u001a\u00020\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLMenu;", "Lcom/almasb/fxgl/scene/SubScene;", "type", "Lcom/almasb/fxgl/app/scene/MenuType;", "(Lcom/almasb/fxgl/app/scene/MenuType;)V", "appHeight", "", "getAppHeight", "()I", "appHeight$delegate", "Lkotlin/Lazy;", "appWidth", "getAppWidth", "appWidth$delegate", "controller", "Lcom/almasb/fxgl/app/GameController;", "getController", "()Lcom/almasb/fxgl/app/GameController;", "controller$delegate", "saveLoadService", "Lcom/almasb/fxgl/profile/SaveLoadService;", "getSaveLoadService", "()Lcom/almasb/fxgl/profile/SaveLoadService;", "getType", "()Lcom/almasb/fxgl/app/scene/MenuType;", "doSave", "", "saveFile", "Lcom/almasb/fxgl/profile/SaveFile;", "fireContinue", "fireDelete", "fireExit", "fireExitToMainMenu", "fireLoad", "fireNewGame", "fireResume", "fireSave", "restoreDefaultSettings", "Companion", "fxgl"})
public abstract class FXGLMenu
extends SubScene {
    @NotNull
    private final SaveLoadService saveLoadService;
    @NotNull
    private final Lazy controller$delegate;
    @NotNull
    private final Lazy appWidth$delegate;
    @NotNull
    private final Lazy appHeight$delegate;
    @NotNull
    private final MenuType type;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final SaveLoadService getSaveLoadService() {
        return this.saveLoadService;
    }

    @NotNull
    protected final GameController getController() {
        Lazy lazy = this.controller$delegate;
        FXGLMenu fXGLMenu = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GameController)lazy.getValue();
    }

    protected final int getAppWidth() {
        Lazy lazy = this.appWidth$delegate;
        FXGLMenu fXGLMenu = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    protected final int getAppHeight() {
        Lazy lazy = this.appHeight$delegate;
        FXGLMenu fXGLMenu = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    protected final void fireNewGame() {
        log.debug("fireNewGame()");
        this.getController().startNewGame();
    }

    protected final void fireContinue() {
        log.debug("fireContinue()");
        IOTask task2 = this.saveLoadService.readLastModifiedSaveFileTask("./", FXGLForKtKt.getSettings().getSaveFileExt()).onSuccess((Consumer)new Consumer<Optional<SaveFile>>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(Optional<SaveFile> it) {
                it.ifPresent(new Consumer<SaveFile>(this){
                    final /* synthetic */ fireContinue.task.1 this$0;

                    public final void accept(@NotNull SaveFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.this$0.fireLoad(it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
        IOTaskExecutorService iOTaskExecutorService = FXGL.Companion.getTaskService();
        IOTask iOTask = task2;
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"task");
        iOTaskExecutorService.runAsyncFXWithDialog(iOTask, FXGLForKtKt.localize("menu.loading") + "...");
    }

    protected final void fireLoad(@NotNull SaveFile saveFile) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        log.debug("fireLoad()");
        String text = FXGLForKtKt.localize("menu.loadSave") + " [" + saveFile.getName() + "]?\n" + FXGLForKtKt.localize("menu.unsavedProgress");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, (Consumer)new Consumer<Boolean>(this, saveFile){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ SaveFile $saveFile;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().loadGame(this.$saveFile.getData());
                }
            }
            {
                this.this$0 = fXGLMenu;
                this.$saveFile = saveFile;
            }
        });
    }

    protected final void fireSave() {
        log.debug("fireSave()");
        FXGLForKtKt.getDisplay().showInputBoxWithCancel(FXGLForKtKt.localize("menu.enterSaveName"), InputPredicates.ALPHANUM, (Consumer)new Consumer<String>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(String saveFileName) {
                String string = saveFileName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"saveFileName");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return;
                }
                SaveFile saveFile = new SaveFile(saveFileName + "." + FXGLForKtKt.getSettings().getSaveFileExt(), null, null, 6, null);
                if (this.this$0.getSaveLoadService().saveFileExists(saveFile.getName())) {
                    FXGLForKtKt.getDisplay().showConfirmationBox(FXGLForKtKt.localize("menu.overwrite") + " [" + saveFileName + "]?", (Consumer)new Consumer<Boolean>(this, saveFile){
                        final /* synthetic */ fireSave.1 this$0;
                        final /* synthetic */ SaveFile $saveFile;

                        public final void accept(Boolean yes) {
                            Boolean bl = yes;
                            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                            if (bl.booleanValue()) {
                                FXGLMenu.access$doSave(this.this$0.this$0, this.$saveFile);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$saveFile = saveFile;
                        }
                    });
                } else {
                    FXGLMenu.access$doSave(this.this$0, saveFile);
                }
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    private final void doSave(SaveFile saveFile) {
        this.getController().saveGame(saveFile.getData());
        FXGL.Companion.getTaskService().runAsyncFXWithDialog(this.saveLoadService.writeTask(saveFile.getName(), saveFile.getData()), FXGLForKtKt.localize("menu.savingData") + ": " + saveFile.getName());
    }

    protected final void fireDelete(@NotNull SaveFile saveFile) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        log.debug("fireDelete()");
        FXGLForKtKt.getDisplay().showConfirmationBox(FXGLForKtKt.localize("menu.deleteSave") + '[' + saveFile.getName() + "]?", (Consumer)new Consumer<Boolean>(this, saveFile){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ SaveFile $saveFile;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    IOTask task2 = this.this$0.getSaveLoadService().deleteSaveFileTask(this.$saveFile.getName());
                    FXGL.Companion.getTaskService().runAsyncFXWithDialog(task2, FXGLForKtKt.localize("menu.deleting") + ": " + this.$saveFile.getName());
                }
            }
            {
                this.this$0 = fXGLMenu;
                this.$saveFile = saveFile;
            }
        });
    }

    protected final void fireResume() {
        log.debug("fireResume()");
        FXGL.Companion.getSceneService().popSubScene();
    }

    protected final void fireExit() {
        log.debug("fireExit()");
        String text = FXGLForKtKt.localize("dialog.exitGame");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, (Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().exit();
                }
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    protected final void fireExitToMainMenu() {
        log.debug("fireExitToMainMenu()");
        String text = FXGLForKtKt.localize("menu.exitMainMenu") + "\n" + FXGLForKtKt.localize("menu.unsavedProgress");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, (Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().gotoMainMenu();
                }
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    protected final void restoreDefaultSettings() {
        log.debug("restoreDefaultSettings()");
    }

    @NotNull
    protected final MenuType getType() {
        return this.type;
    }

    public FXGLMenu(@NotNull MenuType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.saveLoadService = FXGL.Companion.getSaveLoadService();
        this.controller$delegate = LazyKt.lazy((Function0)controller.2.INSTANCE);
        this.appWidth$delegate = LazyKt.lazy((Function0)appWidth.2.INSTANCE);
        this.appHeight$delegate = LazyKt.lazy((Function0)appHeight.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("Menu");
    }

    public static final /* synthetic */ void access$doSave(FXGLMenu $this, SaveFile saveFile) {
        $this.doSave(saveFile);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLMenu$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

