/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.components;

import com.almasb.fxgl.entity.component.Component;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0010J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0002R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\n\u00a8\u0006 "}, d2={"Lcom/almasb/fxgl/dsl/components/ProjectileWithAccelerationComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "direction", "Ljavafx/geometry/Point2D;", "speed", "", "acceleration", "(Ljavafx/geometry/Point2D;DLjavafx/geometry/Point2D;)V", "(Ljavafx/geometry/Point2D;D)V", "getAcceleration", "()Ljavafx/geometry/Point2D;", "setAcceleration", "(Ljavafx/geometry/Point2D;)V", "getDirection", "setDirection", "isAllowRotation", "", "value", "getSpeed", "()D", "setSpeed", "(D)V", "<set-?>", "velocity", "getVelocity", "allowRotation", "isComponentInjectionRequired", "onAdded", "", "onUpdate", "tpf", "updateRotation", "fxgl"})
public final class ProjectileWithAccelerationComponent
extends Component {
    @NotNull
    private Point2D acceleration;
    @NotNull
    private Point2D velocity;
    private double speed;
    private boolean isAllowRotation;

    @NotNull
    public final Point2D getAcceleration() {
        return this.acceleration;
    }

    public final void setAcceleration(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.acceleration = point2D;
    }

    @NotNull
    public final Point2D getVelocity() {
        return this.velocity;
    }

    @NotNull
    public final Point2D getDirection() {
        Point2D point2D = this.velocity.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"velocity.normalize()");
        return point2D;
    }

    public final void setDirection(@NotNull Point2D direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Point2D point2D = direction.normalize().multiply(this.speed);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"direction.normalize().multiply(speed)");
        this.velocity = point2D;
        this.updateRotation();
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double value) {
        this.speed = value;
        Point2D point2D = this.velocity.normalize().multiply(this.speed);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"velocity.normalize().multiply(speed)");
        this.velocity = point2D;
        this.updateRotation();
    }

    @NotNull
    public final ProjectileWithAccelerationComponent allowRotation(boolean allowRotation) {
        this.isAllowRotation = allowRotation;
        return this;
    }

    private final void updateRotation() {
        if (this.isAllowRotation) {
            this.entity.rotateToVector(this.velocity);
        }
    }

    public void onAdded() {
        this.updateRotation();
    }

    public void onUpdate(double tpf) {
        Point2D prevVelocity = this.velocity;
        this.setSpeed(this.velocity.add(this.acceleration.multiply(tpf)).magnitude());
        Point2D point2D = this.velocity.add(this.acceleration.multiply(tpf));
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"velocity.add(acceleration.multiply(tpf))");
        this.setDirection(point2D);
        this.entity.translate(this.velocity.add(prevVelocity).multiply(tpf / 2.0));
    }

    public boolean isComponentInjectionRequired() {
        return false;
    }

    public ProjectileWithAccelerationComponent(@NotNull Point2D direction, double speed) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this.acceleration = new Point2D(0.0, 0.0);
        Point2D point2D = direction.normalize().multiply(speed);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"direction.normalize().multiply(speed)");
        this.velocity = point2D;
        this.speed = speed;
        this.isAllowRotation = true;
    }

    public ProjectileWithAccelerationComponent(@NotNull Point2D direction, double speed, @NotNull Point2D acceleration) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)acceleration, (String)"acceleration");
        this(direction, speed);
        this.acceleration = acceleration;
    }
}

