/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.app.EmbeddedPaneWindow;
import com.almasb.fxgl.app.Engine;
import com.almasb.fxgl.app.FXGLApplication;
import com.almasb.fxgl.app.FXGLPane;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.PrimaryStageWindow;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.GameScene;
import com.almasb.fxgl.app.scene.LoadingScene;
import com.almasb.fxgl.app.scene.SceneFactory;
import com.almasb.fxgl.app.services.FXGLAssetLoaderService;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.core.util.PauseMenuBGGen;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputSequence;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.localization.Language;
import com.almasb.fxgl.localization.LocalizationService;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.profile.DataFile;
import com.almasb.fxgl.profile.SaveLoadHandler;
import com.almasb.fxgl.profile.SaveLoadService;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.DialogService;
import com.gluonhq.attach.lifecycle.LifecycleEvent;
import com.gluonhq.attach.lifecycle.LifecycleService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication;", "Ljavafx/application/Application;", "()V", "isError", "", "embeddedStart", "Lcom/almasb/fxgl/app/FXGLPane;", "exitFXGL", "", "handleFatalError", "error", "", "initAndLoadLocalization", "initPauseResumeHandler", "initPauseResumeHandlerDesktop", "initPauseResumeHandlerMobile", "initSaveLoadHandler", "postServicesInit", "setFirstSceneAfterStartup", "start", "stage", "Ljavafx/stage/Stage;", "startImpl", "windowSupplier", "Lkotlin/Function0;", "Lcom/almasb/fxgl/app/MainWindow;", "Companion", "GameApplicationService", "InitAppTask", "fxgl"})
public final class FXGLApplication
extends Application {
    private boolean isError;
    private static final Logger log;
    private static GameApplication app;
    private static ReadOnlyGameSettings settings;
    private static Engine engine;
    private static MainWindow mainWindow;
    @NotNull
    public static final Companion Companion;

    private final FXGLPane embeddedStart() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        double d = readOnlyGameSettings.getWidth();
        ReadOnlyGameSettings readOnlyGameSettings2 = settings;
        if (readOnlyGameSettings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        FXGLPane pane = new FXGLPane(d, readOnlyGameSettings2.getHeight());
        this.startImpl((Function0<? extends MainWindow>)((Function0)new Function0<MainWindow>(pane){
            final /* synthetic */ FXGLPane $pane;

            @NotNull
            public final MainWindow invoke() {
                ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                SceneFactory sceneFactory = readOnlyGameSettings.getSceneFactory();
                ReadOnlyGameSettings readOnlyGameSettings2 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                int n = readOnlyGameSettings2.getWidth();
                ReadOnlyGameSettings readOnlyGameSettings3 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                FXGLScene fXGLScene = sceneFactory.newStartup(n, readOnlyGameSettings3.getHeight());
                ReadOnlyGameSettings readOnlyGameSettings4 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                return new EmbeddedPaneWindow(this.$pane, fXGLScene, readOnlyGameSettings4);
            }
            {
                this.$pane = fXGLPane;
                super(0);
            }
        }));
        return pane;
    }

    public void start(@NotNull Stage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        this.startImpl((Function0<? extends MainWindow>)((Function0)new Function0<MainWindow>(stage){
            final /* synthetic */ Stage $stage;

            @NotNull
            public final MainWindow invoke() {
                ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                SceneFactory sceneFactory = readOnlyGameSettings.getSceneFactory();
                ReadOnlyGameSettings readOnlyGameSettings2 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                int n = readOnlyGameSettings2.getWidth();
                ReadOnlyGameSettings readOnlyGameSettings3 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                FXGLScene fXGLScene = sceneFactory.newStartup(n, readOnlyGameSettings3.getHeight());
                ReadOnlyGameSettings readOnlyGameSettings4 = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                return new PrimaryStageWindow(this.$stage, fXGLScene, readOnlyGameSettings4);
            }
            {
                this.$stage = stage;
                super(0);
            }
        }));
    }

    private final void startImpl(Function0<? extends MainWindow> windowSupplier) {
        Task task2;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
            final /* synthetic */ FXGLApplication this$0;

            public final void uncaughtException(Thread $noName_0, Throwable e) {
                Throwable throwable = e;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"e");
                FXGLApplication.access$handleFatalError(this.this$0, throwable);
            }
            {
                this.this$0 = fXGLApplication;
            }
        });
        log.debug("Initializing FXGL");
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        Engine engine = FXGLApplication.engine = new Engine(readOnlyGameSettings);
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
        }
        GameApplication gameApplication = app;
        if (gameApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"app");
        }
        FXGL.Companion.inject$fxgl(engine, gameApplication, this);
        MainWindow mainWindow = FXGLApplication.mainWindow = (MainWindow)windowSupplier.invoke();
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.show();
        Task task3 = task2 = IOTask.ofVoid((Runnable)new Runnable(this){
            final /* synthetic */ FXGLApplication this$0;

            public final void run() {
                boolean $i$f$measureNanoTime = false;
                boolean bl = false;
                long start$iv = System.nanoTime();
                boolean bl2 = false;
                Engine engine = FXGLApplication.access$getEngine$cp();
                if (engine == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                }
                engine.initServices();
                FXGLApplication.access$postServicesInit(this.this$0);
                long time = System.nanoTime() - start$iv;
                FXGLApplication.access$getLog$cp().infof("FXGL initialization took: %.3f sec", new Object[]{(double)time / 1.0E9});
            }
            {
                this.this$0 = fXGLApplication;
            }
        }).onSuccess((Consumer)new Consumer<Void>(this){
            final /* synthetic */ FXGLApplication this$0;

            public final void accept(Void it) {
                Engine engine = FXGLApplication.access$getEngine$cp();
                if (engine == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                }
                engine.startLoop();
                FXGLApplication.access$setFirstSceneAfterStartup(this.this$0);
            }
            {
                this.this$0 = fXGLApplication;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ FXGLApplication this$0;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                FXGLApplication.access$handleFatalError(this.this$0, throwable);
            }
            {
                this.this$0 = fXGLApplication;
            }
        }).toJavaFXTask();
        Intrinsics.checkNotNullExpressionValue((Object)task3, (String)"task");
        Async.INSTANCE.execute((Runnable)task3);
    }

    private final void postServicesInit() {
        Async.INSTANCE.startAsync((Runnable)postServicesInit.1.INSTANCE);
        this.initPauseResumeHandler();
        this.initSaveLoadHandler();
        this.initAndLoadLocalization();
        FXGL.Companion.getGameScene().addListener(postServicesInit.2.INSTANCE);
    }

    private final void initPauseResumeHandler() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        if (readOnlyGameSettings.isMobile()) {
            this.initPauseResumeHandlerMobile();
        } else {
            this.initPauseResumeHandlerDesktop();
        }
    }

    private final void initPauseResumeHandlerMobile() {
        Optional serviceWrapper;
        Optional optional = serviceWrapper = LifecycleService.create();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"serviceWrapper");
        if (optional.isEmpty()) {
            log.warning("Attach LifecycleService is not present");
        } else {
            Object t = serviceWrapper.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"serviceWrapper.get()");
            LifecycleService service = (LifecycleService)t;
            log.debug("Init pause/resume handlers via Attach LifecycleService");
            service.addListener(LifecycleEvent.PAUSE, (Runnable)initPauseResumeHandlerMobile.1.INSTANCE);
            service.addListener(LifecycleEvent.RESUME, (Runnable)initPauseResumeHandlerMobile.2.INSTANCE);
        }
    }

    private final void initPauseResumeHandlerDesktop() {
        MainWindow mainWindow = FXGLApplication.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.iconifiedProperty().addListener((ChangeListener)initPauseResumeHandlerDesktop.1.INSTANCE);
    }

    private final void initSaveLoadHandler() {
        FXGL.Companion.getSaveLoadService().addHandler(new SaveLoadHandler(){

            public void onSave(@NotNull DataFile data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Bundle bundle = new Bundle("FXGLServices");
                Engine engine = FXGLApplication.access$getEngine$cp();
                if (engine == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                }
                engine.write(bundle);
                data.putBundle(bundle);
            }

            public void onLoad(@NotNull DataFile data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Bundle bundle = data.getBundle("FXGLServices");
                Engine engine = FXGLApplication.access$getEngine$cp();
                if (engine == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                }
                engine.read(bundle);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void initAndLoadLocalization() {
        void $this$filterTo$iv$iv;
        log.debug("Loading default localization");
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        Language defaultLang = (Language)readOnlyGameSettings.getLanguage().getValue();
        FXGLAssetLoaderService fXGLAssetLoaderService = FXGL.Companion.getAssetLoader();
        StringBuilder stringBuilder = new StringBuilder().append("languages/");
        String string = defaultLang.getName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        PropertyMap langData = fXGLAssetLoaderService.loadPropertyMap(stringBuilder.append(string3).append(".lang").toString());
        LocalizationService localizationService = FXGL.Companion.getLocalizationService();
        Language language = defaultLang;
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"defaultLang");
        localizationService.addLanguageData(language, langData.toStringMap());
        ReadOnlyGameSettings readOnlyGameSettings2 = settings;
        if (readOnlyGameSettings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        Iterable $this$filter$iv = readOnlyGameSettings2.getSupportedLanguages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Language it = (Language)element$iv$iv;
            boolean bl2 = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)defaultLang) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Language lang = (Language)element$iv;
            boolean bl3 = false;
            FXGL.Companion.getLocalizationService().addLanguageDataLazy(lang, (Function0)new Function0<Map<String, ? extends String>>(lang){
                final /* synthetic */ Language $lang;

                @NotNull
                public final Map<String, String> invoke() {
                    FXGLAssetLoaderService fXGLAssetLoaderService = FXGL.Companion.getAssetLoader();
                    StringBuilder stringBuilder = new StringBuilder().append("languages/");
                    String string = this.$lang.getName();
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    return fXGLAssetLoaderService.loadPropertyMap(stringBuilder.append(string3).append(".lang").toString()).toStringMap();
                }
                {
                    this.$lang = language;
                    super(0);
                }
            });
        }
        SimpleObjectProperty simpleObjectProperty = FXGL.Companion.getLocalizationService().selectedLanguageProperty();
        ReadOnlyGameSettings readOnlyGameSettings3 = settings;
        if (readOnlyGameSettings3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        simpleObjectProperty.bind((ObservableValue)readOnlyGameSettings3.getLanguage());
    }

    private final void setFirstSceneAfterStartup() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        if (readOnlyGameSettings.isIntroEnabled()) {
            FXGLForKtKt.getGameController().gotoIntro();
        } else {
            ReadOnlyGameSettings readOnlyGameSettings2 = settings;
            if (readOnlyGameSettings2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (readOnlyGameSettings2.isMainMenuEnabled()) {
                FXGLForKtKt.getGameController().gotoMainMenu();
            } else {
                FXGLForKtKt.getGameController().startNewGame();
            }
        }
    }

    private final void handleFatalError(Throwable error) {
        if (this.isError) {
            return;
        }
        this.isError = true;
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
        }
        engine.stopLoop();
        log.fatal("Uncaught Exception:", error);
        log.fatal("Application will now exit");
        MainWindow mainWindow = FXGLApplication.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.showFatalError(error, new Runnable(this){
            final /* synthetic */ FXGLApplication this$0;

            public final void run() {
                this.this$0.exitFXGL();
            }
            {
                this.this$0 = fXGLApplication;
            }
        });
    }

    public final void exitFXGL() {
        log.debug("Exiting FXGL");
        if (!this.isError) {
            Engine engine = FXGLApplication.engine;
            if (engine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            }
            engine.stopLoopAndExitServices();
        }
        Async.INSTANCE.shutdownNow();
        MainWindow mainWindow = FXGLApplication.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.close();
        Logger.Companion.close();
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get(FXGLApplication.class);
    }

    public static final /* synthetic */ void access$setEngine$cp(Engine engine) {
        FXGLApplication.engine = engine;
    }

    public static final /* synthetic */ void access$setMainWindow$cp(MainWindow mainWindow) {
        FXGLApplication.mainWindow = mainWindow;
    }

    public static final /* synthetic */ void access$handleFatalError(FXGLApplication $this, Throwable error) {
        $this.handleFatalError(error);
    }

    public static final /* synthetic */ void access$postServicesInit(FXGLApplication $this) {
        $this.postServicesInit();
    }

    public static final /* synthetic */ void access$setFirstSceneAfterStartup(FXGLApplication $this) {
        $this.setFirstSceneAfterStartup();
    }

    @JvmStatic
    public static final void launchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull String[] args) {
        Companion.launchFX(app, settings, args);
    }

    @JvmStatic
    @NotNull
    public static final FXGLPane embeddedLaunchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings) {
        return Companion.embeddedLaunchFX(app, settings);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$InitAppTask;", "Ljavafx/concurrent/Task;", "Ljava/lang/Void;", "()V", "call", "failed", "", "initGame", "fxgl"})
    public static final class InitAppTask
    extends Task<Void> {
        @Nullable
        protected Void call() {
            boolean $i$f$measureNanoTime = false;
            boolean bl = false;
            long start$iv = System.nanoTime();
            boolean bl2 = false;
            log.debug("Initializing game");
            this.updateMessage("Initializing game");
            this.initGame();
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            }
            gameApplication.initPhysics();
            GameApplication gameApplication2 = app;
            if (gameApplication2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            }
            gameApplication2.initUI();
            Engine engine = engine;
            if (engine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            }
            engine.onGameReady(FXGL.Companion.getWorldProperties());
            long time = System.nanoTime() - start$iv;
            log.infof("Game initialization took: %.3f sec", new Object[]{(double)time / 1.0E9});
            return null;
        }

        private final void initGame() {
            HashMap vars = new HashMap();
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            }
            gameApplication.initGameVars(vars);
            vars.forEach(initGame.1.INSTANCE);
            GameApplication gameApplication2 = app;
            if (gameApplication2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            }
            gameApplication2.initGame();
        }

        protected void failed() {
            throw (Throwable)new RuntimeException("Initialization failed", this.getException());
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a9\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u0006H\u0002J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000205H\u0002J\u0006\u0010;\u001a\u000205J\u0006\u0010<\u001a\u000205J\u000e\u0010=\u001a\u0002052\u0006\u0010>\u001a\u00020?J\u0012\u0010=\u001a\u0002052\n\u0010>\u001a\u0006\u0012\u0002\b\u00030@J\u0006\u0010A\u001a\u000205J\u0006\u0010B\u001a\u000205J\b\u0010C\u001a\u000205H\u0002J\u0010\u0010D\u001a\u0002092\u0006\u00107\u001a\u00020\u0006H\u0016J\u000e\u0010E\u001a\u0002052\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u0002052\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u000205H\u0016J\b\u0010L\u001a\u000205H\u0016J\u0010\u0010M\u001a\u0002052\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010N\u001a\u000205H\u0016J\b\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020PH\u0016J\u0010\u0010R\u001a\u0002052\u0006\u0010S\u001a\u00020\u0012H\u0016J\u0010\u0010T\u001a\u0002052\u0006\u00107\u001a\u00020\u0006H\u0002J\u000e\u0010U\u001a\u0002052\u0006\u0010F\u001a\u00020GJ\u0006\u0010V\u001a\u000209J\b\u0010W\u001a\u000205H\u0002J\u0006\u0010X\u001a\u000205R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u0002018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006Y"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$GameApplicationService;", "Lcom/almasb/fxgl/scene/SceneService;", "()V", "assetLoaderService", "Lcom/almasb/fxgl/app/services/FXGLAssetLoaderService;", "currentScene", "Lcom/almasb/fxgl/scene/Scene;", "getCurrentScene", "()Lcom/almasb/fxgl/scene/Scene;", "dialogService", "Lcom/almasb/fxgl/ui/DialogService;", "dummyScene", "com/almasb/fxgl/app/FXGLApplication$GameApplicationService$dummyScene$2$1", "getDummyScene", "()Lcom/almasb/fxgl/app/FXGLApplication$GameApplicationService$dummyScene$2$1;", "dummyScene$delegate", "Lkotlin/Lazy;", "gameMenu", "Lcom/almasb/fxgl/scene/SubScene;", "gameScene", "Lcom/almasb/fxgl/app/scene/GameScene;", "getGameScene$fxgl", "()Lcom/almasb/fxgl/app/scene/GameScene;", "setGameScene$fxgl", "(Lcom/almasb/fxgl/app/scene/GameScene;)V", "input", "Lcom/almasb/fxgl/input/Input;", "getInput", "()Lcom/almasb/fxgl/input/Input;", "intro", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "loadScene", "Lcom/almasb/fxgl/app/scene/LoadingScene;", "localService", "Lcom/almasb/fxgl/localization/LocalizationService;", "log", "Lcom/almasb/fxgl/logging/Logger;", "mainMenu", "overlayRoot", "Ljavafx/scene/Group;", "getOverlayRoot", "()Ljavafx/scene/Group;", "saveLoadService", "Lcom/almasb/fxgl/profile/SaveLoadService;", "timer", "Lcom/almasb/fxgl/time/Timer;", "getTimer", "()Lcom/almasb/fxgl/time/Timer;", "window", "Lcom/almasb/fxgl/app/MainWindow;", "getWindow$fxgl", "()Lcom/almasb/fxgl/app/MainWindow;", "addClickFeedbackHandler", "", "addOverlay", "scene", "canShowCloseDialog", "", "clearPreviousGame", "gotoGameMenu", "gotoIntro", "gotoLoading", "loadingTask", "Ljava/lang/Runnable;", "Ljavafx/concurrent/Task;", "gotoMainMenu", "gotoPlay", "initAppScenes", "isInHierarchy", "loadGame", "dataFile", "Lcom/almasb/fxgl/profile/DataFile;", "onGameUpdate", "tpf", "", "onInit", "onMainLoopStarting", "onUpdate", "popSubScene", "prefHeightProperty", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "prefWidthProperty", "pushSubScene", "subScene", "removeOverlay", "saveGame", "saveScreenshot", "showConfirmExitDialog", "startNewGame", "fxgl"})
    public static final class GameApplicationService
    extends SceneService {
        private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
        private FXGLAssetLoaderService assetLoaderService;
        private SaveLoadService saveLoadService;
        private LocalizationService localService;
        private DialogService dialogService;
        @NotNull
        private final Group overlayRoot = new Group();
        @NotNull
        private final Timer timer = new Timer();
        public GameScene gameScene;
        private LoadingScene loadScene;
        private FXGLScene intro;
        private SubScene mainMenu;
        private SubScene gameMenu;
        private final Lazy dummyScene$delegate = LazyKt.lazy((Function0)dummyScene.2.INSTANCE);

        @NotNull
        public Group getOverlayRoot() {
            return this.overlayRoot;
        }

        @NotNull
        public ReadOnlyDoubleProperty prefWidthProperty() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            return readOnlyGameSettings.prefWidthProperty();
        }

        @NotNull
        public ReadOnlyDoubleProperty prefHeightProperty() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            return readOnlyGameSettings.prefHeightProperty();
        }

        @NotNull
        public Input getInput() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            return mainWindow.getInput$fxgl();
        }

        @NotNull
        public Timer getTimer() {
            return this.timer;
        }

        @NotNull
        public Scene getCurrentScene() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            return mainWindow.getCurrentScene();
        }

        @NotNull
        public final GameScene getGameScene$fxgl() {
            GameScene gameScene = this.gameScene;
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            }
            return gameScene;
        }

        public final void setGameScene$fxgl(@NotNull GameScene gameScene) {
            Intrinsics.checkNotNullParameter((Object)((Object)gameScene), (String)"<set-?>");
            this.gameScene = gameScene;
        }

        @NotNull
        public final MainWindow getWindow$fxgl() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            return mainWindow;
        }

        public boolean isInHierarchy(@NotNull Scene scene) {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            return mainWindow.isInHierarchy(scene);
        }

        public void onInit() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            Iterable $this$forEach$iv = readOnlyGameSettings.getCSSList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.log.debug("Applying CSS: " + it);
                MainWindow mainWindow = mainWindow;
                if (mainWindow == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                }
                CSS[] cSSArray = new CSS[1];
                FXGLAssetLoaderService fXGLAssetLoaderService = this.assetLoaderService;
                if (fXGLAssetLoaderService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                }
                cSSArray[0] = fXGLAssetLoaderService.loadCSS(it);
                mainWindow.addCSS(cSSArray);
            }
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            mainWindow.setOnClose((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GameApplicationService this$0;

                public final void invoke() {
                    ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                    if (readOnlyGameSettings == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    }
                    if (readOnlyGameSettings.isCloseConfirmation()) {
                        if (GameApplicationService.access$canShowCloseDialog(this.this$0)) {
                            GameApplicationService.access$showConfirmExitDialog(this.this$0);
                        }
                    } else {
                        FXGL.Companion.getGameController().exit();
                    }
                }
                {
                    this.this$0 = gameApplicationService;
                    super(0);
                }
            }));
            MainWindow mainWindow2 = mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            mainWindow2.getCurrentSceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(this){
                final /* synthetic */ GameApplicationService this$0;

                public final void changed(ObservableValue<? extends Scene> $noName_0, Scene oldScene, Scene newScene) {
                    GameApplicationService.access$getLog$p(this.this$0).debug("Removing overlay from " + oldScene + " and adding to " + newScene);
                    Scene scene = oldScene;
                    Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"oldScene");
                    GameApplicationService.access$removeOverlay(this.this$0, scene);
                    Scene scene2 = newScene;
                    Intrinsics.checkNotNullExpressionValue((Object)scene2, (String)"newScene");
                    GameApplicationService.access$addOverlay(this.this$0, scene2);
                }
                {
                    this.this$0 = gameApplicationService;
                }
            });
            this.initAppScenes();
        }

        public void onGameUpdate(double tpf) {
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            }
            gameApplication.onUpdate(tpf);
        }

        public void onUpdate(double tpf) {
            this.getTimer().update(tpf);
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            mainWindow.update(tpf);
        }

        private final void initAppScenes() {
            this.log.debug("Initializing application scenes");
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            SceneFactory sceneFactory = readOnlyGameSettings.getSceneFactory();
            this.loadScene = sceneFactory.newLoadingScene();
            ReadOnlyGameSettings readOnlyGameSettings2 = settings;
            if (readOnlyGameSettings2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            int n = readOnlyGameSettings2.getWidth();
            ReadOnlyGameSettings readOnlyGameSettings3 = settings;
            if (readOnlyGameSettings3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            int n2 = readOnlyGameSettings3.getHeight();
            GameWorld gameWorld = new GameWorld();
            ReadOnlyGameSettings readOnlyGameSettings4 = settings;
            if (readOnlyGameSettings4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            int n3 = readOnlyGameSettings4.getHeight();
            ReadOnlyGameSettings readOnlyGameSettings5 = settings;
            if (readOnlyGameSettings5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            double d = readOnlyGameSettings5.getPixelsPerMeter();
            ReadOnlyGameSettings readOnlyGameSettings6 = settings;
            if (readOnlyGameSettings6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            PhysicsWorld physicsWorld = new PhysicsWorld(n3, d, readOnlyGameSettings6.getCollisionDetectionStrategy());
            ReadOnlyGameSettings readOnlyGameSettings7 = settings;
            if (readOnlyGameSettings7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            GameScene gameScene = this.gameScene = new GameScene(n, n2, gameWorld, physicsWorld, readOnlyGameSettings7.isExperimental3D());
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            }
            ReadOnlyGameSettings readOnlyGameSettings8 = settings;
            if (readOnlyGameSettings8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            gameScene.setSingleStep(readOnlyGameSettings8.isSingleStep());
            ReadOnlyGameSettings readOnlyGameSettings9 = settings;
            if (readOnlyGameSettings9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (readOnlyGameSettings9.isClickFeedbackEnabled()) {
                this.addClickFeedbackHandler();
            }
            ReadOnlyGameSettings readOnlyGameSettings10 = settings;
            if (readOnlyGameSettings10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (readOnlyGameSettings10.isIntroEnabled()) {
                this.intro = sceneFactory.newIntro();
            }
            ReadOnlyGameSettings readOnlyGameSettings11 = settings;
            if (readOnlyGameSettings11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (readOnlyGameSettings11.isMainMenuEnabled()) {
                this.mainMenu = sceneFactory.newMainMenu();
            }
            ReadOnlyGameSettings readOnlyGameSettings12 = settings;
            if (readOnlyGameSettings12 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (readOnlyGameSettings12.isGameMenuEnabled()) {
                this.gameMenu = sceneFactory.newGameMenu();
                EventHandler<KeyEvent> menuKeyHandler2 = new EventHandler<KeyEvent>(this){
                    private boolean canSwitchGameMenu;
                    final /* synthetic */ GameApplicationService this$0;

                    private final void onMenuKey(boolean pressed) {
                        if (!pressed) {
                            this.canSwitchGameMenu = true;
                            return;
                        }
                        if (this.canSwitchGameMenu) {
                            MainWindow mainWindow = FXGLApplication.access$getMainWindow$cp();
                            if (mainWindow == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                            }
                            if (mainWindow.getCurrentScene() == GameApplicationService.access$getGameMenu$p(this.this$0)) {
                                this.canSwitchGameMenu = false;
                                this.this$0.popSubScene();
                            } else {
                                MainWindow mainWindow2 = FXGLApplication.access$getMainWindow$cp();
                                if (mainWindow2 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                                }
                                if (mainWindow2.getCurrentScene() == this.this$0.getGameScene$fxgl()) {
                                    this.canSwitchGameMenu = false;
                                    SubScene subScene2 = GameApplicationService.access$getGameMenu$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)subScene2);
                                    this.this$0.pushSubScene(subScene2);
                                }
                            }
                        }
                    }

                    public void handle(@NotNull KeyEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        KeyCode keyCode = event.getCode();
                        ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                        if (readOnlyGameSettings == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                        }
                        if (keyCode == readOnlyGameSettings.getMenuKey()) {
                            this.onMenuKey(Intrinsics.areEqual((Object)event.getEventType(), (Object)KeyEvent.KEY_PRESSED));
                        }
                    }
                    {
                        this.this$0 = this$0;
                        this.canSwitchGameMenu = true;
                    }
                };
                GameScene gameScene2 = this.gameScene;
                if (gameScene2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
                }
                Input input = gameScene2.getInput();
                EventType eventType = KeyEvent.ANY;
                Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"KeyEvent.ANY");
                input.addEventHandler(eventType, (EventHandler)menuKeyHandler2);
                SubScene subScene2 = this.gameMenu;
                Intrinsics.checkNotNull((Object)subScene2);
                Input input2 = subScene2.getInput();
                EventType eventType2 = KeyEvent.ANY;
                Intrinsics.checkNotNullExpressionValue((Object)eventType2, (String)"KeyEvent.ANY");
                input2.addEventHandler(eventType2, (EventHandler)menuKeyHandler2);
            }
            this.log.debug("Application scenes initialized");
        }

        private final void addClickFeedbackHandler() {
            GameScene gameScene = this.gameScene;
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            }
            Input input = gameScene.getInput();
            EventType eventType = MouseEvent.MOUSE_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"MouseEvent.MOUSE_PRESSED");
            input.addEventHandler(eventType, (EventHandler)new EventHandler<MouseEvent>(this){
                final /* synthetic */ GameApplicationService this$0;

                public final void handle(MouseEvent it) {
                    Circle circle = new Circle(this.this$0.getGameScene$fxgl().getInput().getMouseXUI(), this.this$0.getGameScene$fxgl().getInput().getMouseYUI(), 5.0, null);
                    circle.setStroke((Paint)Color.GOLD);
                    circle.setStrokeWidth(2.0);
                    circle.opacityProperty().bind((ObservableValue)new SimpleDoubleProperty(1.0).subtract((ObservableNumberValue)circle.radiusProperty().divide(35.0)));
                    Collection collection = (Collection)this.this$0.getOverlayRoot().getChildren();
                    boolean bl = false;
                    collection.add(circle);
                    AnimationBuilder animationBuilder = FXGLForKtKt.animationBuilder().interpolator(Interpolators.SMOOTH.EASE_IN()).onFinished(new Runnable(this, circle){
                        final /* synthetic */ addClickFeedbackHandler.1 this$0;
                        final /* synthetic */ Circle $circle;

                        public final void run() {
                            Collection collection = (Collection)this.this$0.this$0.getOverlayRoot().getChildren();
                            Circle circle = this.$circle;
                            boolean bl = false;
                            collection.remove(circle);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$circle = circle;
                        }
                    });
                    Duration duration = Duration.seconds((double)0.33);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.seconds(0.33)");
                    AnimationBuilder animationBuilder2 = animationBuilder.duration(duration);
                    DoubleProperty doubleProperty = circle.radiusProperty();
                    Intrinsics.checkNotNullExpressionValue((Object)doubleProperty, (String)"circle.radiusProperty()");
                    animationBuilder2.animate((WritableValue)doubleProperty).to((Object)35.0).buildAndPlay();
                }
                {
                    this.this$0 = gameApplicationService;
                }
            });
        }

        public void onMainLoopStarting() {
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            }
            gameApplication.initInput();
            GameApplication gameApplication2 = app;
            if (gameApplication2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            }
            gameApplication2.onPreInit();
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (!readOnlyGameSettings.isExperimentalNative()) {
                MainWindow mainWindow = mainWindow;
                if (mainWindow == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                }
                Image[] imageArray = new Image[1];
                FXGLAssetLoaderService fXGLAssetLoaderService = this.assetLoaderService;
                if (fXGLAssetLoaderService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                }
                ReadOnlyGameSettings readOnlyGameSettings2 = settings;
                if (readOnlyGameSettings2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                }
                imageArray[0] = fXGLAssetLoaderService.loadImage(readOnlyGameSettings2.getAppIcon());
                mainWindow.addIcons(imageArray);
                MainWindow mainWindow2 = mainWindow;
                if (mainWindow2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                }
                FXGLAssetLoaderService fXGLAssetLoaderService2 = this.assetLoaderService;
                if (fXGLAssetLoaderService2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                }
                mainWindow2.setDefaultCursor(new ImageCursor(fXGLAssetLoaderService2.loadCursorImage("fxgl_default.png"), 7.0, 6.0));
            }
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            SystemActions.INSTANCE.bind(mainWindow.getInput$fxgl());
            MainWindow mainWindow3 = mainWindow;
            if (mainWindow3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            mainWindow3.getInput$fxgl().addAction(new UserAction(this, ""){
                private final onMainLoopStarting.subScene.1 subScene;
                final /* synthetic */ GameApplicationService this$0;

                protected void onActionBegin() {
                    this.this$0.pushSubScene(this.subScene);
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1);
                    this.subScene = new SubScene(this){
                        private final Lazy view$delegate;
                        final /* synthetic */ onMainLoopStarting.1 this$0;

                        private final ImageView getView() {
                            Lazy lazy = this.view$delegate;
                            onMainLoopStarting.subScene.1 var2_2 = this;
                            Object var3_3 = null;
                            boolean bl = false;
                            return (ImageView)lazy.getValue();
                        }

                        public void onCreate() {
                            this.getContentRoot().getChildren().setAll((Object[])new Node[]{(Node)this.getView()});
                            Timer timer2 = this.getTimer();
                            Function0 function0 = (Function0)new Function0<Unit>(this){
                                final /* synthetic */ onMainLoopStarting.subScene.1 this$0;

                                public final void invoke() {
                                    this.this$0.this$0.this$0.popSubScene();
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            };
                            Duration duration = Duration.seconds((double)3.0);
                            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.seconds(3.0)");
                            timer2.runOnceAfter(function0, duration);
                        }
                        {
                            this.this$0 = this$0;
                            this.view$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImageView>(this){
                                final /* synthetic */ onMainLoopStarting.subScene.1 this$0;

                                @NotNull
                                public final ImageView invoke() {
                                    ImageView imageView = new ImageView(ImagesKt.toImage((byte[])PauseMenuBGGen.INSTANCE.generate()));
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    ImageView it = imageView;
                                    boolean bl3 = false;
                                    it.setScaleX(4.0);
                                    it.setScaleY(4.0);
                                    it.setTranslateX(this.this$0.this$0.this$0.getPrefWidth() / 2.0);
                                    it.setTranslateY(this.this$0.this$0.this$0.getPrefHeight() / 2.0);
                                    return imageView;
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            }));
                        }
                    };
                }
            }, new InputSequence(KeyCode.F, KeyCode.X, new KeyCode[]{KeyCode.G, KeyCode.L, KeyCode.A, KeyCode.L, KeyCode.M, KeyCode.A, KeyCode.S, KeyCode.B}));
        }

        private final void addOverlay(Scene scene) {
            if (scene instanceof FXGLScene) {
                Collection collection = (Collection)scene.getContentRoot().getChildren();
                Group group = this.getOverlayRoot();
                boolean bl = false;
                collection.add(group);
            } else {
                Collection collection = (Collection)scene.getRoot().getChildren();
                Group group = this.getOverlayRoot();
                boolean bl = false;
                collection.add(group);
            }
        }

        private final void removeOverlay(Scene scene) {
            if (scene instanceof FXGLScene) {
                Collection collection = (Collection)scene.getContentRoot().getChildren();
                Group group = this.getOverlayRoot();
                boolean bl = false;
                collection.remove(group);
            } else {
                Collection collection = (Collection)scene.getRoot().getChildren();
                Group group = this.getOverlayRoot();
                boolean bl = false;
                collection.remove(group);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canShowCloseDialog() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            Scene scene = mainWindow.getCurrentScene();
            LoadingScene loadingScene = this.loadScene;
            if (loadingScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            if (scene == loadingScene) return false;
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (!readOnlyGameSettings.isIntroEnabled()) return true;
            MainWindow mainWindow2 = mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            if (mainWindow2.getCurrentScene() != this.intro) return true;
            return false;
        }

        private final void showConfirmExitDialog() {
            DialogService dialogService = this.dialogService;
            if (dialogService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dialogService");
            }
            LocalizationService localizationService = this.localService;
            if (localizationService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localService");
            }
            dialogService.showConfirmationBox(localizationService.getLocalizedString("dialog.exitGame"), (Consumer)showConfirmExitDialog.1.INSTANCE);
        }

        public final void startNewGame() {
            this.log.debug("Starting new game");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            LoadingScene loadingScene = this.loadScene;
            if (loadingScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            mainWindow.setScene(loadingScene);
            this.clearPreviousGame();
            LoadingScene loadingScene2 = this.loadScene;
            if (loadingScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            loadingScene2.pushNewTask(new InitAppTask());
        }

        private final void clearPreviousGame() {
            this.log.debug("Clearing previous game");
            GameScene gameScene = this.gameScene;
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            }
            gameScene.reset$fxgl();
        }

        public final void saveGame(@NotNull DataFile dataFile) {
            Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
            SaveLoadService saveLoadService = this.saveLoadService;
            if (saveLoadService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadService");
            }
            saveLoadService.save(dataFile);
        }

        public final void loadGame(@NotNull DataFile dataFile) {
            Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
            this.log.debug("Starting loaded game");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            LoadingScene loadingScene = this.loadScene;
            if (loadingScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            mainWindow.setScene(loadingScene);
            this.clearPreviousGame();
            LoadingScene loadingScene2 = this.loadScene;
            if (loadingScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            loadingScene2.pushNewTask(new Runnable(this, dataFile){
                final /* synthetic */ GameApplicationService this$0;
                final /* synthetic */ DataFile $dataFile;

                public final void run() {
                    new InitAppTask().run();
                    GameApplicationService.access$getSaveLoadService$p(this.this$0).load(this.$dataFile);
                }
                {
                    this.this$0 = gameApplicationService;
                    this.$dataFile = dataFile;
                }
            });
        }

        public final void gotoIntro() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            FXGLScene fXGLScene = this.intro;
            Intrinsics.checkNotNull((Object)((Object)fXGLScene));
            mainWindow.setScene(fXGLScene);
        }

        private final dummyScene.1 getDummyScene() {
            Lazy lazy = this.dummyScene$delegate;
            GameApplicationService gameApplicationService = this;
            Object var3_3 = null;
            boolean bl = false;
            return (Object)lazy.getValue();
        }

        public final void gotoMainMenu() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (!readOnlyGameSettings.isMainMenuEnabled()) {
                this.log.warning("Ignoring gotoMainMenu() because main menu is not enabled");
                return;
            }
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            mainWindow.setScene(this.getDummyScene());
            MainWindow mainWindow2 = mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            SubScene subScene2 = this.mainMenu;
            Intrinsics.checkNotNull((Object)subScene2);
            mainWindow2.pushState(subScene2);
        }

        public final void gotoGameMenu() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            if (!readOnlyGameSettings.isGameMenuEnabled()) {
                this.log.warning("Ignoring gotoGameMenu() because game menu is not enabled");
                return;
            }
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            SubScene subScene2 = this.gameMenu;
            Intrinsics.checkNotNull((Object)subScene2);
            mainWindow.pushState(subScene2);
        }

        public final void gotoLoading(@NotNull Runnable loadingTask) {
            Intrinsics.checkNotNullParameter((Object)loadingTask, (String)"loadingTask");
            LoadingScene loadingScene = this.loadScene;
            if (loadingScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            loadingScene.pushNewTask(loadingTask);
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            LoadingScene loadingScene2 = this.loadScene;
            if (loadingScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            mainWindow.setScene(loadingScene2);
        }

        public final void gotoLoading(@NotNull Task<?> loadingTask) {
            Intrinsics.checkNotNullParameter(loadingTask, (String)"loadingTask");
            LoadingScene loadingScene = this.loadScene;
            if (loadingScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            loadingScene.pushNewTask(loadingTask);
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            LoadingScene loadingScene2 = this.loadScene;
            if (loadingScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
            }
            mainWindow.setScene(loadingScene2);
        }

        public final void gotoPlay() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            GameScene gameScene = this.gameScene;
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            }
            mainWindow.setScene(gameScene);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean saveScreenshot() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            Image fxImage = mainWindow.takeScreenshot();
            BufferedImage img = SwingFXUtils.fromFXImage((Image)fxImage, null);
            StringBuilder stringBuilder = new StringBuilder().append("./");
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            StringBuilder stringBuilder2 = stringBuilder.append(readOnlyGameSettings.getTitle());
            ReadOnlyGameSettings readOnlyGameSettings2 = settings;
            if (readOnlyGameSettings2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            String fileName = stringBuilder2.append(readOnlyGameSettings2.getVersion()).append(LocalDateTime.now()).toString();
            fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
            try {
                String name = StringsKt.endsWith$default((String)fileName, (String)".png", (boolean)false, (int)2, null) ? fileName : fileName + ".png";
                Closeable closeable = Files.newOutputStream(Paths.get(name, new String[0]), new OpenOption[0]);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl3 = false;
                    boolean bl4 = ImageIO.write((RenderedImage)img, "png", it);
                    return bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.log.warning("saveScreenshot(" + fileName + ".png) failed: " + e);
                return false;
            }
        }

        public void pushSubScene(@NotNull SubScene subScene2) {
            Intrinsics.checkNotNullParameter((Object)subScene2, (String)"subScene");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            mainWindow.pushState(subScene2);
        }

        public void popSubScene() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            mainWindow.popState();
        }

        public static final /* synthetic */ boolean access$canShowCloseDialog(GameApplicationService $this) {
            return $this.canShowCloseDialog();
        }

        public static final /* synthetic */ void access$showConfirmExitDialog(GameApplicationService $this) {
            $this.showConfirmExitDialog();
        }

        public static final /* synthetic */ Logger access$getLog$p(GameApplicationService $this) {
            return $this.log;
        }

        public static final /* synthetic */ void access$removeOverlay(GameApplicationService $this, Scene scene) {
            $this.removeOverlay(scene);
        }

        public static final /* synthetic */ void access$addOverlay(GameApplicationService $this, Scene scene) {
            $this.addOverlay(scene);
        }

        public static final /* synthetic */ SubScene access$getGameMenu$p(GameApplicationService $this) {
            return $this.gameMenu;
        }

        public static final /* synthetic */ void access$setGameMenu$p(GameApplicationService $this, SubScene subScene2) {
            $this.gameMenu = subScene2;
        }

        public static final /* synthetic */ SaveLoadService access$getSaveLoadService$p(GameApplicationService $this) {
            SaveLoadService saveLoadService = $this.saveLoadService;
            if (saveLoadService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadService");
            }
            return saveLoadService;
        }

        public static final /* synthetic */ void access$setSaveLoadService$p(GameApplicationService $this, SaveLoadService saveLoadService) {
            $this.saveLoadService = saveLoadService;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J+\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$Companion;", "", "()V", "app", "Lcom/almasb/fxgl/app/GameApplication;", "engine", "Lcom/almasb/fxgl/app/Engine;", "log", "Lcom/almasb/fxgl/logging/Logger;", "mainWindow", "Lcom/almasb/fxgl/app/MainWindow;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "embeddedLaunchFX", "Lcom/almasb/fxgl/app/FXGLPane;", "launchFX", "", "args", "", "", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;[Ljava/lang/String;)V", "fxgl"})
    public static final class Companion {
        @JvmStatic
        public final void launchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            app = app;
            settings = settings;
            Application.launch(FXGLApplication.class, (String[])Arrays.copyOf(args, args.length));
        }

        @JvmStatic
        @NotNull
        public final FXGLPane embeddedLaunchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            app = app;
            settings = settings;
            return new FXGLApplication().embeddedStart();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

