/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.achievement.Achievement;
import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.MenuItem;
import com.almasb.fxgl.app.scene.FXGLDefaultMenu;
import com.almasb.fxgl.app.scene.FXGLMenu;
import com.almasb.fxgl.app.scene.MenuType;
import com.almasb.fxgl.app.services.IOTaskExecutorService;
import com.almasb.fxgl.core.UpdatableRunner;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.input.view.TriggerView;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.particle.ParticleEmitter;
import com.almasb.fxgl.particle.ParticleEmitters;
import com.almasb.fxgl.particle.ParticleSystem;
import com.almasb.fxgl.profile.SaveFile;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.ui.FXGLScrollPane;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactoryService;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.animation.FadeTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0016\u0018\u0000 @2\u00020\u0001:\u0005@ABCDB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015H\u0002J\b\u0010%\u001a\u00020\u0006H\u0004J\b\u0010&\u001a\u00020\u0006H\u0004J\b\u0010'\u001a\u00020\u0006H\u0004J\b\u0010(\u001a\u00020\u0006H\u0004J\b\u0010)\u001a\u00020\u0006H\u0004J\b\u0010*\u001a\u00020\u0006H\u0004J\b\u0010+\u001a\u00020\u0006H\u0004J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002J\u0010\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\f2\u0006\u00105\u001a\u000203H\u0002J\b\u00106\u001a\u00020\u001bH\u0002J\b\u00107\u001a\u000203H\u0002J\b\u00108\u001a\u00020\u001bH\u0016J\b\u00109\u001a\u00020\u001bH\u0016J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u0015H\u0014J\b\u0010<\u001a\u00020\u001bH\u0002J\u0010\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\fH\u0002J\u0010\u0010?\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu;", "Lcom/almasb/fxgl/app/scene/FXGLMenu;", "type", "Lcom/almasb/fxgl/app/scene/MenuType;", "(Lcom/almasb/fxgl/app/scene/MenuType;)V", "EMPTY", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuContent;", "animations", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/animation/Animation;", "Lkotlin/collections/ArrayList;", "menu", "Ljavafx/scene/Node;", "menuContentRoot", "Ljavafx/scene/layout/Pane;", "menuRoot", "particleSystem", "Lcom/almasb/fxgl/particle/ParticleSystem;", "pressAnyKeyState", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$PressAnyKeyState;", "t", "", "titleColor", "Ljavafx/beans/property/SimpleObjectProperty;", "Ljavafx/scene/paint/Color;", "kotlin.jvm.PlatformType", "addNewInputBinding", "", "action", "Lcom/almasb/fxgl/input/UserAction;", "trigger", "Lcom/almasb/fxgl/input/Trigger;", "grid", "Ljavafx/scene/layout/GridPane;", "createBackground", "width", "height", "createContentAchievements", "createContentAudio", "createContentControls", "createContentCredits", "createContentGameplay", "createContentLoad", "createContentVideo", "createExtraMenu", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuBox;", "createMenuBodyGameMenu", "createMenuBodyMainMenu", "createOptionsMenu", "createTitleView", "title", "", "createVersionView", "version", "initParticles", "makeVersionString", "onCreate", "onDestroy", "onUpdate", "tpf", "showProfileDialog", "switchMenuContentTo", "content", "switchMenuTo", "Companion", "MenuBox", "MenuButton", "MenuContent", "PressAnyKeyState", "fxgl"})
public class FXGLDefaultMenu
extends FXGLMenu {
    private final ParticleSystem particleSystem;
    private final SimpleObjectProperty<Color> titleColor;
    private double t;
    private final Pane menuRoot;
    private final Pane menuContentRoot;
    private final MenuContent EMPTY;
    private final PressAnyKeyState pressAnyKeyState;
    private final Node menu;
    private final ArrayList<Animation<?>> animations;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    private final void initParticles() {
        ParticleEmitter emitter;
        Texture t = FXGL.Companion.texture("particles/smoke.png", 128.0, 128.0).brighter().brighter();
        ParticleEmitter particleEmitter = emitter = ParticleEmitters.newFireEmitter();
        Intrinsics.checkNotNullExpressionValue((Object)particleEmitter, (String)"emitter");
        particleEmitter.setBlendMode(BlendMode.SRC_OVER);
        emitter.setSourceImage(t.getImage());
        emitter.setSize(150.0, 220.0);
        emitter.setNumParticles(10);
        emitter.setEmissionRate(0.01);
        emitter.setVelocityFunction((Function)initParticles.1.INSTANCE);
        emitter.setExpireFunction((Function)initParticles.2.INSTANCE);
        emitter.setScaleFunction((Function)initParticles.3.INSTANCE);
        emitter.setSpawnPointFunction((Function)new Function<Integer, Point2D>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final Point2D apply(Integer it) {
                return new Point2D(FXGL.Companion.random(0.0, (double)this.this$0.getAppWidth() - 200.0), 120.0);
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        });
        this.particleSystem.addParticleEmitter(emitter, 0.0, (double)FXGL.Companion.getAppHeight());
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate() {
        this.animations.clear();
        Object object = this.menuRoot.getChildren().get(0);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.FXGLDefaultMenu.MenuBox");
        }
        MenuBox menuBox = (MenuBox)((Object)object);
        ObservableList observableList = menuBox.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"menuBox.children");
        Iterable $this$forEachIndexed$iv = (Iterable)observableList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void node;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Node node2 = (Node)item$iv;
            int index = n;
            boolean bl2 = false;
            void v2 = node;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"node");
            v2.setTranslateX(-250.0);
            AnimationBuilder animationBuilder = FXGL.Companion.animationBuilder();
            Duration duration = Duration.seconds((double)((double)index * 0.07));
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.seconds(index * 0.07)");
            AnimationBuilder animationBuilder2 = animationBuilder.delay(duration).interpolator(Interpolators.EXPONENTIAL.EASE_OUT());
            Duration duration2 = Duration.seconds((double)0.66);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.seconds(0.66)");
            Animation animation = animationBuilder2.duration(duration2).translate(new Node[]{node}).from(new Point2D(-250.0, 0.0)).to(new Point2D(0.0, 0.0)).build();
            Collection collection = this.animations;
            boolean bl3 = false;
            collection.add(animation);
            animation.stop();
            animation.start();
        }
    }

    public void onDestroy() {
        this.switchMenuTo(this.menu);
        this.switchMenuContentTo((Node)this.EMPTY);
    }

    protected void onUpdate(double tpf) {
        if (this.getType() == MenuType.MAIN_MENU && FXGLForKtKt.getSettings().isUserProfileEnabled() && Intrinsics.areEqual((Object)FXGLForKtKt.getSettings().getProfileName().getValue(), (Object)"DEFAULT")) {
            this.showProfileDialog();
        }
        Iterable $this$forEach$iv = this.animations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animation it = (Animation)element$iv;
            boolean bl = false;
            it.onUpdate(tpf);
        }
        double frequency = 1.7;
        this.t += tpf * frequency;
        this.particleSystem.onUpdate(tpf);
        Color color = Color.color((double)1.0, (double)1.0, (double)1.0, (double)FXGLMath.noise1D((double)this.t));
        this.titleColor.set((Object)color);
    }

    private final Node createBackground(double width, double height) {
        Rectangle bg = new Rectangle(width, height);
        bg.setFill((Paint)Color.rgb((int)10, (int)1, (int)1, (double)(this.getType() == MenuType.GAME_MENU ? 0.5 : 1.0)));
        return (Node)bg;
    }

    private final Node createTitleView(String title) {
        ParticleEmitter emitter;
        Text text2;
        Text text;
        UIFactoryService uIFactoryService = FXGLForKtKt.getUIFactoryService();
        String string = title;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Text text3 = text = uIFactoryService.newText(string3, 50.0);
        Intrinsics.checkNotNullExpressionValue((Object)text3, (String)"text");
        text3.setFill((Paint)null);
        text.strokeProperty().bind((ObservableValue)this.titleColor);
        text.setStrokeWidth(1.5);
        UIFactoryService uIFactoryService2 = FXGLForKtKt.getUIFactoryService();
        String string4 = title;
        n2 = 1;
        n3 = title.length();
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Text text4 = text2 = uIFactoryService2.newText(string6, 50.0);
        Intrinsics.checkNotNullExpressionValue((Object)text4, (String)"text2");
        text4.setFill((Paint)null);
        text2.setStroke((Paint)this.titleColor.getValue());
        text2.setStrokeWidth(1.5);
        Bounds bounds = text.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"text.layoutBounds");
        double d = bounds.getWidth();
        Bounds bounds2 = text2.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds2, (String)"text2.layoutBounds");
        double textWidth = d + bounds2.getWidth();
        Rectangle border = new Rectangle(textWidth + (double)30, 65.0, null);
        border.setStroke((Paint)Color.WHITE);
        border.setStrokeWidth(4.0);
        border.setArcWidth(25.0);
        border.setArcHeight(25.0);
        ParticleEmitter particleEmitter = emitter = ParticleEmitters.newExplosionEmitter((int)50);
        Intrinsics.checkNotNullExpressionValue((Object)particleEmitter, (String)"emitter");
        particleEmitter.setBlendMode(BlendMode.ADD);
        emitter.setSourceImage(FXGLForKtKt.image("particles/trace_horizontal.png", 64.0, 64.0));
        emitter.setMaxEmissions(Integer.MAX_VALUE);
        emitter.setSize(18.0, 22.0);
        emitter.setNumParticles(2);
        emitter.setEmissionRate(0.2);
        emitter.setVelocityFunction((Function)createTitleView.1.INSTANCE);
        emitter.setExpireFunction((Function)createTitleView.2.INSTANCE);
        emitter.setScaleFunction((Function)createTitleView.3.INSTANCE);
        emitter.setSpawnPointFunction((Function)createTitleView.4.INSTANCE);
        emitter.setAccelerationFunction((Supplier)createTitleView.5.INSTANCE);
        HBox box = new HBox(new Node[]{(Node)text, (Node)text2});
        box.setAlignment(Pos.CENTER);
        StackPane titleRoot = new StackPane(new Node[]{(Node)border, (Node)box});
        titleRoot.setTranslateX((double)this.getAppWidth() / 2.0 - (textWidth + (double)30) / (double)2);
        titleRoot.setTranslateY(50.0);
        if (!FXGL.Companion.getSettings().isExperimentalNative()) {
            this.particleSystem.addParticleEmitter(emitter, (double)this.getAppWidth() / 2.0 - (double)30, titleRoot.getTranslateY() + border.getHeight() - (double)16);
        }
        return (Node)titleRoot;
    }

    private final Node createVersionView(String version) {
        Text view2;
        Text text = view2 = FXGL.Companion.getUIFactoryService().newText(version);
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"view");
        text.setTranslateY((double)(FXGL.Companion.getAppHeight() - 2));
        return (Node)view2;
    }

    private final MenuBox createMenuBodyMainMenu() {
        log.debug("createMenuBodyMainMenu()");
        MenuBox box = new MenuBox(new MenuButton[0]);
        EnumSet<MenuItem> enabledItems = FXGLForKtKt.getSettings().getEnabledMenuItems();
        MenuButton itemNewGame = new MenuButton("menu.newGame");
        itemNewGame.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent it) {
                this.this$0.fireNewGame();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        box.add(itemNewGame);
        MenuButton itemOptions = new MenuButton("menu.options");
        itemOptions.setChild(this.createOptionsMenu());
        box.add(itemOptions);
        if (enabledItems.contains((Object)MenuItem.EXTRA)) {
            MenuButton itemExtra = new MenuButton("menu.extra");
            itemExtra.setChild(this.createExtraMenu());
            box.add(itemExtra);
        }
        MenuButton itemExit = new MenuButton("menu.exit");
        itemExit.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent it) {
                this.this$0.fireExit();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        box.add(itemExit);
        return box;
    }

    private final MenuBox createMenuBodyGameMenu() {
        MenuButton itemExit;
        log.debug("createMenuBodyGameMenu()");
        MenuBox box = new MenuBox(new MenuButton[0]);
        EnumSet<MenuItem> enabledItems = FXGLForKtKt.getSettings().getEnabledMenuItems();
        MenuButton itemResume = new MenuButton("menu.resume");
        itemResume.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent it) {
                this.this$0.fireResume();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        box.add(itemResume);
        if (enabledItems.contains((Object)MenuItem.SAVE_LOAD)) {
            MenuButton itemSave = new MenuButton("menu.save");
            itemSave.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
                final /* synthetic */ FXGLDefaultMenu this$0;

                public final void handle(ActionEvent it) {
                    this.this$0.fireSave();
                }
                {
                    this.this$0 = fXGLDefaultMenu;
                }
            }));
            MenuButton itemLoad = new MenuButton("menu.load");
            itemLoad.setMenuContent(new Supplier<MenuContent>(this){
                final /* synthetic */ FXGLDefaultMenu this$0;

                @NotNull
                public final MenuContent get() {
                    return this.this$0.createContentLoad();
                }
                {
                    this.this$0 = fXGLDefaultMenu;
                }
            }, false);
            box.add(itemSave);
            box.add(itemLoad);
        }
        MenuButton itemOptions = new MenuButton("menu.options");
        itemOptions.setChild(this.createOptionsMenu());
        box.add(itemOptions);
        if (enabledItems.contains((Object)MenuItem.EXTRA)) {
            MenuButton itemExtra = new MenuButton("menu.extra");
            itemExtra.setChild(this.createExtraMenu());
            box.add(itemExtra);
        }
        if (FXGLForKtKt.getSettings().isMainMenuEnabled()) {
            itemExit = new MenuButton("menu.mainMenu");
            itemExit.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
                final /* synthetic */ FXGLDefaultMenu this$0;

                public final void handle(ActionEvent it) {
                    this.this$0.fireExitToMainMenu();
                }
                {
                    this.this$0 = fXGLDefaultMenu;
                }
            }));
            box.add(itemExit);
        } else {
            itemExit = new MenuButton("menu.exit");
            itemExit.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
                final /* synthetic */ FXGLDefaultMenu this$0;

                public final void handle(ActionEvent it) {
                    this.this$0.fireExit();
                }
                {
                    this.this$0 = fXGLDefaultMenu;
                }
            }));
            box.add(itemExit);
        }
        return box;
    }

    private final MenuBox createOptionsMenu() {
        log.debug("createOptionsMenu()");
        MenuButton itemGameplay = new MenuButton("menu.gameplay");
        MenuButton.setMenuContent$default(itemGameplay, new Supplier<MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final MenuContent get() {
                return this.this$0.createContentGameplay();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }, false, 2, null);
        MenuButton itemControls = new MenuButton("menu.controls");
        MenuButton.setMenuContent$default(itemControls, new Supplier<MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final MenuContent get() {
                return this.this$0.createContentControls();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }, false, 2, null);
        MenuButton itemVideo = new MenuButton("menu.video");
        MenuButton.setMenuContent$default(itemVideo, new Supplier<MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final MenuContent get() {
                return this.this$0.createContentVideo();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }, false, 2, null);
        MenuButton itemAudio = new MenuButton("menu.audio");
        MenuButton.setMenuContent$default(itemAudio, new Supplier<MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final MenuContent get() {
                return this.this$0.createContentAudio();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }, false, 2, null);
        MenuButton btnRestore = new MenuButton("menu.restore");
        btnRestore.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent it) {
                FXGL.Companion.getDialogService().showConfirmationBox(FXGLForKtKt.localize("menu.settingsRestore"), (Consumer)new Consumer<Boolean>(this){
                    final /* synthetic */ createOptionsMenu.5 this$0;

                    public final void accept(Boolean yes) {
                        Boolean bl = yes;
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"yes");
                        if (bl.booleanValue()) {
                            FXGLDefaultMenu.access$switchMenuContentTo(this.this$0.this$0, (Node)FXGLDefaultMenu.access$getEMPTY$p(this.this$0.this$0));
                            this.this$0.this$0.restoreDefaultSettings();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        return new MenuBox(itemGameplay, itemControls, itemVideo, itemAudio, btnRestore);
    }

    private final MenuBox createExtraMenu() {
        log.debug("createExtraMenu()");
        MenuButton itemAchievements = new MenuButton("menu.trophies");
        MenuButton.setMenuContent$default(itemAchievements, new Supplier<MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final MenuContent get() {
                return this.this$0.createContentAchievements();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }, false, 2, null);
        MenuButton itemCredits = new MenuButton("menu.credits");
        MenuButton.setMenuContent$default(itemCredits, new Supplier<MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final MenuContent get() {
                return this.this$0.createContentCredits();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }, false, 2, null);
        return new MenuBox(itemAchievements, itemCredits);
    }

    private final void switchMenuTo(Node menu) {
        Node oldMenu = (Node)this.menuRoot.getChildren().get(0);
        FadeTransition ft = new FadeTransition(Duration.seconds((double)0.33), oldMenu);
        ft.setToValue(0.0);
        ft.setOnFinished((EventHandler)new EventHandler<ActionEvent>(this, menu, oldMenu){
            final /* synthetic */ FXGLDefaultMenu this$0;
            final /* synthetic */ Node $menu;
            final /* synthetic */ Node $oldMenu;

            public final void handle(ActionEvent it) {
                this.$menu.setOpacity(0.0);
                FXGLDefaultMenu.access$getMenuRoot$p(this.this$0).getChildren().set(0, (Object)this.$menu);
                Node node = this.$oldMenu;
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"oldMenu");
                node.setOpacity(1.0);
                FadeTransition ft2 = new FadeTransition(Duration.seconds((double)0.33), this.$menu);
                ft2.setToValue(1.0);
                ft2.play();
            }
            {
                this.this$0 = fXGLDefaultMenu;
                this.$menu = node;
                this.$oldMenu = node2;
            }
        });
        ft.play();
    }

    private final void switchMenuContentTo(Node content) {
        this.menuContentRoot.getChildren().set(0, (Object)content);
    }

    private final String makeVersionString() {
        return "v" + FXGLForKtKt.getSettings().getVersion() + (FXGLForKtKt.getSettings().getApplicationMode() == ApplicationMode.RELEASE ? "" : "-" + (Object)((Object)FXGLForKtKt.getSettings().getApplicationMode()));
    }

    @NotNull
    protected final MenuContent createContentLoad() {
        log.debug("createContentLoad()");
        ListView list = FXGLForKtKt.getUIFactoryService().newListView();
        double FONT_SIZE = 16.0;
        list.setCellFactory((Callback)new Callback<ListView<SaveFile>, ListCell<SaveFile>>(FONT_SIZE){
            final /* synthetic */ double $FONT_SIZE;

            public final ListCell<SaveFile> call(ListView<SaveFile> it) {
                return (ListCell)new ListCell<SaveFile>(this){
                    final /* synthetic */ createContentLoad.1 this$0;

                    protected void updateItem(@Nullable SaveFile item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty || item == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            String string = "%-25.25s %s";
                            Object[] objectArray = new Object[]{item.getName(), item.getDateTime().format(DateTimeFormatter.ofPattern("dd-MM-yyyy HH-mm"))};
                            boolean bl = false;
                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                            String nameDate = string2;
                            Text text = FXGLForKtKt.getUIFactoryService().newText(nameDate, Color.WHITE, FontType.MONO, this.this$0.$FONT_SIZE);
                            this.setGraphic((Node)text);
                        }
                    }
                    {
                        this.this$0 = this$0;
                    }
                };
            }
            {
                this.$FONT_SIZE = d;
            }
        });
        IOTask task2 = this.getSaveLoadService().readSaveFilesTask("./", FXGLForKtKt.getSettings().getSaveFileExt()).onSuccess((Consumer)new Consumer<List<? extends SaveFile>>(list){
            final /* synthetic */ ListView $list;

            public final void accept(List<SaveFile> it) {
                ListView listView = this.$list;
                Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"list");
                ObservableList observableList = listView.getItems();
                List<SaveFile> list = it;
                Intrinsics.checkNotNullExpressionValue(list, (String)"it");
                observableList.addAll((Collection)list);
            }
            {
                this.$list = listView;
            }
        });
        IOTaskExecutorService iOTaskExecutorService = FXGL.Companion.getTaskService();
        IOTask iOTask = task2;
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"task");
        iOTaskExecutorService.runAsyncFXWithDialog(iOTask, FXGLForKtKt.localize("menu.load"));
        DoubleProperty doubleProperty = list.prefHeightProperty();
        ListView listView = list;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"list");
        doubleProperty.bind((ObservableValue)Bindings.size((ObservableList)listView.getItems()).multiply(FONT_SIZE).add(16));
        Button btnLoad = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.load"));
        BooleanProperty booleanProperty = btnLoad.disableProperty();
        ReadOnlyObjectProperty readOnlyObjectProperty = list.getSelectionModel().selectedItemProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyObjectProperty, (String)"list.selectionModel.selectedItemProperty()");
        booleanProperty.bind((ObservableValue)readOnlyObjectProperty.isNull());
        btnLoad.setOnAction((EventHandler)new EventHandler<ActionEvent>(this, list){
            final /* synthetic */ FXGLDefaultMenu this$0;
            final /* synthetic */ ListView $list;

            public final void handle(ActionEvent it) {
                SaveFile saveFile;
                ListView listView = this.$list;
                Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"list");
                MultipleSelectionModel multipleSelectionModel = listView.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)multipleSelectionModel, (String)"list.selectionModel");
                SaveFile saveFile2 = saveFile = (SaveFile)multipleSelectionModel.getSelectedItem();
                Intrinsics.checkNotNullExpressionValue((Object)saveFile2, (String)"saveFile");
                this.this$0.fireLoad(saveFile2);
            }
            {
                this.this$0 = fXGLDefaultMenu;
                this.$list = listView;
            }
        });
        Button btnDelete = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.delete"));
        BooleanProperty booleanProperty2 = btnDelete.disableProperty();
        ReadOnlyObjectProperty readOnlyObjectProperty2 = list.getSelectionModel().selectedItemProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyObjectProperty2, (String)"list.selectionModel.selectedItemProperty()");
        booleanProperty2.bind((ObservableValue)readOnlyObjectProperty2.isNull());
        btnDelete.setOnAction((EventHandler)new EventHandler<ActionEvent>(this, list){
            final /* synthetic */ FXGLDefaultMenu this$0;
            final /* synthetic */ ListView $list;

            public final void handle(ActionEvent it) {
                SaveFile saveFile;
                ListView listView = this.$list;
                Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"list");
                MultipleSelectionModel multipleSelectionModel = listView.getSelectionModel();
                Intrinsics.checkNotNullExpressionValue((Object)multipleSelectionModel, (String)"list.selectionModel");
                SaveFile saveFile2 = saveFile = (SaveFile)multipleSelectionModel.getSelectedItem();
                Intrinsics.checkNotNullExpressionValue((Object)saveFile2, (String)"saveFile");
                this.this$0.fireDelete(saveFile2);
            }
            {
                this.this$0 = fXGLDefaultMenu;
                this.$list = listView;
            }
        });
        HBox hbox = new HBox(50.0, new Node[]{(Node)btnLoad, (Node)btnDelete});
        hbox.setAlignment(Pos.CENTER);
        return new MenuContent((Node)list, (Node)hbox);
    }

    @NotNull
    protected final MenuContent createContentGameplay() {
        log.debug("createContentGameplay()");
        return new MenuContent(new Node[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final MenuContent createContentControls() {
        log.debug("createContentControls()");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(200.0, 200.0, 200.0, Priority.ALWAYS, HPos.LEFT, true));
        grid.getRowConstraints().add((Object)new RowConstraints(40.0, 40.0, 40.0, Priority.ALWAYS, VPos.CENTER, true));
        grid.setUserData((Object)0);
        Map $this$forEach$iv = FXGLForKtKt.getInput().getAllBindings();
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void action;
            Map.Entry element$iv;
            Map.Entry $dstr$action$trigger = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$action$trigger;
            boolean bl3 = false;
            UserAction userAction = (UserAction)entry.getKey();
            entry = $dstr$action$trigger;
            bl3 = false;
            Trigger trigger = (Trigger)entry.getValue();
            this.addNewInputBinding((UserAction)action, trigger, grid);
        }
        FXGLScrollPane scroll = new FXGLScrollPane((Node)grid);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        scroll.setMaxHeight((double)FXGLForKtKt.getAppHeight() / 2.5);
        HBox hbox = new HBox(new Node[]{(Node)scroll});
        hbox.setAlignment(Pos.CENTER);
        return new MenuContent((Node)hbox);
    }

    private final void addNewInputBinding(UserAction action, Trigger trigger, GridPane grid) {
        Text actionName = FXGLForKtKt.getUIFactoryService().newText(action.getName(), Color.WHITE, 18.0);
        TriggerView triggerView = new TriggerView(trigger, null, 0.0, 6, null);
        triggerView.triggerProperty().bind((ObservableValue)FXGLForKtKt.getInput().triggerProperty(action));
        triggerView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(this, action){
            final /* synthetic */ FXGLDefaultMenu this$0;
            final /* synthetic */ UserAction $action;

            public final void handle(MouseEvent it) {
                if (FXGLDefaultMenu.access$getPressAnyKeyState$p(this.this$0).isActive()) {
                    return;
                }
                FXGLDefaultMenu.access$getPressAnyKeyState$p(this.this$0).setActive(true);
                FXGLDefaultMenu.access$getPressAnyKeyState$p(this.this$0).setActionContext(this.$action);
                FXGL.Companion.getSceneService().pushSubScene((SubScene)FXGLDefaultMenu.access$getPressAnyKeyState$p(this.this$0));
            }
            {
                this.this$0 = fXGLDefaultMenu;
                this.$action = userAction;
            }
        });
        HBox hBox = new HBox();
        hBox.setPrefWidth(100.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().add((Object)triggerView);
        Object object = grid.getUserData();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        int controlsRow = (Integer)object;
        grid.addRow(controlsRow++, new Node[]{(Node)actionName, (Node)hBox});
        grid.setUserData((Object)controlsRow);
    }

    @NotNull
    protected final MenuContent createContentVideo() {
        ChoiceBox languageBox;
        log.debug("createContentVideo()");
        ChoiceBox choiceBox = languageBox = FXGLForKtKt.getUIFactoryService().newChoiceBox(FXCollections.observableArrayList((Collection)FXGLForKtKt.getSettings().getSupportedLanguages()));
        Intrinsics.checkNotNullExpressionValue((Object)choiceBox, (String)"languageBox");
        choiceBox.setValue(FXGLForKtKt.getSettings().getLanguage().getValue());
        FXGLForKtKt.getSettings().getLanguage().bindBidirectional((Property)languageBox.valueProperty());
        VBox vbox = new VBox();
        if (FXGLForKtKt.getSettings().isFullScreenAllowed()) {
            CheckBox cbFullScreen = FXGLForKtKt.getUIFactoryService().newCheckBox();
            cbFullScreen.selectedProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().getFullScreen());
            vbox.getChildren().add((Object)new HBox(25.0, new Node[]{(Node)FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localize("menu.fullscreen") + ": "), (Node)cbFullScreen}));
        }
        return new MenuContent((Node)new HBox(25.0, new Node[]{(Node)FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.language").concat((Object)":")), (Node)languageBox}), (Node)vbox);
    }

    @NotNull
    protected final MenuContent createContentAudio() {
        log.debug("createContentAudio()");
        Slider sliderMusic = new Slider(0.0, 1.0, 1.0);
        sliderMusic.valueProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().globalMusicVolumeProperty());
        Text textMusic = FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.music.volume").concat((Object)": "));
        Text percentMusic = FXGLForKtKt.getUIFactoryService().newText("");
        percentMusic.textProperty().bind((ObservableValue)sliderMusic.valueProperty().multiply(100).asString("%.0f"));
        Slider sliderSound = new Slider(0.0, 1.0, 1.0);
        sliderSound.valueProperty().bindBidirectional((Property)FXGLForKtKt.getSettings().globalSoundVolumeProperty());
        Text textSound = FXGLForKtKt.getUIFactoryService().newText(FXGLForKtKt.localizedStringProperty("menu.sound.volume").concat((Object)": "));
        Text percentSound = FXGLForKtKt.getUIFactoryService().newText("");
        percentSound.textProperty().bind((ObservableValue)sliderSound.valueProperty().multiply(100).asString("%.0f"));
        HBox hboxMusic = new HBox(15.0, new Node[]{(Node)textMusic, (Node)sliderMusic, (Node)percentMusic});
        HBox hboxSound = new HBox(15.0, new Node[]{(Node)textSound, (Node)sliderSound, (Node)percentSound});
        hboxMusic.setAlignment(Pos.CENTER_RIGHT);
        hboxSound.setAlignment(Pos.CENTER_RIGHT);
        return new MenuContent((Node)hboxMusic, (Node)hboxSound);
    }

    @NotNull
    protected final MenuContent createContentCredits() {
        log.debug("createContentCredits()");
        FXGLScrollPane pane = new FXGLScrollPane();
        pane.setPrefWidth(500.0);
        pane.setPrefHeight((double)(FXGLForKtKt.getAppHeight() / 2));
        pane.setStyle("-fx-background:black;");
        VBox vbox = new VBox();
        vbox.setAlignment(Pos.CENTER_LEFT);
        vbox.setPrefWidth(pane.getPrefWidth() - (double)15);
        ArrayList<String> credits = new ArrayList<String>((Collection)FXGLForKtKt.getSettings().getCredits());
        credits.add("");
        credits.add("Powered by FXGL " + FXGL.Companion.getVersion());
        credits.add("Author: Almas Baimagambetov");
        credits.add("https://github.com/AlmasB/FXGL");
        credits.add("");
        for (String credit : credits) {
            if (credit.length() > 45) {
                log.warning("Credit name length > 45: " + credit);
            }
            vbox.getChildren().add((Object)FXGLForKtKt.getUIFactoryService().newText(credit));
        }
        pane.setContent((Node)vbox);
        return new MenuContent((Node)pane);
    }

    @NotNull
    protected final MenuContent createContentAchievements() {
        log.debug("createContentAchievements()");
        MenuContent content = new MenuContent(new Node[0]);
        Iterable $this$forEach$iv = FXGLForKtKt.getAchievementService().getAchievementsCopy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement a = (Achievement)element$iv;
            boolean bl = false;
            CheckBox checkBox = new CheckBox();
            checkBox.setDisable(true);
            checkBox.selectedProperty().bind((ObservableValue)a.achievedProperty());
            Text text = FXGLForKtKt.getUIFactoryService().newText(a.getName());
            Tooltip tooltip = new Tooltip(a.getDescription());
            tooltip.setShowDelay(Duration.seconds((double)0.1));
            Tooltip.install((Node)((Node)text), (Tooltip)tooltip);
            HBox box = new HBox(25.0, new Node[]{(Node)text, (Node)checkBox});
            box.setAlignment(Pos.CENTER_RIGHT);
            content.getChildren().add((Object)box);
        }
        return content;
    }

    private final void showProfileDialog() {
        ChoiceBox profilesBox = FXGLForKtKt.getUIFactoryService().newChoiceBox(FXCollections.observableArrayList());
        Button btnNew = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("multiplayer.new"));
        Button btnSelect = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("multiplayer.select"));
        BooleanProperty booleanProperty = btnSelect.disableProperty();
        ObjectProperty objectProperty = profilesBox.valueProperty();
        Intrinsics.checkNotNullExpressionValue((Object)objectProperty, (String)"profilesBox.valueProperty()");
        booleanProperty.bind((ObservableValue)objectProperty.isNull());
        Button btnDelete = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty("menu.delete"));
        BooleanProperty booleanProperty2 = btnDelete.disableProperty();
        ObjectProperty objectProperty2 = profilesBox.valueProperty();
        Intrinsics.checkNotNullExpressionValue((Object)objectProperty2, (String)"profilesBox.valueProperty()");
        booleanProperty2.bind((ObservableValue)objectProperty2.isNull());
        btnNew.setOnAction((EventHandler)showProfileDialog.1.INSTANCE);
        btnSelect.setOnAction((EventHandler)new EventHandler<ActionEvent>(profilesBox){
            final /* synthetic */ ChoiceBox $profilesBox;

            public final void handle(ActionEvent it) {
                ChoiceBox choiceBox = this.$profilesBox;
                Intrinsics.checkNotNullExpressionValue((Object)choiceBox, (String)"profilesBox");
                String name = (String)choiceBox.getValue();
                FXGLForKtKt.getSettings().getProfileName().set(name);
            }
            {
                this.$profilesBox = choiceBox;
            }
        });
    }

    public FXGLDefaultMenu(@NotNull MenuType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(type);
        this.particleSystem = new ParticleSystem();
        this.titleColor = new SimpleObjectProperty((Object)Color.WHITE);
        this.menuRoot = new Pane();
        this.menuContentRoot = new Pane();
        this.EMPTY = new MenuContent(new Node[0]);
        this.pressAnyKeyState = new PressAnyKeyState();
        if (this.getAppWidth() < 800 || this.getAppHeight() < 600) {
            log.warning("FXGLDefaultMenu is not designed for resolutions < 800x600");
        }
        this.menu = type == MenuType.MAIN_MENU ? (Node)this.createMenuBodyMainMenu() : (Node)this.createMenuBodyGameMenu();
        double menuX = 50.0;
        double menuY = (double)this.getAppHeight() / 2.0 - ((MenuBox)this.menu).getLayoutHeight() / (double)2;
        this.menuRoot.setTranslateX(menuX);
        this.menuRoot.setTranslateY(menuY);
        this.menuContentRoot.setTranslateX((double)this.getAppWidth() - 500.0);
        this.menuContentRoot.setTranslateY(menuY);
        this.initParticles();
        this.menuRoot.getChildren().addAll((Object[])new Node[]{this.menu});
        this.menuContentRoot.getChildren().add((Object)this.EMPTY);
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{this.createBackground(FXGLForKtKt.getAppWidth(), FXGLForKtKt.getAppHeight()), this.createTitleView(FXGLForKtKt.getSettings().getTitle()), this.createVersionView(this.makeVersionString()), (Node)this.particleSystem.getPane(), (Node)this.menuRoot, (Node)this.menuContentRoot});
        boolean bl = false;
        this.animations = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("FXGL.DefaultMenu");
    }

    public static final /* synthetic */ void access$switchMenuContentTo(FXGLDefaultMenu $this, Node content) {
        $this.switchMenuContentTo(content);
    }

    public static final /* synthetic */ void access$switchMenuTo(FXGLDefaultMenu $this, Node menu) {
        $this.switchMenuTo(menu);
    }

    public static final /* synthetic */ MenuContent access$getEMPTY$p(FXGLDefaultMenu $this) {
        return $this.EMPTY;
    }

    public static final /* synthetic */ Pane access$getMenuRoot$p(FXGLDefaultMenu $this) {
        return $this.menuRoot;
    }

    public static final /* synthetic */ PressAnyKeyState access$getPressAnyKeyState$p(FXGLDefaultMenu $this) {
        return $this.pressAnyKeyState;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0004R\u00020\u00050\u0003\"\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u0004R\u00020\u0005R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuBox;", "Ljavafx/scene/layout/VBox;", "items", "", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuButton;", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu;", "([Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuButton;)V", "layoutHeight", "", "getLayoutHeight", "()D", "add", "", "item", "fxgl"})
    private static final class MenuBox
    extends VBox {
        public final double getLayoutHeight() {
            return 10 * this.getChildren().size();
        }

        public final void add(@NotNull MenuButton item) {
            Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
            item.setParent(this);
            this.getChildren().addAll((Object[])new Node[]{(Node)item});
        }

        public MenuBox(MenuButton ... items) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            for (MenuButton item : items) {
                this.add(item);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u001e\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\b\b\u0002\u0010\u0017\u001a\u00020\fJ\u0014\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuButton;", "Ljavafx/scene/layout/Pane;", "stringKey", "", "(Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu;Ljava/lang/String;)V", "btn", "Ljavafx/scene/control/Button;", "getBtn", "()Ljavafx/scene/control/Button;", "cachedContent", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuContent;", "isAnimating", "", "p", "Ljavafx/scene/shape/Polygon;", "parent", "Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuBox;", "setChild", "", "menu", "setMenuContent", "contentSupplier", "Ljava/util/function/Supplier;", "isCached", "setOnAction", "e", "Ljavafx/event/EventHandler;", "Ljavafx/event/ActionEvent;", "setParent", "fxgl"})
    private final class MenuButton
    extends Pane {
        private MenuBox parent;
        private MenuContent cachedContent;
        private final Polygon p;
        @NotNull
        private final Button btn;
        private boolean isAnimating;

        @NotNull
        public final Button getBtn() {
            return this.btn;
        }

        public final void setOnAction(@NotNull EventHandler<ActionEvent> e) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            this.btn.setOnAction(e);
        }

        public final void setParent(@NotNull MenuBox menu) {
            Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
            this.parent = menu;
        }

        public final void setMenuContent(@NotNull Supplier<MenuContent> contentSupplier, boolean isCached) {
            Intrinsics.checkNotNullParameter(contentSupplier, (String)"contentSupplier");
            this.btn.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(this, isCached, contentSupplier){
                final /* synthetic */ MenuButton this$0;
                final /* synthetic */ boolean $isCached;
                final /* synthetic */ Supplier $contentSupplier;

                public final void handle(ActionEvent it) {
                    if (MenuButton.access$getCachedContent$p(this.this$0) == null || !this.$isCached) {
                        MenuButton.access$setCachedContent$p(this.this$0, (MenuContent)((Object)this.$contentSupplier.get()));
                    }
                    FXGLDefaultMenu fXGLDefaultMenu = this.this$0.FXGLDefaultMenu.this;
                    MenuContent menuContent = MenuButton.access$getCachedContent$p(this.this$0);
                    Intrinsics.checkNotNull((Object)((Object)menuContent));
                    FXGLDefaultMenu.access$switchMenuContentTo(fXGLDefaultMenu, (Node)menuContent);
                }
                {
                    this.this$0 = menuButton;
                    this.$isCached = bl;
                    this.$contentSupplier = supplier;
                }
            });
        }

        public static /* synthetic */ void setMenuContent$default(MenuButton menuButton, Supplier supplier, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            menuButton.setMenuContent(supplier, bl);
        }

        public final void setChild(@NotNull MenuBox menu) {
            Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
            MenuButton back = new MenuButton("menu.back");
            menu.getChildren().add(0, (Object)back);
            back.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(this){
                final /* synthetic */ MenuButton this$0;

                public final void handle(ActionEvent it) {
                    FXGLDefaultMenu fXGLDefaultMenu = this.this$0.FXGLDefaultMenu.this;
                    MenuBox menuBox = MenuButton.access$getParent$p(this.this$0);
                    Intrinsics.checkNotNull((Object)((Object)menuBox));
                    FXGLDefaultMenu.access$switchMenuTo(fXGLDefaultMenu, (Node)menuBox);
                }
                {
                    this.this$0 = menuButton;
                }
            });
            this.btn.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(this, menu){
                final /* synthetic */ MenuButton this$0;
                final /* synthetic */ MenuBox $menu;

                public final void handle(ActionEvent it) {
                    FXGLDefaultMenu.access$switchMenuTo(this.this$0.FXGLDefaultMenu.this, (Node)this.$menu);
                }
                {
                    this.this$0 = menuButton;
                    this.$menu = menuBox;
                }
            });
        }

        public MenuButton(String stringKey) {
            Intrinsics.checkNotNullParameter((Object)stringKey, (String)"stringKey");
            this.p = new Polygon(new double[]{0.0, 0.0, 220.0, 0.0, 250.0, 35.0, 0.0, 35.0});
            Button button = FXGLForKtKt.getUIFactoryService().newButton(FXGLForKtKt.localizedStringProperty(stringKey));
            Intrinsics.checkNotNullExpressionValue((Object)button, (String)"getUIFactoryService().ne\u2026tringProperty(stringKey))");
            this.btn = button;
            this.btn.setAlignment(Pos.CENTER_LEFT);
            this.btn.setStyle("-fx-background-color: transparent");
            this.p.setMouseTransparent(true);
            LinearGradient g = new LinearGradient(0.0, 1.0, 1.0, 0.2, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.6, Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.34)), new Stop(0.85, Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.74)), new Stop(1.0, Color.WHITE)});
            Color color = Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.75);
            if (color == null) {
                throw new NullPointerException("null cannot be cast to non-null type javafx.scene.paint.Paint");
            }
            this.p.fillProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.btn.pressedProperty())).then((Object)((Paint)color)).otherwise((Object)g));
            this.p.setStroke((Paint)Color.color((double)0.1, (double)0.1, (double)0.1, (double)0.15));
            if (!FXGLForKtKt.getSettings().isExperimentalNative()) {
                this.p.setEffect((Effect)new GaussianBlur());
            }
            this.p.visibleProperty().bind((ObservableValue)this.btn.hoverProperty());
            this.getChildren().addAll((Object[])new Node[]{(Node)this.btn, (Node)this.p});
            this.btn.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean isFocused) {
                    Boolean bl = isFocused;
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isFocused");
                    if (bl.booleanValue()) {
                        boolean isOK;
                        boolean bl2;
                        block5: {
                            Iterable $this$none$iv = FXGLDefaultMenu.this.animations;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    Animation it = (Animation)element$iv;
                                    boolean bl3 = false;
                                    if (!it.isAnimating()) continue;
                                    bl2 = false;
                                    break block5;
                                }
                                bl2 = true;
                            }
                        }
                        boolean bl4 = isOK = bl2 && !isAnimating;
                        if (isOK) {
                            isAnimating = true;
                            FXGL.Companion.animationBuilder().onFinished(new Runnable(){

                                @Override
                                public final void run() {
                                    isAnimating = false;
                                }
                            }).bobbleDown((Node)this).buildAndPlay((UpdatableRunner)FXGLDefaultMenu.this);
                        }
                    }
                }
            });
        }

        public static final /* synthetic */ MenuContent access$getCachedContent$p(MenuButton $this) {
            return $this.cachedContent;
        }

        public static final /* synthetic */ void access$setCachedContent$p(MenuButton $this, MenuContent menuContent) {
            $this.cachedContent = menuContent;
        }

        public static final /* synthetic */ MenuBox access$getParent$p(MenuButton $this) {
            return $this.parent;
        }

        public static final /* synthetic */ void access$setParent$p(MenuButton $this, MenuBox menuBox) {
            $this.parent = menuBox;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$PressAnyKeyState;", "Lcom/almasb/fxgl/scene/SubScene;", "(Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu;)V", "actionContext", "Lcom/almasb/fxgl/input/UserAction;", "getActionContext", "()Lcom/almasb/fxgl/input/UserAction;", "setActionContext", "(Lcom/almasb/fxgl/input/UserAction;)V", "isActive", "", "()Z", "setActive", "(Z)V", "fxgl"})
    private final class PressAnyKeyState
    extends SubScene {
        @Nullable
        private UserAction actionContext;
        private boolean isActive;

        @Nullable
        public final UserAction getActionContext() {
            return this.actionContext;
        }

        public final void setActionContext(@Nullable UserAction userAction) {
            this.actionContext = userAction;
        }

        public final boolean isActive() {
            return this.isActive;
        }

        public final void setActive(boolean bl) {
            this.isActive = bl;
        }

        public PressAnyKeyState() {
            Input input = this.getInput();
            EventType eventType = KeyEvent.KEY_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"KeyEvent.KEY_PRESSED");
            input.addEventFilter(eventType, (EventHandler)new EventHandler<KeyEvent>(){

                public final void handle(KeyEvent e) {
                    KeyEvent keyEvent = e;
                    Intrinsics.checkNotNullExpressionValue((Object)keyEvent, (String)"e");
                    KeyCode keyCode = keyEvent.getCode();
                    Intrinsics.checkNotNullExpressionValue((Object)keyCode, (String)"e.code");
                    if (Input.Companion.isIllegal(keyCode)) {
                        return;
                    }
                    Input input = FXGLForKtKt.getInput();
                    UserAction userAction = this.getActionContext();
                    Intrinsics.checkNotNull((Object)userAction);
                    KeyCode keyCode2 = e.getCode();
                    Intrinsics.checkNotNullExpressionValue((Object)keyCode2, (String)"e.code");
                    boolean rebound = input.rebind(userAction, keyCode2, InputModifier.Companion.from(e));
                    if (rebound) {
                        FXGL.Companion.getSceneService().popSubScene();
                        this.setActive(false);
                    }
                }
            });
            Input input2 = this.getInput();
            EventType eventType2 = MouseEvent.MOUSE_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType2, (String)"MouseEvent.MOUSE_PRESSED");
            input2.addEventFilter(eventType2, (EventHandler)new EventHandler<MouseEvent>(){

                public final void handle(MouseEvent e) {
                    Input input = FXGLForKtKt.getInput();
                    UserAction userAction = this.getActionContext();
                    Intrinsics.checkNotNull((Object)userAction);
                    MouseEvent mouseEvent = e;
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"e");
                    MouseButton mouseButton = mouseEvent.getButton();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseButton, (String)"e.button");
                    boolean rebound = input.rebind(userAction, mouseButton, InputModifier.Companion.from(e));
                    if (rebound) {
                        FXGL.Companion.getSceneService().popSubScene();
                        this.setActive(false);
                    }
                }
            });
            Rectangle rect = new Rectangle(250.0, 100.0);
            rect.setStroke((Paint)Color.color((double)0.85, (double)0.9, (double)0.9, (double)0.95));
            rect.setStrokeWidth(10.0);
            rect.setArcWidth(15.0);
            rect.setArcHeight(15.0);
            Text text = FXGLForKtKt.getUIFactoryService().newText("", 24.0);
            text.textProperty().bind((ObservableValue)FXGLForKtKt.localizedStringProperty("menu.pressAnyKey"));
            StackPane pane = new StackPane(new Node[]{(Node)rect, (Node)text});
            pane.setTranslateX((double)FXGLForKtKt.getAppWidth() / 2.0 - (double)125);
            pane.setTranslateY((double)FXGLForKtKt.getAppHeight() / 2.0 - (double)50);
            this.getContentRoot().getChildren().add((Object)pane);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u000fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$MenuContent;", "Ljavafx/scene/layout/VBox;", "items", "", "Ljavafx/scene/Node;", "([Ljavafx/scene/Node;)V", "maxW", "", "getMaxW", "()I", "setMaxW", "(I)V", "onClose", "Ljava/lang/Runnable;", "onOpen", "", "setOnClose", "onCloseAction", "setOnOpen", "onOpenAction", "fxgl"})
    public static final class MenuContent
    extends VBox {
        private Runnable onOpen;
        private Runnable onClose;
        private int maxW;

        public final int getMaxW() {
            return this.maxW;
        }

        public final void setMaxW(int n) {
            this.maxW = n;
        }

        public final void setOnOpen(@NotNull Runnable onOpenAction) {
            Intrinsics.checkNotNullParameter((Object)onOpenAction, (String)"onOpenAction");
            this.onOpen = onOpenAction;
        }

        public final void setOnClose(@NotNull Runnable onCloseAction) {
            Intrinsics.checkNotNullParameter((Object)onCloseAction, (String)"onCloseAction");
            this.onClose = onCloseAction;
        }

        private final void onOpen() {
            if (this.onOpen != null) {
                Runnable runnable = this.onOpen;
                Intrinsics.checkNotNull((Object)runnable);
                runnable.run();
            }
        }

        private final void onClose() {
            if (this.onClose != null) {
                Runnable runnable = this.onClose;
                Intrinsics.checkNotNull((Object)runnable);
                runnable.run();
            }
        }

        public MenuContent(Node ... items) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            Node[] nodeArray = items;
            int n = 0;
            Node[] nodeArray2 = nodeArray;
            int n2 = 0;
            if (!(nodeArray2.length == 0)) {
                Bounds bounds = items[0].getLayoutBounds();
                Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"items[0].layoutBounds");
                this.maxW = (int)bounds.getWidth();
                for (Node n3 : items) {
                    Bounds bounds2 = n3.getLayoutBounds();
                    Intrinsics.checkNotNullExpressionValue((Object)bounds2, (String)"n.layoutBounds");
                    int w = (int)bounds2.getWidth();
                    if (w <= this.maxW) continue;
                    this.maxW = w;
                }
                for (Node item : items) {
                    this.getChildren().addAll((Object[])new Node[]{item});
                }
            }
            this.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

                public final void changed(ObservableValue<? extends Scene> $noName_0, Scene $noName_1, Scene newScene) {
                    if (newScene != null) {
                        this.onOpen();
                    } else {
                        this.onClose();
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLDefaultMenu$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

