/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.app.scene.Camera3D;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.GameScene;
import com.almasb.fxgl.app.scene.GameView;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.ui.UI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.robot.Robot;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.stage.Screen;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0002\\]B1\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u0002042\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020,J\u001f\u0010<\u001a\u0002042\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0>\"\u00020,\u00a2\u0006\u0002\u0010?J\u0006\u0010@\u001a\u000204J\u0006\u0010A\u001a\u000204J\u0010\u0010B\u001a\u0002042\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u0002042\u0006\u0010C\u001a\u00020DH\u0002J\u0018\u0010F\u001a\u0002042\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020HH\u0002J\u0018\u0010J\u001a\u00020K2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020HH\u0002J\u0010\u0010L\u001a\u0002042\u0006\u0010M\u001a\u00020\u0015H\u0016J\u0010\u0010N\u001a\u0002042\u0006\u0010M\u001a\u00020\u0015H\u0016J\u0010\u0010O\u001a\u0002042\u0006\u0010P\u001a\u00020HH\u0014J\u000e\u0010Q\u001a\u0002042\u0006\u00105\u001a\u000206J\u000e\u0010R\u001a\u0002042\u0006\u00108\u001a\u000209J\u000e\u0010S\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020,J\u001f\u0010U\u001a\u0002042\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0>\"\u00020,\u00a2\u0006\u0002\u0010?J\r\u0010V\u001a\u000204H\u0000\u00a2\u0006\u0002\bWJ\u000e\u0010X\u001a\u0002042\u0006\u0010Y\u001a\u00020\u000bJ\b\u0010Z\u001a\u000204H\u0002J\u000e\u0010[\u001a\u0002042\u0006\u0010P\u001a\u00020HR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001c\"\u0004\b \u0010\u001eR\u000e\u0010!\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\"\u001a\u0012 $*\b\u0018\u00010#R\u00020\u00000#R\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0012\u001a\u0004\b%\u0010&R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+8G\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020201X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene;", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "width", "", "height", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "is3D", "", "(IILcom/almasb/fxgl/entity/GameWorld;Lcom/almasb/fxgl/physics/PhysicsWorld;Z)V", "camera3D", "Lcom/almasb/fxgl/app/scene/Camera3D;", "getCamera3D", "()Lcom/almasb/fxgl/app/scene/Camera3D;", "camera3D$delegate", "Lkotlin/Lazy;", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "gameRoot", "Ljavafx/scene/Group;", "getGameWorld", "()Lcom/almasb/fxgl/entity/GameWorld;", "isMouseGrabbed", "()Z", "setMouseGrabbed", "(Z)V", "isSingleStep", "setSingleStep", "isZSortingNeeded", "mouseWarper", "Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "kotlin.jvm.PlatformType", "getMouseWarper", "()Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "mouseWarper$delegate", "getPhysicsWorld", "()Lcom/almasb/fxgl/physics/PhysicsWorld;", "uiNodes", "Ljavafx/collections/ObservableList;", "Ljavafx/scene/Node;", "getUINodes", "()Ljavafx/collections/ObservableList;", "uiRoot", "zChangeListener", "Ljavafx/beans/value/ChangeListener;", "", "addGameView", "", "view", "Lcom/almasb/fxgl/app/scene/GameView;", "addUI", "ui", "Lcom/almasb/fxgl/ui/UI;", "addUINode", "node", "addUINodes", "nodes", "", "([Ljavafx/scene/Node;)V", "clearGameViews", "clearUINodes", "destroyView", "viewComponent", "Lcom/almasb/fxgl/entity/components/ViewComponent;", "initView", "initViewport", "w", "", "h", "make3DSubScene", "Ljavafx/scene/SubScene;", "onEntityAdded", "entity", "onEntityRemoved", "onUpdate", "tpf", "removeGameView", "removeUI", "removeUINode", "n", "removeUINodes", "reset", "reset$fxgl", "setUIMouseTransparent", "b", "sortZ", "step", "Companion", "MouseWarper", "fxgl"})
public final class GameScene
extends FXGLScene
implements EntityWorldListener {
    private final Group gameRoot;
    private final Group uiRoot;
    private final ArrayList<Entity> entities;
    private boolean isZSortingNeeded;
    private final ChangeListener<Number> zChangeListener;
    private boolean isSingleStep;
    @NotNull
    private final Lazy camera3D$delegate;
    private final Lazy mouseWarper$delegate;
    private boolean isMouseGrabbed;
    @NotNull
    private final GameWorld gameWorld;
    @NotNull
    private final PhysicsWorld physicsWorld;
    private final boolean is3D;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    @JvmName(name="getUINodes")
    @NotNull
    public final ObservableList<Node> getUINodes() {
        ObservableList observableList = this.uiRoot.getChildrenUnmodifiable();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"uiRoot.childrenUnmodifiable");
        return observableList;
    }

    public final boolean isSingleStep() {
        return this.isSingleStep;
    }

    public final void setSingleStep(boolean bl) {
        this.isSingleStep = bl;
    }

    @NotNull
    public final Camera3D getCamera3D() {
        Lazy lazy = this.camera3D$delegate;
        GameScene gameScene = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Camera3D)lazy.getValue();
    }

    private final MouseWarper getMouseWarper() {
        Lazy lazy = this.mouseWarper$delegate;
        GameScene gameScene = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MouseWarper)lazy.getValue();
    }

    public final boolean isMouseGrabbed() {
        return this.isMouseGrabbed;
    }

    public final void setMouseGrabbed(boolean bl) {
        this.isMouseGrabbed = bl;
    }

    private final SubScene make3DSubScene(double w, double h) {
        SubScene scene3D = new SubScene((Parent)this.gameRoot, w, h, true, SceneAntialiasing.BALANCED);
        scene3D.setCamera((Camera)this.getCamera3D().getPerspectiveCamera());
        return scene3D;
    }

    private final void initViewport(double w, double h) {
        this.gameRoot.translateXProperty().bind((ObservableValue)this.getViewport().xProperty().negate());
        this.gameRoot.translateYProperty().bind((ObservableValue)this.getViewport().yProperty().negate());
        Scale scale = new Scale();
        scale.pivotXProperty().bind((ObservableValue)this.getViewport().xProperty());
        scale.pivotYProperty().bind((ObservableValue)this.getViewport().yProperty());
        scale.xProperty().bind((ObservableValue)this.getViewport().zoomProperty());
        scale.yProperty().bind((ObservableValue)this.getViewport().zoomProperty());
        this.gameRoot.getTransforms().add((Object)scale);
        Rotate rotate = new Rotate(0.0, Rotate.Z_AXIS);
        rotate.pivotXProperty().bind((ObservableValue)this.getViewport().xProperty().add(w / (double)2));
        rotate.pivotYProperty().bind((ObservableValue)this.getViewport().yProperty().add(h / (double)2));
        rotate.angleProperty().bind((ObservableValue)this.getViewport().angleProperty().negate());
        this.gameRoot.getTransforms().add((Object)rotate);
    }

    protected void onUpdate(double tpf) {
        if (this.isSingleStep) {
            return;
        }
        this.step(tpf);
    }

    public final void step(double tpf) {
        this.gameWorld.onUpdate(tpf);
        this.physicsWorld.onUpdate(tpf);
        this.getViewport().onUpdate(tpf);
        if (!this.is3D && this.isZSortingNeeded) {
            this.sortZ();
            this.isZSortingNeeded = false;
        }
        if (this.is3D) {
            this.getCamera3D().update(tpf);
        }
        if (this.isMouseGrabbed) {
            if (this.getInput().getMouseXWorld() < (double)10) {
                this.getMouseWarper().warp();
            } else if (this.getInput().getMouseXWorld() + (double)10 > (double)FXGL.Companion.getAppWidth()) {
                this.getMouseWarper().warp();
            } else if (this.getInput().getMouseYWorld() < (double)10) {
                this.getMouseWarper().warp();
            } else if (this.getInput().getMouseYWorld() + (double)10 > (double)FXGL.Companion.getAppHeight()) {
                this.getMouseWarper().warp();
            }
        }
    }

    public final void addUINode(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.uiRoot.getChildren().add((Object)node);
    }

    public final void addUINodes(Node ... nodes) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        for (Node node : nodes) {
            this.addUINode(node);
        }
    }

    public final boolean removeUINode(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return this.uiRoot.getChildren().remove((Object)n);
    }

    public final void removeUINodes(Node ... nodes) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        for (Node node : nodes) {
            this.removeUINode(node);
        }
    }

    public final void addUI(@NotNull UI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.addUINode((Node)ui.getRoot());
    }

    public final void removeUI(@NotNull UI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.removeUINode((Node)ui.getRoot());
    }

    public final void clearGameViews() {
        this.gameRoot.getChildren().clear();
    }

    public final void clearUINodes() {
        this.uiRoot.getChildren().clear();
    }

    public final void setUIMouseTransparent(boolean b) {
        this.uiRoot.setMouseTransparent(b);
    }

    private final void sortZ() {
        ArrayList tmp = new ArrayList((Collection)this.gameRoot.getChildren());
        List $this$sortBy$iv = tmp;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Node it = (Node)a;
                    boolean bl2 = false;
                    Node node = it;
                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"it");
                    Object object = node.getProperties().get((Object)"viewData");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
                    }
                    it = (Node)b;
                    Comparable comparable = Integer.valueOf(((GameView)object).getZ());
                    bl2 = false;
                    Node node2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"it");
                    Object object2 = node2.getProperties().get((Object)"viewData");
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
                    }
                    Integer n = ((GameView)object2).getZ();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            });
        }
        this.gameRoot.getChildren().setAll((Collection)tmp);
    }

    public final void reset$fxgl() {
        log.debug("Clearing game scene");
        this.gameWorld.reset();
        this.gameWorld.addWorldListener((EntityWorldListener)this.physicsWorld);
        this.gameWorld.addWorldListener((EntityWorldListener)this);
        this.physicsWorld.clear();
        this.physicsWorld.clearCollisionHandlers();
        this.getTimer().clear();
        this.getViewport().unbind();
        this.gameRoot.getChildren().clear();
        this.uiRoot.getChildren().clear();
    }

    public void onEntityAdded(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entities.add(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"entity.viewComponent");
        this.initView(viewComponent);
    }

    public void onEntityRemoved(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entities.remove(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"entity.viewComponent");
        this.destroyView(viewComponent);
    }

    public final void addGameView(@NotNull GameView view2) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        view2.getZProperty().addListener(this.zChangeListener);
        ObservableMap observableMap = view2.getNode().getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)observableMap, (String)"view.node.properties");
        ((Map)observableMap).put("viewData", view2);
        this.gameRoot.getChildren().add((Object)view2.getNode());
        this.isZSortingNeeded = true;
    }

    public final void removeGameView(@NotNull GameView view2) {
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        view2.getNode().getProperties().clear();
        this.gameRoot.getChildren().remove((Object)view2.getNode());
    }

    private final void initView(ViewComponent viewComponent) {
        Node node = (Node)viewComponent.getParent();
        Integer n = viewComponent.zIndexProperty().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"viewComponent.zIndexProperty.value");
        GameView view2 = new GameView(node, n);
        view2.getZProperty().bind((ObservableValue)viewComponent.zIndexProperty());
        this.addGameView(view2);
    }

    private final void destroyView(ViewComponent viewComponent) {
        block1: {
            Object object = viewComponent.getParent().getProperties().get((Object)"viewData");
            if (object == null) break block1;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Object object3 = it;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
            }
            GameView view2 = (GameView)object3;
            view2.getZProperty().unbind();
            view2.getZProperty().removeListener(this.zChangeListener);
            this.removeGameView(view2);
        }
    }

    @NotNull
    public final GameWorld getGameWorld() {
        return this.gameWorld;
    }

    @NotNull
    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    @JvmOverloads
    public GameScene(int width, int height, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld, boolean is3D) {
        Intrinsics.checkNotNullParameter((Object)gameWorld, (String)"gameWorld");
        Intrinsics.checkNotNullParameter((Object)physicsWorld, (String)"physicsWorld");
        super(width, height);
        this.gameWorld = gameWorld;
        this.physicsWorld = physicsWorld;
        this.is3D = is3D;
        this.gameRoot = new Group();
        this.uiRoot = new Group();
        this.entities = new ArrayList();
        this.zChangeListener = (ChangeListener)new ChangeListener<Number>(this){
            final /* synthetic */ GameScene this$0;

            public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number $noName_2) {
                GameScene.access$setZSortingNeeded$p(this.this$0, true);
            }
            {
                this.this$0 = gameScene;
            }
        };
        this.camera3D$delegate = LazyKt.lazy((Function0)camera3D.2.INSTANCE);
        this.mouseWarper$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MouseWarper>(this){
            final /* synthetic */ GameScene this$0;

            public final MouseWarper invoke() {
                return (MouseWarper)Async.INSTANCE.startAsyncFX((Callable)new Callable<MouseWarper>(this){
                    final /* synthetic */ mouseWarper.2 this$0;

                    public final MouseWarper call() {
                        return this.this$0.this$0.new MouseWarper();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).await();
            }
            {
                this.this$0 = gameScene;
                super(0);
            }
        }));
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{this.is3D ? (Node)this.make3DSubScene(width, height) : (Node)this.gameRoot, (Node)this.uiRoot});
        this.initViewport(width, height);
        this.getContentRoot().getChildren().add((Object)this.getViewport().getCamera$fxgl().getViewComponent().getParent());
        log.debug("Game scene initialized: " + width + "x" + height);
        this.gameWorld.addWorldListener((EntityWorldListener)this.physicsWorld);
        this.gameWorld.addWorldListener((EntityWorldListener)this);
    }

    public /* synthetic */ GameScene(int n, int n2, GameWorld gameWorld, PhysicsWorld physicsWorld, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        this(n, n2, gameWorld, physicsWorld, bl);
    }

    @JvmOverloads
    public GameScene(int width, int height, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld) {
        this(width, height, gameWorld, physicsWorld, false, 16, null);
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get(GameScene.class);
    }

    public static final /* synthetic */ boolean access$isZSortingNeeded$p(GameScene $this) {
        return $this.isZSortingNeeded;
    }

    public static final /* synthetic */ void access$setZSortingNeeded$p(GameScene $this, boolean bl) {
        $this.isZSortingNeeded = bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "", "(Lcom/almasb/fxgl/app/scene/GameScene;)V", "primaryScreen", "Ljavafx/stage/Screen;", "kotlin.jvm.PlatformType", "robot", "Ljavafx/scene/robot/Robot;", "screenCenter", "Ljavafx/geometry/Point2D;", "warp", "", "fxgl"})
    private final class MouseWarper {
        private final Screen primaryScreen;
        private final Point2D screenCenter;
        private final Robot robot;

        public final void warp() {
            log.debug("Warping mouse to: " + this.screenCenter);
            this.robot.mouseMove(this.screenCenter);
        }

        public MouseWarper() {
            Screen screen = this.primaryScreen = Screen.getPrimary();
            Intrinsics.checkNotNullExpressionValue((Object)screen, (String)"primaryScreen");
            Rectangle2D rectangle2D = screen.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"primaryScreen.bounds");
            double d = rectangle2D.getWidth() / 2.0;
            Screen screen2 = this.primaryScreen;
            Intrinsics.checkNotNullExpressionValue((Object)screen2, (String)"primaryScreen");
            Rectangle2D rectangle2D2 = screen2.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"primaryScreen.bounds");
            this.screenCenter = new Point2D(d, rectangle2D2.getHeight() / 2.0);
            this.robot = new Robot();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

