/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene3d.obj;

import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.scene3d.Model3D;
import com.almasb.fxgl.scene3d.Model3DLoader;
import com.almasb.fxgl.scene3d.obj.MtlData;
import com.almasb.fxgl.scene3d.obj.ObjData;
import com.almasb.fxgl.scene3d.obj.ObjGroup;
import com.almasb.fxgl.scene3d.obj.ObjModelLoader;
import com.almasb.fxgl.scene3d.obj.SubGroup;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableMap;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.shape.VertexFormat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/scene3d/obj/ObjModelLoader;", "Lcom/almasb/fxgl/scene3d/Model3DLoader;", "()V", "load", "Lcom/almasb/fxgl/scene3d/Model3D;", "url", "Ljava/net/URL;", "Companion", "fxgl"})
public final class ObjModelLoader
implements Model3DLoader {
    private static final LinkedHashMap<Function1<String, Boolean>, Function2<List<String>, ObjData, Unit>> objParsers;
    private static final LinkedHashMap<Function1<String, Boolean>, Function2<List<String>, MtlData, Unit>> mtlParsers;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Model3D load(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            ObjData data = ObjModelLoader.Companion.loadObjData(url);
            Model3D modelRoot = new Model3D();
            Iterable $this$forEach$iv = data.getGroups();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObjGroup it = (ObjGroup)element$iv;
                boolean bl = false;
                Model3D groupRoot = new Model3D();
                ObservableMap observableMap = groupRoot.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)observableMap, (String)"groupRoot.properties");
                ((Map)observableMap).put("name", it.getName());
                Iterable $this$forEach$iv2 = it.getSubGroups();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    float f;
                    Object object;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv2;
                    SubGroup it2 = (SubGroup)element$iv2;
                    boolean bl2 = false;
                    if (it2.getFaces().isEmpty()) continue;
                    TriangleMesh mesh = new TriangleMesh(VertexFormat.POINT_NORMAL_TEXCOORD);
                    Iterable iterable = data.getVertices();
                    ObservableFloatArray observableFloatArray = mesh.getPoints();
                    boolean $i$f$map = false;
                    void var21_27 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        float f2 = ((Number)item$iv$iv).floatValue();
                        object = destination$iv$iv2;
                        boolean bl3 = false;
                        Float f3 = Float.valueOf((float)(it3 * 0.05f));
                        object.add(f3);
                    }
                    object = (List)destination$iv$iv2;
                    float[] fArray = CollectionsKt.toFloatArray((Collection)((Collection)object));
                    observableFloatArray.addAll(Arrays.copyOf(fArray, fArray.length));
                    if (data.getVertexTextures().isEmpty()) {
                        int $this$map$iv2 = 2;
                        observableFloatArray = mesh.getTexCoords();
                        float[] fArray2 = new float[$this$map$iv2];
                        int n = 0;
                        while (n < $this$map$iv2) {
                            int destination$iv$iv2 = n;
                            int n2 = n++;
                            object = fArray2;
                            boolean bl4 = false;
                            f = 0.0f;
                            object[n2] = f;
                        }
                        object = fArray2;
                        observableFloatArray.addAll((float[])object);
                    } else {
                        float[] fArray3 = CollectionsKt.toFloatArray((Collection)data.getVertexTextures());
                        mesh.getTexCoords().addAll(Arrays.copyOf(fArray3, fArray3.length));
                    }
                    if (data.getVertexNormals().isEmpty()) {
                        int $this$map$iv2 = 3;
                        observableFloatArray = mesh.getNormals();
                        float[] fArray4 = new float[$this$map$iv2];
                        int n = 0;
                        while (n < $this$map$iv2) {
                            int $noName_0 = n;
                            int n3 = n++;
                            object = fArray4;
                            boolean bl5 = false;
                            f = 0.0f;
                            object[n3] = f;
                        }
                        object = fArray4;
                        observableFloatArray.addAll((float[])object);
                    } else {
                        float[] fArray5 = CollectionsKt.toFloatArray((Collection)data.getVertexNormals());
                        mesh.getNormals().addAll(Arrays.copyOf(fArray5, fArray5.length));
                    }
                    int[] nArray = CollectionsKt.toIntArray((Collection)it2.getFaces());
                    mesh.getFaces().addAll(Arrays.copyOf(nArray, nArray.length));
                    MeshView view2 = new MeshView((Mesh)mesh);
                    view2.setMaterial(it2.getMaterial());
                    view2.setCullFace(CullFace.NONE);
                    groupRoot.addMeshView(view2);
                }
                modelRoot.addModel(groupRoot);
            }
            return modelRoot;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (Throwable)new RuntimeException("Load failed for URL: " + url + " Error: " + e);
        }
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        objParsers = new LinkedHashMap();
        bl = false;
        mtlParsers = new LinkedHashMap();
        ((Map)objParsers).put(Companion.1.INSTANCE, new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull ObjData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseGroup((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)objParsers).put(Companion.3.INSTANCE, new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull ObjData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseVertexTextures((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)objParsers).put(Companion.5.INSTANCE, new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull ObjData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseVertexNormals((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)objParsers).put(Companion.7.INSTANCE, new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull ObjData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseVertices((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)objParsers).put(Companion.9.INSTANCE, new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull ObjData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseFaces((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)objParsers).put(Companion.11.INSTANCE, new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull ObjData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseMaterialLib((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)objParsers).put(Companion.13.INSTANCE, new Function2<List<? extends String>, ObjData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull ObjData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseUseMaterial((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)mtlParsers).put(Companion.15.INSTANCE, new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull MtlData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseNewMaterial((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)mtlParsers).put(Companion.17.INSTANCE, new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull MtlData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseColorAmbient((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)mtlParsers).put(Companion.19.INSTANCE, new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull MtlData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseColorDiffuse((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)mtlParsers).put(Companion.21.INSTANCE, new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull MtlData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseColorSpecular((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)mtlParsers).put(Companion.23.INSTANCE, new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull MtlData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseSpecularPower((Companion)this.receiver, p1, p2);
            }
        });
        ((Map)mtlParsers).put(Companion.25.INSTANCE, new Function2<List<? extends String>, MtlData, Unit>(Companion){

            public final void invoke(@NotNull List<String> p1, @NotNull MtlData p2) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                com.almasb.fxgl.scene3d.obj.ObjModelLoader$Companion.access$parseDiffuseMap((Companion)this.receiver, p1, p2);
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010\u001b\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010\u001c\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010\u001d\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010\u001e\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u001f\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010 \u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010!\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010\"\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u001e\u0010#\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0012\u0010$\u001a\u00020%*\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\t*\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\t*\b\u0012\u0004\u0012\u00020\u00060\tH\u0002Rr\u0010\u0003\u001af\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\u0004j2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010\r\u001af\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\b0\u0004j2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/almasb/fxgl/scene3d/obj/ObjModelLoader$Companion;", "", "()V", "mtlParsers", "Ljava/util/LinkedHashMap;", "Lkotlin/Function1;", "", "", "Lkotlin/Function2;", "", "Lcom/almasb/fxgl/scene3d/obj/MtlData;", "", "Lkotlin/collections/LinkedHashMap;", "objParsers", "Lcom/almasb/fxgl/scene3d/obj/ObjData;", "loadMtlData", "url", "Ljava/net/URL;", "loadObjData", "parseColorAmbient", "tokens", "data", "parseColorDiffuse", "parseColorSpecular", "parseDiffuseMap", "parseFaceVertex", "token", "parseFaces", "parseGroup", "parseMaterialLib", "parseNewMaterial", "parseSpecularPower", "parseUseMaterial", "parseVertexNormals", "parseVertexTextures", "parseVertices", "toColor", "Ljavafx/scene/paint/Color;", "toFloats2", "", "toFloats3", "fxgl"})
    public static final class Companion {
        private final void parseGroup(List<String> tokens, ObjData data) {
            String groupName = tokens.isEmpty() ? "default" : tokens.get(0);
            Collection collection = data.getGroups();
            ObjGroup objGroup = new ObjGroup(groupName);
            boolean bl = false;
            collection.add(objGroup);
        }

        private final void parseVertexTextures(List<String> tokens, ObjData data) {
            Collection collection = data.getVertexTextures();
            Iterable iterable = this.toFloats2(tokens);
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }

        private final void parseVertexNormals(List<String> tokens, ObjData data) {
            Collection collection = data.getVertexNormals();
            Iterable iterable = this.toFloats3(tokens);
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }

        private final void parseVertices(List<String> tokens, ObjData data) {
            Collection collection = data.getVertices();
            Iterable iterable = this.toFloats3(tokens);
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }

        /*
         * WARNING - void declaration
         */
        private final void parseFaces(List<String> tokens, ObjData data) {
            if (tokens.size() > 3) {
                int n = 2;
                int n2 = tokens.size();
                while (n < n2) {
                    void i2;
                    this.parseFaceVertex(tokens.get(0), data);
                    this.parseFaceVertex(tokens.get((int)(i2 - true)), data);
                    this.parseFaceVertex(tokens.get((int)i2), data);
                    ++i2;
                }
            } else {
                Iterable $this$forEach$iv = tokens;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String token = (String)element$iv;
                    boolean bl = false;
                    Companion.parseFaceVertex(token, data);
                }
            }
        }

        private final void parseFaceVertex(String token, ObjData data) {
            List faceVertex = StringsKt.split$default((CharSequence)token, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            switch (faceVertex.size()) {
                case 1: {
                    Collection collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    Object object = (String)faceVertex.get(0);
                    boolean bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    object = 0;
                    bl = false;
                    collection.add(object);
                    collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    object = 0;
                    bl = false;
                    collection.add(object);
                    break;
                }
                case 2: {
                    Collection collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    Object object = (String)faceVertex.get(0);
                    boolean bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    object = 0;
                    bl = false;
                    collection.add(object);
                    collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    object = (String)faceVertex.get(1);
                    bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    break;
                }
                case 3: {
                    Collection collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    Object object = (String)faceVertex.get(0);
                    boolean bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    object = (String)faceVertex.get(2);
                    bl = false;
                    object = Integer.parseInt((String)object) - 1;
                    bl = false;
                    collection.add(object);
                    collection = data.getCurrentGroup().getCurrentSubGroup().getFaces();
                    Integer n = StringsKt.toIntOrNull((String)((String)faceVertex.get(1)));
                    object = (n != null ? n : 1) - 1;
                    bl = false;
                    collection.add(object);
                    break;
                }
            }
        }

        private final void parseMaterialLib(List<String> tokens, ObjData data) {
            String fileName = tokens.get(0);
            StringBuilder stringBuilder = new StringBuilder();
            String string = data.getUrl().toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.url.toExternalForm()");
            URL mtlURL = new URL(stringBuilder.append(StringsKt.substringBeforeLast$default((String)string, (char)'/', null, (int)2, null)).append('/').append(fileName).toString());
            MtlData mtlData = this.loadMtlData(mtlURL);
            Map map = data.getMaterials();
            Map map2 = mtlData.getMaterials();
            boolean bl = false;
            map.putAll(map2);
            map = data.getAmbientColors();
            map2 = mtlData.getAmbientColors();
            bl = false;
            map.putAll(map2);
        }

        private final void parseUseMaterial(List<String> tokens, ObjData data) {
            Collection collection = data.getCurrentGroup().getSubGroups();
            SubGroup subGroup = new SubGroup();
            boolean bl = false;
            collection.add(subGroup);
            Material material = data.getMaterials().get(tokens.get(0));
            if (material == null) {
                throw (Throwable)new RuntimeException("Material with name " + tokens.get(0) + " not found");
            }
            data.getCurrentGroup().getCurrentSubGroup().setMaterial(material);
            data.getCurrentGroup().getCurrentSubGroup().setAmbientColor(data.getAmbientColors().get(data.getCurrentGroup().getCurrentSubGroup().getMaterial()));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Float> toFloats2(List<String> $this$toFloats2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.take((Iterable)$this$toFloats2, (int)2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                boolean bl2 = false;
                Float f = Float.valueOf(Float.parseFloat((String)var11_11));
                collection.add(f);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Float> toFloats3(List<String> $this$toFloats3) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.take((Iterable)$this$toFloats3, (int)3);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                boolean bl2 = false;
                Float f = Float.valueOf(Float.parseFloat((String)var11_11));
                collection.add(f);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Color toColor(List<String> $this$toColor) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.toFloats3($this$toColor);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Double d = (double)it > 1.0 ? 1.0 : (double)it;
                collection.add(d);
            }
            List rgb = (List)destination$iv$iv;
            Color color = Color.color((double)((Number)rgb.get(0)).doubleValue(), (double)((Number)rgb.get(1)).doubleValue(), (double)((Number)rgb.get(2)).doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"Color.color(rgb[0], rgb[1], rgb[2])");
            return color;
        }

        private final void parseNewMaterial(List<String> tokens, MtlData data) {
            data.setCurrentMaterial(new PhongMaterial());
            ((Map)data.getMaterials()).put(tokens.get(0), data.getCurrentMaterial());
        }

        private final void parseColorAmbient(List<String> tokens, MtlData data) {
            ((Map)data.getAmbientColors()).put(data.getCurrentMaterial(), this.toColor(tokens));
        }

        private final void parseColorDiffuse(List<String> tokens, MtlData data) {
            data.getCurrentMaterial().setDiffuseColor(this.toColor(tokens));
        }

        private final void parseColorSpecular(List<String> tokens, MtlData data) {
            data.getCurrentMaterial().setSpecularColor(this.toColor(tokens));
        }

        private final void parseSpecularPower(List<String> tokens, MtlData data) {
            String string = tokens.get(0);
            boolean bl = false;
            data.getCurrentMaterial().setSpecularPower(Double.parseDouble(string));
        }

        private final void parseDiffuseMap(List<String> tokens, MtlData data) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = data.getUrl().toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.url.toExternalForm()");
            String ext = stringBuilder.append(StringsKt.substringBeforeLast$default((String)string, (String)"/", null, (int)2, null)).append("/").toString();
            data.getCurrentMaterial().setDiffuseMap(FXGL.Companion.getAssetLoader().loadImage(new URL(ext + tokens.get(0))));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final ObjData loadObjData(URL url) {
            ObjData data = new ObjData(url);
            InputStream inputStream = url.openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"url.openStream()");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream2;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            boolean $i$f$useLines = false;
            Closeable closeable2 = $this$useLines$iv;
            int n2 = 8192;
            n = 0;
            closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n2);
            n2 = 0;
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable2;
                boolean bl3 = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl4 = false;
                Sequence $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                block5: for (Object element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl5 = false;
                    Map map = objParsers;
                    boolean bl6 = false;
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void condition2;
                        Map.Entry entry;
                        Map.Entry entry2 = entry = iterator.next();
                        boolean bl7 = false;
                        map = (Function1)entry2.getKey();
                        entry2 = entry;
                        bl7 = false;
                        Function2 action = (Function2)entry2.getValue();
                        if (!((Boolean)condition2.invoke((Object)line)).booleanValue()) continue;
                        CharSequence charSequence = line;
                        boolean bl8 = false;
                        String string = charSequence;
                        if (string == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        String string2 = " +";
                        int n3 = 0;
                        string2 = new Regex(string2);
                        n3 = 0;
                        boolean bl9 = false;
                        List tokens = CollectionsKt.drop((Iterable)string2.split(charSequence, n3), (int)1);
                        action.invoke((Object)tokens, (Object)data);
                        continue block5;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            return data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final MtlData loadMtlData(URL url) {
            MtlData data = new MtlData(url);
            InputStream inputStream = url.openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"url.openStream()");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream2;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            boolean $i$f$useLines = false;
            Closeable closeable2 = $this$useLines$iv;
            int n2 = 8192;
            n = 0;
            closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n2);
            n2 = 0;
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable2;
                boolean bl3 = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl4 = false;
                Sequence $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                block5: for (Object element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl5 = false;
                    Object object = line;
                    boolean bl6 = false;
                    String string = object;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String lineTrimmed = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    Map map = mtlParsers;
                    boolean bl7 = false;
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void condition2;
                        Object object2 = object = iterator.next();
                        boolean bl8 = false;
                        map = (Function1)object2.getKey();
                        object2 = object;
                        bl8 = false;
                        Function2 action = (Function2)object2.getValue();
                        if (!((Boolean)condition2.invoke((Object)lineTrimmed)).booleanValue()) continue;
                        CharSequence charSequence = lineTrimmed;
                        String string2 = " +";
                        int n3 = 0;
                        string2 = new Regex(string2);
                        n3 = 0;
                        boolean bl9 = false;
                        List tokens = CollectionsKt.drop((Iterable)string2.split(charSequence, n3), (int)1);
                        action.invoke((Object)tokens, (Object)data);
                        continue block5;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            return data;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$parseGroup(Companion $this, List tokens, ObjData data) {
            $this.parseGroup(tokens, data);
        }

        public static final /* synthetic */ void access$parseVertexTextures(Companion $this, List tokens, ObjData data) {
            $this.parseVertexTextures(tokens, data);
        }

        public static final /* synthetic */ void access$parseVertexNormals(Companion $this, List tokens, ObjData data) {
            $this.parseVertexNormals(tokens, data);
        }

        public static final /* synthetic */ void access$parseVertices(Companion $this, List tokens, ObjData data) {
            $this.parseVertices(tokens, data);
        }

        public static final /* synthetic */ void access$parseFaces(Companion $this, List tokens, ObjData data) {
            $this.parseFaces(tokens, data);
        }

        public static final /* synthetic */ void access$parseMaterialLib(Companion $this, List tokens, ObjData data) {
            $this.parseMaterialLib(tokens, data);
        }

        public static final /* synthetic */ void access$parseUseMaterial(Companion $this, List tokens, ObjData data) {
            $this.parseUseMaterial(tokens, data);
        }

        public static final /* synthetic */ void access$parseNewMaterial(Companion $this, List tokens, MtlData data) {
            $this.parseNewMaterial(tokens, data);
        }

        public static final /* synthetic */ void access$parseColorAmbient(Companion $this, List tokens, MtlData data) {
            $this.parseColorAmbient(tokens, data);
        }

        public static final /* synthetic */ void access$parseColorDiffuse(Companion $this, List tokens, MtlData data) {
            $this.parseColorDiffuse(tokens, data);
        }

        public static final /* synthetic */ void access$parseColorSpecular(Companion $this, List tokens, MtlData data) {
            $this.parseColorSpecular(tokens, data);
        }

        public static final /* synthetic */ void access$parseSpecularPower(Companion $this, List tokens, MtlData data) {
            $this.parseSpecularPower(tokens, data);
        }

        public static final /* synthetic */ void access$parseDiffuseMap(Companion $this, List tokens, MtlData data) {
            $this.parseDiffuseMap(tokens, data);
        }
    }
}

