/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.app.CursorInfo;
import com.almasb.fxgl.app.EmbeddedPaneWindow;
import com.almasb.fxgl.app.Engine;
import com.almasb.fxgl.app.FXGLApplication;
import com.almasb.fxgl.app.FXGLPane;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.PrimaryStageWindow;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.GameScene;
import com.almasb.fxgl.app.scene.LoadingScene;
import com.almasb.fxgl.app.scene.SceneFactory;
import com.almasb.fxgl.app.services.FXGLAssetLoaderService;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.core.util.PauseMenuBGGen;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputSequence;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.localization.Language;
import com.almasb.fxgl.localization.LocalizationService;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.profile.DataFile;
import com.almasb.fxgl.profile.SaveLoadHandler;
import com.almasb.fxgl.profile.SaveLoadService;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.DialogService;
import com.almasb.fxgl.ui.FontFactory;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactoryService;
import com.gluonhq.attach.lifecycle.LifecycleEvent;
import com.gluonhq.attach.lifecycle.LifecycleService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Application;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication;", "Ljavafx/application/Application;", "()V", "isError", "", "embeddedStart", "Lcom/almasb/fxgl/app/FXGLPane;", "exitFXGL", "", "handleFatalError", "error", "", "initAndLoadLocalization", "initPauseResumeHandler", "initPauseResumeHandlerDesktop", "initPauseResumeHandlerMobile", "initSaveLoadHandler", "postServicesInit", "setFirstSceneAfterStartup", "start", "stage", "Ljavafx/stage/Stage;", "startImpl", "windowSupplier", "Lkotlin/Function0;", "Lcom/almasb/fxgl/app/MainWindow;", "Companion", "GameApplicationService", "InitAppTask", "fxgl"})
public final class FXGLApplication
extends Application {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isError;
    @NotNull
    private static final Logger log = Logger.Companion.get(FXGLApplication.class);
    private static GameApplication app;
    private static ReadOnlyGameSettings settings;
    private static Engine engine;
    private static MainWindow mainWindow;

    private final FXGLPane embeddedStart() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        double d = readOnlyGameSettings.getWidth();
        readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        FXGLPane pane = new FXGLPane(d, readOnlyGameSettings.getHeight());
        this.startImpl((Function0<? extends MainWindow>)((Function0)new Function0<MainWindow>(pane){
            final /* synthetic */ FXGLPane $pane;
            {
                this.$pane = $pane;
                super(0);
            }

            @NotNull
            public final MainWindow invoke() {
                ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                SceneFactory sceneFactory = readOnlyGameSettings.getSceneFactory();
                readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                int n = readOnlyGameSettings.getWidth();
                readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                FXGLScene fXGLScene = sceneFactory.newStartup(n, readOnlyGameSettings.getHeight());
                readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                return new EmbeddedPaneWindow(this.$pane, fXGLScene, readOnlyGameSettings);
            }
        }));
        return pane;
    }

    public void start(@NotNull Stage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        this.startImpl((Function0<? extends MainWindow>)((Function0)new Function0<MainWindow>(stage){
            final /* synthetic */ Stage $stage;
            {
                this.$stage = $stage;
                super(0);
            }

            @NotNull
            public final MainWindow invoke() {
                ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                SceneFactory sceneFactory = readOnlyGameSettings.getSceneFactory();
                readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                int n = readOnlyGameSettings.getWidth();
                readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                FXGLScene fXGLScene = sceneFactory.newStartup(n, readOnlyGameSettings.getHeight());
                readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                if (readOnlyGameSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                return new PrimaryStageWindow(this.$stage, fXGLScene, readOnlyGameSettings);
            }
        }));
    }

    private final void startImpl(Function0<? extends MainWindow> windowSupplier) {
        Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> FXGLApplication.startImpl$lambda-0(this, arg_0, arg_1));
        log.debug("Initializing FXGL");
        Object object = settings;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        engine = new Engine((ReadOnlyGameSettings)object);
        if ((object = engine) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            throw null;
        }
        Object object2 = object;
        object = app;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"app");
            throw null;
        }
        FXGL.Companion.inject$fxgl((Engine)object2, (GameApplication)object, this);
        mainWindow = (MainWindow)windowSupplier.invoke();
        object = mainWindow;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            throw null;
        }
        ((MainWindow)object).show();
        Task task = IOTask.ofVoid(() -> FXGLApplication.startImpl$lambda-2(this)).onSuccess(arg_0 -> FXGLApplication.startImpl$lambda-3(this, arg_0)).onFailure(arg_0 -> FXGLApplication.startImpl$lambda-4(this, arg_0)).toJavaFXTask();
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
        Async.INSTANCE.execute((Runnable)task);
    }

    private final void postServicesInit() {
        Async.INSTANCE.startAsync(FXGLApplication::postServicesInit$lambda-6);
        this.initPauseResumeHandler();
        this.initSaveLoadHandler();
        this.initAndLoadLocalization();
        FXGL.Companion.getGameScene().addListener(FXGLApplication::postServicesInit$lambda-7);
    }

    private final void initPauseResumeHandler() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        if (readOnlyGameSettings.isMobile()) {
            this.initPauseResumeHandlerMobile();
        } else {
            this.initPauseResumeHandlerDesktop();
        }
    }

    private final void initPauseResumeHandlerMobile() {
        Optional serviceWrapper = LifecycleService.create();
        if (serviceWrapper.isEmpty()) {
            log.warning("Attach LifecycleService is not present");
        } else {
            Object t = serviceWrapper.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"serviceWrapper.get()");
            LifecycleService service = (LifecycleService)t;
            log.debug("Init pause/resume handlers via Attach LifecycleService");
            service.addListener(LifecycleEvent.PAUSE, FXGLApplication::initPauseResumeHandlerMobile$lambda-8);
            service.addListener(LifecycleEvent.RESUME, FXGLApplication::initPauseResumeHandlerMobile$lambda-9);
        }
    }

    private final void initPauseResumeHandlerDesktop() {
        MainWindow mainWindow = FXGLApplication.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            throw null;
        }
        mainWindow.iconifiedProperty().addListener(FXGLApplication::initPauseResumeHandlerDesktop$lambda-10);
    }

    private final void initSaveLoadHandler() {
        FXGL.Companion.getSaveLoadService().addHandler(new SaveLoadHandler(){

            public void onSave(@NotNull DataFile data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Bundle bundle = new Bundle("FXGLServices");
                Engine engine = FXGLApplication.access$getEngine$cp();
                if (engine == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                    throw null;
                }
                engine.write(bundle);
                data.putBundle(bundle);
            }

            public void onLoad(@NotNull DataFile data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Bundle bundle = data.getBundle("FXGLServices");
                Engine engine = FXGLApplication.access$getEngine$cp();
                if (engine == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                    throw null;
                }
                engine.read(bundle);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void initAndLoadLocalization() {
        void $this$filterTo$iv$iv;
        log.debug("Loading default localization");
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        Language defaultLang = (Language)readOnlyGameSettings.getLanguage().getValue();
        FXGLAssetLoaderService fXGLAssetLoaderService = FXGL.Companion.getAssetLoader();
        StringBuilder stringBuilder = new StringBuilder().append("languages/");
        Object object = defaultLang.getName();
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        PropertyMap langData = fXGLAssetLoaderService.loadPropertyMap(stringBuilder.append(string2).append(".lang").toString());
        LocalizationService localizationService = FXGL.Companion.getLocalizationService();
        Intrinsics.checkNotNullExpressionValue((Object)defaultLang, (String)"defaultLang");
        localizationService.addLanguageData(defaultLang, langData.toStringMap());
        object = settings;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        Iterable $this$filter$iv = ((ReadOnlyGameSettings)object).getSupportedLanguages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Language it = (Language)element$iv$iv;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)defaultLang))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Language lang = (Language)element$iv;
            boolean bl3 = false;
            FXGL.Companion.getLocalizationService().addLanguageDataLazy(lang, (Function0)new Function0<Map<String, ? extends String>>(lang){
                final /* synthetic */ Language $lang;
                {
                    this.$lang = $lang;
                    super(0);
                }

                @NotNull
                public final Map<String, String> invoke() {
                    FXGLAssetLoaderService fXGLAssetLoaderService = FXGL.Companion.getAssetLoader();
                    StringBuilder stringBuilder = new StringBuilder().append("languages/");
                    String string = this.$lang.getName();
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    return fXGLAssetLoaderService.loadPropertyMap(stringBuilder.append(string3).append(".lang").toString()).toStringMap();
                }
            });
        }
        object = settings;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        FXGL.Companion.getLocalizationService().selectedLanguageProperty().bind((ObservableValue)((ReadOnlyGameSettings)object).getLanguage());
    }

    private final void setFirstSceneAfterStartup() {
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        if (readOnlyGameSettings.isIntroEnabled()) {
            FXGLForKtKt.getGameController().gotoIntro();
        } else {
            readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (readOnlyGameSettings.isMainMenuEnabled()) {
                FXGLForKtKt.getGameController().gotoMainMenu();
            } else {
                FXGLForKtKt.getGameController().startNewGame();
            }
        }
    }

    private final void handleFatalError(Throwable error) {
        if (this.isError) {
            return;
        }
        this.isError = true;
        Object object = engine;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            throw null;
        }
        ((Engine)object).stopLoop();
        log.fatal("Uncaught Exception:", error);
        log.fatal("Application will now exit");
        object = mainWindow;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            throw null;
        }
        ((MainWindow)object).showFatalError(error, () -> FXGLApplication.handleFatalError$lambda-13(this));
    }

    public final void exitFXGL() {
        Object object;
        log.debug("Exiting FXGL");
        if (!this.isError) {
            object = engine;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                throw null;
            }
            ((Engine)object).stopLoopAndExitServices();
        }
        Async.INSTANCE.shutdownNow();
        object = mainWindow;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            throw null;
        }
        ((MainWindow)object).close();
        Logger.Companion.close();
    }

    private static final void startImpl$lambda-0(FXGLApplication this$0, Thread $noName_0, Throwable e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
        this$0.handleFatalError(e);
    }

    private static final void startImpl$lambda-2(FXGLApplication this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        boolean $i$f$measureNanoTime = false;
        boolean bl = false;
        long start$iv = System.nanoTime();
        boolean bl2 = false;
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            throw null;
        }
        engine.initServices();
        this$0.postServicesInit();
        long time = System.nanoTime() - start$iv;
        Object[] objectArray = new Object[]{(double)time / 1.0E9};
        log.infof("FXGL initialization took: %.3f sec", objectArray);
    }

    private static final void startImpl$lambda-3(FXGLApplication this$0, Void it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            throw null;
        }
        engine.startLoop();
        this$0.setFirstSceneAfterStartup();
    }

    private static final void startImpl$lambda-4(FXGLApplication this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleFatalError(it);
    }

    private static final void postServicesInit$lambda-6$lambda-5(UIFactoryService $uiFactory, FontFactory $fontUI, FontFactory $fontGame, FontFactory $fontMono, FontFactory $fontText) {
        Intrinsics.checkNotNullParameter((Object)$uiFactory, (String)"$uiFactory");
        Intrinsics.checkNotNullParameter((Object)$fontUI, (String)"$fontUI");
        Intrinsics.checkNotNullParameter((Object)$fontGame, (String)"$fontGame");
        Intrinsics.checkNotNullParameter((Object)$fontMono, (String)"$fontMono");
        Intrinsics.checkNotNullParameter((Object)$fontText, (String)"$fontText");
        log.debug("Registering font factories with UI factory");
        $uiFactory.registerFontFactory(FontType.UI, $fontUI);
        $uiFactory.registerFontFactory(FontType.GAME, $fontGame);
        $uiFactory.registerFontFactory(FontType.MONO, $fontMono);
        $uiFactory.registerFontFactory(FontType.TEXT, $fontText);
    }

    private static final void postServicesInit$lambda-6() {
        log.debug("Loading fonts");
        UIFactoryService uiFactory = FXGL.Companion.getUIFactoryService();
        ReadOnlyGameSettings readOnlyGameSettings = settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        FontFactory fontUI = FXGL.Companion.getAssetLoader().loadFont(readOnlyGameSettings.getFontUI());
        ReadOnlyGameSettings readOnlyGameSettings2 = settings;
        if (readOnlyGameSettings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        FontFactory fontGame = FXGL.Companion.getAssetLoader().loadFont(readOnlyGameSettings2.getFontGame());
        ReadOnlyGameSettings readOnlyGameSettings3 = settings;
        if (readOnlyGameSettings3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        FontFactory fontMono = FXGL.Companion.getAssetLoader().loadFont(readOnlyGameSettings3.getFontMono());
        ReadOnlyGameSettings readOnlyGameSettings4 = settings;
        if (readOnlyGameSettings4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            throw null;
        }
        FontFactory fontText = FXGL.Companion.getAssetLoader().loadFont(readOnlyGameSettings4.getFontText());
        Async.INSTANCE.startAsyncFX(() -> FXGLApplication.postServicesInit$lambda-6$lambda-5(uiFactory, fontUI, fontGame, fontMono, fontText));
    }

    private static final void postServicesInit$lambda-7(double tpf) {
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            throw null;
        }
        engine.onGameUpdate(tpf);
    }

    private static final void initPauseResumeHandlerMobile$lambda-8() {
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            throw null;
        }
        engine.pauseLoop();
    }

    private static final void initPauseResumeHandlerMobile$lambda-9() {
        Engine engine = FXGLApplication.engine;
        if (engine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
            throw null;
        }
        engine.resumeLoop();
    }

    private static final void initPauseResumeHandlerDesktop$lambda-10(ObservableValue $noName_0, Boolean $noName_1, Boolean isMinimized) {
        Intrinsics.checkNotNullExpressionValue((Object)isMinimized, (String)"isMinimized");
        if (isMinimized.booleanValue()) {
            Engine engine = FXGLApplication.engine;
            if (engine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                throw null;
            }
            engine.pauseLoop();
        } else {
            Engine engine = FXGLApplication.engine;
            if (engine == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                throw null;
            }
            engine.resumeLoop();
        }
    }

    private static final void handleFatalError$lambda-13(FXGLApplication this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.exitFXGL();
    }

    @JvmStatic
    public static final void launchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull String[] args) {
        Companion.launchFX(app, settings, args);
    }

    @JvmStatic
    @NotNull
    public static final FXGLPane embeddedLaunchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings) {
        return Companion.embeddedLaunchFX(app, settings);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J+\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$Companion;", "", "()V", "app", "Lcom/almasb/fxgl/app/GameApplication;", "engine", "Lcom/almasb/fxgl/app/Engine;", "log", "Lcom/almasb/fxgl/logging/Logger;", "mainWindow", "Lcom/almasb/fxgl/app/MainWindow;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "embeddedLaunchFX", "Lcom/almasb/fxgl/app/FXGLPane;", "launchFX", "", "args", "", "", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;[Ljava/lang/String;)V", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void launchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            app = app;
            settings = settings;
            Application.launch(FXGLApplication.class, (String[])Arrays.copyOf(args, args.length));
        }

        @JvmStatic
        @NotNull
        public final FXGLPane embeddedLaunchFX(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            app = app;
            settings = settings;
            return new FXGLApplication().embeddedStart();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$InitAppTask;", "Ljavafx/concurrent/Task;", "Ljava/lang/Void;", "()V", "call", "failed", "", "initGame", "fxgl"})
    public static final class InitAppTask
    extends Task<Void> {
        @Nullable
        protected Void call() {
            boolean $i$f$measureNanoTime = false;
            boolean bl = false;
            long start$iv = System.nanoTime();
            boolean bl2 = false;
            log.debug("Initializing game");
            this.updateMessage("Initializing game");
            this.initGame();
            Object object = app;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                throw null;
            }
            ((GameApplication)object).initPhysics();
            object = app;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                throw null;
            }
            ((GameApplication)object).initUI();
            object = engine;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
                throw null;
            }
            ((Engine)object).onGameReady(FXGL.Companion.getWorldProperties());
            long time = System.nanoTime() - start$iv;
            Object[] objectArray = new Object[]{(double)time / 1.0E9};
            log.infof("Game initialization took: %.3f sec", objectArray);
            return null;
        }

        private final void initGame() {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                throw null;
            }
            gameApplication.initGameVars((Map<String, Object>)vars);
            vars.forEach(InitAppTask::initGame$lambda-1);
            gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                throw null;
            }
            gameApplication.initGame();
        }

        protected void failed() {
            throw new RuntimeException("Initialization failed", this.getException());
        }

        private static final void initGame$lambda-1(String name, Object value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            FXGL.Companion.getWorldProperties().setValue(name, value);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n*\u0001\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020\u0006H\u0002J\b\u0010<\u001a\u00020=H\u0002J\b\u0010>\u001a\u000209H\u0002J\u0006\u0010?\u001a\u000209J\u0006\u0010@\u001a\u000209J\u000e\u0010A\u001a\u0002092\u0006\u0010B\u001a\u00020CJ\u0012\u0010A\u001a\u0002092\n\u0010B\u001a\u0006\u0012\u0002\b\u00030DJ\u0006\u0010E\u001a\u000209J\u0006\u0010F\u001a\u000209J\b\u0010G\u001a\u000209H\u0002J\u0010\u0010H\u001a\u00020=2\u0006\u0010;\u001a\u00020\u0006H\u0016J\u000e\u0010I\u001a\u0002092\u0006\u0010J\u001a\u00020KJ\u0010\u0010L\u001a\u0002092\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u000209H\u0016J\b\u0010P\u001a\u000209H\u0016J\u0010\u0010Q\u001a\u0002092\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010R\u001a\u000209H\u0016J\b\u0010S\u001a\u00020TH\u0016J\b\u0010U\u001a\u00020TH\u0016J\u0010\u0010V\u001a\u0002092\u0006\u0010W\u001a\u00020\u0016H\u0016J\u0010\u0010X\u001a\u0002092\u0006\u0010;\u001a\u00020\u0006H\u0002J\u000e\u0010Y\u001a\u0002092\u0006\u0010J\u001a\u00020KJ\u0006\u0010Z\u001a\u00020=J\b\u0010[\u001a\u000209H\u0002J\b\u0010\\\u001a\u000209H\u0002J\u0006\u0010]\u001a\u000209R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u000201X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006^"}, d2={"Lcom/almasb/fxgl/app/FXGLApplication$GameApplicationService;", "Lcom/almasb/fxgl/scene/SceneService;", "()V", "assetLoaderService", "Lcom/almasb/fxgl/app/services/FXGLAssetLoaderService;", "currentScene", "Lcom/almasb/fxgl/scene/Scene;", "getCurrentScene", "()Lcom/almasb/fxgl/scene/Scene;", "dialogService", "Lcom/almasb/fxgl/ui/DialogService;", "dummyScene", "com/almasb/fxgl/app/FXGLApplication$GameApplicationService$dummyScene$2$1", "getDummyScene", "()Lcom/almasb/fxgl/app/FXGLApplication$GameApplicationService$dummyScene$2$1;", "dummyScene$delegate", "Lkotlin/Lazy;", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "getEventBus", "()Lcom/almasb/fxgl/event/EventBus;", "gameMenu", "Lcom/almasb/fxgl/scene/SubScene;", "gameScene", "Lcom/almasb/fxgl/app/scene/GameScene;", "getGameScene$fxgl", "()Lcom/almasb/fxgl/app/scene/GameScene;", "setGameScene$fxgl", "(Lcom/almasb/fxgl/app/scene/GameScene;)V", "input", "Lcom/almasb/fxgl/input/Input;", "getInput", "()Lcom/almasb/fxgl/input/Input;", "intro", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "loadScene", "Lcom/almasb/fxgl/app/scene/LoadingScene;", "localService", "Lcom/almasb/fxgl/localization/LocalizationService;", "log", "Lcom/almasb/fxgl/logging/Logger;", "mainMenu", "overlayRoot", "Ljavafx/scene/Group;", "getOverlayRoot", "()Ljavafx/scene/Group;", "saveLoadService", "Lcom/almasb/fxgl/profile/SaveLoadService;", "timer", "Lcom/almasb/fxgl/time/Timer;", "getTimer", "()Lcom/almasb/fxgl/time/Timer;", "window", "Lcom/almasb/fxgl/app/MainWindow;", "getWindow$fxgl", "()Lcom/almasb/fxgl/app/MainWindow;", "addClickFeedbackHandler", "", "addOverlay", "scene", "canShowCloseDialog", "", "clearPreviousGame", "gotoGameMenu", "gotoIntro", "gotoLoading", "loadingTask", "Ljava/lang/Runnable;", "Ljavafx/concurrent/Task;", "gotoMainMenu", "gotoPlay", "initAppScenes", "isInHierarchy", "loadGame", "dataFile", "Lcom/almasb/fxgl/profile/DataFile;", "onGameUpdate", "tpf", "", "onInit", "onMainLoopStarting", "onUpdate", "popSubScene", "prefHeightProperty", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "prefWidthProperty", "pushSubScene", "subScene", "removeOverlay", "saveGame", "saveScreenshot", "setSceneAfterIntro", "showConfirmExitDialog", "startNewGame", "fxgl"})
    public static final class GameApplicationService
    extends SceneService {
        @NotNull
        private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
        private FXGLAssetLoaderService assetLoaderService;
        private SaveLoadService saveLoadService;
        private LocalizationService localService;
        private DialogService dialogService;
        @NotNull
        private final Group overlayRoot = new Group();
        @NotNull
        private final EventBus eventBus = new EventBus();
        @NotNull
        private final Timer timer = new Timer();
        public GameScene gameScene;
        private LoadingScene loadScene;
        @Nullable
        private FXGLScene intro;
        @Nullable
        private SubScene mainMenu;
        @Nullable
        private SubScene gameMenu;
        @NotNull
        private final Lazy dummyScene$delegate = LazyKt.lazy((Function0)dummyScene.2.INSTANCE);

        @NotNull
        public Group getOverlayRoot() {
            return this.overlayRoot;
        }

        @NotNull
        public ReadOnlyDoubleProperty prefWidthProperty() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            return readOnlyGameSettings.prefWidthProperty();
        }

        @NotNull
        public ReadOnlyDoubleProperty prefHeightProperty() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            return readOnlyGameSettings.prefHeightProperty();
        }

        @NotNull
        public EventBus getEventBus() {
            return this.eventBus;
        }

        @NotNull
        public Input getInput() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            return mainWindow.getInput$fxgl();
        }

        @NotNull
        public Timer getTimer() {
            return this.timer;
        }

        @NotNull
        public Scene getCurrentScene() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            return mainWindow.getCurrentScene();
        }

        @NotNull
        public final GameScene getGameScene$fxgl() {
            GameScene gameScene = this.gameScene;
            if (gameScene != null) {
                return gameScene;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            throw null;
        }

        public final void setGameScene$fxgl(@NotNull GameScene gameScene) {
            Intrinsics.checkNotNullParameter((Object)((Object)gameScene), (String)"<set-?>");
            this.gameScene = gameScene;
        }

        @NotNull
        public final MainWindow getWindow$fxgl() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            return mainWindow;
        }

        public boolean isInHierarchy(@NotNull Scene scene) {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            return mainWindow.isInHierarchy(scene);
        }

        public void onInit() {
            Object object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            Iterable $this$forEach$iv = ((ReadOnlyGameSettings)object).getCSSList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.log.debug(Intrinsics.stringPlus((String)"Applying CSS: ", (Object)it));
                CSS[] cSSArray = mainWindow;
                if (cSSArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                    throw null;
                }
                CSS[] cSSArray2 = cSSArray;
                cSSArray = new CSS[1];
                FXGLAssetLoaderService fXGLAssetLoaderService = this.assetLoaderService;
                if (fXGLAssetLoaderService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                    throw null;
                }
                cSSArray[0] = fXGLAssetLoaderService.loadCSS(it);
                cSSArray2.addCSS(cSSArray);
            }
            object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            ((MainWindow)object).setOnClose((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ GameApplicationService this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                    if (readOnlyGameSettings == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                        throw null;
                    }
                    if (readOnlyGameSettings.isCloseConfirmation()) {
                        if (GameApplicationService.access$canShowCloseDialog(this.this$0)) {
                            GameApplicationService.access$showConfirmExitDialog(this.this$0);
                        }
                    } else {
                        FXGL.Companion.getGameController().exit();
                    }
                }
            }));
            object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            ((MainWindow)object).getCurrentSceneProperty().addListener((arg_0, arg_1, arg_2) -> GameApplicationService.onInit$lambda-1(this, arg_0, arg_1, arg_2));
            this.initAppScenes();
        }

        public void onGameUpdate(double tpf) {
            GameApplication gameApplication = app;
            if (gameApplication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                throw null;
            }
            gameApplication.onUpdate(tpf);
        }

        public void onUpdate(double tpf) {
            this.getTimer().update(tpf);
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            mainWindow.update(tpf);
        }

        /*
         * WARNING - void declaration
         */
        private final void initAppScenes() {
            this.log.debug("Initializing application scenes");
            Object object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            SceneFactory sceneFactory = ((ReadOnlyGameSettings)object).getSceneFactory();
            this.loadScene = sceneFactory.newLoadingScene();
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            int n = ((ReadOnlyGameSettings)object).getWidth();
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            int n2 = ((ReadOnlyGameSettings)object).getHeight();
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            int n3 = ((ReadOnlyGameSettings)object).getHeight();
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            double d = ((ReadOnlyGameSettings)object).getPixelsPerMeter();
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            PhysicsWorld physicsWorld = new PhysicsWorld(n3, d, ((ReadOnlyGameSettings)object).getCollisionDetectionStrategy());
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            this.setGameScene$fxgl(new GameScene(n, n2, new GameWorld(), physicsWorld, ((ReadOnlyGameSettings)object).is3D()));
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            this.getGameScene$fxgl().setSingleStep(((ReadOnlyGameSettings)object).isSingleStep());
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (((ReadOnlyGameSettings)object).isClickFeedbackEnabled()) {
                this.addClickFeedbackHandler();
            }
            if ((object = settings) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (((ReadOnlyGameSettings)object).isIntroEnabled()) {
                void it;
                object = sceneFactory.newIntro();
                boolean bl = false;
                boolean bl2 = false;
                Object object2 = object;
                GameApplicationService gameApplicationService = this;
                boolean bl3 = false;
                it.setOnFinished$fxgl(() -> GameApplicationService.initAppScenes$lambda-3$lambda-2(this));
                Unit unit = Unit.INSTANCE;
                gameApplicationService.intro = (FXGLScene)((Object)object);
            }
            if ((object = settings) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (((ReadOnlyGameSettings)object).isMainMenuEnabled()) {
                this.mainMenu = sceneFactory.newMainMenu();
            }
            if ((object = settings) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (((ReadOnlyGameSettings)object).isGameMenuEnabled()) {
                this.gameMenu = sceneFactory.newGameMenu();
                EventHandler<KeyEvent> menuKeyHandler2 = new EventHandler<KeyEvent>(this){
                    private boolean canSwitchGameMenu;
                    final /* synthetic */ GameApplicationService this$0;
                    {
                        this.this$0 = $receiver;
                        this.canSwitchGameMenu = true;
                    }

                    private final void onMenuKey(boolean pressed) {
                        if (!pressed) {
                            this.canSwitchGameMenu = true;
                            return;
                        }
                        if (this.canSwitchGameMenu) {
                            MainWindow mainWindow = FXGLApplication.access$getMainWindow$cp();
                            if (mainWindow == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                                throw null;
                            }
                            if (mainWindow.getCurrentScene() == GameApplicationService.access$getGameMenu$p(this.this$0)) {
                                this.canSwitchGameMenu = false;
                                this.this$0.popSubScene();
                            } else {
                                mainWindow = FXGLApplication.access$getMainWindow$cp();
                                if (mainWindow == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                                    throw null;
                                }
                                if (mainWindow.getCurrentScene() == this.this$0.getGameScene$fxgl()) {
                                    this.canSwitchGameMenu = false;
                                    mainWindow = GameApplicationService.access$getGameMenu$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)mainWindow);
                                    this.this$0.pushSubScene((SubScene)mainWindow);
                                }
                            }
                        }
                    }

                    public void handle(@NotNull KeyEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        ReadOnlyGameSettings readOnlyGameSettings = FXGLApplication.access$getSettings$cp();
                        if (readOnlyGameSettings == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                            throw null;
                        }
                        if (event.getCode() == readOnlyGameSettings.getMenuKey()) {
                            this.onMenuKey(Intrinsics.areEqual((Object)event.getEventType(), (Object)KeyEvent.KEY_PRESSED));
                        }
                    }
                };
                Input input = this.getGameScene$fxgl().getInput();
                EventType eventType = KeyEvent.ANY;
                Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"ANY");
                input.addEventHandler(eventType, (EventHandler)menuKeyHandler2);
                eventType = this.gameMenu;
                Intrinsics.checkNotNull((Object)eventType);
                Input input2 = eventType.getInput();
                eventType = KeyEvent.ANY;
                Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"ANY");
                input2.addEventHandler(eventType, (EventHandler)menuKeyHandler2);
            }
            this.log.debug("Application scenes initialized");
        }

        private final void setSceneAfterIntro() {
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (readOnlyGameSettings.isMainMenuEnabled()) {
                FXGLForKtKt.getGameController().gotoMainMenu();
            } else {
                FXGLForKtKt.getGameController().startNewGame();
            }
        }

        private final void addClickFeedbackHandler() {
            Input input = this.getGameScene$fxgl().getInput();
            EventType eventType = MouseEvent.MOUSE_PRESSED;
            Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"MOUSE_PRESSED");
            input.addEventHandler(eventType, arg_0 -> GameApplicationService.addClickFeedbackHandler$lambda-5(this, arg_0));
        }

        public void onMainLoopStarting() {
            Object object = app;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                throw null;
            }
            ((GameApplication)object).initInput();
            object = app;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"app");
                throw null;
            }
            ((GameApplication)object).onPreInit();
            object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (!((ReadOnlyGameSettings)object).isNative()) {
                object = mainWindow;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                    throw null;
                }
                Image[] imageArray = object;
                object = new Image[1];
                Object object2 = this.assetLoaderService;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                    throw null;
                }
                FXGLAssetLoaderService fXGLAssetLoaderService = object2;
                object2 = settings;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                object[0] = fXGLAssetLoaderService.loadImage(((ReadOnlyGameSettings)object2).getAppIcon());
                imageArray.addIcons((Image[])object);
                object2 = settings;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    throw null;
                }
                CursorInfo cursorInfo = ((ReadOnlyGameSettings)object2).getDefaultCursor();
                object2 = mainWindow;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                    throw null;
                }
                FXGLAssetLoaderService fXGLAssetLoaderService2 = object2;
                object2 = this.assetLoaderService;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
                    throw null;
                }
                ((MainWindow)((Object)fXGLAssetLoaderService2)).setDefaultCursor(new ImageCursor(object2.loadImage(cursorInfo.getImageName()), cursorInfo.getHotspotX(), cursorInfo.getHotspotY()));
            }
            if ((object = mainWindow) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            SystemActions.INSTANCE.bind(((MainWindow)object).getInput$fxgl());
            object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            Input input = ((MainWindow)object).getInput$fxgl();
            object = new KeyCode[]{KeyCode.G, KeyCode.L, KeyCode.A, KeyCode.L, KeyCode.M, KeyCode.A, KeyCode.S, KeyCode.B};
            input.addAction(new UserAction(this){
                @NotNull
                private final onMainLoopStarting.subScene.1 subScene;
                final /* synthetic */ GameApplicationService this$0;
                {
                    this.this$0 = $receiver;
                    super("");
                    this.subScene = new SubScene(this.this$0){
                        @NotNull
                        private final Lazy view$delegate;
                        final /* synthetic */ GameApplicationService this$0;
                        {
                            this.this$0 = $receiver;
                            this.view$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImageView>(this.this$0){
                                final /* synthetic */ GameApplicationService this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                @NotNull
                                public final ImageView invoke() {
                                    ImageView imageView = new ImageView(ImagesKt.toImage((byte[])PauseMenuBGGen.INSTANCE.generate()));
                                    GameApplicationService gameApplicationService = this.this$0;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    ImageView it = imageView;
                                    boolean bl3 = false;
                                    it.setScaleX(4.0);
                                    it.setScaleY(4.0);
                                    it.setTranslateX(gameApplicationService.getPrefWidth() / 2.0);
                                    it.setTranslateY(gameApplicationService.getPrefHeight() / 2.0);
                                    return imageView;
                                }
                            }));
                        }

                        private final ImageView getView() {
                            Lazy lazy = this.view$delegate;
                            boolean bl = false;
                            return (ImageView)lazy.getValue();
                        }

                        public void onCreate() {
                            Node[] nodeArray = new Node[]{(Node)this.getView()};
                            this.getContentRoot().getChildren().setAll((Object[])nodeArray);
                            Timer timer2 = this.getTimer();
                            Function0 function0 = (Function0)new Function0<Unit>(this.this$0){
                                final /* synthetic */ GameApplicationService this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.popSubScene();
                                }
                            };
                            nodeArray = Duration.seconds((double)3.0);
                            Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"seconds(3.0)");
                            timer2.runOnceAfter(function0, (Duration)nodeArray);
                        }

                        static {
                        }
                    };
                }

                protected void onActionBegin() {
                    this.this$0.pushSubScene(this.subScene);
                }
            }, new InputSequence(KeyCode.F, KeyCode.X, (KeyCode[])object));
        }

        private final void addOverlay(Scene scene) {
            if (scene instanceof FXGLScene) {
                Pane pane = scene.getContentRoot();
                Object object = pane.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scene.contentRoot.children");
                object = (Collection)object;
                Group group = this.getOverlayRoot();
                boolean bl = false;
                object.add(group);
            } else {
                Pane pane = scene.getRoot();
                Object object = pane.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scene.root.children");
                object = (Collection)object;
                Group group = this.getOverlayRoot();
                boolean bl = false;
                object.add(group);
            }
        }

        private final void removeOverlay(Scene scene) {
            if (scene instanceof FXGLScene) {
                Pane pane = scene.getContentRoot();
                Object object = pane.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scene.contentRoot.children");
                object = (Collection)object;
                Group group = this.getOverlayRoot();
                boolean bl = false;
                object.remove(group);
            } else {
                Pane pane = scene.getRoot();
                Object object = pane.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scene.root.children");
                object = (Collection)object;
                Group group = this.getOverlayRoot();
                boolean bl = false;
                object.remove(group);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canShowCloseDialog() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            LoadingScene loadingScene = this.loadScene;
            if (loadingScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            if (mainWindow.getCurrentScene() == loadingScene) return false;
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (!readOnlyGameSettings.isIntroEnabled()) return true;
            MainWindow mainWindow2 = mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            if (mainWindow2.getCurrentScene() != this.intro) return true;
            return false;
        }

        private final void showConfirmExitDialog() {
            DialogService dialogService = this.dialogService;
            if (dialogService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dialogService");
                throw null;
            }
            DialogService dialogService2 = dialogService;
            dialogService = this.localService;
            if (dialogService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localService");
                throw null;
            }
            dialogService2.showConfirmationBox(dialogService.getLocalizedString("dialog.exitGame"), GameApplicationService::showConfirmExitDialog$lambda-6);
        }

        public final void startNewGame() {
            this.log.debug("Starting new game");
            Object object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            MainWindow mainWindow = object;
            object = this.loadScene;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            mainWindow.setScene((FXGLScene)((Object)object));
            this.clearPreviousGame();
            object = this.loadScene;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            ((LoadingScene)((Object)object)).pushNewTask(new InitAppTask());
        }

        private final void clearPreviousGame() {
            this.log.debug("Clearing previous game");
            this.getGameScene$fxgl().reset$fxgl();
        }

        public final void saveGame(@NotNull DataFile dataFile) {
            Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
            SaveLoadService saveLoadService = this.saveLoadService;
            if (saveLoadService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadService");
                throw null;
            }
            saveLoadService.save(dataFile);
        }

        public final void loadGame(@NotNull DataFile dataFile) {
            Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
            this.log.debug("Starting loaded game");
            Object object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            MainWindow mainWindow = object;
            object = this.loadScene;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            mainWindow.setScene((FXGLScene)((Object)object));
            this.clearPreviousGame();
            object = this.loadScene;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            ((LoadingScene)((Object)object)).pushNewTask(() -> GameApplicationService.loadGame$lambda-7(this, dataFile));
        }

        public final void gotoIntro() {
            Object object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            MainWindow mainWindow = object;
            object = this.intro;
            Intrinsics.checkNotNull((Object)object);
            mainWindow.setScene((FXGLScene)((Object)object));
        }

        private final dummyScene.1 getDummyScene() {
            Lazy lazy = this.dummyScene$delegate;
            boolean bl = false;
            return (Object)lazy.getValue();
        }

        public final void gotoMainMenu() {
            Object object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (!((ReadOnlyGameSettings)object).isMainMenuEnabled()) {
                this.log.warning("Ignoring gotoMainMenu() because main menu is not enabled");
                return;
            }
            object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            ((MainWindow)object).setScene(this.getDummyScene());
            object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            Object object2 = object;
            object = this.mainMenu;
            Intrinsics.checkNotNull((Object)object);
            ((MainWindow)object2).pushState((SubScene)object);
        }

        public final void gotoGameMenu() {
            Object object = settings;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            if (!((ReadOnlyGameSettings)object).isGameMenuEnabled()) {
                this.log.warning("Ignoring gotoGameMenu() because game menu is not enabled");
                return;
            }
            object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            Object object2 = object;
            object = this.gameMenu;
            Intrinsics.checkNotNull((Object)object);
            ((MainWindow)object2).pushState((SubScene)object);
        }

        public final void gotoLoading(@NotNull Runnable loadingTask) {
            Intrinsics.checkNotNullParameter((Object)loadingTask, (String)"loadingTask");
            Object object = this.loadScene;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            object.pushNewTask(loadingTask);
            object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            LoadingScene loadingScene = object;
            object = this.loadScene;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            ((MainWindow)((Object)loadingScene)).setScene((FXGLScene)((Object)object));
        }

        public final void gotoLoading(@NotNull Task<?> loadingTask) {
            Intrinsics.checkNotNullParameter(loadingTask, (String)"loadingTask");
            Object object = this.loadScene;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            object.pushNewTask(loadingTask);
            object = mainWindow;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            LoadingScene loadingScene = object;
            object = this.loadScene;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
                throw null;
            }
            ((MainWindow)((Object)loadingScene)).setScene((FXGLScene)((Object)object));
        }

        public final void gotoPlay() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            mainWindow.setScene(this.getGameScene$fxgl());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean saveScreenshot() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            Image fxImage = mainWindow.takeScreenshot();
            BufferedImage img = ImagesKt.toBufferedImage((Image)fxImage);
            ReadOnlyGameSettings readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            StringBuilder stringBuilder = new StringBuilder().append("./").append(readOnlyGameSettings.getTitle());
            readOnlyGameSettings = settings;
            if (readOnlyGameSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                throw null;
            }
            String fileName = stringBuilder.append(readOnlyGameSettings.getVersion()).append(LocalDateTime.now()).toString();
            fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
            try {
                String name = StringsKt.endsWith$default((String)fileName, (String)".png", (boolean)false, (int)2, null) ? fileName : Intrinsics.stringPlus((String)fileName, (Object)".png");
                Closeable closeable = Files.newOutputStream(Paths.get(name, new String[0]), new OpenOption[0]);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl3 = false;
                    boolean bl4 = ImageIO.write((RenderedImage)img, "png", it);
                    return bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.log.warning("saveScreenshot(" + fileName + ".png) failed: " + e);
                return false;
            }
        }

        public void pushSubScene(@NotNull SubScene subScene2) {
            Intrinsics.checkNotNullParameter((Object)subScene2, (String)"subScene");
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            mainWindow.pushState(subScene2);
        }

        public void popSubScene() {
            MainWindow mainWindow = mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
                throw null;
            }
            mainWindow.popState();
        }

        private static final void onInit$lambda-1(GameApplicationService this$0, ObservableValue $noName_0, Scene oldScene, Scene newScene) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.log.debug("Removing overlay from " + oldScene + " and adding to " + newScene);
            Intrinsics.checkNotNullExpressionValue((Object)oldScene, (String)"oldScene");
            this$0.removeOverlay(oldScene);
            Intrinsics.checkNotNullExpressionValue((Object)newScene, (String)"newScene");
            this$0.addOverlay(newScene);
        }

        private static final void initAppScenes$lambda-3$lambda-2(GameApplicationService this$0) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.setSceneAfterIntro();
        }

        private static final void addClickFeedbackHandler$lambda-5$lambda-4(GameApplicationService this$0, Circle $circle) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$circle, (String)"$circle");
            Group group = this$0.getOverlayRoot();
            Object object = group.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"overlayRoot.children");
            object = (Collection)object;
            boolean bl = false;
            object.remove($circle);
        }

        private static final void addClickFeedbackHandler$lambda-5(GameApplicationService this$0, MouseEvent it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Circle circle = new Circle(this$0.getGameScene$fxgl().getInput().getMouseXUI(), this$0.getGameScene$fxgl().getInput().getMouseYUI(), 5.0, null);
            circle.setStroke((Paint)Color.GOLD);
            circle.setStrokeWidth(2.0);
            circle.opacityProperty().bind((ObservableValue)new SimpleDoubleProperty(1.0).subtract((ObservableNumberValue)circle.radiusProperty().divide(35.0)));
            Group group = this$0.getOverlayRoot();
            Object object = group.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"overlayRoot.children");
            object = (Collection)object;
            boolean bl = false;
            object.add(circle);
            AnimationBuilder animationBuilder = FXGLForKtKt.animationBuilder().interpolator(Interpolators.SMOOTH.EASE_IN()).onFinished(() -> GameApplicationService.addClickFeedbackHandler$lambda-5$lambda-4(this$0, circle));
            group = Duration.seconds((double)0.33);
            Intrinsics.checkNotNullExpressionValue((Object)group, (String)"seconds(0.33)");
            AnimationBuilder animationBuilder2 = animationBuilder.duration((Duration)group);
            group = circle.radiusProperty();
            Intrinsics.checkNotNullExpressionValue((Object)group, (String)"circle.radiusProperty()");
            animationBuilder2.animate((WritableValue)group).to((Object)35.0).buildAndPlay();
        }

        private static final void showConfirmExitDialog$lambda-6(Boolean yes) {
            Intrinsics.checkNotNullExpressionValue((Object)yes, (String)"yes");
            if (yes.booleanValue()) {
                FXGL.Companion.getGameController().exit();
            }
        }

        private static final void loadGame$lambda-7(GameApplicationService this$0, DataFile $dataFile) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$dataFile, (String)"$dataFile");
            new InitAppTask().run();
            SaveLoadService saveLoadService = this$0.saveLoadService;
            if (saveLoadService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadService");
                throw null;
            }
            saveLoadService.load($dataFile);
        }

        public static final /* synthetic */ boolean access$canShowCloseDialog(GameApplicationService $this) {
            return $this.canShowCloseDialog();
        }

        public static final /* synthetic */ void access$showConfirmExitDialog(GameApplicationService $this) {
            $this.showConfirmExitDialog();
        }

        public static final /* synthetic */ SubScene access$getGameMenu$p(GameApplicationService $this) {
            return $this.gameMenu;
        }
    }
}

