/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AssetLoader;
import com.almasb.fxgl.app.DialogSubState;
import com.almasb.fxgl.app.Engine;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.GameController;
import com.almasb.fxgl.app.GameScene;
import com.almasb.fxgl.app.LoadingScene;
import com.almasb.fxgl.app.LoopRunner;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.PauseMenuSubState;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SceneFactory;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.FXGLExecutor;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.local.Language;
import com.almasb.fxgl.core.local.Local;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.Function;
import com.almasb.fxgl.dev.DevPane;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.saving.LoadEvent;
import com.almasb.fxgl.saving.SaveEvent;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.saving.SaveLoadManager;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.ProgressDialog;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.Display;
import com.almasb.fxgl.ui.ErrorDialog;
import com.almasb.fxgl.ui.FXGLUIConfig;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactory;
import com.almasb.sslogger.Logger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Group;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0002J\u000e\u0010e\u001a\u00020b2\u0006\u0010f\u001a\u00020SJ\b\u0010g\u001a\u00020bH\u0002J\b\u0010h\u001a\u00020bH\u0002J\b\u0010i\u001a\u00020\u0018H\u0002J\b\u0010j\u001a\u00020bH\u0002J\u0010\u0010k\u001a\u00020b2\u0006\u0010l\u001a\u00020)H\u0002J\b\u0010m\u001a\u00020bH\u0016J\b\u0010n\u001a\u00020bH\u0016J\b\u0010o\u001a\u00020bH\u0002J(\u0010p\u001a\u0002Hq\"\n\b\u0000\u0010q\u0018\u0001*\u00020S2\f\u0010r\u001a\b\u0012\u0004\u0012\u0002Hq0WH\u0086\b\u00a2\u0006\u0002\u0010sJ\b\u0010t\u001a\u00020bH\u0016J\b\u0010u\u001a\u00020bH\u0016J\b\u0010v\u001a\u00020bH\u0016J\b\u0010w\u001a\u00020bH\u0016J\u0010\u0010x\u001a\u00020b2\u0006\u0010y\u001a\u00020zH\u0002J\b\u0010{\u001a\u00020bH\u0002J\b\u0010|\u001a\u00020bH\u0002J\b\u0010}\u001a\u00020bH\u0002J\u0010\u0010~\u001a\u0002092\u0006\u0010\u007f\u001a\u00020\u0018H\u0016J\u0013\u0010\u0080\u0001\u001a\u00020b2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0016J\t\u0010\u0083\u0001\u001a\u00020bH\u0016J\t\u0010\u0084\u0001\u001a\u00020bH\u0002J\t\u0010\u0085\u0001\u001a\u00020bH\u0002J\t\u0010\u0086\u0001\u001a\u00020)H\u0002J\t\u0010\u0087\u0001\u001a\u00020bH\u0002J\u0010\u0010@\u001a\u00020b2\u0006\u0010Z\u001a\u00020[H\u0002J\t\u0010\u0088\u0001\u001a\u00020bH\u0016J\n\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\u0013\u0010\u008b\u0001\u001a\u00020b2\b\u0010\u008c\u0001\u001a\u00030\u008d\u0001H\u0016J\u0011\u0010\u008e\u0001\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0002J\t\u0010\u008f\u0001\u001a\u00020bH\u0016J\t\u0010\u0090\u0001\u001a\u00020bH\u0002J\u0012\u0010\u0091\u0001\u001a\u00020b2\u0007\u0010\u0092\u0001\u001a\u00020)H\u0016J\t\u0010\u0093\u0001\u001a\u00020bH\u0016J\t\u0010\u0094\u0001\u001a\u000209H\u0016J\t\u0010\u0095\u0001\u001a\u00020bH\u0002J\u0013\u0010\u0096\u0001\u001a\u00020b2\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0002J\u0007\u0010\u0099\u0001\u001a\u00020bJ\t\u0010\u009a\u0001\u001a\u00020bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0010\u001a\u0004\b\"\u0010#R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010'\u001a\u001e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(j\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*`+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010,\u001a\u00020-8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0010\u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u0002028@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u0010\u001a\u0004\b3\u00104R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010G\u001a\u00020HX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u000e\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010Q\u001a\u0012\u0012\u0004\u0012\u00020S0Rj\b\u0012\u0004\u0012\u00020S`TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010U\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020S0W\u0012\u0004\u0012\u00020S0VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010YR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010Z\u001a\u00020[8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R\u0014\u0010^\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`\u00a8\u0006\u009b\u0001"}, d2={"Lcom/almasb/fxgl/app/Engine;", "Lcom/almasb/fxgl/app/GameController;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "stage", "Ljavafx/stage/Stage;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;Ljavafx/stage/Stage;)V", "getApp$fxgl", "()Lcom/almasb/fxgl/app/GameApplication;", "assetLoader", "Lcom/almasb/fxgl/app/AssetLoader;", "getAssetLoader$fxgl", "()Lcom/almasb/fxgl/app/AssetLoader;", "assetLoader$delegate", "Lkotlin/Lazy;", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "getBundle$fxgl", "()Lcom/almasb/fxgl/core/serialization/Bundle;", "setBundle$fxgl", "(Lcom/almasb/fxgl/core/serialization/Bundle;)V", "defaultProfile", "Lcom/almasb/fxgl/saving/UserProfile;", "devPane", "Lcom/almasb/fxgl/dev/DevPane;", "getDevPane$fxgl", "()Lcom/almasb/fxgl/dev/DevPane;", "devPane$delegate", "dialogState", "Lcom/almasb/fxgl/app/DialogSubState;", "display", "Lcom/almasb/fxgl/ui/Display;", "getDisplay$fxgl", "()Lcom/almasb/fxgl/ui/Display;", "display$delegate", "engineTimer", "Lcom/almasb/fxgl/time/Timer;", "environmentVars", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "getEventBus$fxgl", "()Lcom/almasb/fxgl/event/EventBus;", "eventBus$delegate", "executor", "Lcom/almasb/fxgl/core/concurrent/FXGLExecutor;", "getExecutor$fxgl", "()Lcom/almasb/fxgl/core/concurrent/FXGLExecutor;", "executor$delegate", "gameMenu", "Lcom/almasb/fxgl/scene/FXGLScene;", "handledOnce", "", "intro", "isFirstRun", "loadState", "Lcom/almasb/fxgl/app/LoadingScene;", "log", "Lcom/almasb/sslogger/Logger;", "loop", "Lcom/almasb/fxgl/app/LoopRunner;", "mainMenu", "mainWindow", "Lcom/almasb/fxgl/app/MainWindow;", "overlayRoot", "Ljavafx/scene/Group;", "playState", "Lcom/almasb/fxgl/app/GameScene;", "getPlayState$fxgl", "()Lcom/almasb/fxgl/app/GameScene;", "setPlayState$fxgl", "(Lcom/almasb/fxgl/app/GameScene;)V", "profileName", "Ljavafx/beans/property/SimpleStringProperty;", "saveLoadManager", "Lcom/almasb/fxgl/saving/SaveLoadManager;", "services", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/core/EngineService;", "Lkotlin/collections/ArrayList;", "servicesCache", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "Ljava/lang/Class;", "getSettings$fxgl", "()Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "tpf", "", "getTpf", "()D", "version", "getVersion$fxgl", "()Ljava/lang/String;", "addOverlay", "", "scene", "Lcom/almasb/fxgl/scene/Scene;", "addService", "engineService", "attachEventHandlers", "attachPauseResumeListener", "createProfile", "createRequiredDirs", "doSave", "saveFileName", "exit", "fixAspectRatio", "generateDefaultProfile", "getService", "T", "serviceClass", "(Ljava/lang/Class;)Lcom/almasb/fxgl/core/EngineService;", "gotoGameMenu", "gotoIntro", "gotoMainMenu", "gotoPlay", "handleFatalError", "error", "", "initAppScenes", "initFatalExceptionHandler", "loadDefaultSystemData", "loadFromProfile", "profile", "loadGame", "saveFile", "Lcom/almasb/fxgl/saving/SaveFile;", "loadGameFromLastSave", "loadLocalization", "loadSystemData", "loadVersion", "logVersion", "popSubScene", "profileNameProperty", "Ljavafx/beans/property/StringProperty;", "pushSubScene", "subScene", "Lcom/almasb/fxgl/scene/SubScene;", "removeOverlay", "restoreDefaultProfileSettings", "runPreInit", "saveGame", "fileName", "saveProfile", "saveScreenshot", "saveSystemData", "startLoadedGame", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "startLoop", "startNewGame", "fxgl"})
public final class Engine
implements GameController {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Logger log;
    @NotNull
    private final String version;
    private boolean isFirstRun;
    @NotNull
    public Bundle bundle;
    private MainWindow mainWindow;
    @NotNull
    public GameScene playState;
    private LoadingScene loadState;
    private DialogSubState dialogState;
    private FXGLScene intro;
    private FXGLScene mainMenu;
    private FXGLScene gameMenu;
    private final LoopRunner loop;
    private final ArrayList<EngineService> services;
    private final ObjectMap<Class<? extends EngineService>, EngineService> servicesCache;
    @NotNull
    private final Lazy assetLoader$delegate;
    @NotNull
    private final Lazy eventBus$delegate;
    @NotNull
    private final Lazy display$delegate;
    @NotNull
    private final Lazy executor$delegate;
    @NotNull
    private final Lazy devPane$delegate;
    private final Timer engineTimer;
    private final Group overlayRoot;
    private final SimpleStringProperty profileName;
    private UserProfile defaultProfile;
    private SaveLoadManager saveLoadManager;
    private final HashMap<String, Object> environmentVars;
    private boolean handledOnce;
    @NotNull
    private final GameApplication app;
    @NotNull
    private final ReadOnlyGameSettings settings;
    private final Stage stage;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "assetLoader", "getAssetLoader$fxgl()Lcom/almasb/fxgl/app/AssetLoader;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "eventBus", "getEventBus$fxgl()Lcom/almasb/fxgl/event/EventBus;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "display", "getDisplay$fxgl()Lcom/almasb/fxgl/ui/Display;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "executor", "getExecutor$fxgl()Lcom/almasb/fxgl/core/concurrent/FXGLExecutor;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "devPane", "getDevPane$fxgl()Lcom/almasb/fxgl/dev/DevPane;"))};
    }

    @NotNull
    public final String getVersion$fxgl() {
        return this.version;
    }

    @NotNull
    public final Bundle getBundle$fxgl() {
        Bundle bundle = this.bundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        return bundle;
    }

    public final void setBundle$fxgl(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"<set-?>");
        this.bundle = bundle;
    }

    @NotNull
    public final GameScene getPlayState$fxgl() {
        GameScene gameScene = this.playState;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
        }
        return gameScene;
    }

    public final void setPlayState$fxgl(@NotNull GameScene gameScene) {
        Intrinsics.checkParameterIsNotNull((Object)gameScene, (String)"<set-?>");
        this.playState = gameScene;
    }

    public final double getTpf() {
        return this.loop.tpf();
    }

    public final void addService(@NotNull EngineService engineService) {
        Intrinsics.checkParameterIsNotNull((Object)engineService, (String)"engineService");
        this.log.debug("Adding new engine service: " + engineService.getClass());
        Collection collection = this.services;
        collection.add(engineService);
    }

    private final <T extends EngineService> T getService(Class<T> serviceClass) {
        Object object;
        block7: {
            block6: {
                Object v1;
                Iterable iterable;
                block5: {
                    int $i$f$getService = 0;
                    if (this.servicesCache.containsKey(serviceClass)) {
                        Object object2 = this.servicesCache.get(serviceClass);
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                        return (T)((EngineService)object2);
                    }
                    Iterable iterable2 = iterable = (Iterable)this.services;
                    for (Object t : iterable2) {
                        EngineService it = (EngineService)t;
                        boolean bl = false;
                        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                        if (!(it instanceof EngineService)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                if ((object = (EngineService)v1) == null) break block6;
                Iterable it = iterable = object;
                boolean bl = false;
                this.servicesCache.put(serviceClass, (Object)it);
                object = iterable;
                if (object != null) break block7;
            }
            throw (Throwable)new IllegalArgumentException("Engine does not have service: " + serviceClass);
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)object;
    }

    @NotNull
    public final AssetLoader getAssetLoader$fxgl() {
        Lazy lazy = this.assetLoader$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (AssetLoader)lazy.getValue();
    }

    @NotNull
    public final EventBus getEventBus$fxgl() {
        Lazy lazy = this.eventBus$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (EventBus)lazy.getValue();
    }

    @NotNull
    public final Display getDisplay$fxgl() {
        Lazy lazy = this.display$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (Display)lazy.getValue();
    }

    @NotNull
    public final FXGLExecutor getExecutor$fxgl() {
        Lazy lazy = this.executor$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[3];
        return (FXGLExecutor)lazy.getValue();
    }

    @NotNull
    public final DevPane getDevPane$fxgl() {
        Lazy lazy = this.devPane$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[4];
        return (DevPane)lazy.getValue();
    }

    private final String loadVersion() {
        String string = ResourceBundle.getBundle("com.almasb.fxgl.app.system").getString("fxgl.version");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ResourceBundle.getBundle\u2026getString(\"fxgl.version\")");
        return string;
    }

    private final void logVersion() {
        String platform = "DESKTOP" + (FXGL.Companion.isBrowser() ? " BROWSER" : "");
        this.log.info("FXGL-" + this.version + " on " + platform);
        this.log.info("Source code and latest versions at: https://github.com/AlmasB/FXGL");
        this.log.info("             Join the FXGL chat at: https://gitter.im/AlmasB/FXGL");
    }

    public final void startLoop() {
        this.saveLoadManager = new SaveLoadManager(this.profileName.getValue());
        long start = System.nanoTime();
        this.loadLocalization();
        this.log.debug("Registering font factories");
        this.settings.getUIFactory().registerFontFactory(FontType.UI, this.getAssetLoader$fxgl().loadFont(this.settings.getFontUI()));
        this.settings.getUIFactory().registerFontFactory(FontType.GAME, this.getAssetLoader$fxgl().loadFont(this.settings.getFontGame()));
        this.settings.getUIFactory().registerFontFactory(FontType.MONO, this.getAssetLoader$fxgl().loadFont(this.settings.getFontMono()));
        this.settings.getUIFactory().registerFontFactory(FontType.TEXT, this.getAssetLoader$fxgl().loadFont(this.settings.getFontText()));
        this.log.debug("Setting UI factory");
        FXGLUIConfig.setUIFactory((UIFactory)this.settings.getUIFactory());
        FXGLScene startupScene = this.settings.getSceneFactory().newStartup();
        MainWindow mainWindow = this.mainWindow = new MainWindow(this.stage, startupScene, this.settings);
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.show();
        this.initFatalExceptionHandler();
        Async.start((Runnable)new Runnable(this, startupScene, start){
            final /* synthetic */ Engine this$0;
            final /* synthetic */ FXGLScene $startupScene;
            final /* synthetic */ long $start;

            public final void run() {
                IOTask.setDefaultExecutor((Executor)((Executor)this.this$0.getExecutor$fxgl()));
                IOTask.setDefaultFailAction((Consumer)((Consumer)new Consumer<Throwable>(this){
                    final /* synthetic */ startLoop.1 this$0;

                    public final void accept(Throwable it) {
                        this.this$0.this$0.getDisplay$fxgl().showErrorBox(it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
                Engine.access$setFirstRun$p(this.this$0, !FS.Companion.exists("system/"));
                if (Engine.access$isFirstRun$p(this.this$0)) {
                    Engine.access$createRequiredDirs(this.this$0);
                    Engine.access$loadDefaultSystemData(this.this$0);
                } else {
                    Engine.access$loadSystemData(this.this$0);
                }
                Engine.access$initAppScenes(this.this$0);
                Engine.access$attachPauseResumeListener(this.this$0);
                Engine.access$attachEventHandlers(this.this$0);
                Async.startFX((Runnable)new Runnable(this){
                    final /* synthetic */ startLoop.1 this$0;

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public final void run() {
                        Engine.access$runPreInit(this.this$0.this$0);
                        Engine.access$addOverlay(this.this$0.this$0, this.this$0.$startupScene);
                        Engine.access$getMainWindow$p(this.this$0.this$0).getCurrentStateProperty().addListener((ChangeListener)new ChangeListener<Scene>(this){
                            final /* synthetic */ startLoop.2 this$0;

                            public final void changed(ObservableValue<? extends Scene> $noName_0, Scene oldScene, Scene newScene) {
                                Engine.access$getLog$p(this.this$0.this$0.this$0).debug("Removing overlay from " + oldScene + " and adding to " + newScene);
                                Engine engine = this.this$0.this$0.this$0;
                                Scene scene = oldScene;
                                Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"oldScene");
                                Engine.access$removeOverlay(engine, scene);
                                Engine engine2 = this.this$0.this$0.this$0;
                                Scene scene2 = newScene;
                                Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"newScene");
                                Engine.access$addOverlay(engine2, scene2);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        v0 = this.this$0.this$0.getSettings$fxgl().getClass().getDeclaredMethods();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"settings.javaClass.declaredMethods");
                        var2_2 = $receiver$iv = v0;
                        destination$iv$iv = new ArrayList<E>();
                        for (void element$iv$iv : $receiver$iv$iv) {
                            it = element$iv$iv;
                            $i$a$-filter-Engine$startLoop$1$2$2 = false;
                            v1 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                            v2 = v1.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it.name");
                            if (StringsKt.startsWith$default((String)v2, (String)"is", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                            v3 = it.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it.name");
                            if (StringsKt.startsWith$default((String)v3, (String)"get", (boolean)false, (int)2, null)) lbl-1000:
                            // 2 sources

                            {
                                v4 = true;
                            } else {
                                v4 = false;
                            }
                            if (!v4) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        var2_2 = $receiver$iv.iterator();
                        while (var2_2.hasNext()) {
                            element$iv /* !! */  = var2_2.next();
                            it = (Method)element$iv /* !! */ ;
                            $i$a$-forEach-Engine$startLoop$1$2$3 = false;
                            var6_8 = Engine.access$getEnvironmentVars$p(this.this$0.this$0);
                            v5 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                            v6 = v5.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.name");
                            var7_10 = StringsKt.decapitalize((String)StringsKt.removePrefix((String)v6, (CharSequence)"get"));
                            Intrinsics.checkExpressionValueIsNotNull((Object)it.invoke((Object)this.this$0.this$0.getSettings$fxgl(), new Object[0]), (String)"it.invoke(settings)");
                            var6_8.put(var7_10, it);
                        }
                        Engine.access$getLog$p(this.this$0.this$0).debug("Logging environment variables");
                        var2_2 = $receiver$iv = (Map)Engine.access$getEnvironmentVars$p(this.this$0.this$0);
                        element$iv /* !! */  = var2_2.entrySet().iterator();
                        while (element$iv /* !! */ .hasNext()) {
                            $key_value = element$iv = (Map.Entry)element$iv /* !! */ .next();
                            $i$a$-forEach-Engine$startLoop$1$2$4 = false;
                            var7_10 = $key_value;
                            key = (String)var7_10.getKey();
                            var7_10 = $key_value;
                            value = var7_10.getValue();
                            Engine.access$getLog$p(this.this$0.this$0).debug(key + ": " + value);
                        }
                        $receiver$iv = Engine.access$getServices$p(this.this$0.this$0);
                        var2_2 = $receiver$iv.iterator();
                        while (var2_2.hasNext()) {
                            element$iv /* !! */  = var2_2.next();
                            service = (EngineService)element$iv /* !! */ ;
                            $i$a$-forEach-Engine$startLoop$1$2$5 = false;
                            v7 = ReflectionUtils.findFieldsByAnnotation((Object)service, Inject.class);
                            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"findFieldsByAnnotation(s\u2026vice, Inject::class.java)");
                            $receiver$iv = (Iterable)v7;
                            for (T element$iv : $receiver$iv) {
                                field = (Field)element$iv;
                                $i$a$-forEach-Engine$startLoop$1$2$5$1 = false;
                                injectKey = field.getDeclaredAnnotation(Inject.class).value();
                                var12_17 = Engine.access$getEnvironmentVars$p(this.this$0.this$0);
                                var13_18 = var12_17;
                                if (!var13_18.containsKey(injectKey)) {
                                    throw (Throwable)new IllegalArgumentException("Cannot inject @Inject(" + injectKey + "). No value present for " + injectKey);
                                }
                                ReflectionUtils.inject((Field)field, (Object)service, Engine.access$getEnvironmentVars$p(this.this$0.this$0).get(injectKey));
                            }
                        }
                        $receiver$iv = Engine.access$getServices$p(this.this$0.this$0);
                        var2_2 = $receiver$iv.iterator();
                        while (var2_2.hasNext()) {
                            element$iv /* !! */  = var2_2.next();
                            it = (EngineService)element$iv /* !! */ ;
                            $i$a$-forEach-Engine$startLoop$1$2$6 = false;
                            it.onMainLoopStarting();
                        }
                        Engine.access$getLog$p(this.this$0.this$0).infof("FXGL initialization took: %.3f sec", new Object[]{(double)(System.nanoTime() - this.this$0.$start) / 1.0E9});
                        Engine.access$getLoop$p(this.this$0.this$0).start();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = engine;
                this.$startupScene = fXGLScene;
                this.$start = l;
            }
        });
    }

    private final void addOverlay(Scene scene) {
        Collection collection = (Collection)scene.getRoot().getChildren();
        Group group = this.overlayRoot;
        collection.add(group);
    }

    private final void removeOverlay(Scene scene) {
        Collection collection = (Collection)scene.getRoot().getChildren();
        Group group = this.overlayRoot;
        collection.remove(group);
    }

    private final void loadLocalization() {
        Object v0;
        SimpleObjectProperty<Language> simpleObjectProperty;
        block2: {
            this.log.debug("Loading localizations");
            List builtInLangs = CollectionsKt.listOf((Object[])new String[]{"english", "french", "german", "russian", "hungarian"});
            Iterable $receiver$iv = builtInLangs;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Local.addLanguage((String)it, (ResourceBundle)FXGL.Companion.getAssetLoader().loadResourceBundle("languages/" + it + ".properties"));
            }
            Iterable iterable = Local.getLanguages();
            simpleObjectProperty = this.settings.getLanguage();
            Iterable iterable2 = iterable;
            Iterator iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                Language it = (Language)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"english")) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Object var9_10 = v0;
        simpleObjectProperty.setValue(var9_10);
        Local.selectedLanguageProperty().bind((ObservableValue)this.settings.getLanguage());
    }

    private final void attachPauseResumeListener() {
        if (!FXGL.Companion.isMobile()) {
            this.stage.iconifiedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(this){
                final /* synthetic */ Engine this$0;

                public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean isMinimized) {
                    Boolean bl = isMinimized;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isMinimized");
                    if (bl.booleanValue()) {
                        Engine.access$getLoop$p(this.this$0).pause();
                    } else {
                        Engine.access$getLoop$p(this.this$0).resume();
                    }
                }
                {
                    this.this$0 = engine;
                }
            });
        }
    }

    private final void initAppScenes() {
        this.log.debug("Initializing application scenes");
        SceneFactory sceneFactory = this.settings.getSceneFactory();
        this.loadState = sceneFactory.newLoadingScene();
        this.playState = new GameScene(this.settings.getWidth(), this.settings.getHeight(), new GameState(), new GameWorld(), new PhysicsWorld(this.settings.getHeight(), this.settings.getPixelsPerMeter()));
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        this.dialogState = new DialogSubState((ReadOnlyObjectProperty<FXGLScene>)((ReadOnlyObjectProperty)mainWindow.getCurrentFXGLScene()));
        if (this.settings.isIntroEnabled()) {
            this.intro = sceneFactory.newIntro();
        }
        if (this.settings.isMenuEnabled()) {
            this.mainMenu = sceneFactory.newMainMenu();
            this.gameMenu = sceneFactory.newGameMenu();
        }
        if (this.settings.isMenuEnabled()) {
            EventHandler<KeyEvent> menuKeyHandler2 = new EventHandler<KeyEvent>(this){
                private boolean canSwitchGameMenu;
                final /* synthetic */ Engine this$0;

                private final void onMenuKey(boolean pressed) {
                    if (!pressed) {
                        this.canSwitchGameMenu = true;
                        return;
                    }
                    if (this.canSwitchGameMenu) {
                        if (Engine.access$getMainWindow$p(this.this$0).getCurrentState() == Engine.access$getGameMenu$p(this.this$0)) {
                            this.canSwitchGameMenu = false;
                            this.this$0.gotoPlay();
                        } else if (Engine.access$getMainWindow$p(this.this$0).getCurrentState() == this.this$0.getPlayState$fxgl()) {
                            this.canSwitchGameMenu = false;
                            this.this$0.gotoGameMenu();
                        }
                    }
                }

                public void handle(@NotNull KeyEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    if (event.getCode() == this.this$0.getSettings$fxgl().getMenuKey()) {
                        this.onMenuKey(Intrinsics.areEqual((Object)event.getEventType(), (Object)KeyEvent.KEY_PRESSED));
                    }
                }
                {
                    this.this$0 = $outer;
                    this.canSwitchGameMenu = true;
                }
            };
            GameScene gameScene = this.playState;
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
            }
            Input input = gameScene.getInput();
            EventType eventType = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"KeyEvent.ANY");
            input.addEventHandler(eventType, (EventHandler)menuKeyHandler2);
            FXGLScene fXGLScene = this.gameMenu;
            if (fXGLScene == null) {
                Intrinsics.throwNpe();
            }
            Input input2 = fXGLScene.getInput();
            EventType eventType2 = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType2, (String)"KeyEvent.ANY");
            input2.addEventHandler(eventType2, (EventHandler)menuKeyHandler2);
        } else {
            GameScene gameScene = this.playState;
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
            }
            Input.addAction$default((Input)gameScene.getInput(), (UserAction)new UserAction(this, "Pause"){
                final /* synthetic */ Engine this$0;

                protected void onActionBegin() {
                    PauseMenuSubState.INSTANCE.requestShow$fxgl((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ initAppScenes.1 this$0;

                        public final void invoke() {
                            Engine.access$getMainWindow$p(this.this$0.this$0).pushState(PauseMenuSubState.INSTANCE);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }

                protected void onActionEnd() {
                    PauseMenuSubState.INSTANCE.unlockSwitch$fxgl();
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            }, (KeyCode)this.settings.getMenuKey(), null, (int)4, null);
        }
        this.log.debug("Application scenes initialized");
    }

    private final void createRequiredDirs() {
        FS.Companion.createDirectoryTask("system/").then((Function)createRequiredDirs.1.INSTANCE).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable e) {
                Engine.access$getLog$p(this.this$0).warning("Failed to create system dir: " + e);
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void saveSystemData() {
        this.log.debug("Saving FXGL system data");
        Bundle bundle = this.bundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        FS.Companion.writeDataTask((Serializable)bundle, "system/fxgl.bundle").onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable it) {
                Engine.access$getLog$p(this.this$0).warning("Failed to save: " + it);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void loadSystemData() {
        this.log.debug("Loading FXGL system data");
        FS.Companion.readDataTask("system/fxgl.bundle").onSuccess((Consumer)new Consumer<Bundle>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Bundle it) {
                Bundle bundle = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"it");
                this.this$0.setBundle$fxgl(bundle);
                Engine.access$getLog$p(this.this$0).debug(String.valueOf(this.this$0.getBundle$fxgl()));
            }
            {
                this.this$0 = engine;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable it) {
                Engine.access$getLog$p(this.this$0).warning("Failed to load: " + it);
                Engine.access$loadDefaultSystemData(this.this$0);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void loadDefaultSystemData() {
        this.log.debug("Loading default FXGL system data");
        this.bundle = new Bundle("FXGL");
    }

    private final void initFatalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
            final /* synthetic */ Engine this$0;

            public final void uncaughtException(Thread $noName_0, Throwable error) {
                Throwable throwable = error;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"error");
                Engine.access$handleFatalError(this.this$0, throwable);
            }
            {
                this.this$0 = engine;
            }
        });
    }

    private final void attachEventHandlers() {
        EventBus eventBus2 = FXGL.Companion.getEventBus();
        EventType<SaveEvent> eventType = SaveEvent.ANY;
        Intrinsics.checkExpressionValueIsNotNull(eventType, (String)"SaveEvent.ANY");
        eventBus2.addEventHandler(eventType, (EventHandler)new EventHandler<SaveEvent>(this){
            final /* synthetic */ Engine this$0;

            public final void handle(SaveEvent e) {
                ReadOnlyGameSettings readOnlyGameSettings = this.this$0.getSettings$fxgl();
                UserProfile userProfile = e.getProfile();
                Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"e.getProfile()");
                readOnlyGameSettings.save(userProfile);
            }
            {
                this.this$0 = engine;
            }
        });
        EventBus eventBus3 = FXGL.Companion.getEventBus();
        EventType<LoadEvent> eventType2 = LoadEvent.ANY;
        Intrinsics.checkExpressionValueIsNotNull(eventType2, (String)"LoadEvent.ANY");
        eventBus3.addEventHandler(eventType2, (EventHandler)new EventHandler<LoadEvent>(this){
            final /* synthetic */ Engine this$0;

            public final void handle(LoadEvent e) {
                ReadOnlyGameSettings readOnlyGameSettings = this.this$0.getSettings$fxgl();
                UserProfile userProfile = e.getProfile();
                Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"e.getProfile()");
                readOnlyGameSettings.load(userProfile);
            }
            {
                this.this$0 = engine;
            }
        });
    }

    private final void runPreInit() {
        this.log.debug("Running preInit()");
        this.app.initInput();
        GameScene gameScene = this.playState;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
        }
        SystemActions.INSTANCE.bind(gameScene.getInput());
        this.generateDefaultProfile();
    }

    private final void generateDefaultProfile() {
        this.log.debug("generateDefaultProfile()");
        this.defaultProfile = this.createProfile();
    }

    private final void loop(double tpf) {
        this.engineTimer.update(tpf);
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.onUpdate$fxgl(tpf);
        Iterable $receiver$iv = this.services;
        for (Object element$iv : $receiver$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onUpdate(tpf);
        }
    }

    private final void handleFatalError(Throwable error) {
        if (this.handledOnce) {
            return;
        }
        this.handledOnce = true;
        if (Logger.Companion.isConfigured()) {
            this.log.fatal("Uncaught Exception:", error);
            this.log.fatal("Application will now exit");
        } else {
            String string = "Uncaught Exception:";
            System.out.println((Object)string);
            error.printStackTrace();
            string = "Application will now exit";
            System.out.println((Object)string);
        }
        this.loop.stop();
        new ErrorDialog(error).showAndWait();
        if (this.loop.isStarted()) {
            this.exit();
        } else {
            if (Logger.Companion.isConfigured()) {
                Logger.Companion.close();
            }
            System.exit(-1);
        }
    }

    @Override
    public void startNewGame() {
        this.log.debug("Starting new game");
        LoadingScene loadingScene = this.loadState;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadState");
        }
        loadingScene.setDataFile$fxgl(DataFile.Companion.getEMPTY());
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene2 = this.loadState;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadState");
        }
        mainWindow.setScene(loadingScene2);
    }

    private final void startLoadedGame(DataFile dataFile) {
        this.log.debug("Starting loaded game");
        LoadingScene loadingScene = this.loadState;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadState");
        }
        loadingScene.setDataFile$fxgl(dataFile);
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene2 = this.loadState;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadState");
        }
        mainWindow.setScene(loadingScene2);
    }

    @Override
    public void gotoIntro() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.intro;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoMainMenu() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.mainMenu;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoGameMenu() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.gameMenu;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoPlay() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        GameScene gameScene = this.playState;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
        }
        mainWindow.setScene(gameScene);
    }

    @Override
    public void saveGame(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        this.doSave(fileName);
    }

    private final void doSave(String saveFileName) {
        DataFile dataFile = this.app.saveState();
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
        SaveFile saveFile = new SaveFile(saveFileName, localDateTime);
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.saveTask(dataFile, saveFile).runAsyncFXWithDialog((IOTask.UIDialogHandler)new ProgressDialog(Local.getLocalizedString((String)"menu.savingData") + ": " + saveFileName));
    }

    @Override
    public void loadGame(@NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.loadTask(saveFile).onSuccess((Consumer)new Consumer<DataFile>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(DataFile it) {
                DataFile dataFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFile, (String)"it");
                Engine.access$startLoadedGame(this.this$0, dataFile);
            }
            {
                this.this$0 = engine;
            }
        }).runAsyncFXWithDialog((IOTask.UIDialogHandler)new ProgressDialog(Local.getLocalizedString((String)"menu.loading") + ": " + saveFile.getName()));
    }

    @Override
    public void loadGameFromLastSave() {
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.loadLastModifiedSaveFileTask().then(new Function<T, IOTask<R>>(this){
            final /* synthetic */ Engine this$0;

            public final IOTask<DataFile> apply(SaveFile it) {
                return Engine.access$getSaveLoadManager$p(this.this$0).loadTask(it);
            }
            {
                this.this$0 = engine;
            }
        }).onSuccess((Consumer)new Consumer<DataFile>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(DataFile it) {
                DataFile dataFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFile, (String)"it");
                Engine.access$startLoadedGame(this.this$0, dataFile);
            }
            {
                this.this$0 = engine;
            }
        }).runAsyncFXWithDialog((IOTask.UIDialogHandler)new ProgressDialog(Local.getLocalizedString((String)"menu.loading") + "..."));
    }

    @Override
    public boolean saveScreenshot() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        return mainWindow.saveScreenshot();
    }

    @Override
    public void fixAspectRatio() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.fixAspectRatio();
    }

    @Override
    public void saveProfile() {
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.saveProfileTask(this.createProfile()).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable error) {
                String cfr_ignored_0 = "Failed to save profile: " + Engine.access$getProfileName$p(this.this$0).getValue() + " - " + error;
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    @Override
    public boolean loadFromProfile(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        if (!profile.isCompatible(FXGL.Companion.getSettings().getTitle(), FXGL.Companion.getSettings().getVersion())) {
            return false;
        }
        FXGL.Companion.getEventBus().fireEvent((Event)new LoadEvent(LoadEvent.LOAD_PROFILE, profile));
        return true;
    }

    @Override
    @NotNull
    public StringProperty profileNameProperty() {
        return (StringProperty)this.profileName;
    }

    @Override
    public void restoreDefaultProfileSettings() {
        this.log.debug("restoreDefaultSettings()");
        EventBus eventBus2 = FXGL.Companion.getEventBus();
        UserProfile userProfile = this.defaultProfile;
        if (userProfile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultProfile");
        }
        eventBus2.fireEvent((Event)new LoadEvent(LoadEvent.RESTORE_SETTINGS, userProfile));
    }

    private final UserProfile createProfile() {
        this.log.debug("Creating default profile");
        UserProfile profile = new UserProfile(FXGL.Companion.getSettings().getTitle(), FXGL.Companion.getSettings().getVersion());
        FXGL.Companion.getEventBus().fireEvent((Event)new SaveEvent(profile));
        return profile;
    }

    @Override
    public void pushSubScene(@NotNull SubScene subScene) {
        Intrinsics.checkParameterIsNotNull((Object)subScene, (String)"subScene");
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.pushState(subScene);
    }

    @Override
    public void popSubScene() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.popState();
    }

    @Override
    public void exit() {
        this.log.debug("Exiting FXGL");
        Iterable $receiver$iv = this.services;
        for (Object element$iv : $receiver$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onExit();
        }
        this.settings.isMenuEnabled();
        this.log.debug("Shutting down background threads");
        this.getExecutor$fxgl().shutdownNow();
        this.saveSystemData();
        this.log.debug("Closing logger and exiting JavaFX");
        Logger.Companion.close();
        Platform.exit();
    }

    @NotNull
    public final GameApplication getApp$fxgl() {
        return this.app;
    }

    @NotNull
    public final ReadOnlyGameSettings getSettings$fxgl() {
        return this.settings;
    }

    public Engine(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull Stage stage) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
        this.app = app;
        this.settings = settings;
        this.stage = stage;
        this.log = Logger.Companion.get(this.getClass());
        this.loop = new LoopRunner((Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ Engine this$0;

            public final void invoke(double it) {
                Engine.access$loop(this.this$0, it);
            }
            {
                this.this$0 = engine;
                super(1);
            }
        }));
        Engine engine = this;
        Cloneable cloneable = new ArrayList();
        engine.services = cloneable;
        this.servicesCache = new ObjectMap();
        this.assetLoader$delegate = LazyKt.lazy((Function0)assetLoader.2.INSTANCE);
        this.eventBus$delegate = LazyKt.lazy((Function0)eventBus.2.INSTANCE);
        this.display$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Display>(this){
            final /* synthetic */ Engine this$0;

            @NotNull
            public final Display invoke() {
                DialogSubState dialogSubState = Engine.access$getDialogState$p(this.this$0);
                if (dialogSubState == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.ui.Display");
                }
                return dialogSubState;
            }
            {
                this.this$0 = engine;
                super(0);
            }
        }));
        this.executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);
        this.devPane$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DevPane>(this){
            final /* synthetic */ Engine this$0;

            @NotNull
            public final DevPane invoke() {
                return new DevPane(this.this$0.getPlayState$fxgl(), this.this$0.getSettings$fxgl());
            }
            {
                this.this$0 = engine;
                super(0);
            }
        }));
        this.engineTimer = new Timer();
        this.overlayRoot = new Group();
        this.profileName = new SimpleStringProperty("no-profile");
        engine = this;
        cloneable = new HashMap();
        engine.environmentVars = cloneable;
        this.log.debug("Initializing FXGL");
        this.version = this.loadVersion();
        this.logVersion();
        Map map = this.environmentVars;
        String string = "overlayRoot";
        Group group = this.overlayRoot;
        map.put(string, group);
        map = this.environmentVars;
        string = "masterTimer";
        group = this.engineTimer;
        map.put(string, group);
    }

    public static final /* synthetic */ boolean access$isFirstRun$p(Engine $this) {
        return $this.isFirstRun;
    }

    public static final /* synthetic */ void access$setFirstRun$p(Engine $this, boolean bl) {
        $this.isFirstRun = bl;
    }

    public static final /* synthetic */ void access$createRequiredDirs(Engine $this) {
        $this.createRequiredDirs();
    }

    public static final /* synthetic */ void access$loadDefaultSystemData(Engine $this) {
        $this.loadDefaultSystemData();
    }

    public static final /* synthetic */ void access$loadSystemData(Engine $this) {
        $this.loadSystemData();
    }

    public static final /* synthetic */ void access$initAppScenes(Engine $this) {
        $this.initAppScenes();
    }

    public static final /* synthetic */ void access$attachPauseResumeListener(Engine $this) {
        $this.attachPauseResumeListener();
    }

    public static final /* synthetic */ void access$attachEventHandlers(Engine $this) {
        $this.attachEventHandlers();
    }

    public static final /* synthetic */ void access$runPreInit(Engine $this) {
        $this.runPreInit();
    }

    public static final /* synthetic */ void access$addOverlay(Engine $this, Scene scene) {
        $this.addOverlay(scene);
    }

    public static final /* synthetic */ MainWindow access$getMainWindow$p(Engine $this) {
        MainWindow mainWindow = $this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        return mainWindow;
    }

    public static final /* synthetic */ void access$setMainWindow$p(Engine $this, MainWindow mainWindow) {
        $this.mainWindow = mainWindow;
    }

    public static final /* synthetic */ Logger access$getLog$p(Engine $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$removeOverlay(Engine $this, Scene scene) {
        $this.removeOverlay(scene);
    }

    public static final /* synthetic */ HashMap access$getEnvironmentVars$p(Engine $this) {
        return $this.environmentVars;
    }

    public static final /* synthetic */ LoopRunner access$getLoop$p(Engine $this) {
        return $this.loop;
    }

    public static final /* synthetic */ FXGLScene access$getGameMenu$p(Engine $this) {
        return $this.gameMenu;
    }

    public static final /* synthetic */ void access$setGameMenu$p(Engine $this, FXGLScene fXGLScene) {
        $this.gameMenu = fXGLScene;
    }

    public static final /* synthetic */ void access$handleFatalError(Engine $this, Throwable error) {
        $this.handleFatalError(error);
    }

    public static final /* synthetic */ void access$startLoadedGame(Engine $this, DataFile dataFile) {
        $this.startLoadedGame(dataFile);
    }

    public static final /* synthetic */ SaveLoadManager access$getSaveLoadManager$p(Engine $this) {
        SaveLoadManager saveLoadManager = $this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        return saveLoadManager;
    }

    public static final /* synthetic */ void access$setSaveLoadManager$p(Engine $this, SaveLoadManager saveLoadManager) {
        $this.saveLoadManager = saveLoadManager;
    }

    public static final /* synthetic */ SimpleStringProperty access$getProfileName$p(Engine $this) {
        return $this.profileName;
    }

    public static final /* synthetic */ void access$loop(Engine $this, double tpf) {
        $this.loop(tpf);
    }

    public static final /* synthetic */ DialogSubState access$getDialogState$p(Engine $this) {
        DialogSubState dialogSubState = $this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        return dialogSubState;
    }

    public static final /* synthetic */ void access$setDialogState$p(Engine $this, DialogSubState dialogSubState) {
        $this.dialogState = dialogSubState;
    }
}

