/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.Engine;
import com.almasb.fxgl.app.GameSettings;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.dev.DevService;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.sslogger.ConsoleOutput;
import com.almasb.sslogger.FileOutput;
import com.almasb.sslogger.Logger;
import com.almasb.sslogger.LoggerConfig;
import com.almasb.sslogger.LoggerLevel;
import com.almasb.sslogger.LoggerOutput;
import java.lang.reflect.Method;
import java.util.Map;
import javafx.application.Application;
import javafx.stage.Stage;

public abstract class GameApplication {
    private static final Logger log = Logger.get(GameApplication.class);

    public static void launch(String[] args) {
        try {
            GameApplication instance = GameApplication.newInstance();
            GameApplication.launch(instance, args);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
        }
    }

    public static void launch(Class<? extends GameApplication> appClass, String[] args) {
        try {
            GameApplication instance = (GameApplication)ReflectionUtils.newInstance(appClass);
            GameApplication.launch(instance, args);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
        }
    }

    public static void customLaunch(GameApplication app, Stage stage) {
        try {
            if (System.getProperty("javafx.platform") == null) {
                System.setProperty("javafx.platform", "Desktop");
            }
            ReadOnlyGameSettings settings = app.takeUserSettings();
            app.initLogger(settings);
            FXGLApplication.customLaunchFX(app, settings, stage);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
        }
    }

    private static void launch(GameApplication app, String[] args) {
        if (System.getProperty("javafx.platform") == null) {
            System.setProperty("javafx.platform", "Desktop");
        }
        ReadOnlyGameSettings settings = app.takeUserSettings();
        app.initLogger(settings);
        FXGLApplication.launchFX(app, settings, args);
    }

    private static GameApplication newInstance() {
        Class appClass = ReflectionUtils.getCallingClass(GameApplication.class, (String)"launch");
        return (GameApplication)ReflectionUtils.newInstance((Class)appClass);
    }

    private static void printErrorAndExit(Exception e) {
        System.out.println("Error during launch:");
        e.printStackTrace();
        System.out.println("Application will now exit");
        System.exit(-1);
    }

    private ReadOnlyGameSettings takeUserSettings() {
        GameSettings localSettings = new GameSettings();
        this.initSettings(localSettings);
        return localSettings.toReadOnly();
    }

    private void initLogger(ReadOnlyGameSettings settings) {
        Logger.configure((LoggerConfig)new LoggerConfig());
        if (FXGL.isDesktop()) {
            Logger.addOutput((LoggerOutput)new FileOutput("FXGL"), (LoggerLevel)LoggerLevel.DEBUG);
        }
        Logger.addOutput((LoggerOutput)new ConsoleOutput(), (LoggerLevel)settings.getApplicationMode().getLoggerLevel());
        log.debug("Logger initialized");
        log.debug("Logging settings\n" + settings);
    }

    protected abstract void initSettings(GameSettings var1);

    protected void initInput() {
    }

    protected void initGameVars(Map<String, Object> vars) {
    }

    protected void initGame() {
    }

    protected void initPhysics() {
    }

    protected void initUI() {
    }

    protected void onUpdate(double tpf) {
    }

    protected DataFile saveState() {
        log.warning("Called saveState(), but it wasn't overridden!");
        throw new UnsupportedOperationException("Default implementation is not available");
    }

    protected void loadState(DataFile dataFile) {
        log.warning("Called loadState(), but it wasn't overridden!");
        throw new UnsupportedOperationException("Default implementation is not available");
    }

    public static final class FXGLApplication
    extends Application {
        public static GameApplication app;
        private static ReadOnlyGameSettings settings;

        public void start(Stage stage) {
            Engine engine = new Engine(app, settings, stage);
            settings.getEngineServices().forEach(serviceClass -> engine.addService((EngineService)ReflectionUtils.newInstance((Class)serviceClass)));
            if (settings.getApplicationMode() != ApplicationMode.RELEASE) {
                engine.addService(new DevService());
            }
            ReflectionUtils.callInaccessible((Object)FXGL.Companion, (Method)ReflectionUtils.getMethod(FXGL.Companion.getClass(), (String)"inject", (Class[])new Class[]{Engine.class}), (Object[])new Object[]{engine});
            engine.startLoop();
        }

        static void launchFX(GameApplication app, ReadOnlyGameSettings settings, String[] args) {
            FXGLApplication.app = app;
            FXGLApplication.settings = settings;
            FXGLApplication.launch((String[])args);
        }

        static void customLaunchFX(GameApplication app, ReadOnlyGameSettings settings, Stage stage) {
            FXGLApplication.app = app;
            FXGLApplication.settings = settings;
            new FXGLApplication().start(stage);
        }
    }
}

