/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.Viewport;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020\u0019J\u0006\u0010#\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020/R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010\u00a8\u00060"}, d2={"Lcom/almasb/fxgl/scene/FXGLScene;", "Lcom/almasb/fxgl/scene/Scene;", "width", "", "height", "(II)V", "active", "Ljavafx/beans/property/SimpleBooleanProperty;", "effect", "Ljavafx/scene/effect/Effect;", "getEffect", "()Ljavafx/scene/effect/Effect;", "setEffect", "(Ljavafx/scene/effect/Effect;)V", "", "getHeight", "()D", "viewport", "Lcom/almasb/fxgl/scene/Viewport;", "getViewport", "()Lcom/almasb/fxgl/scene/Viewport;", "getWidth", "activeProperty", "Ljavafx/beans/property/BooleanProperty;", "appendCSS", "", "css", "Lcom/almasb/fxgl/scene/CSS;", "bindSize", "scaledWidth", "Ljavafx/beans/property/DoubleProperty;", "scaledHeight", "scaleRatioX", "scaleRatioY", "clearCSS", "clearEffect", "setBackgroundColor", "color", "Ljavafx/scene/paint/Paint;", "setBackgroundRepeat", "image", "Ljavafx/scene/image/Image;", "textureName", "", "setCursor", "imageName", "hotspot", "Ljavafx/geometry/Point2D;", "fxgl"})
public abstract class FXGLScene
extends Scene {
    @NotNull
    private final Viewport viewport;
    private final SimpleBooleanProperty active;

    @NotNull
    public final Viewport getViewport() {
        return this.viewport;
    }

    public final double getWidth() {
        return this.getRoot().getPrefWidth();
    }

    public final double getHeight() {
        return this.getRoot().getPrefHeight();
    }

    @Nullable
    public final Effect getEffect() {
        return this.getContentRoot().getEffect();
    }

    public final void setEffect(@Nullable Effect effect) {
        this.getContentRoot().setEffect(effect);
    }

    public final void clearEffect() {
        this.setEffect(null);
    }

    public final void setCursor(@NotNull String imageName, @NotNull Point2D hotspot) {
        Intrinsics.checkParameterIsNotNull((Object)imageName, (String)"imageName");
        Intrinsics.checkParameterIsNotNull((Object)hotspot, (String)"hotspot");
        this.getRoot().setCursor((Cursor)new ImageCursor(FXGL.Companion.getAssetLoader().loadCursorImage(imageName), hotspot.getX(), hotspot.getY()));
    }

    @NotNull
    public final BooleanProperty activeProperty() {
        return (BooleanProperty)this.active;
    }

    public final void appendCSS(@NotNull CSS css) {
        Intrinsics.checkParameterIsNotNull((Object)css, (String)"css");
        this.getRoot().getStylesheets().add((Object)css.getExternalForm());
    }

    public final void clearCSS() {
        this.getRoot().getStylesheets().clear();
    }

    public final void bindSize(@NotNull DoubleProperty scaledWidth, @NotNull DoubleProperty scaledHeight, @NotNull DoubleProperty scaleRatioX, @NotNull DoubleProperty scaleRatioY) {
        Intrinsics.checkParameterIsNotNull((Object)scaledWidth, (String)"scaledWidth");
        Intrinsics.checkParameterIsNotNull((Object)scaledHeight, (String)"scaledHeight");
        Intrinsics.checkParameterIsNotNull((Object)scaleRatioX, (String)"scaleRatioX");
        Intrinsics.checkParameterIsNotNull((Object)scaleRatioY, (String)"scaleRatioY");
        this.getRoot().prefWidthProperty().bind((ObservableValue)scaledWidth);
        this.getRoot().prefHeightProperty().bind((ObservableValue)scaledHeight);
        Scale scale = new Scale();
        scale.xProperty().bind((ObservableValue)scaleRatioX);
        scale.yProperty().bind((ObservableValue)scaleRatioY);
        this.getRoot().getTransforms().setAll((Object[])new Transform[]{(Transform)scale});
    }

    public final void setBackgroundColor(@NotNull Paint color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.getRoot().setBackground(new Background(new BackgroundFill[]{new BackgroundFill(color, null, null)}));
    }

    public final void setBackgroundRepeat(@NotNull String textureName) {
        Intrinsics.checkParameterIsNotNull((Object)textureName, (String)"textureName");
        Image image = FXGL.Companion.texture(textureName).getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"FXGL.texture(textureName).image");
        this.setBackgroundRepeat(image);
    }

    public final void setBackgroundRepeat(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        this.getRoot().setBackground(new Background(new BackgroundImage[]{new BackgroundImage(image, BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT, null, null)}));
    }

    @JvmOverloads
    public FXGLScene(int width, int height) {
        this.viewport = new Viewport(width, height);
        this.active = new SimpleBooleanProperty(false);
        if (FXGL.Companion.isDesktop()) {
            this.setCursor("fxgl_default.png", new Point2D(7.0, 6.0));
        }
    }

    @JvmOverloads
    public /* synthetic */ FXGLScene(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = FXGL.Companion.getAppWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = FXGL.Companion.getAppHeight();
        }
        this(n, n2);
    }

    @JvmOverloads
    public FXGLScene(int width) {
        this(width, 0, 2, null);
    }

    @JvmOverloads
    public FXGLScene() {
        this(0, 0, 3, null);
    }
}

