/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.MainWindow$sam$javafx_event_EventHandler$0;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.core.local.Local;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.input.MouseEventData;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.sslogger.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020)0+J\u001a\u0010-\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020)0+J\u001a\u0010/\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020)0+J\b\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u000205H\u0002J\u0006\u00106\u001a\u00020\u0005J\b\u00107\u001a\u00020)H\u0002J\u0015\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020&H\u0000\u00a2\u0006\u0002\b:J\u0006\u0010;\u001a\u00020)J\u000e\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020#J\u0010\u0010>\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010?\u001a\u000202J\u000e\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010C\u001a\u00020)J\b\u0010D\u001a\u00020)H\u0002J\u0006\u0010E\u001a\u00020FR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001dj\b\u0012\u0004\u0012\u00020\u0005`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R2\u0010!\u001a&\u0012\f\u0012\n $*\u0004\u0018\u00010#0# $*\u0012\u0012\f\u0012\n $*\u0004\u0018\u00010#0#\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/almasb/fxgl/app/MainWindow;", "", "stage", "Ljavafx/stage/Stage;", "scene", "Lcom/almasb/fxgl/scene/FXGLScene;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "(Ljavafx/stage/Stage;Lcom/almasb/fxgl/scene/FXGLScene;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;)V", "currentFXGLScene", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "getCurrentFXGLScene", "()Ljavafx/beans/property/ReadOnlyObjectWrapper;", "currentState", "Lcom/almasb/fxgl/scene/Scene;", "getCurrentState", "()Lcom/almasb/fxgl/scene/Scene;", "currentStateProperty", "getCurrentStateProperty", "fxScene", "Ljavafx/scene/Scene;", "log", "Lcom/almasb/sslogger/Logger;", "scaleRatioX", "Ljavafx/beans/property/DoubleProperty;", "scaleRatioY", "scaledHeight", "scaledWidth", "scenes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getStage", "()Ljavafx/stage/Stage;", "subScenes", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/scene/SubScene;", "kotlin.jvm.PlatformType", "windowBorderHeight", "", "windowBorderWidth", "addGlobalHandler", "", "handler", "Lkotlin/Function1;", "Ljavafx/event/Event;", "addKeyHandler", "Ljavafx/scene/input/KeyEvent;", "addMouseHandler", "Lcom/almasb/fxgl/input/MouseEventData;", "canShowCloseDialog", "", "createScene", "root", "Ljavafx/scene/Parent;", "getCurrentScene", "initStage", "onUpdate", "tpf", "onUpdate$fxgl", "popState", "pushState", "newState", "registerScene", "saveScreenshot", "fileName", "", "setScene", "show", "showConfirmExitDialog", "takeScreenshot", "Ljavafx/scene/image/Image;", "fxgl"})
public final class MainWindow {
    private final Logger log;
    private final javafx.scene.Scene fxScene;
    @NotNull
    private final ReadOnlyObjectWrapper<FXGLScene> currentFXGLScene;
    @NotNull
    private final ReadOnlyObjectWrapper<Scene> currentStateProperty;
    private final ArrayList<FXGLScene> scenes;
    private final DoubleProperty scaledWidth;
    private final DoubleProperty scaledHeight;
    private final DoubleProperty scaleRatioX;
    private final DoubleProperty scaleRatioY;
    private final ObservableList<SubScene> subScenes;
    private double windowBorderWidth;
    private double windowBorderHeight;
    @NotNull
    private final Stage stage;
    private final ReadOnlyGameSettings settings;

    @NotNull
    public final ReadOnlyObjectWrapper<FXGLScene> getCurrentFXGLScene() {
        return this.currentFXGLScene;
    }

    @NotNull
    public final ReadOnlyObjectWrapper<Scene> getCurrentStateProperty() {
        return this.currentStateProperty;
    }

    @NotNull
    public final Scene getCurrentState() {
        Scene scene;
        if (this.subScenes.isEmpty()) {
            Object object = this.currentFXGLScene.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"currentFXGLScene.value");
            scene = (Scene)object;
        } else {
            ObservableList<SubScene> observableList = this.subScenes;
            Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"subScenes");
            Object object = CollectionsKt.last((List)((List)observableList));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"subScenes.last()");
            scene = (Scene)object;
        }
        return scene;
    }

    /*
     * WARNING - void declaration
     */
    private final javafx.scene.Scene createScene(Parent root) {
        Rectangle2D bounds;
        Rectangle2D rectangle2D;
        this.log.debug("Creating a JavaFX scene");
        double newW = this.settings.getWidth();
        double newH = this.settings.getHeight();
        if (this.settings.isFullScreenAllowed()) {
            Screen screen = Screen.getPrimary();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen, (String)"Screen.getPrimary()");
            rectangle2D = screen.getBounds();
        } else {
            Screen screen = Screen.getPrimary();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen, (String)"Screen.getPrimary()");
            rectangle2D = screen.getVisualBounds();
        }
        Rectangle2D rectangle2D2 = bounds = rectangle2D;
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2D2, (String)"bounds");
        if (newW > rectangle2D2.getWidth() || newH > bounds.getHeight()) {
            this.log.debug("Target size > screen size");
            double extraMargin = 25.0;
            double ratio = newW / newH;
            int n = (int)bounds.getWidth();
            int n2 = 1;
            while (n >= n2) {
                void newWidth;
                if ((double)newWidth / ratio <= bounds.getHeight()) {
                    newW = (double)newWidth - extraMargin;
                    newH = (double)newWidth / ratio;
                    break;
                }
                --newWidth;
            }
        }
        newW = (int)newW;
        newH = (int)newH;
        javafx.scene.Scene scene = new javafx.scene.Scene(root, newW, newH);
        this.scaledWidth.set(newW);
        this.scaledHeight.set(newH);
        this.scaleRatioX.set(this.scaledWidth.getValue() / (double)this.settings.getWidth());
        this.scaleRatioY.set(this.scaledHeight.getValue() / (double)this.settings.getHeight());
        this.log.debug("Target settings size: " + (double)this.settings.getWidth() + " x " + (double)this.settings.getHeight());
        this.log.debug("Scaled scene size:    " + newW + " x " + newH);
        this.log.debug("Scaled ratio: (" + this.scaleRatioX.getValue() + ", " + this.scaleRatioY.getValue() + ')');
        return scene;
    }

    private final void initStage() {
        Stage stage;
        Stage $receiver = stage = this.stage;
        boolean bl = false;
        $receiver.setScene(this.fxScene);
        $receiver.setTitle(this.settings.getTitle() + ' ' + this.settings.getVersion());
        $receiver.setResizable(this.settings.isManualResizeEnabled());
        if (this.settings.isDesktop()) {
            $receiver.initStyle(this.settings.getStageStyle());
        }
        $receiver.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(this){
            final /* synthetic */ MainWindow this$0;
            {
                this.this$0 = mainWindow;
            }

            public final void handle(WindowEvent e) {
                e.consume();
                if (MainWindow.access$getSettings$p(this.this$0).isCloseConfirmation()) {
                    if (MainWindow.access$canShowCloseDialog(this.this$0)) {
                        MainWindow.access$showConfirmExitDialog(this.this$0);
                    }
                } else {
                    FXGL.Companion.getGameController().exit();
                }
            }
        });
        if (!this.settings.isExperimentalNative()) {
            $receiver.getIcons().add((Object)FXGL.Companion.image(this.settings.getAppIcon()));
        }
        if (this.settings.isFullScreenAllowed()) {
            $receiver.setFullScreenExitHint("");
            $receiver.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
        }
        this.settings.getFullScreen().addListener((ChangeListener)new ChangeListener<Boolean>($receiver){
            final /* synthetic */ Stage $this_with;

            public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean fullscreenNow) {
                Boolean bl = fullscreenNow;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"fullscreenNow");
                this.$this_with.setFullScreen(bl.booleanValue());
            }
            {
                this.$this_with = stage;
            }
        });
        $receiver.sizeToScene();
        $receiver.centerOnScreen();
    }

    private final void showConfirmExitDialog() {
        FXGL.Companion.getDisplay().showConfirmationBox(Local.getLocalizedString((String)"dialog.exitGame"), (Consumer)showConfirmExitDialog.1.INSTANCE);
    }

    public final void onUpdate$fxgl(double tpf) {
        this.getCurrentState().update$fxgl(tpf);
    }

    public final void setScene(@NotNull FXGLScene scene) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        if (!this.subScenes.isEmpty()) {
            this.log.warning("Cannot change states with active substates");
            return;
        }
        if (!this.scenes.contains(scene)) {
            this.registerScene(scene);
        }
        FXGLScene prevState = (FXGLScene)this.currentFXGLScene.getValue();
        prevState.exit$fxgl();
        ((FXGLScene)this.currentFXGLScene.getValue()).activeProperty().set(false);
        this.currentFXGLScene.setValue((Object)scene);
        this.fxScene.setRoot((Parent)scene.getRoot());
        scene.activeProperty().set(true);
        this.log.debug(prevState + " -> " + scene);
        FXGLScene fXGLScene = (FXGLScene)this.currentFXGLScene.getValue();
        FXGLScene fXGLScene2 = prevState;
        Intrinsics.checkExpressionValueIsNotNull((Object)fXGLScene2, (String)"prevState");
        fXGLScene.enter$fxgl(fXGLScene2);
        this.currentStateProperty.setValue((Object)this.getCurrentState());
    }

    public final void pushState(@NotNull SubScene newState) {
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        this.log.debug("Push state: " + newState);
        Scene prevState = this.getCurrentState();
        prevState.getInput().clearAll();
        this.log.debug(prevState + " -> " + newState);
        this.subScenes.add((Object)newState);
        this.getCurrentScene().getRoot().getChildren().add((Object)newState.getRoot());
        newState.enter$fxgl(prevState);
        this.currentStateProperty.setValue((Object)this.getCurrentState());
    }

    public final void popState() {
        if (this.subScenes.isEmpty()) {
            throw (Throwable)new IllegalStateException("Cannot pop state: Substates are empty!");
        }
        ObservableList<SubScene> observableList = this.subScenes;
        Intrinsics.checkExpressionValueIsNotNull(observableList, (String)"subScenes");
        SubScene prevState = (SubScene)CollectionsKt.last((List)((List)observableList));
        this.log.debug("Pop state: " + prevState);
        prevState.exit$fxgl();
        this.subScenes.remove(this.subScenes.size() - 1);
        this.getCurrentScene().getRoot().getChildren().remove((Object)prevState.getRoot());
        this.currentStateProperty.setValue((Object)this.getCurrentState());
        this.log.debug(this.getCurrentState() + " <- " + prevState);
    }

    private final boolean canShowCloseDialog() {
        return true;
    }

    public final void show() {
        this.log.debug("Opening main window");
        this.stage.show();
        double d = this.stage.getWidth();
        Double d2 = this.scaledWidth.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d2, (String)"scaledWidth.value");
        this.windowBorderWidth = d - d2;
        double d3 = this.stage.getHeight();
        Double d4 = this.scaledHeight.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)d4, (String)"scaledHeight.value");
        this.windowBorderHeight = d3 - d4;
        if (this.windowBorderHeight < 0.5 && this.settings.isLinux()) {
            this.windowBorderHeight = 35.0;
        }
        this.scaledWidth.bind((ObservableValue)this.stage.widthProperty().subtract((ObservableNumberValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.stage.fullScreenProperty())).then(0).otherwise(this.windowBorderWidth)));
        this.scaledHeight.bind((ObservableValue)this.stage.heightProperty().subtract((ObservableNumberValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.stage.fullScreenProperty())).then(0).otherwise(this.windowBorderHeight)));
        if (this.settings.isPreserveResizeRatio()) {
            this.scaleRatioX.bind((ObservableValue)Bindings.min((ObservableNumberValue)((ObservableNumberValue)this.scaledWidth.divide(this.settings.getWidth())), (ObservableNumberValue)((ObservableNumberValue)this.scaledHeight.divide(this.settings.getHeight()))));
            this.scaleRatioY.bind((ObservableValue)this.scaleRatioX);
        } else {
            this.scaleRatioX.bind((ObservableValue)this.scaledWidth.divide(this.settings.getWidth()));
            this.scaleRatioY.bind((ObservableValue)this.scaledHeight.divide(this.settings.getHeight()));
        }
        this.log.debug("Window border size: (" + this.windowBorderWidth + ", " + this.windowBorderHeight + ')');
        this.log.debug("Scaled size: " + this.scaledWidth.getValue() + " x " + this.scaledHeight.getValue());
        this.log.debug("Scaled ratio: (" + this.scaleRatioX.getValue() + ", " + this.scaleRatioY.getValue() + ')');
        StringBuilder stringBuilder = new StringBuilder().append("Scene size: ");
        javafx.scene.Scene scene = this.stage.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"stage.scene");
        StringBuilder stringBuilder2 = stringBuilder.append(scene.getWidth()).append(" x ");
        javafx.scene.Scene scene2 = this.stage.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"stage.scene");
        this.log.debug(stringBuilder2.append(scene2.getHeight()).toString());
        this.log.debug("Stage size: " + this.stage.getWidth() + " x " + this.stage.getHeight());
    }

    private final void registerScene(FXGLScene scene) {
        scene.bindSize(this.scaledWidth, this.scaledHeight, this.scaleRatioX, this.scaleRatioY);
        Iterable $receiver$iv = this.settings.getCSSList();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.log.debug("Applying CSS: " + it);
            scene.appendCSS(FXGL.Companion.getAssetLoader().loadCSS(it));
        }
        if (!this.settings.isExperimentalNative() && this.settings.isDesktop() && scene.getRoot().getCursor() == null) {
            scene.setCursor(FXGL.Companion.getAssetLoader().loadCursorImage("fxgl_default.png"), new Point2D(7.0, 6.0));
        }
        this.scenes.add(scene);
    }

    @NotNull
    public final FXGLScene getCurrentScene() {
        Object object = this.currentFXGLScene.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"currentFXGLScene.value");
        return (FXGLScene)object;
    }

    public final void addKeyHandler(@NotNull Function1<? super KeyEvent, Unit> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        Function1<? super KeyEvent, Unit> function1 = handler;
        this.fxScene.addEventHandler(KeyEvent.ANY, (EventHandler)new MainWindow$sam$javafx_event_EventHandler$0(function1));
    }

    public final void addMouseHandler(@NotNull Function1<? super MouseEventData, Unit> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.fxScene.addEventHandler(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(this, handler){
            final /* synthetic */ MainWindow this$0;
            final /* synthetic */ Function1 $handler;

            public final void handle(MouseEvent it) {
                MouseEvent mouseEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"it");
                Point2D point2D = new Point2D(this.this$0.getCurrentScene().getViewport().getX(), this.this$0.getCurrentScene().getViewport().getY());
                Double d = MainWindow.access$getScaleRatioX$p(this.this$0).getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"scaleRatioX.value");
                double d2 = d;
                Double d3 = MainWindow.access$getScaleRatioY$p(this.this$0).getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)d3, (String)"scaleRatioY.value");
                this.$handler.invoke((Object)new MouseEventData(mouseEvent, point2D, d2, d3.doubleValue()));
            }
            {
                this.this$0 = mainWindow;
                this.$handler = function1;
            }
        });
    }

    public final void addGlobalHandler(@NotNull Function1<? super Event, Unit> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        this.fxScene.addEventHandler(EventType.ROOT, (EventHandler)new EventHandler<Event>(handler){
            final /* synthetic */ Function1 $handler;

            public final void handle(Event it) {
                Event event = it.copyFor(null, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)event, (String)"it.copyFor(null, null)");
                this.$handler.invoke((Object)event);
            }
            {
                this.$handler = function1;
            }
        });
    }

    @NotNull
    public final Image takeScreenshot() {
        WritableImage writableImage = this.fxScene.snapshot(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)writableImage, (String)"fxScene.snapshot(null)");
        return (Image)writableImage;
    }

    public final boolean saveScreenshot() {
        String fileName = "./" + this.settings.getTitle() + this.settings.getVersion() + LocalDateTime.now();
        fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
        return this.saveScreenshot(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveScreenshot(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Image fxImage = this.takeScreenshot();
        BufferedImage img = SwingFXUtils.fromFXImage((Image)fxImage, null);
        try {
            String name = StringsKt.endsWith$default((String)fileName, (String)".png", (boolean)false, (int)2, null) ? fileName : fileName + ".png";
            Closeable closeable = Files.newOutputStream(Paths.get(name, new String[0]), new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                boolean bl2 = ImageIO.write((RenderedImage)img, "png", it);
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("saveScreenshot(" + fileName + ".png) failed: " + e);
            return false;
        }
    }

    @NotNull
    public final Stage getStage() {
        return this.stage;
    }

    public MainWindow(@NotNull Stage stage, @NotNull FXGLScene scene, @NotNull ReadOnlyGameSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.stage = stage;
        this.settings = settings;
        this.log = Logger.Companion.get(this.getClass());
        this.currentFXGLScene = new ReadOnlyObjectWrapper((Object)scene);
        this.currentStateProperty = new ReadOnlyObjectWrapper((Object)scene);
        MainWindow mainWindow = this;
        ArrayList arrayList = new ArrayList();
        mainWindow.scenes = arrayList;
        this.scaledWidth = (DoubleProperty)new SimpleDoubleProperty();
        this.scaledHeight = (DoubleProperty)new SimpleDoubleProperty();
        this.scaleRatioX = (DoubleProperty)new SimpleDoubleProperty();
        this.scaleRatioY = (DoubleProperty)new SimpleDoubleProperty();
        this.subScenes = FXCollections.observableArrayList();
        this.fxScene = this.createScene((Parent)scene.getRoot());
        this.setScene(scene);
        this.initStage();
        this.addKeyHandler((Function1<? super KeyEvent, Unit>)((Function1)new Function1<KeyEvent, Unit>(){

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getCurrentState().getInput().onKeyEvent(it);
            }
        }));
        this.addMouseHandler((Function1<? super MouseEventData, Unit>)((Function1)new Function1<MouseEventData, Unit>(){

            public final void invoke(@NotNull MouseEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getCurrentState().getInput().onMouseEvent(it);
            }
        }));
        this.addGlobalHandler((Function1<? super Event, Unit>)((Function1)new Function1<Event, Unit>(){

            public final void invoke(@NotNull Event it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getCurrentState().getInput().fireEvent(it);
            }
        }));
    }

    public static final /* synthetic */ ReadOnlyGameSettings access$getSettings$p(MainWindow $this) {
        return $this.settings;
    }

    public static final /* synthetic */ boolean access$canShowCloseDialog(MainWindow $this) {
        return $this.canShowCloseDialog();
    }

    public static final /* synthetic */ void access$showConfirmExitDialog(MainWindow $this) {
        $this.showConfirmExitDialog();
    }

    public static final /* synthetic */ DoubleProperty access$getScaleRatioX$p(MainWindow $this) {
        return $this.scaleRatioX;
    }

    public static final /* synthetic */ DoubleProperty access$getScaleRatioY$p(MainWindow $this) {
        return $this.scaleRatioY;
    }
}

