/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl;

import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.CollidableComponent;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsComponent;
import java.io.Serializable;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\bJ\u0016\u0010\u0005\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\bJ\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0012\u0010\u001d\u001a\u00020\u00002\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u001f\u0010&\u001a\u00020\u00002\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)\u00a2\u0006\u0002\u0010*J\u0016\u0010&\u001a\u00020\u00002\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u0001J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/almasb/fxgl/dsl/EntityBuilder;", "", "()V", "entity", "Lcom/almasb/fxgl/entity/Entity;", "at", "p", "Lcom/almasb/fxgl/core/math/Vec2;", "Ljavafx/geometry/Point2D;", "x", "", "y", "bbox", "box", "Lcom/almasb/fxgl/physics/HitBox;", "build", "buildAndAttach", "buildScreenBounds", "thickness", "buildScreenBoundsAndAttach", "collidable", "from", "data", "Lcom/almasb/fxgl/entity/SpawnData;", "opacity", "value", "rotate", "angle", "scale", "type", "t", "", "view", "node", "Ljavafx/scene/Node;", "textureName", "", "viewWithBBox", "with", "comps", "", "Lcom/almasb/fxgl/entity/component/Component;", "([Lcom/almasb/fxgl/entity/component/Component;)Lcom/almasb/fxgl/dsl/EntityBuilder;", "propertyKey", "propertyValue", "zIndex", "z", "", "fxgl"})
public final class EntityBuilder {
    private final Entity entity = new Entity();

    @NotNull
    public final EntityBuilder from(@NotNull SpawnData data) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.at(data.getX(), data.getY());
        Iterable $receiver$iv = (Iterable)data.getData();
        for (Object element$iv : $receiver$iv) {
            ObjectMap.Entry it2 = (ObjectMap.Entry)element$iv;
            boolean bl2 = false;
            this.entity.setProperty((String)it2.key, it2.value);
        }
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder type(@NotNull Enum<?> t) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull(t, (String)"t");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setType((Serializable)((Object)t));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder at(double x, double y) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setPosition(x, y);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder at(@NotNull Vec2 p) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setPosition(p);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder at(@NotNull Point2D p) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setPosition(p);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder rotate(double angle) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.rotateBy(angle);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder scale(double x, double y) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setScaleX(x);
        this.entity.setScaleY(y);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder scale(@NotNull Point2D scale) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.scale(scale.getX(), scale.getY());
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder opacity(double value) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getViewComponent().setOpacity(value);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder bbox(@NotNull HitBox box) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)box, (String)"box");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getBoundingBoxComponent().addHitBox(box);
        Point2D center = this.entity.getBoundingBoxComponent().getCenterLocal();
        this.entity.getTransformComponent().setScaleOrigin(center);
        this.entity.getTransformComponent().setRotationOrigin(center);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder view(@NotNull Node node) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        ViewComponent.addChild$default((ViewComponent)this.entity.getViewComponent(), (Node)node, (boolean)false, (int)2, null);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder viewWithBBox(@NotNull Node node) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.view(node);
        this.entity.getBoundingBoxComponent().clearHitBoxes();
        Bounds bounds = node.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"node.layoutBounds");
        double w = bounds.getWidth();
        Bounds bounds2 = node.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds2, (String)"node.layoutBounds");
        double h = bounds2.getHeight();
        this.bbox(new HitBox("__VIEW__", BoundingShape.box((double)w, (double)h)));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder view(@NotNull String textureName) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)textureName, (String)"textureName");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.view((Node)FXGL.Companion.texture(textureName));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder viewWithBBox(@NotNull String textureName) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)textureName, (String)"textureName");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.viewWithBBox((Node)FXGL.Companion.texture(textureName));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder zIndex(int z) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getTransformComponent().setZ(z);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder collidable() {
        return this.with((Component)new CollidableComponent(true));
    }

    @NotNull
    public final EntityBuilder with(Component ... comps) {
        Component[] $receiver$iv;
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)comps, (String)"comps");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        Component[] componentArray = $receiver$iv = comps;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component element$iv;
            Component it2 = element$iv = componentArray[i];
            boolean bl2 = false;
            this.entity.addComponent(it2);
        }
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder with(@NotNull String propertyKey, @NotNull Object propertyValue) {
        EntityBuilder entityBuilder;
        Intrinsics.checkParameterIsNotNull((Object)propertyKey, (String)"propertyKey");
        Intrinsics.checkParameterIsNotNull((Object)propertyValue, (String)"propertyValue");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setProperty(propertyKey, propertyValue);
        return entityBuilder;
    }

    @NotNull
    public final Entity build() {
        return this.entity;
    }

    @NotNull
    public final Entity buildAndAttach() {
        Entity entity;
        Entity it = entity = this.entity;
        boolean bl = false;
        FXGL.Companion.getGameWorld().addEntity(it);
        return entity;
    }

    @NotNull
    public final Entity buildScreenBounds(double thickness) {
        double w = FXGL.Companion.getAppWidth();
        double h = FXGL.Companion.getAppHeight();
        return this.bbox(new HitBox("LEFT", new Point2D(-thickness, 0.0), BoundingShape.box((double)thickness, (double)h))).bbox(new HitBox("RIGHT", new Point2D(w, 0.0), BoundingShape.box((double)thickness, (double)h))).bbox(new HitBox("TOP", new Point2D(0.0, -thickness), BoundingShape.box((double)w, (double)thickness))).bbox(new HitBox("BOT", new Point2D(0.0, h), BoundingShape.box((double)w, (double)thickness))).with((Component)new PhysicsComponent()).build();
    }

    @NotNull
    public final Entity buildScreenBoundsAndAttach(double thickness) {
        Entity entity;
        Entity it = entity = this.entity;
        boolean bl = false;
        FXGL.Companion.getGameWorld().addEntity(this.buildScreenBounds(thickness));
        return entity;
    }
}

