/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.saving;

import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.local.Local;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.fxgl.scene.ProgressDialog;
import com.almasb.sslogger.Logger;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class SaveLoadManager {
    private static final Logger log = Logger.get(SaveLoadManager.class);
    private static final String PROFILE_FILE_NAME = FXGL.getSettings().getProfileName();
    private static final String PROFILES_DIR = FXGL.getSettings().getProfileDir();
    private static final String SAVE_DIR = FXGL.getSettings().getSaveDir();
    private static final String SAVE_FILE_EXT = FXGL.getSettings().getSaveFileExt();
    private static final String DATA_FILE_EXT = FXGL.getSettings().getDataFileExt();
    private static final FS fs = new FS(FXGL.getSettings().isDesktop());
    private final String profileName;
    private ObservableList<SaveFile> saveFiles = FXCollections.observableArrayList();

    public SaveLoadManager(String profileName) {
        this.profileName = profileName;
    }

    public ObservableList<SaveFile> saveFiles() {
        return FXCollections.unmodifiableObservableList(this.saveFiles);
    }

    public void querySaveFiles() {
        log.debug("Querying save files");
        this.loadSaveFilesTask().onSuccess(files -> {
            this.saveFiles.setAll((Collection)files);
            Collections.sort(this.saveFiles, SaveFile.RECENT_FIRST);
        }).runAsyncFXWithDialog((IOTask.UIDialogHandler)new ProgressDialog(Local.getLocalizedString((String)"menu.loadingSaveFiles")));
    }

    private String profileDir() {
        return "./" + PROFILES_DIR + this.profileName + "/";
    }

    private String saveDir() {
        return this.profileDir() + SAVE_DIR;
    }

    public IOTask<Void> saveTask(DataFile dataFile, SaveFile saveFile) {
        log.debug("Saving data: " + saveFile.getName());
        return fs.writeDataTask((Serializable)saveFile, this.saveDir() + saveFile.getName() + SAVE_FILE_EXT).then(n -> fs.writeDataTask((Serializable)dataFile, this.saveDir() + saveFile.getName() + DATA_FILE_EXT)).then(n -> IOTask.ofVoid((String)"updateSaves", () -> Async.startFX(() -> {
            this.saveFiles.add((Object)saveFile);
            Collections.sort(this.saveFiles, SaveFile.RECENT_FIRST);
        })));
    }

    public IOTask<Void> saveProfileTask(UserProfile profile) {
        log.debug("Saving profile: " + this.profileName);
        return fs.writeDataTask((Serializable)profile, this.profileDir() + PROFILE_FILE_NAME).then(n -> new IOTask<Void>("checkSavesDir(" + this.saveDir() + ")"){

            protected Void onExecute() throws Exception {
                if (!fs.exists(SaveLoadManager.this.saveDir())) {
                    log.debug("Creating non-existent saves dir");
                    fs.createDirectoryTask(SaveLoadManager.this.saveDir()).then(n -> fs.writeDataTask(Collections.singletonList("This directory contains save files."), SaveLoadManager.this.saveDir() + "Readme.txt")).onFailure(e -> {
                        log.warning("Failed to create saves dir: " + e);
                        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), (Throwable)e);
                    }).run();
                }
                return null;
            }
        });
    }

    public IOTask<DataFile> loadTask(SaveFile saveFile) {
        log.debug("Loading data: " + saveFile.getName());
        return fs.readDataTask(this.saveDir() + saveFile.getName() + DATA_FILE_EXT);
    }

    public IOTask<UserProfile> loadProfileTask() {
        log.debug("Loading profile: " + this.profileName);
        return fs.readDataTask(this.profileDir() + PROFILE_FILE_NAME);
    }

    public IOTask<Void> deleteSaveFileTask(SaveFile saveFile) {
        log.debug("Deleting save file: " + saveFile.getName());
        return fs.deleteFileTask(this.saveDir() + saveFile.getName() + SAVE_FILE_EXT).then(n -> fs.deleteFileTask(this.saveDir() + saveFile.getName() + DATA_FILE_EXT)).then(n -> IOTask.ofVoid((String)"updateSaves", () -> Async.startFX(() -> this.saveFiles.remove((Object)saveFile))));
    }

    public boolean saveFileExists(String saveFileName) {
        log.debug("Checking if save file exists: " + saveFileName);
        return fs.exists(this.saveDir() + saveFileName + SAVE_FILE_EXT);
    }

    public static IOTask<List<String>> loadProfileNamesTask() {
        log.debug("Loading profile names");
        return fs.loadDirectoryNamesTask("./" + PROFILES_DIR, false);
    }

    public static IOTask<Void> deleteProfileTask(String profileName) {
        log.debug("Deleting profile: " + profileName);
        return fs.deleteDirectoryTask("./" + PROFILES_DIR + profileName);
    }

    public IOTask<List<SaveFile>> loadSaveFilesTask() {
        log.debug("Loading save files");
        return fs.loadFileNamesTask(this.saveDir(), true, Collections.singletonList(new FileExtension(SAVE_FILE_EXT))).then(fileNames -> IOTask.of((String)"readSaveFiles", () -> {
            ArrayList<SaveFile> list = new ArrayList<SaveFile>();
            for (String name : fileNames) {
                SaveFile file = (SaveFile)fs.readDataTask(this.saveDir() + name).run();
                if (file == null) continue;
                list.add(file);
            }
            return list;
        }));
    }

    public IOTask<SaveFile> loadLastModifiedSaveFileTask() {
        log.debug("Loading last modified save file");
        return this.loadSaveFilesTask().then(files -> IOTask.of((String)"findLastSave", () -> {
            if (files.isEmpty()) {
                throw new FileNotFoundException("No save files found");
            }
            Collections.sort(files, SaveFile.RECENT_FIRST);
            return (SaveFile)files.get(0);
        }));
    }

    static {
        log.debug("Checking profiles dir: " + PROFILES_DIR);
        if (!fs.exists(PROFILES_DIR)) {
            log.debug("Creating non-existent profiles dir");
            fs.createDirectoryTask(PROFILES_DIR).then(n -> fs.writeDataTask(Collections.singletonList("This directory contains user profiles."), PROFILES_DIR + "Readme.txt")).onFailure(e -> {
                log.warning("Failed to create profiles dir: " + e);
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), (Throwable)e);
            }).run();
        }
    }
}

