/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.saving;

import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.saving.ProfileManager;
import com.almasb.sslogger.Logger;
import java.util.Collections;
import java.util.List;

public final class SaveLoadManager {
    private static final Logger log = Logger.get(SaveLoadManager.class);
    private final String PROFILE_FILE_NAME;
    private final String PROFILES_DIR;
    private final String SAVE_DIR;
    private final String SAVE_FILE_EXT;
    private final String DATA_FILE_EXT;
    private final FS fs;

    public SaveLoadManager(ReadOnlyGameSettings settings) {
        this.fs = new FS(settings.isDesktop());
        this.PROFILES_DIR = settings.getProfileDir();
        this.DATA_FILE_EXT = settings.getDataFileExt();
        this.SAVE_FILE_EXT = settings.getSaveFileExt();
        this.SAVE_DIR = settings.getSaveDir();
        this.PROFILE_FILE_NAME = settings.getProfileName();
        if (!this.fs.exists(this.PROFILES_DIR)) {
            this.createProfilesDir();
        }
    }

    private void createProfilesDir() {
        log.debug("Creating profiles dir");
        this.fs.createDirectoryTask(this.PROFILES_DIR).then(n -> this.fs.writeDataTask(Collections.singletonList("This directory contains user profiles."), this.PROFILES_DIR + "Readme.txt")).onFailure(e -> {
            log.warning("Failed to create profiles dir: " + e);
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), (Throwable)e);
        }).run();
    }

    public IOTask<List<String>> readProfileNamesTask() {
        log.debug("Reading profile names");
        return this.fs.loadDirectoryNamesTask("./" + this.PROFILES_DIR, false);
    }

    public IOTask<Void> deleteProfileTask(String profileName) {
        log.debug("Deleting profile: " + profileName);
        return this.fs.deleteDirectoryTask("./" + this.PROFILES_DIR + profileName);
    }

    public ProfileManager getProfileManager(String profileName) {
        return new ProfileManager(this.fs, profileName, this.PROFILES_DIR, this.PROFILE_FILE_NAME, this.SAVE_DIR, this.SAVE_FILE_EXT, this.DATA_FILE_EXT);
    }
}

