/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.CSS;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.audio.AudioKt;
import com.almasb.fxgl.audio.AudioType;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.audio.impl.DesktopAudioService;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.entity.level.LevelLoader;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.ui.FontFactory;
import com.almasb.fxgl.ui.UI;
import com.almasb.fxgl.ui.UIController;
import com.almasb.sslogger.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0004J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u0004J\u0016\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u0004J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u0004042\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u00105\u001a\u0002062\u0006\u0010\u001d\u001a\u00020\u0004J\u001e\u00105\u001a\u0002062\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208J\u0016\u0010:\u001a\u00020;2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010<\u001a\u00020=J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u0004042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0016j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/almasb/fxgl/app/AssetLoader;", "", "()V", "AI_DIR", "", "ASSETS_DIR", "CSS_DIR", "CURSORS_DIR", "FONTS_DIR", "JSON_DIR", "LEVELS_DIR", "MUSIC_DIR", "PROPERTIES_DIR", "SCRIPTS_DIR", "SOUNDS_DIR", "TEXTURES_DIR", "TEXT_DIR", "TMX_DIR", "UI_DIR", "audioService", "Lcom/almasb/fxgl/audio/impl/DesktopAudioService;", "cachedAssets", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "log", "Lcom/almasb/sslogger/Logger;", "clearCache", "", "getAssetFromCache", "name", "getStream", "Ljava/io/InputStream;", "getURL", "Ljava/net/URL;", "loadCSS", "Lcom/almasb/fxgl/app/CSS;", "loadCursorImage", "Ljavafx/scene/image/Image;", "loadFont", "Lcom/almasb/fxgl/ui/FontFactory;", "loadImage", "loadLevel", "Lcom/almasb/fxgl/entity/level/Level;", "levelLoader", "Lcom/almasb/fxgl/entity/level/LevelLoader;", "loadMusic", "Lcom/almasb/fxgl/audio/Music;", "loadResourceBundle", "Ljava/util/ResourceBundle;", "loadSound", "Lcom/almasb/fxgl/audio/Sound;", "loadText", "", "loadTexture", "Lcom/almasb/fxgl/texture/Texture;", "width", "", "height", "loadUI", "Lcom/almasb/fxgl/ui/UI;", "controller", "Lcom/almasb/fxgl/ui/UIController;", "readAllLines", "fxgl"})
public final class AssetLoader {
    private final String ASSETS_DIR = "/assets/";
    private final String TEXTURES_DIR = this.ASSETS_DIR + "textures/";
    private final String SOUNDS_DIR = this.ASSETS_DIR + "sounds/";
    private final String MUSIC_DIR = this.ASSETS_DIR + "music/";
    private final String TEXT_DIR = this.ASSETS_DIR + "text/";
    private final String JSON_DIR = this.ASSETS_DIR + "json/";
    private final String TMX_DIR = this.ASSETS_DIR + "tmx/";
    private final String SCRIPTS_DIR = this.ASSETS_DIR + "scripts/";
    private final String PROPERTIES_DIR = this.ASSETS_DIR + "properties/";
    private final String AI_DIR = this.ASSETS_DIR + "ai/";
    private final String LEVELS_DIR = this.ASSETS_DIR + "levels/";
    private final String UI_DIR = this.ASSETS_DIR + "ui/";
    private final String CSS_DIR = this.UI_DIR + "css/";
    private final String FONTS_DIR = this.UI_DIR + "fonts/";
    private final String CURSORS_DIR = this.UI_DIR + "cursors/";
    private final Logger log = Logger.Companion.get(this.getClass());
    private final DesktopAudioService audioService = new DesktopAudioService();
    private final HashMap<String, Object> cachedAssets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadImage(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXTURES_DIR + name);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return (Image)t;
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Image image = new Image(it);
                this.cachedAssets.put(this.TEXTURES_DIR + name, image);
                Image image2 = image;
                return image2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load texture " + name, (Throwable)e);
            return ImagesKt.getDummyImage();
        }
    }

    @NotNull
    public final Texture loadTexture(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new Texture(this.loadImage(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Texture loadTexture(@NotNull String name, double width, double height) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String cacheKey = this.TEXTURES_DIR + name + "@" + width + "x" + height;
        Object asset = this.getAssetFromCache(cacheKey);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return new Texture((Image)t);
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Texture texture = new Texture(new Image(it, width, height, false, true));
                this.cachedAssets.put(cacheKey, texture.getImage());
                Texture texture2 = texture;
                return texture2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load texture " + name, (Throwable)e);
            return new Texture(ImagesKt.getDummyImage());
        }
    }

    @NotNull
    public final Sound loadSound(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.SOUNDS_DIR + name);
        if (asset != null) {
            Object t = Sound.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Sound::class.java.cast(asset)");
            return (Sound)t;
        }
        try {
            Sound sound = new Sound(this.audioService.loadAudio(AudioType.SOUND, this.getURL(this.SOUNDS_DIR + name)));
            this.cachedAssets.put(this.SOUNDS_DIR + name, sound);
            return sound;
        }
        catch (Exception e) {
            this.log.warning("Failed to load sound " + name, (Throwable)e);
            return new Sound(AudioKt.getDummyAudio());
        }
    }

    @NotNull
    public final Music loadMusic(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.MUSIC_DIR + name);
        if (asset != null) {
            Object t = Music.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Music::class.java.cast(asset)");
            return (Music)t;
        }
        try {
            Music music = new Music(this.audioService.loadAudio(AudioType.MUSIC, this.getURL(this.MUSIC_DIR + name)));
            this.cachedAssets.put(this.MUSIC_DIR + name, music);
            return music;
        }
        catch (Exception e) {
            this.log.warning("Failed to load music " + name, (Throwable)e);
            return new Music(AudioKt.getDummyAudio());
        }
    }

    @NotNull
    public final List<String> loadText(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXT_DIR + name);
        if (asset != null) {
            return (List)asset;
        }
        List<String> text = this.readAllLines(this.TEXT_DIR + name);
        this.cachedAssets.put(this.TEXT_DIR + name, text);
        return text;
    }

    @NotNull
    public final Level loadLevel(@NotNull String name, @NotNull LevelLoader levelLoader) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)levelLoader, (String)"levelLoader");
        return levelLoader.load(this.getURL(this.LEVELS_DIR + name), FXGL.Companion.getGameWorld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ResourceBundle loadResourceBundle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.PROPERTIES_DIR + name);
        if (asset != null) {
            return (ResourceBundle)asset;
        }
        try {
            Closeable closeable = this.getStream(this.PROPERTIES_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream = it;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                boolean bl3 = false;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset2);
                Reader reader = inputStreamReader;
                PropertyResourceBundle bundle = new PropertyResourceBundle(reader);
                this.cachedAssets.put(this.PROPERTIES_DIR + name, bundle);
                ResourceBundle resourceBundle = bundle;
                return resourceBundle;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load resource bundle " + name, (Throwable)e);
            return new ListResourceBundle(){

                @NotNull
                protected Object[][] getContents() {
                    return new Object[0][];
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadCursorImage(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            Closeable closeable = this.getStream(this.CURSORS_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Image image = new Image(it);
                return image;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load cursor image " + name, (Throwable)e);
            return ImagesKt.getDummyImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UI loadUI(@NotNull String name, @NotNull UIController controller) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        try {
            Closeable closeable = this.getStream(this.UI_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                FXMLLoader loader = new FXMLLoader();
                loader.setController((Object)controller);
                Parent root = (Parent)loader.load(it);
                controller.init();
                Parent parent = root;
                Intrinsics.checkExpressionValueIsNotNull((Object)parent, (String)"root");
                UI uI = new UI(parent, controller);
                return uI;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load FXML " + name, (Throwable)e);
            this.log.warning("Failed to load UI, so controller.init() will not be called");
            return new UI((Parent)new Pane(), controller);
        }
    }

    @NotNull
    public final CSS loadCSS(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            String string = this.getURL(this.CSS_DIR + name).toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getURL(CSS_DIR + name).toExternalForm()");
            return new CSS(string);
        }
        catch (Exception e) {
            this.log.warning("Failed to load css " + name, (Throwable)e);
            return new CSS("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FontFactory loadFont(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.FONTS_DIR + name);
        if (asset != null) {
            Object t = FontFactory.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"FontFactory::class.java.cast(asset)");
            return (FontFactory)t;
        }
        try {
            Closeable closeable = this.getStream(this.FONTS_DIR + name);
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Font font = Font.loadFont((InputStream)it, (double)12.0);
                if (font == null) {
                    throw (Throwable)new IllegalArgumentException("Font.loadFont(" + name + ") returned null");
                }
                Font font2 = font;
                FontFactory fontFactory = new FontFactory(font2);
                ((Map)this.cachedAssets).put(this.FONTS_DIR + name, fontFactory);
                FontFactory fontFactory2 = fontFactory;
                return fontFactory2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to load font " + name, (Throwable)e);
            Font font = Font.font((double)12.0);
            Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"Font.font(12.0)");
            return new FontFactory(font);
        }
    }

    @NotNull
    public final InputStream getStream(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            InputStream inputStream = this.getURL(name).openStream();
            if (inputStream == null) {
                throw (Throwable)new IOException("Input stream to \"" + name + "\" is null!");
            }
            return inputStream;
        }
        catch (IOException e) {
            throw (Throwable)new IllegalArgumentException("Failed to obtain input stream to URL: " + e);
        }
    }

    private final URL getURL(String name) {
        this.log.debug("Loading from file system: " + name);
        Object object = GameApplication.FXGLApplication.app;
        if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getResource(name)) == null) {
            String string = name;
            int n = 1;
            StringBuilder stringBuilder = new StringBuilder().append("/fxgl");
            Class<?> clazz = this.getClass();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            object = clazz.getResource(stringBuilder.append(string4).toString());
        }
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("Asset \"" + name + "\" was not found!");
        }
        return object;
    }

    private final Object getAssetFromCache(String name) {
        Object asset = this.cachedAssets.get(name);
        if (asset != null) {
            this.log.debug("Loading from cache: " + name);
            return asset;
        }
        return null;
    }

    private final List<String> readAllLines(String name) {
        try {
            InputStream inputStream = this.getStream(name);
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            return TextStreamsKt.readLines((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        }
        catch (Exception e) {
            this.log.warning("Failed to load plain text file " + name, (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    public final void clearCache() {
        this.log.debug("Clearing assets cache");
        this.cachedAssets.clear();
    }

    public AssetLoader() {
        AssetLoader assetLoader2 = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        assetLoader2.cachedAssets = hashMap;
    }
}

