/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.app.FXGLDefaultMenu;
import com.almasb.fxgl.app.FXGLMenu;
import com.almasb.fxgl.app.MenuItem;
import com.almasb.fxgl.app.MenuType;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.Function;
import com.almasb.fxgl.core.util.Supplier;
import com.almasb.fxgl.dsl.AnimationBuilder;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.particle.ParticleEmitter;
import com.almasb.fxgl.particle.ParticleEmitters;
import com.almasb.fxgl.particle.ParticleSystem;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.ui.FXGLButton;
import com.almasb.fxgl.ui.UIFactory;
import com.almasb.sslogger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import javafx.animation.FadeTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 .2\u00020\u0001:\u0003./0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0016H\u0014J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0016H\u0014J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0016H\u0014J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\fH\u0014J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0018H\u0014J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0018H\u0014R&\u0010\u0005\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/almasb/fxgl/app/FXGLDefaultMenu;", "Lcom/almasb/fxgl/app/FXGLMenu;", "type", "Lcom/almasb/fxgl/app/MenuType;", "(Lcom/almasb/fxgl/app/MenuType;)V", "animations", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/animation/Animation;", "Lkotlin/collections/ArrayList;", "particleSystem", "Lcom/almasb/fxgl/particle/ParticleSystem;", "t", "", "titleColor", "Ljavafx/beans/property/ObjectProperty;", "Ljavafx/scene/paint/Color;", "createActionButton", "Ljavafx/scene/control/Button;", "name", "Ljavafx/beans/binding/StringBinding;", "action", "Ljava/lang/Runnable;", "", "createBackground", "Ljavafx/scene/Node;", "width", "height", "createExtraMenu", "Lcom/almasb/fxgl/app/FXGLDefaultMenu$MenuBox;", "createMenuBodyGameMenu", "createMenuBodyMainMenu", "createOptionsMenu", "createProfileView", "profileName", "createTitleView", "title", "createVersionView", "version", "onCreate", "", "onUpdate", "tpf", "switchMenuContentTo", "content", "switchMenuTo", "menu", "Companion", "MenuBox", "MenuButton", "fxgl"})
public final class FXGLDefaultMenu
extends FXGLMenu {
    private ParticleSystem particleSystem;
    private ObjectProperty<Color> titleColor;
    private double t;
    private final ArrayList<Animation<?>> animations;
    private static final Logger log;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void onCreate() {
        this.animations.clear();
        Object object = this.getMenuRoot().getChildren().get(0);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.FXGLDefaultMenu.MenuBox");
        }
        MenuBox menuBox = (MenuBox)((Object)object);
        ObservableList observableList = menuBox.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"menuBox.children");
        Iterable $this$forEachIndexed$iv = (Iterable)observableList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void node;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Node node2 = (Node)item$iv;
            int index = n2;
            boolean bl2 = false;
            void v2 = node;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"node");
            v2.setTranslateX(-250.0);
            AnimationBuilder animationBuilder = FXGL.Companion.animationBuilder();
            Duration duration = Duration.seconds((double)((double)index * 0.07));
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.seconds(index * 0.07)");
            AnimationBuilder animationBuilder2 = animationBuilder.delay(duration).interpolator(Interpolators.EXPONENTIAL.EASE_OUT());
            Duration duration2 = Duration.seconds((double)0.66);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.seconds(0.66)");
            Animation<?> animation = animationBuilder2.duration(duration2).translate(new Node[]{node}).from(new Point2D(-250.0, 0.0)).to(new Point2D(0.0, 0.0)).build();
            Collection collection = this.animations;
            boolean bl3 = false;
            collection.add(animation);
            animation.stop();
            animation.start();
        }
    }

    protected void onUpdate(double tpf) {
        Iterable $this$forEach$iv = this.animations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animation it = (Animation)element$iv;
            boolean bl = false;
            it.onUpdate(tpf);
        }
        double frequency = 1.7;
        this.t += tpf * frequency;
        ParticleSystem particleSystem = this.particleSystem;
        if (particleSystem == null) {
            Intrinsics.throwNpe();
        }
        particleSystem.onUpdate(tpf);
        Color color = Color.color((double)1.0, (double)1.0, (double)1.0, (double)FXGLMath.noise1D((double)this.t));
        ObjectProperty<Color> objectProperty = this.titleColor;
        if (objectProperty == null) {
            Intrinsics.throwNpe();
        }
        objectProperty.set((Object)color);
    }

    @Override
    @NotNull
    protected Node createBackground(double width, double height) {
        Rectangle bg = new Rectangle(width, height);
        bg.setFill((Paint)Color.rgb((int)10, (int)1, (int)1));
        return (Node)bg;
    }

    @Override
    @NotNull
    protected Node createTitleView(@NotNull String title) {
        Text text2;
        Text text;
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        this.titleColor = (ObjectProperty)new SimpleObjectProperty((Object)Color.WHITE);
        String string = title;
        int n = 0;
        int n2 = 1;
        UIFactory uIFactory = FXGL.Companion.getUIFactory();
        int n3 = 0;
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string3 = string2;
        Text text3 = text = uIFactory.newText(string3, 50.0);
        Intrinsics.checkExpressionValueIsNotNull((Object)text3, (String)"text");
        text3.setFill((Paint)null);
        text.strokeProperty().bind((ObservableValue)this.titleColor);
        text.setStrokeWidth(1.5);
        String string4 = title;
        n2 = 1;
        n3 = title.length();
        uIFactory = FXGL.Companion.getUIFactory();
        boolean bl = false;
        String string5 = string4.substring(n2, n3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string3 = string5;
        Text text4 = text2 = uIFactory.newText(string3, 50.0);
        Intrinsics.checkExpressionValueIsNotNull((Object)text4, (String)"text2");
        text4.setFill((Paint)null);
        ObjectProperty<Color> objectProperty = this.titleColor;
        if (objectProperty == null) {
            Intrinsics.throwNpe();
        }
        text2.setStroke((Paint)objectProperty.getValue());
        text2.setStrokeWidth(1.5);
        Bounds bounds = text.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"text.layoutBounds");
        double d = bounds.getWidth();
        Bounds bounds2 = text2.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds2, (String)"text2.layoutBounds");
        double textWidth = d + bounds2.getWidth();
        Rectangle bg = new Rectangle(textWidth + (double)30, 65.0, null);
        bg.setStroke((Paint)Color.WHITE);
        bg.setStrokeWidth(4.0);
        bg.setArcWidth(25.0);
        bg.setArcHeight(25.0);
        ParticleEmitter emitter = ParticleEmitters.newExplosionEmitter((int)50);
        Texture t = FXGL.Companion.texture("particles/trace_horizontal.png", 64.0, 64.0);
        ParticleEmitter particleEmitter = emitter;
        Intrinsics.checkExpressionValueIsNotNull((Object)particleEmitter, (String)"emitter");
        particleEmitter.setBlendMode(BlendMode.ADD);
        emitter.setSourceImage(t.getImage());
        emitter.setMaxEmissions(Integer.MAX_VALUE);
        emitter.setSize(18.0, 22.0);
        emitter.setNumParticles(2);
        emitter.setEmissionRate(0.2);
        emitter.setVelocityFunction((Function)createTitleView.1.INSTANCE);
        emitter.setExpireFunction((Function)createTitleView.2.INSTANCE);
        emitter.setScaleFunction((Function)createTitleView.3.INSTANCE);
        emitter.setSpawnPointFunction((Function)createTitleView.4.INSTANCE);
        emitter.setAccelerationFunction((Supplier)createTitleView.5.INSTANCE);
        HBox box = new HBox(new Node[]{(Node)text, (Node)text2});
        box.setAlignment(Pos.CENTER);
        StackPane titleRoot = new StackPane();
        titleRoot.getChildren().addAll((Object[])new Node[]{(Node)bg, (Node)box});
        titleRoot.setTranslateX((double)(FXGL.Companion.getAppWidth() / 2) - (textWidth + (double)30) / (double)2);
        titleRoot.setTranslateY(50.0);
        ParticleSystem particleSystem = this.particleSystem = new ParticleSystem();
        if (particleSystem == null) {
            Intrinsics.throwNpe();
        }
        particleSystem.addParticleEmitter(emitter, (double)(FXGL.Companion.getAppWidth() / 2 - 30), titleRoot.getTranslateY() + (double)34);
        return (Node)titleRoot;
    }

    @Override
    @NotNull
    protected Node createVersionView(@NotNull String version) {
        Text view;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Text text = view = FXGL.Companion.getUIFactory().newText(version);
        Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"view");
        text.setTranslateY((double)(FXGL.Companion.getAppHeight() - 2));
        return (Node)view;
    }

    @Override
    @NotNull
    protected Node createProfileView(@NotNull String profileName) {
        Text view;
        Intrinsics.checkParameterIsNotNull((Object)profileName, (String)"profileName");
        Text text = view = FXGL.Companion.getUIFactory().newText(profileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"view");
        text.setTranslateY((double)(FXGL.Companion.getAppHeight() - 2));
        double d = FXGL.Companion.getAppWidth();
        Bounds bounds = view.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)bounds, (String)"view.layoutBounds");
        view.setTranslateX(d - bounds.getWidth());
        return (Node)view;
    }

    private final MenuBox createMenuBodyMainMenu() {
        log.debug("createMenuBodyMainMenu()");
        MenuBox box = new MenuBox(new MenuButton[0]);
        EnumSet<MenuItem> enabledItems = FXGL.Companion.getSettings().getEnabledMenuItems();
        MenuButton itemNewGame = new MenuButton("menu.newGame");
        itemNewGame.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent it) {
                this.this$0.fireNewGame();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        box.add$fxgl(itemNewGame);
        MenuButton itemOptions = new MenuButton("menu.options");
        itemOptions.setChild(this.createOptionsMenu());
        box.add$fxgl(itemOptions);
        if (enabledItems.contains((Object)MenuItem.EXTRA)) {
            MenuButton itemExtra = new MenuButton("menu.extra");
            itemExtra.setChild(this.createExtraMenu());
            box.add$fxgl(itemExtra);
        }
        MenuButton itemExit = new MenuButton("menu.exit");
        itemExit.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent it) {
                this.this$0.fireExit();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        box.add$fxgl(itemExit);
        return box;
    }

    private final MenuBox createMenuBodyGameMenu() {
        log.debug("createMenuBodyGameMenu()");
        MenuBox box = new MenuBox(new MenuButton[0]);
        EnumSet<MenuItem> enabledItems = FXGL.Companion.getSettings().getEnabledMenuItems();
        MenuButton itemResume = new MenuButton("menu.resume");
        itemResume.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent it) {
                this.this$0.fireResume();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        box.add$fxgl(itemResume);
        if (enabledItems.contains((Object)MenuItem.SAVE_LOAD)) {
            MenuButton itemSave = new MenuButton("menu.save");
            itemSave.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
                final /* synthetic */ FXGLDefaultMenu this$0;

                public final void handle(ActionEvent it) {
                    this.this$0.fireSave();
                }
                {
                    this.this$0 = fXGLDefaultMenu;
                }
            }));
            MenuButton itemLoad = new MenuButton("menu.load");
            itemLoad.setMenuContent((Supplier<FXGLMenu.MenuContent>)((Supplier)new Supplier<FXGLMenu.MenuContent>(this){
                final /* synthetic */ FXGLDefaultMenu this$0;

                @NotNull
                public final FXGLMenu.MenuContent get() {
                    return this.this$0.createContentLoad();
                }
                {
                    this.this$0 = fXGLDefaultMenu;
                }
            }));
            box.add$fxgl(itemSave);
            box.add$fxgl(itemLoad);
        }
        MenuButton itemOptions = new MenuButton("menu.options");
        itemOptions.setChild(this.createOptionsMenu());
        box.add$fxgl(itemOptions);
        if (enabledItems.contains((Object)MenuItem.EXTRA)) {
            MenuButton itemExtra = new MenuButton("menu.extra");
            itemExtra.setChild(this.createExtraMenu());
            box.add$fxgl(itemExtra);
        }
        MenuButton itemExit = new MenuButton("menu.mainMenu");
        itemExit.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent it) {
                this.this$0.fireExitToMainMenu();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        box.add$fxgl(itemExit);
        return box;
    }

    private final MenuBox createOptionsMenu() {
        log.debug("createOptionsMenu()");
        MenuButton itemGameplay = new MenuButton("menu.gameplay");
        itemGameplay.setMenuContent((Supplier<FXGLMenu.MenuContent>)((Supplier)new Supplier<FXGLMenu.MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final FXGLMenu.MenuContent get() {
                return this.this$0.createContentGameplay();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        MenuButton itemControls = new MenuButton("menu.controls");
        itemControls.setMenuContent((Supplier<FXGLMenu.MenuContent>)((Supplier)new Supplier<FXGLMenu.MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final FXGLMenu.MenuContent get() {
                return this.this$0.createContentControls();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        MenuButton itemVideo = new MenuButton("menu.video");
        itemVideo.setMenuContent((Supplier<FXGLMenu.MenuContent>)((Supplier)new Supplier<FXGLMenu.MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final FXGLMenu.MenuContent get() {
                return this.this$0.createContentVideo();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        MenuButton itemAudio = new MenuButton("menu.audio");
        itemAudio.setMenuContent((Supplier<FXGLMenu.MenuContent>)((Supplier)new Supplier<FXGLMenu.MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final FXGLMenu.MenuContent get() {
                return this.this$0.createContentAudio();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        MenuButton btnRestore = new MenuButton("menu.restore");
        btnRestore.setOnAction((EventHandler<ActionEvent>)((EventHandler)new EventHandler<ActionEvent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            public final void handle(ActionEvent e) {
                FXGL.Companion.getDisplay().showConfirmationBox(FXGL.Companion.localize("menu.settingsRestore"), (Consumer)new Consumer<Boolean>(this){
                    final /* synthetic */ createOptionsMenu.5 this$0;

                    public final void accept(Boolean yes) {
                        Boolean bl = yes;
                        if (bl == null) {
                            Intrinsics.throwNpe();
                        }
                        if (bl.booleanValue()) {
                            this.this$0.this$0.switchMenuContentTo((Node)this.this$0.this$0.getEMPTY$fxgl());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        return new MenuBox(itemGameplay, itemControls, itemVideo, itemAudio, btnRestore);
    }

    private final MenuBox createExtraMenu() {
        log.debug("createExtraMenu()");
        MenuButton itemAchievements = new MenuButton("menu.trophies");
        itemAchievements.setMenuContent((Supplier<FXGLMenu.MenuContent>)((Supplier)new Supplier<FXGLMenu.MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final FXGLMenu.MenuContent get() {
                return this.this$0.createContentAchievements();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        MenuButton itemCredits = new MenuButton("menu.credits");
        itemCredits.setMenuContent((Supplier<FXGLMenu.MenuContent>)((Supplier)new Supplier<FXGLMenu.MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final FXGLMenu.MenuContent get() {
                return this.this$0.createContentCredits();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        MenuButton itemFeedback = new MenuButton("menu.feedback");
        itemFeedback.setMenuContent((Supplier<FXGLMenu.MenuContent>)((Supplier)new Supplier<FXGLMenu.MenuContent>(this){
            final /* synthetic */ FXGLDefaultMenu this$0;

            @NotNull
            public final FXGLMenu.MenuContent get() {
                return this.this$0.createContentFeedback();
            }
            {
                this.this$0 = fXGLDefaultMenu;
            }
        }));
        return new MenuBox(itemAchievements, itemCredits, itemFeedback);
    }

    @Override
    protected void switchMenuTo(@NotNull Node menu) {
        Intrinsics.checkParameterIsNotNull((Object)menu, (String)"menu");
        Node oldMenu = (Node)this.getMenuRoot().getChildren().get(0);
        FadeTransition ft = new FadeTransition(Duration.seconds((double)0.33), oldMenu);
        ft.setToValue(0.0);
        ft.setOnFinished((EventHandler)new EventHandler<ActionEvent>(this, menu, oldMenu){
            final /* synthetic */ FXGLDefaultMenu this$0;
            final /* synthetic */ Node $menu;
            final /* synthetic */ Node $oldMenu;

            public final void handle(ActionEvent e) {
                this.$menu.setOpacity(0.0);
                this.this$0.getMenuRoot().getChildren().set(0, (Object)this.$menu);
                Node node = this.$oldMenu;
                Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"oldMenu");
                node.setOpacity(1.0);
                FadeTransition ft2 = new FadeTransition(Duration.seconds((double)0.33), this.$menu);
                ft2.setToValue(1.0);
                ft2.play();
            }
            {
                this.this$0 = fXGLDefaultMenu;
                this.$menu = node;
                this.$oldMenu = node2;
            }
        });
        ft.play();
    }

    @Override
    protected void switchMenuContentTo(@NotNull Node content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.getMenuContentRoot().getChildren().set(0, (Object)content);
    }

    @Override
    @NotNull
    protected Button createActionButton(@NotNull String name, @NotNull Runnable action) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        MenuButton btn = new MenuButton(name);
        btn.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(action){
            final /* synthetic */ Runnable $action;

            public final void handle(ActionEvent event) {
                this.$action.run();
            }
            {
                this.$action = runnable;
            }
        });
        return (Button)btn.getBtn();
    }

    @Override
    @NotNull
    protected Button createActionButton(@NotNull StringBinding name, @NotNull Runnable action) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        String string = name.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.value");
        MenuButton btn = new MenuButton(string);
        btn.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(action){
            final /* synthetic */ Runnable $action;

            public final void handle(ActionEvent event) {
                this.$action.run();
            }
            {
                this.$action = runnable;
            }
        });
        return (Button)btn.getBtn();
    }

    public FXGLDefaultMenu(@NotNull MenuType type) {
        ParticleEmitter emitter;
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        super(type);
        if (FXGL.Companion.getAppWidth() < 600 || FXGL.Companion.getAppHeight() < 600) {
            log.warning("FXGLDefaultMenu is not designed for resolutions < 800x600");
        }
        final MenuBox menu = type == MenuType.MAIN_MENU ? this.createMenuBodyMainMenu() : this.createMenuBodyGameMenu();
        double menuX = 50.0;
        double menuY = (double)(FXGL.Companion.getAppHeight() / 2) - menu.getLayoutHeight$fxgl() / (double)2;
        this.getMenuRoot().setTranslateX(menuX);
        this.getMenuRoot().setTranslateY(menuY);
        this.getMenuContentRoot().setTranslateX((double)(FXGL.Companion.getAppWidth() - 500));
        this.getMenuContentRoot().setTranslateY(menuY);
        Texture t = FXGL.Companion.texture("particles/smoke.png", 128.0, 128.0).brighter().brighter();
        ParticleEmitter particleEmitter = emitter = ParticleEmitters.newFireEmitter();
        Intrinsics.checkExpressionValueIsNotNull((Object)particleEmitter, (String)"emitter");
        particleEmitter.setBlendMode(BlendMode.SRC_OVER);
        emitter.setSourceImage(t.getImage());
        emitter.setSize(150.0, 220.0);
        emitter.setNumParticles(10);
        emitter.setEmissionRate(0.01);
        emitter.setVelocityFunction((Function)1.INSTANCE);
        emitter.setExpireFunction((Function)2.INSTANCE);
        emitter.setScaleFunction((Function)3.INSTANCE);
        emitter.setSpawnPointFunction((Function)4.INSTANCE);
        ParticleSystem particleSystem = this.particleSystem;
        if (particleSystem == null) {
            Intrinsics.throwNpe();
        }
        particleSystem.addParticleEmitter(emitter, 0.0, (double)FXGL.Companion.getAppHeight());
        ObservableList observableList = this.getContentRoot().getChildren();
        ParticleSystem particleSystem2 = this.particleSystem;
        if (particleSystem2 == null) {
            Intrinsics.throwNpe();
        }
        observableList.add(3, (Object)particleSystem2.getPane());
        this.getMenuRoot().getChildren().addAll((Object[])new Node[]{(Node)menu});
        this.getMenuContentRoot().getChildren().add((Object)this.getEMPTY$fxgl());
        this.activeProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public final void changed(ObservableValue<? extends Boolean> observable, Boolean wasActive, Boolean isActive) {
                if (!isActive.booleanValue()) {
                    this.switchMenuTo((Node)menu);
                    this.switchMenuContentTo((Node)this.getEMPTY$fxgl());
                }
            }
        });
        FXGLDefaultMenu fXGLDefaultMenu = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        fXGLDefaultMenu.animations = arrayList;
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("FXGL.DefaultMenu");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\b\u0000\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0004R\u00020\u00050\u0003\"\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u0004R\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000eR\u0014\u0010\u0007\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/app/FXGLDefaultMenu$MenuBox;", "Ljavafx/scene/layout/VBox;", "items", "", "Lcom/almasb/fxgl/app/FXGLDefaultMenu$MenuButton;", "Lcom/almasb/fxgl/app/FXGLDefaultMenu;", "([Lcom/almasb/fxgl/app/FXGLDefaultMenu$MenuButton;)V", "layoutHeight", "", "getLayoutHeight$fxgl", "()D", "add", "", "item", "add$fxgl", "fxgl"})
    public static final class MenuBox
    extends VBox {
        public final double getLayoutHeight$fxgl() {
            return 10 * this.getChildren().size();
        }

        public final void add$fxgl(@NotNull MenuButton item) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)item), (String)"item");
            item.setParent(this);
            this.getChildren().addAll((Object[])new Node[]{(Node)item});
        }

        public MenuBox(MenuButton ... items) {
            Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
            for (MenuButton item : items) {
                this.add$fxgl(item);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016J\u0014\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/app/FXGLDefaultMenu$MenuButton;", "Ljavafx/scene/layout/Pane;", "stringKey", "", "(Lcom/almasb/fxgl/app/FXGLDefaultMenu;Ljava/lang/String;)V", "btn", "Lcom/almasb/fxgl/ui/FXGLButton;", "getBtn", "()Lcom/almasb/fxgl/ui/FXGLButton;", "cachedContent", "Lcom/almasb/fxgl/app/FXGLMenu$MenuContent;", "isAnimating", "", "p", "Ljavafx/scene/shape/Polygon;", "parent", "Lcom/almasb/fxgl/app/FXGLDefaultMenu$MenuBox;", "setChild", "", "menu", "setMenuContent", "contentSupplier", "Lcom/almasb/fxgl/core/util/Supplier;", "setOnAction", "e", "Ljavafx/event/EventHandler;", "Ljavafx/event/ActionEvent;", "setParent", "fxgl"})
    public final class MenuButton
    extends Pane {
        private MenuBox parent;
        private FXGLMenu.MenuContent cachedContent;
        private final Polygon p;
        @NotNull
        private final FXGLButton btn;
        private boolean isAnimating;

        @NotNull
        public final FXGLButton getBtn() {
            return this.btn;
        }

        public final void setOnAction(@NotNull EventHandler<ActionEvent> e) {
            Intrinsics.checkParameterIsNotNull(e, (String)"e");
            this.btn.setOnAction(e);
        }

        public final void setParent(@NotNull MenuBox menu) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)menu), (String)"menu");
            this.parent = menu;
        }

        public final void setMenuContent(@NotNull Supplier<FXGLMenu.MenuContent> contentSupplier) {
            Intrinsics.checkParameterIsNotNull(contentSupplier, (String)"contentSupplier");
            this.btn.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(this, contentSupplier){
                final /* synthetic */ MenuButton this$0;
                final /* synthetic */ Supplier $contentSupplier;

                public final void handle(ActionEvent event) {
                    if (MenuButton.access$getCachedContent$p(this.this$0) == null) {
                        MenuButton.access$setCachedContent$p(this.this$0, (FXGLMenu.MenuContent)((Object)this.$contentSupplier.get()));
                    }
                    FXGLDefaultMenu fXGLDefaultMenu = this.this$0.FXGLDefaultMenu.this;
                    FXGLMenu.MenuContent menuContent = MenuButton.access$getCachedContent$p(this.this$0);
                    if (menuContent == null) {
                        Intrinsics.throwNpe();
                    }
                    fXGLDefaultMenu.switchMenuContentTo((Node)menuContent);
                }
                {
                    this.this$0 = menuButton;
                    this.$contentSupplier = supplier;
                }
            });
        }

        public final void setChild(@NotNull MenuBox menu) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)menu), (String)"menu");
            MenuButton back = new MenuButton("menu.back");
            menu.getChildren().add(0, (Object)back);
            back.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(this){
                final /* synthetic */ MenuButton this$0;

                public final void handle(ActionEvent event) {
                    FXGLDefaultMenu fXGLDefaultMenu = this.this$0.FXGLDefaultMenu.this;
                    MenuBox menuBox = MenuButton.access$getParent$p(this.this$0);
                    if (menuBox == null) {
                        Intrinsics.throwNpe();
                    }
                    fXGLDefaultMenu.switchMenuTo((Node)menuBox);
                }
                {
                    this.this$0 = menuButton;
                }
            });
            this.btn.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(this, menu){
                final /* synthetic */ MenuButton this$0;
                final /* synthetic */ MenuBox $menu;

                public final void handle(ActionEvent event) {
                    this.this$0.FXGLDefaultMenu.this.switchMenuTo((Node)this.$menu);
                }
                {
                    this.this$0 = menuButton;
                    this.$menu = menuBox;
                }
            });
        }

        public MenuButton(String stringKey) {
            Intrinsics.checkParameterIsNotNull((Object)stringKey, (String)"stringKey");
            this.p = new Polygon(new double[]{0.0, 0.0, 220.0, 0.0, 250.0, 35.0, 0.0, 35.0});
            this.btn = new FXGLButton();
            this.btn.setAlignment(Pos.CENTER_LEFT);
            this.btn.setStyle("-fx-background-color: transparent");
            this.btn.textProperty().bind((ObservableValue)FXGL.Companion.localizedStringProperty(stringKey));
            this.p.setMouseTransparent(true);
            LinearGradient g = new LinearGradient(0.0, 1.0, 1.0, 0.2, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.6, Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.34)), new Stop(0.85, Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.74)), new Stop(1.0, Color.WHITE)});
            Color color = Color.color((double)1.0, (double)0.8, (double)0.0, (double)0.75);
            if (color == null) {
                throw new TypeCastException("null cannot be cast to non-null type javafx.scene.paint.Paint");
            }
            this.p.fillProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.btn.pressedProperty())).then((Object)((Paint)color)).otherwise((Object)g));
            this.p.setStroke((Paint)Color.color((double)0.1, (double)0.1, (double)0.1, (double)0.15));
            this.p.setEffect((Effect)new GaussianBlur());
            this.p.visibleProperty().bind((ObservableValue)this.btn.hoverProperty());
            this.getChildren().addAll((Object[])new Node[]{(Node)this.btn, (Node)this.p});
            this.btn.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean isFocused) {
                    Boolean bl = isFocused;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isFocused");
                    if (bl.booleanValue()) {
                        boolean isOK;
                        boolean bl2;
                        block5: {
                            Iterable $this$none$iv = FXGLDefaultMenu.this.animations;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    Animation it = (Animation)element$iv;
                                    boolean bl3 = false;
                                    if (!it.isAnimating()) continue;
                                    bl2 = false;
                                    break block5;
                                }
                                bl2 = true;
                            }
                        }
                        boolean bl4 = isOK = bl2 && !isAnimating;
                        if (isOK) {
                            isAnimating = true;
                            FXGL.Companion.animationBuilder().onFinished(new Runnable(){

                                @Override
                                public final void run() {
                                    isAnimating = false;
                                }
                            }).bobbleDown((Node)this).buildAndPlay(FXGLDefaultMenu.this);
                        }
                    }
                }
            });
        }

        public static final /* synthetic */ FXGLMenu.MenuContent access$getCachedContent$p(MenuButton $this) {
            return $this.cachedContent;
        }

        public static final /* synthetic */ void access$setCachedContent$p(MenuButton $this, FXGLMenu.MenuContent menuContent) {
            $this.cachedContent = menuContent;
        }

        public static final /* synthetic */ MenuBox access$getParent$p(MenuButton $this) {
            return $this.parent;
        }

        public static final /* synthetic */ void access$setParent$p(MenuButton $this, MenuBox menuBox) {
            $this.parent = menuBox;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/FXGLDefaultMenu$Companion;", "", "()V", "log", "Lcom/almasb/sslogger/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

