/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.saving;

import com.almasb.fxgl.app.ProgressDialog;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.Function;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.saving.ProfileManager;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.sslogger.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u001aJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0 J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0 J\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0'0 J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0 2\u0006\u0010\"\u001a\u00020\u001aJ\u0006\u0010*\u001a\u00020\u001eJ\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0005J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u00100\u001a\u00020%J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u00102\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u001aR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR2\u0010\u0018\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\r\u00a8\u00063"}, d2={"Lcom/almasb/fxgl/saving/ProfileManager;", "", "fs", "Lcom/almasb/fxgl/io/FS;", "profileName", "", "profilesDirName", "profileFileName", "savesDirName", "saveFileExt", "dataFileExt", "(Lcom/almasb/fxgl/io/FS;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDataFileExt", "()Ljava/lang/String;", "getFs", "()Lcom/almasb/fxgl/io/FS;", "log", "Lcom/almasb/sslogger/Logger;", "profileDir", "getProfileFileName", "getProfileName", "getProfilesDirName", "saveDir", "getSaveFileExt", "saveFiles", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/saving/SaveFile;", "kotlin.jvm.PlatformType", "getSavesDirName", "createSavesDir", "", "deleteSaveFileTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "Ljava/lang/Void;", "saveFile", "loadLastModifiedSaveFileTask", "loadProfileTask", "Lcom/almasb/fxgl/saving/UserProfile;", "loadSaveFilesTask", "", "loadTask", "Lcom/almasb/fxgl/saving/DataFile;", "querySaveFiles", "saveFileExists", "", "saveFileName", "saveFilesProperty", "saveProfileTask", "profile", "saveTask", "dataFile", "fxgl"})
public final class ProfileManager {
    private final Logger log;
    private final String profileDir;
    private final String saveDir;
    private final ObservableList<SaveFile> saveFiles;
    @NotNull
    private final FS fs;
    @NotNull
    private final String profileName;
    @NotNull
    private final String profilesDirName;
    @NotNull
    private final String profileFileName;
    @NotNull
    private final String savesDirName;
    @NotNull
    private final String saveFileExt;
    @NotNull
    private final String dataFileExt;

    @NotNull
    public final ObservableList<SaveFile> saveFilesProperty() {
        ObservableList observableList = FXCollections.unmodifiableObservableList(this.saveFiles);
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"FXCollections.unmodifiab\u2026ObservableList(saveFiles)");
        return observableList;
    }

    @NotNull
    public final IOTask<Void> saveProfileTask(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Saving profile: " + this.profileName);
        IOTask iOTask = this.fs.writeDataTask((Serializable)profile, this.profileDir + this.profileFileName).then(new Function<T, IOTask<R>>(this){
            final /* synthetic */ ProfileManager this$0;

            public final IOTask<Void> apply(Void it) {
                return IOTask.ofVoid((String)("checkSavesDir(" + ProfileManager.access$getSaveDir$p(this.this$0) + ')'), (Runnable)new Runnable(this){
                    final /* synthetic */ saveProfileTask.1 this$0;

                    public final void run() {
                        if (!this.this$0.this$0.getFs().exists(ProfileManager.access$getSaveDir$p(this.this$0.this$0))) {
                            ProfileManager.access$createSavesDir(this.this$0.this$0);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = profileManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"fs.writeDataTask(profile\u2026      }\n                }");
        return iOTask;
    }

    private final void createSavesDir() {
        this.log.debug("Creating saves dir");
        this.fs.createDirectoryTask(this.saveDir).then(new Function<T, IOTask<R>>(this){
            final /* synthetic */ ProfileManager this$0;

            public final IOTask<Void> apply(Void it) {
                return this.this$0.getFs().writeDataTask(CollectionsKt.listOf((Object)"This directory contains save files."), ProfileManager.access$getSaveDir$p(this.this$0) + "Readme.txt");
            }
            {
                this.this$0 = profileManager;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ ProfileManager this$0;

            public final void accept(Throwable e) {
                ProfileManager.access$getLog$p(this.this$0).warning("Failed to create saves dir: " + e);
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
            {
                this.this$0 = profileManager;
            }
        }).run();
    }

    @NotNull
    public final IOTask<UserProfile> loadProfileTask() {
        this.log.debug("Loading profile: " + this.profileName);
        return this.fs.readDataTask(this.profileDir + this.profileFileName);
    }

    public final boolean saveFileExists(@NotNull String saveFileName) {
        Intrinsics.checkParameterIsNotNull((Object)saveFileName, (String)"saveFileName");
        this.log.debug("Checking if save file exists: " + saveFileName);
        return this.fs.exists(this.saveDir + saveFileName + this.saveFileExt);
    }

    @NotNull
    public final IOTask<Void> deleteSaveFileTask(@NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        this.log.debug("Deleting save file: " + saveFile.getName());
        IOTask iOTask = this.fs.deleteFileTask(this.saveDir + saveFile.getName() + this.saveFileExt).then(new Function<T, IOTask<R>>(this, saveFile){
            final /* synthetic */ ProfileManager this$0;
            final /* synthetic */ SaveFile $saveFile;

            @NotNull
            public final IOTask<Void> apply(Void it) {
                return this.this$0.getFs().deleteFileTask(ProfileManager.access$getSaveDir$p(this.this$0) + this.$saveFile.getName() + this.this$0.getDataFileExt());
            }
            {
                this.this$0 = profileManager;
                this.$saveFile = saveFile;
            }
        }).then(new Function<T, IOTask<R>>(this, saveFile){
            final /* synthetic */ ProfileManager this$0;
            final /* synthetic */ SaveFile $saveFile;

            public final IOTask<Void> apply(Void it) {
                return IOTask.ofVoid((String)"updateSaves", (Runnable)new Runnable(this){
                    final /* synthetic */ deleteSaveFileTask.2 this$0;

                    public final void run() {
                        Async.INSTANCE.startAsyncFX((Callable)new Callable<Boolean>(this){
                            final /* synthetic */ deleteSaveFileTask.1 this$0;

                            public final boolean call() {
                                return ProfileManager.access$getSaveFiles$p(this.this$0.this$0.this$0).remove((Object)this.this$0.this$0.$saveFile);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = profileManager;
                this.$saveFile = saveFile;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"fs.deleteFileTask(saveDi\u2026es.remove(saveFile) } } }");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> saveTask(@NotNull DataFile dataFile, @NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"dataFile");
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        this.log.debug("Saving data: " + saveFile.getName());
        IOTask iOTask = this.fs.writeDataTask((Serializable)saveFile, this.saveDir + saveFile.getName() + this.saveFileExt).then(new Function<T, IOTask<R>>(this, dataFile, saveFile){
            final /* synthetic */ ProfileManager this$0;
            final /* synthetic */ DataFile $dataFile;
            final /* synthetic */ SaveFile $saveFile;

            public final IOTask<Void> apply(Void it) {
                return this.this$0.getFs().writeDataTask((Serializable)this.$dataFile, ProfileManager.access$getSaveDir$p(this.this$0) + this.$saveFile.getName() + this.this$0.getDataFileExt());
            }
            {
                this.this$0 = profileManager;
                this.$dataFile = dataFile;
                this.$saveFile = saveFile;
            }
        }).then(new Function<T, IOTask<R>>(this, saveFile){
            final /* synthetic */ ProfileManager this$0;
            final /* synthetic */ SaveFile $saveFile;

            public final IOTask<Void> apply(Void it) {
                return IOTask.ofVoid((String)"updateSaves", (Runnable)new Runnable(this){
                    final /* synthetic */ saveTask.2 this$0;

                    public final void run() {
                        Async.INSTANCE.startAsyncFX(new Runnable(this){
                            final /* synthetic */ saveTask.1 this$0;

                            public final void run() {
                                ProfileManager.access$getSaveFiles$p(this.this$0.this$0.this$0).add((Object)this.this$0.this$0.$saveFile);
                                Collections.sort((List)ProfileManager.access$getSaveFiles$p(this.this$0.this$0.this$0), SaveFile.RECENT_FIRST);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = profileManager;
                this.$saveFile = saveFile;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"fs.writeDataTask(saveFil\u2026      }\n                }");
        return iOTask;
    }

    @NotNull
    public final IOTask<DataFile> loadTask(@NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        this.log.debug("Loading data: " + saveFile.getName());
        return this.fs.readDataTask(this.saveDir + saveFile.getName() + this.dataFileExt);
    }

    @NotNull
    public final IOTask<List<SaveFile>> loadSaveFilesTask() {
        this.log.debug("Loading save files");
        IOTask iOTask = this.fs.loadFileNamesTask(this.saveDir, true, CollectionsKt.listOf((Object)new FileExtension(this.saveFileExt))).then(new Function<T, IOTask<R>>(this){
            final /* synthetic */ ProfileManager this$0;

            public final IOTask<List<SaveFile>> apply(List<String> fileNames) {
                return IOTask.of((String)"readSaveFiles", (Callable)new Callable<R>(this, fileNames){
                    final /* synthetic */ loadSaveFilesTask.1 this$0;
                    final /* synthetic */ List $fileNames;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final ArrayList<SaveFile> call() {
                        void var1_1;
                        ArrayList<SaveFile> list = new ArrayList<SaveFile>();
                        for (String name : this.$fileNames) {
                            SaveFile file = (SaveFile)this.this$0.this$0.getFs().readDataTask(ProfileManager.access$getSaveDir$p(this.this$0.this$0) + name).run();
                            if (file == null) continue;
                            list.add(file);
                        }
                        return var1_1;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fileNames = list;
                    }
                });
            }
            {
                this.this$0 = profileManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"fs.loadFileNamesTask(sav\u2026      }\n                }");
        return iOTask;
    }

    @NotNull
    public final IOTask<SaveFile> loadLastModifiedSaveFileTask() {
        this.log.debug("Loading last modified save file");
        IOTask iOTask = this.loadSaveFilesTask().then((Function)loadLastModifiedSaveFileTask.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"loadSaveFilesTask().then\u2026]\n            }\n        }");
        return iOTask;
    }

    public final void querySaveFiles() {
        this.log.debug("Querying save files");
        this.loadSaveFilesTask().onSuccess((Consumer)new Consumer<List<? extends SaveFile>>(this){
            final /* synthetic */ ProfileManager this$0;

            public final void accept(List<SaveFile> files) {
                ProfileManager.access$getSaveFiles$p(this.this$0).setAll((Collection)files);
                Collections.sort((List)ProfileManager.access$getSaveFiles$p(this.this$0), SaveFile.RECENT_FIRST);
            }
            {
                this.this$0 = profileManager;
            }
        }).runAsyncFXWithDialog((IOTask.UIDialogHandler)new ProgressDialog(FXGL.Companion.localize("menu.loadingSaveFiles")));
    }

    @NotNull
    public final FS getFs() {
        return this.fs;
    }

    @NotNull
    public final String getProfileName() {
        return this.profileName;
    }

    @NotNull
    public final String getProfilesDirName() {
        return this.profilesDirName;
    }

    @NotNull
    public final String getProfileFileName() {
        return this.profileFileName;
    }

    @NotNull
    public final String getSavesDirName() {
        return this.savesDirName;
    }

    @NotNull
    public final String getSaveFileExt() {
        return this.saveFileExt;
    }

    @NotNull
    public final String getDataFileExt() {
        return this.dataFileExt;
    }

    /*
     * WARNING - void declaration
     */
    public ProfileManager(@NotNull FS fs2, @NotNull String profileName, @NotNull String profilesDirName, @NotNull String profileFileName, @NotNull String savesDirName, @NotNull String saveFileExt, @NotNull String dataFileExt) {
        void this_$iv;
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)fs2, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)profileName, (String)"profileName");
        Intrinsics.checkParameterIsNotNull((Object)profilesDirName, (String)"profilesDirName");
        Intrinsics.checkParameterIsNotNull((Object)profileFileName, (String)"profileFileName");
        Intrinsics.checkParameterIsNotNull((Object)savesDirName, (String)"savesDirName");
        Intrinsics.checkParameterIsNotNull((Object)saveFileExt, (String)"saveFileExt");
        Intrinsics.checkParameterIsNotNull((Object)dataFileExt, (String)"dataFileExt");
        this.fs = fs2;
        this.profileName = profileName;
        this.profilesDirName = profilesDirName;
        this.profileFileName = profileFileName;
        this.savesDirName = savesDirName;
        this.saveFileExt = saveFileExt;
        this.dataFileExt = dataFileExt;
        Logger.Companion companion = Logger.Companion;
        ProfileManager profileManager = this;
        boolean $i$f$get = false;
        profileManager.log = logger = this_$iv.get(ProfileManager.class);
        this.profileDir = "./" + this.profilesDirName + this.profileName + '/';
        this.saveDir = this.profileDir + this.savesDirName;
        this.saveFiles = FXCollections.observableArrayList();
    }

    public static final /* synthetic */ String access$getSaveDir$p(ProfileManager $this) {
        return $this.saveDir;
    }

    public static final /* synthetic */ void access$createSavesDir(ProfileManager $this) {
        $this.createSavesDir();
    }

    public static final /* synthetic */ Logger access$getLog$p(ProfileManager $this) {
        return $this.log;
    }

    public static final /* synthetic */ ObservableList access$getSaveFiles$p(ProfileManager $this) {
        return $this.saveFiles;
    }
}

