/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AssetLoader;
import com.almasb.fxgl.app.DialogSubState;
import com.almasb.fxgl.app.Engine;
import com.almasb.fxgl.app.FXGLScene;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.GameController;
import com.almasb.fxgl.app.GameScene;
import com.almasb.fxgl.app.LoadingScene;
import com.almasb.fxgl.app.LoopRunner;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.PauseMenu;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SceneFactory;
import com.almasb.fxgl.app.StartupScene;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.Function;
import com.almasb.fxgl.dev.DevPane;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.localization.Language;
import com.almasb.fxgl.localization.LocalizationService;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.saving.LoadEvent;
import com.almasb.fxgl.saving.SaveEvent;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.SceneListener;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.Display;
import com.almasb.fxgl.ui.ErrorDialog;
import com.almasb.fxgl.ui.FXGLUIConfig;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactory;
import com.almasb.sslogger.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0003\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020lH\u0002J\u000e\u0010m\u001a\u00020j2\u0006\u0010n\u001a\u00020_J\b\u0010o\u001a\u00020@H\u0002J\b\u0010p\u001a\u00020\u0018H\u0002J\b\u0010q\u001a\u00020jH\u0002J\u0010\u0010r\u001a\u00020j2\u0006\u0010s\u001a\u00020+H\u0002J\b\u0010t\u001a\u00020jH\u0016J\b\u0010u\u001a\u00020jH\u0002J(\u0010v\u001a\u0002Hw\"\n\b\u0000\u0010w\u0018\u0001*\u00020_2\f\u0010x\u001a\b\u0012\u0004\u0012\u0002Hw0bH\u0086\b\u00a2\u0006\u0002\u0010yJ\b\u0010z\u001a\u00020jH\u0016J\b\u0010{\u001a\u00020jH\u0016J\b\u0010|\u001a\u00020jH\u0016J\b\u0010}\u001a\u00020jH\u0016J\u0011\u0010~\u001a\u00020j2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J\t\u0010\u0081\u0001\u001a\u00020jH\u0002J\t\u0010\u0082\u0001\u001a\u00020jH\u0002J\t\u0010\u0083\u0001\u001a\u00020jH\u0002J\t\u0010\u0084\u0001\u001a\u00020jH\u0002J\t\u0010\u0085\u0001\u001a\u00020jH\u0002J\t\u0010\u0086\u0001\u001a\u00020jH\u0002J\t\u0010\u0087\u0001\u001a\u00020jH\u0002J\t\u0010\u0088\u0001\u001a\u00020jH\u0002J\t\u0010\u0089\u0001\u001a\u00020jH\u0002J\t\u0010\u008a\u0001\u001a\u00020jH\u0002J\t\u0010\u008b\u0001\u001a\u00020jH\u0002J\t\u0010\u008c\u0001\u001a\u00020jH\u0002J\u0012\u0010\u008d\u0001\u001a\u00020@2\u0007\u0010\u008e\u0001\u001a\u00020\u0018H\u0016J\u0013\u0010\u008f\u0001\u001a\u00020j2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0016J\t\u0010\u0092\u0001\u001a\u00020jH\u0016J\t\u0010\u0093\u0001\u001a\u00020jH\u0002J\t\u0010\u0094\u0001\u001a\u00020jH\u0002J\u0010\u0010L\u001a\u00020j2\u0006\u0010e\u001a\u00020fH\u0002J\u0013\u0010\u0095\u0001\u001a\u00020j2\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0016J\t\u0010\u0098\u0001\u001a\u00020jH\u0016J\t\u0010\u0099\u0001\u001a\u00020jH\u0002J\n\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0016J\u0013\u0010\u009c\u0001\u001a\u00020j2\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001H\u0016J\u0011\u0010\u009f\u0001\u001a\u00020j2\u0006\u0010k\u001a\u00020lH\u0002J\t\u0010\u00a0\u0001\u001a\u00020jH\u0016J\t\u0010\u00a1\u0001\u001a\u00020jH\u0002J\u0012\u0010\u00a2\u0001\u001a\u00020j2\u0007\u0010\u00a3\u0001\u001a\u00020+H\u0016J\t\u0010\u00a4\u0001\u001a\u00020jH\u0016J\t\u0010\u00a5\u0001\u001a\u00020@H\u0016J\t\u0010\u00a6\u0001\u001a\u00020jH\u0002J\t\u0010\u00a7\u0001\u001a\u00020jH\u0002J\u0013\u0010\u00a8\u0001\u001a\u00020j2\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001H\u0002J\u0007\u0010\u00ab\u0001\u001a\u00020jJ\t\u0010\u00ac\u0001\u001a\u00020jH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0010\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R*\u0010)\u001a\u001e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*j\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,`-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010.\u001a\u00020/8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0010\u001a\u0004\b0\u00101R\u001b\u00103\u001a\u0002048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\u0010\u001a\u0004\b5\u00106R\u001b\u00108\u001a\u0002098@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010\u0010\u001a\u0004\b:\u0010;R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010E\u001a\u00020F8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010\u0010\u001a\u0004\bG\u0010HR\u000e\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020MX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u0004\u0018\u00010TX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010U\u001a\u00020VX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u000e\u0010[\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010]\u001a\u0012\u0012\u0004\u0012\u00020_0^j\b\u0012\u0004\u0012\u00020_``X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010a\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020_0b\u0012\u0004\u0012\u00020_0*j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020_0b\u0012\u0004\u0012\u00020_`-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010e\u001a\u00020f8F\u00a2\u0006\u0006\u001a\u0004\bg\u0010h\u00a8\u0006\u00ad\u0001"}, d2={"Lcom/almasb/fxgl/app/Engine;", "Lcom/almasb/fxgl/app/GameController;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "stage", "Ljavafx/stage/Stage;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;Ljavafx/stage/Stage;)V", "getApp$fxgl", "()Lcom/almasb/fxgl/app/GameApplication;", "assetLoader", "Lcom/almasb/fxgl/app/AssetLoader;", "getAssetLoader$fxgl", "()Lcom/almasb/fxgl/app/AssetLoader;", "assetLoader$delegate", "Lkotlin/Lazy;", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "getBundle$fxgl", "()Lcom/almasb/fxgl/core/serialization/Bundle;", "setBundle$fxgl", "(Lcom/almasb/fxgl/core/serialization/Bundle;)V", "defaultProfile", "Lcom/almasb/fxgl/saving/UserProfile;", "devPane", "Lcom/almasb/fxgl/dev/DevPane;", "getDevPane$fxgl", "()Lcom/almasb/fxgl/dev/DevPane;", "devPane$delegate", "dialogScene", "Lcom/almasb/fxgl/app/DialogSubState;", "display", "Lcom/almasb/fxgl/ui/Display;", "getDisplay$fxgl", "()Lcom/almasb/fxgl/ui/Display;", "display$delegate", "engineTimer", "Lcom/almasb/fxgl/time/Timer;", "getEngineTimer$fxgl", "()Lcom/almasb/fxgl/time/Timer;", "environmentVars", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "getEventBus$fxgl", "()Lcom/almasb/fxgl/event/EventBus;", "eventBus$delegate", "executor", "Lcom/almasb/fxgl/core/concurrent/Async;", "getExecutor$fxgl", "()Lcom/almasb/fxgl/core/concurrent/Async;", "executor$delegate", "fs", "Lcom/almasb/fxgl/io/FS;", "getFs$fxgl", "()Lcom/almasb/fxgl/io/FS;", "fs$delegate", "gameMenu", "Lcom/almasb/fxgl/app/FXGLScene;", "handledOnce", "", "intro", "isFirstRun", "loadScene", "Lcom/almasb/fxgl/app/LoadingScene;", "local", "Lcom/almasb/fxgl/localization/LocalizationService;", "getLocal$fxgl", "()Lcom/almasb/fxgl/localization/LocalizationService;", "local$delegate", "log", "Lcom/almasb/sslogger/Logger;", "loop", "Lcom/almasb/fxgl/app/LoopRunner;", "mainMenu", "mainWindow", "Lcom/almasb/fxgl/app/MainWindow;", "overlayRoot", "Ljavafx/scene/Group;", "pauseMenu", "Lcom/almasb/fxgl/app/PauseMenu;", "playScene", "Lcom/almasb/fxgl/app/GameScene;", "getPlayScene$fxgl", "()Lcom/almasb/fxgl/app/GameScene;", "setPlayScene$fxgl", "(Lcom/almasb/fxgl/app/GameScene;)V", "profileName", "Ljavafx/beans/property/SimpleStringProperty;", "services", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/core/EngineService;", "Lkotlin/collections/ArrayList;", "servicesCache", "Ljava/lang/Class;", "getSettings$fxgl", "()Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "tpf", "", "getTpf", "()D", "addOverlay", "", "scene", "Lcom/almasb/fxgl/scene/Scene;", "addService", "engineService", "canShowCloseDialog", "createProfile", "createRequiredDirs", "doSave", "saveFileName", "exit", "generateDefaultProfile", "getService", "T", "serviceClass", "(Ljava/lang/Class;)Lcom/almasb/fxgl/core/EngineService;", "gotoGameMenu", "gotoIntro", "gotoMainMenu", "gotoPlay", "handleFatalError", "e", "", "initAndLoadLocalization", "initAndRegisterFontFactories", "initAndSetUIFactory", "initAndShowMainWindow", "initAppScenes", "initEngine", "initEnvironmentVars", "initEventHandlers", "initFatalExceptionHandler", "initPauseResumeListener", "injectDependenciesIntoServices", "loadDefaultSystemData", "loadFromProfile", "profile", "loadGame", "saveFile", "Lcom/almasb/fxgl/saving/SaveFile;", "loadGameFromLastSave", "loadSystemData", "logVersion", "onGameReady", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "popSubScene", "prepareToStartLoop", "profileNameProperty", "Ljavafx/beans/property/StringProperty;", "pushSubScene", "subScene", "Lcom/almasb/fxgl/scene/SubScene;", "removeOverlay", "restoreDefaultProfileSettings", "runPreInit", "saveGame", "fileName", "saveProfile", "saveScreenshot", "saveSystemData", "showConfirmExitDialog", "startLoadedGame", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "startLoop", "startNewGame", "fxgl"})
public final class Engine
implements GameController {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Logger log;
    private boolean isFirstRun;
    @NotNull
    public Bundle bundle;
    private MainWindow mainWindow;
    @NotNull
    public GameScene playScene;
    private LoadingScene loadScene;
    private DialogSubState dialogScene;
    private FXGLScene intro;
    private FXGLScene mainMenu;
    private FXGLScene gameMenu;
    private PauseMenu pauseMenu;
    private final LoopRunner loop;
    private final ArrayList<EngineService> services;
    private final HashMap<Class<? extends EngineService>, EngineService> servicesCache;
    @NotNull
    private final Lazy assetLoader$delegate;
    @NotNull
    private final Lazy eventBus$delegate;
    @NotNull
    private final Lazy display$delegate;
    @NotNull
    private final Lazy executor$delegate;
    @NotNull
    private final Lazy fs$delegate;
    @NotNull
    private final Lazy local$delegate;
    @NotNull
    private final Lazy devPane$delegate;
    @NotNull
    private final Timer engineTimer;
    private final Group overlayRoot;
    private final SimpleStringProperty profileName;
    private UserProfile defaultProfile;
    private final HashMap<String, Object> environmentVars;
    private boolean handledOnce;
    @NotNull
    private final GameApplication app;
    @NotNull
    private final ReadOnlyGameSettings settings;
    private final Stage stage;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "assetLoader", "getAssetLoader$fxgl()Lcom/almasb/fxgl/app/AssetLoader;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "eventBus", "getEventBus$fxgl()Lcom/almasb/fxgl/event/EventBus;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "display", "getDisplay$fxgl()Lcom/almasb/fxgl/ui/Display;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "executor", "getExecutor$fxgl()Lcom/almasb/fxgl/core/concurrent/Async;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "fs", "getFs$fxgl()Lcom/almasb/fxgl/io/FS;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "local", "getLocal$fxgl()Lcom/almasb/fxgl/localization/LocalizationService;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "devPane", "getDevPane$fxgl()Lcom/almasb/fxgl/dev/DevPane;"))};
    }

    @NotNull
    public final Bundle getBundle$fxgl() {
        Bundle bundle = this.bundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        return bundle;
    }

    public final void setBundle$fxgl(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"<set-?>");
        this.bundle = bundle;
    }

    @NotNull
    public final GameScene getPlayScene$fxgl() {
        GameScene gameScene = this.playScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playScene");
        }
        return gameScene;
    }

    public final void setPlayScene$fxgl(@NotNull GameScene gameScene) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)gameScene), (String)"<set-?>");
        this.playScene = gameScene;
    }

    public final double getTpf() {
        return this.loop.tpf();
    }

    public final void addService(@NotNull EngineService engineService) {
        Intrinsics.checkParameterIsNotNull((Object)engineService, (String)"engineService");
        this.log.debug("Adding new engine service: " + engineService.getClass());
        Collection collection = this.services;
        boolean bl = false;
        collection.add(engineService);
    }

    @NotNull
    public final /* synthetic */ <T extends EngineService> T getService(@NotNull Class<T> serviceClass) {
        Object object;
        block7: {
            block6: {
                Object v1;
                boolean bl;
                Iterable iterable;
                block5: {
                    int $i$f$getService = 0;
                    Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
                    if (this.servicesCache.containsKey(serviceClass)) {
                        Object v = this.servicesCache.get(serviceClass);
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                        return (T)((EngineService)v);
                    }
                    iterable = this.services;
                    bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        EngineService it = (EngineService)t;
                        boolean bl3 = false;
                        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                        if (!(it instanceof EngineService)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                if ((object = (EngineService)v1) == null) break block6;
                iterable = object;
                bl = false;
                boolean bl4 = false;
                Iterable it = iterable;
                boolean bl5 = false;
                this.servicesCache.put(serviceClass, it);
                object = iterable;
                if (object != null) break block7;
            }
            throw (Throwable)new IllegalArgumentException("Engine does not have service: " + serviceClass);
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)object;
    }

    @NotNull
    public final AssetLoader getAssetLoader$fxgl() {
        Lazy lazy = this.assetLoader$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (AssetLoader)lazy.getValue();
    }

    @NotNull
    public final EventBus getEventBus$fxgl() {
        Lazy lazy = this.eventBus$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (EventBus)lazy.getValue();
    }

    @NotNull
    public final Display getDisplay$fxgl() {
        Lazy lazy = this.display$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return (Display)lazy.getValue();
    }

    @NotNull
    public final Async getExecutor$fxgl() {
        Lazy lazy = this.executor$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[3];
        boolean bl = false;
        return (Async)lazy.getValue();
    }

    @NotNull
    public final FS getFs$fxgl() {
        Lazy lazy = this.fs$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[4];
        boolean bl = false;
        return (FS)lazy.getValue();
    }

    @NotNull
    public final LocalizationService getLocal$fxgl() {
        Lazy lazy = this.local$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[5];
        boolean bl = false;
        return (LocalizationService)lazy.getValue();
    }

    @NotNull
    public final DevPane getDevPane$fxgl() {
        Lazy lazy = this.devPane$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[6];
        boolean bl = false;
        return (DevPane)lazy.getValue();
    }

    @NotNull
    public final Timer getEngineTimer$fxgl() {
        return this.engineTimer;
    }

    private final void logVersion() {
        String jVersion = System.getProperty("java.version", "?");
        String fxVersion = System.getProperty("javafx.version", "?");
        String version = this.settings.getRuntimeInfo().getVersion();
        String build2 = this.settings.getRuntimeInfo().getBuild();
        this.log.info("FXGL-" + version + " (" + build2 + ") on " + this.settings.getPlatform() + " (J:" + jVersion + " FX:" + fxVersion + ')');
        this.log.info("Source code and latest versions at: https://github.com/AlmasB/FXGL");
        this.log.info("             Join the FXGL chat at: https://gitter.im/AlmasB/FXGL");
    }

    /*
     * Unable to fully structure code
     */
    private final void initEnvironmentVars() {
        this.log.debug("Initializing environment variables");
        ((Map)this.environmentVars).put("overlayRoot", this.overlayRoot);
        ((Map)this.environmentVars).put("masterTimer", this.engineTimer);
        ((Map)this.environmentVars).put("eventBus", this.getEventBus$fxgl());
        ((Map)this.environmentVars).put("sceneStack", this);
        v0 = this.settings.getClass().getDeclaredMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"settings.javaClass.declaredMethods");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var6_9 = $this$filterTo$iv$iv;
        var7_11 = ((void)var6_9).length;
        for (var8_13 = 0; var8_13 < var7_11; ++var8_13) {
            it = element$iv$iv = var6_9[var8_13];
            $i$a$-filter-Engine$initEnvironmentVars$1 = false;
            v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            v2 = v1.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it.name");
            if (StringsKt.startsWith$default((String)v2, (String)"is", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v3 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it.name");
            if (StringsKt.startsWith$default((String)v3, (String)"get", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v4 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it.name");
            if (StringsKt.endsWith$default((String)v4, (String)"Property", (boolean)false, (int)2, null)) lbl-1000:
            // 3 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        var3_3 = $this$forEach$iv.iterator();
        while (var3_3.hasNext()) {
            element$iv = var3_3.next();
            it = (Method)element$iv;
            $i$a$-forEach-Engine$initEnvironmentVars$2 = false;
            v6 = this.environmentVars;
            v7 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
            v8 = v7.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it.name");
            v9 = StringsKt.decapitalize((String)StringsKt.removePrefix((String)v8, (CharSequence)"get"));
            v10 = it.invoke((Object)this.settings, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it.invoke(settings)");
            v6.put(v9, v10);
        }
        this.log.debug("Logging environment variables");
        $this$forEach$iv = this.environmentVars;
        $i$f$forEach = false;
        var3_3 = $this$forEach$iv;
        var4_5 = false;
        var5_8 = var3_3.entrySet().iterator();
        while (var5_8.hasNext()) {
            $dstr$key$value = element$iv = var5_8.next();
            $i$a$-forEach-Engine$initEnvironmentVars$3 = false;
            var9_14 = $dstr$key$value;
            var10_16 = false;
            key = (String)var9_14.getKey();
            var9_14 = $dstr$key$value;
            var10_16 = false;
            value = var9_14.getValue();
            this.log.debug(key + ": " + value);
        }
    }

    public final void startLoop() {
        long start = System.nanoTime();
        this.initAndLoadLocalization();
        this.initAndRegisterFontFactories();
        this.initAndSetUIFactory();
        this.initAndShowMainWindow();
        this.initFatalExceptionHandler();
        this.getExecutor$fxgl().startAsync(new Runnable(this, start){
            final /* synthetic */ Engine this$0;
            final /* synthetic */ long $start;

            public final void run() {
                Engine.access$initEngine(this.this$0);
                this.this$0.getExecutor$fxgl().startAsyncFX(new Runnable(this){
                    final /* synthetic */ startLoop.1 this$0;

                    public final void run() {
                        Engine.access$prepareToStartLoop(this.this$0.this$0);
                        Engine.access$getLog$p(this.this$0.this$0).infof("FXGL initialization took: %.3f sec", new Object[]{(double)(System.nanoTime() - this.this$0.$start) / 1.0E9});
                        Engine.access$getLoop$p(this.this$0.this$0).start();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = engine;
                this.$start = l;
            }
        });
    }

    private final void initAndLoadLocalization() {
        this.log.debug("Loading localizations");
        Iterable $this$forEach$iv = Language.Companion.getBuiltInLanguages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Language it = (Language)element$iv;
            boolean bl = false;
            String string2 = it.getName();
            StringBuilder stringBuilder = new StringBuilder().append("languages/");
            AssetLoader assetLoader2 = this.getAssetLoader$fxgl();
            Language language = it;
            LocalizationService localizationService = this.getLocal$fxgl();
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            localizationService.addLanguageData(language, assetLoader2.loadResourceBundle(stringBuilder.append(string).append(".properties").toString()));
        }
        this.getLocal$fxgl().selectedLanguageProperty().bind((ObservableValue)this.settings.getLanguage());
    }

    private final void initAndRegisterFontFactories() {
        this.log.debug("Registering font factories");
        this.settings.getUIFactory().registerFontFactory(FontType.UI, this.getAssetLoader$fxgl().loadFont(this.settings.getFontUI()));
        this.settings.getUIFactory().registerFontFactory(FontType.GAME, this.getAssetLoader$fxgl().loadFont(this.settings.getFontGame()));
        this.settings.getUIFactory().registerFontFactory(FontType.MONO, this.getAssetLoader$fxgl().loadFont(this.settings.getFontMono()));
        this.settings.getUIFactory().registerFontFactory(FontType.TEXT, this.getAssetLoader$fxgl().loadFont(this.settings.getFontText()));
    }

    private final void initAndSetUIFactory() {
        this.log.debug("Setting UI factory");
        FXGLUIConfig.setUIFactory((UIFactory)this.settings.getUIFactory());
        FXGLUIConfig.setLocalizationService((LocalizationService)this.getLocal$fxgl());
    }

    private final void initAndShowMainWindow() {
        StartupScene startupScene = this.settings.getSceneFactory().newStartup();
        this.addOverlay(startupScene);
        MainWindow mainWindow = this.mainWindow = new MainWindow(this.stage, startupScene, this.settings);
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.addIcons(this.getAssetLoader$fxgl().loadImage(this.settings.getAppIcon()));
        Iterable $this$forEach$iv = this.settings.getCSSList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.log.debug("Applying CSS: " + it);
            MainWindow mainWindow2 = this.mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            mainWindow2.addCSS(this.getAssetLoader$fxgl().loadCSS(it));
        }
        MainWindow mainWindow3 = this.mainWindow;
        if (mainWindow3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow3.setDefaultCursor(new ImageCursor(this.getAssetLoader$fxgl().loadCursorImage("fxgl_default.png"), 7.0, 6.0));
        MainWindow mainWindow4 = this.mainWindow;
        if (mainWindow4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow4.show();
        MainWindow mainWindow5 = this.mainWindow;
        if (mainWindow5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow5.setOnClose((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ Engine this$0;

            public final void invoke() {
                if (this.this$0.getSettings$fxgl().isCloseConfirmation()) {
                    if (Engine.access$canShowCloseDialog(this.this$0)) {
                        Engine.access$showConfirmExitDialog(this.this$0);
                    }
                } else {
                    this.this$0.exit();
                }
            }
            {
                this.this$0 = engine;
                super(0);
            }
        }));
        MainWindow mainWindow6 = this.mainWindow;
        if (mainWindow6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow6.getCurrentSceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(this){
            final /* synthetic */ Engine this$0;

            public final void changed(ObservableValue<? extends Scene> $noName_0, Scene oldScene, Scene newScene) {
                Engine.access$getLog$p(this.this$0).debug("Removing overlay from " + oldScene + " and adding to " + newScene);
                Scene scene = oldScene;
                Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"oldScene");
                Engine.access$removeOverlay(this.this$0, scene);
                Scene scene2 = newScene;
                Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"newScene");
                Engine.access$addOverlay(this.this$0, scene2);
            }
            {
                this.this$0 = engine;
            }
        });
    }

    private final void addOverlay(Scene scene) {
        Collection collection = (Collection)scene.getRoot().getChildren();
        Group group = this.overlayRoot;
        boolean bl = false;
        collection.add(group);
    }

    private final void removeOverlay(Scene scene) {
        Collection collection = (Collection)scene.getRoot().getChildren();
        Group group = this.overlayRoot;
        boolean bl = false;
        collection.remove(group);
    }

    private final void initFatalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
            final /* synthetic */ Engine this$0;

            public final void uncaughtException(Thread $noName_0, Throwable error) {
                Throwable throwable = error;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"error");
                Engine.access$handleFatalError(this.this$0, throwable);
            }
            {
                this.this$0 = engine;
            }
        });
    }

    private final void initEngine() {
        IOTask.setDefaultExecutor((Executor)((Executor)this.getExecutor$fxgl()));
        IOTask.setDefaultFailAction((Consumer)((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable it) {
                this.this$0.getDisplay$fxgl().showErrorBox(it);
            }
            {
                this.this$0 = engine;
            }
        }));
        boolean bl = this.isFirstRun = !this.getFs$fxgl().exists("system/");
        if (!this.settings.isExperimentalNative()) {
            if (this.isFirstRun) {
                this.createRequiredDirs();
                this.loadDefaultSystemData();
            } else {
                this.loadSystemData();
            }
        } else {
            this.loadDefaultSystemData();
        }
        this.initAppScenes();
        this.initPauseResumeListener();
        this.initEventHandlers();
    }

    private final void prepareToStartLoop() {
        this.runPreInit();
        this.injectDependenciesIntoServices();
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onMainLoopStarting();
        }
        this.app.onPreInit();
    }

    private final void createRequiredDirs() {
        this.getFs$fxgl().createDirectoryTask("system/").then(new Function<T, IOTask<R>>(this){
            final /* synthetic */ Engine this$0;

            public final IOTask<Void> apply(Void it) {
                return this.this$0.getFs$fxgl().writeDataTask(CollectionsKt.listOf((Object)"This directory contains FXGL system data files."), "system/Readme.txt");
            }
            {
                this.this$0 = engine;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable e) {
                Engine.access$getLog$p(this.this$0).warning("Failed to create system dir: " + e);
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void saveSystemData() {
        this.log.debug("Saving FXGL system data");
        FS fS = this.getFs$fxgl();
        Bundle bundle = this.bundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        fS.writeDataTask((Serializable)bundle, "system/fxgl.bundle").onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable it) {
                Engine.access$getLog$p(this.this$0).warning("Failed to save: " + it);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void loadSystemData() {
        this.log.debug("Loading FXGL system data");
        this.getFs$fxgl().readDataTask("system/fxgl.bundle").onSuccess((Consumer)new Consumer<Bundle>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Bundle it) {
                Bundle bundle = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"it");
                this.this$0.setBundle$fxgl(bundle);
                Engine.access$getLog$p(this.this$0).debug(String.valueOf(this.this$0.getBundle$fxgl()));
            }
            {
                this.this$0 = engine;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable it) {
                Engine.access$getLog$p(this.this$0).warning("Failed to load: " + it);
                Engine.access$loadDefaultSystemData(this.this$0);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void loadDefaultSystemData() {
        this.log.debug("Loading default FXGL system data");
        this.bundle = new Bundle("FXGL");
    }

    private final void initAppScenes() {
        this.log.debug("Initializing application scenes");
        SceneFactory sceneFactory = this.settings.getSceneFactory();
        this.loadScene = sceneFactory.newLoadingScene();
        GameScene gameScene = this.playScene = new GameScene(this.settings.getWidth(), this.settings.getHeight(), new GameState(), new GameWorld(), new PhysicsWorld(this.settings.getHeight(), this.settings.getPixelsPerMeter()));
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playScene");
        }
        gameScene.setSingleStep(this.settings.isSingleStep());
        GameScene gameScene2 = this.playScene;
        if (gameScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playScene");
        }
        gameScene2.addListener(new SceneListener(this){
            final /* synthetic */ Engine this$0;

            public void onUpdate(double tpf) {
                this.this$0.getApp$fxgl().onUpdate(tpf);
            }
            {
                this.this$0 = $outer;
            }
        });
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        this.dialogScene = new DialogSubState((ReadOnlyObjectProperty<FXGLScene>)((ReadOnlyObjectProperty)mainWindow.getCurrentFXGLSceneProperty()));
        if (this.settings.isIntroEnabled()) {
            this.intro = sceneFactory.newIntro();
        }
        if (this.settings.isMenuEnabled()) {
            this.mainMenu = sceneFactory.newMainMenu();
            this.gameMenu = sceneFactory.newGameMenu();
        }
        if (this.settings.isMenuEnabled()) {
            EventHandler<KeyEvent> menuKeyHandler2 = new EventHandler<KeyEvent>(this){
                private boolean canSwitchGameMenu;
                final /* synthetic */ Engine this$0;

                private final void onMenuKey(boolean pressed) {
                    if (!pressed) {
                        this.canSwitchGameMenu = true;
                        return;
                    }
                    if (this.canSwitchGameMenu) {
                        if (Engine.access$getMainWindow$p(this.this$0).getCurrentScene() == Engine.access$getGameMenu$p(this.this$0)) {
                            this.canSwitchGameMenu = false;
                            this.this$0.gotoPlay();
                        } else if (Engine.access$getMainWindow$p(this.this$0).getCurrentScene() == this.this$0.getPlayScene$fxgl()) {
                            this.canSwitchGameMenu = false;
                            this.this$0.gotoGameMenu();
                        }
                    }
                }

                public void handle(@NotNull KeyEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    if (event.getCode() == this.this$0.getSettings$fxgl().getMenuKey()) {
                        this.onMenuKey(Intrinsics.areEqual((Object)event.getEventType(), (Object)KeyEvent.KEY_PRESSED));
                    }
                }
                {
                    this.this$0 = $outer;
                    this.canSwitchGameMenu = true;
                }
            };
            GameScene gameScene3 = this.playScene;
            if (gameScene3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playScene");
            }
            Input input = gameScene3.getInput();
            EventType eventType = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"KeyEvent.ANY");
            input.addEventHandler(eventType, (EventHandler)menuKeyHandler2);
            FXGLScene fXGLScene = this.gameMenu;
            if (fXGLScene == null) {
                Intrinsics.throwNpe();
            }
            Input input2 = fXGLScene.getInput();
            EventType eventType2 = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType2, (String)"KeyEvent.ANY");
            input2.addEventHandler(eventType2, (EventHandler)menuKeyHandler2);
        } else {
            this.pauseMenu = sceneFactory.newPauseMenu();
            GameScene gameScene4 = this.playScene;
            if (gameScene4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playScene");
            }
            Input.addAction$default((Input)gameScene4.getInput(), (UserAction)new UserAction(this, "Pause"){
                final /* synthetic */ Engine this$0;

                protected void onActionBegin() {
                    PauseMenu pauseMenu = Engine.access$getPauseMenu$p(this.this$0);
                    if (pauseMenu == null) {
                        Intrinsics.throwNpe();
                    }
                    pauseMenu.requestShow$fxgl((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ initAppScenes.2 this$0;

                        public final void invoke() {
                            MainWindow mainWindow = Engine.access$getMainWindow$p(this.this$0.this$0);
                            PauseMenu pauseMenu = Engine.access$getPauseMenu$p(this.this$0.this$0);
                            if (pauseMenu == null) {
                                Intrinsics.throwNpe();
                            }
                            mainWindow.pushState(pauseMenu);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }

                protected void onActionEnd() {
                    PauseMenu pauseMenu = Engine.access$getPauseMenu$p(this.this$0);
                    if (pauseMenu == null) {
                        Intrinsics.throwNpe();
                    }
                    pauseMenu.unlockSwitch$fxgl();
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            }, (KeyCode)this.settings.getMenuKey(), null, (int)4, null);
        }
        this.log.debug("Application scenes initialized");
    }

    private final void initPauseResumeListener() {
        if (!this.settings.isMobile()) {
            this.stage.iconifiedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(this){
                final /* synthetic */ Engine this$0;

                public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean isMinimized) {
                    Boolean bl = isMinimized;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isMinimized");
                    if (bl.booleanValue()) {
                        Engine.access$getLoop$p(this.this$0).pause();
                    } else {
                        Engine.access$getLoop$p(this.this$0).resume();
                    }
                }
                {
                    this.this$0 = engine;
                }
            });
        }
    }

    private final void initEventHandlers() {
        EventBus eventBus2 = this.getEventBus$fxgl();
        EventType<SaveEvent> eventType = SaveEvent.ANY;
        Intrinsics.checkExpressionValueIsNotNull(eventType, (String)"SaveEvent.ANY");
        eventBus2.addEventHandler(eventType, (EventHandler)new EventHandler<SaveEvent>(this){
            final /* synthetic */ Engine this$0;

            public final void handle(SaveEvent e) {
                ReadOnlyGameSettings readOnlyGameSettings = this.this$0.getSettings$fxgl();
                SaveEvent saveEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)saveEvent), (String)"e");
                UserProfile userProfile = saveEvent.getProfile();
                Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"e.profile");
                readOnlyGameSettings.save(userProfile);
            }
            {
                this.this$0 = engine;
            }
        });
        EventBus eventBus3 = this.getEventBus$fxgl();
        EventType<LoadEvent> eventType2 = LoadEvent.ANY;
        Intrinsics.checkExpressionValueIsNotNull(eventType2, (String)"LoadEvent.ANY");
        eventBus3.addEventHandler(eventType2, (EventHandler)new EventHandler<LoadEvent>(this){
            final /* synthetic */ Engine this$0;

            public final void handle(LoadEvent e) {
                ReadOnlyGameSettings readOnlyGameSettings = this.this$0.getSettings$fxgl();
                LoadEvent loadEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)loadEvent), (String)"e");
                UserProfile userProfile = loadEvent.getProfile();
                Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"e.profile");
                readOnlyGameSettings.load(userProfile);
            }
            {
                this.this$0 = engine;
            }
        });
    }

    private final void runPreInit() {
        this.log.debug("Running preInit()");
        this.app.initInput();
        GameScene gameScene = this.playScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playScene");
        }
        SystemActions.INSTANCE.bind(gameScene.getInput());
        this.generateDefaultProfile();
    }

    private final void generateDefaultProfile() {
        this.log.debug("generateDefaultProfile()");
        this.defaultProfile = this.createProfile();
    }

    private final void injectDependenciesIntoServices() {
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService service = (EngineService)element$iv;
            boolean bl = false;
            Array array = ReflectionUtils.findFieldsByAnnotation((Object)service, Inject.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)array, (String)"findFieldsByAnnotation(s\u2026vice, Inject::class.java)");
            Iterable $this$forEach$iv2 = (Iterable)array;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                String injectKey = field.getDeclaredAnnotation(Inject.class).value();
                Map map = this.environmentVars;
                boolean bl3 = false;
                Map map2 = map;
                boolean bl4 = false;
                if (!map2.containsKey(injectKey)) {
                    throw (Throwable)new IllegalArgumentException("Cannot inject @Inject(" + injectKey + "). No value present for " + injectKey);
                }
                ReflectionUtils.inject((Field)field, (Object)service, (Object)this.environmentVars.get(injectKey));
            }
        }
    }

    private final void loop(double tpf) {
        this.engineTimer.update(tpf);
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.onUpdate(tpf);
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onUpdate(tpf);
        }
    }

    private final void handleFatalError(Throwable e) {
        Exception error;
        if (this.handledOnce) {
            return;
        }
        this.handledOnce = true;
        Exception exception = error = e instanceof Exception ? (Exception)e : (Exception)new RuntimeException(e);
        if (Logger.Companion.isConfigured()) {
            this.log.fatal("Uncaught Exception:", (Throwable)error);
            this.log.fatal("Application will now exit");
        } else {
            String string = "Uncaught Exception:";
            boolean bl = false;
            System.out.println((Object)string);
            error.printStackTrace();
            string = "Application will now exit";
            bl = false;
            System.out.println((Object)string);
        }
        this.loop.stop();
        new ErrorDialog((Throwable)error).showAndWait();
        if (this.loop.isStarted()) {
            this.exit();
        } else {
            if (Logger.Companion.isConfigured()) {
                Logger.Companion.close();
            }
            System.exit(-1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canShowCloseDialog() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        Scene scene = mainWindow.getCurrentScene();
        DialogSubState dialogSubState = this.dialogScene;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogScene");
        }
        if (scene == dialogSubState) return false;
        MainWindow mainWindow2 = this.mainWindow;
        if (mainWindow2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        Scene scene2 = mainWindow2.getCurrentScene();
        LoadingScene loadingScene = this.loadScene;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        if (scene2 == loadingScene) return false;
        if (!this.settings.isIntroEnabled()) return true;
        MainWindow mainWindow3 = this.mainWindow;
        if (mainWindow3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        if (mainWindow3.getCurrentScene() != this.intro) return true;
        return false;
    }

    private final void showConfirmExitDialog() {
        this.getDisplay$fxgl().showConfirmationBox(this.getLocal$fxgl().getLocalizedString("dialog.exitGame"), (Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"yes");
                if (bl.booleanValue()) {
                    this.this$0.exit();
                }
            }
            {
                this.this$0 = engine;
            }
        });
    }

    @Override
    public void startNewGame() {
        this.log.debug("Starting new game");
        LoadingScene loadingScene = this.loadScene;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        loadingScene.setDataFile$fxgl(DataFile.Companion.getEMPTY());
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene2 = this.loadScene;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        mainWindow.setScene(loadingScene2);
    }

    private final void startLoadedGame(DataFile dataFile) {
        this.log.debug("Starting loaded game");
        LoadingScene loadingScene = this.loadScene;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        loadingScene.setDataFile$fxgl(dataFile);
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene2 = this.loadScene;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        mainWindow.setScene(loadingScene2);
    }

    @Override
    public void gotoIntro() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.intro;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoMainMenu() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.mainMenu;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoGameMenu() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.gameMenu;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoPlay() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        GameScene gameScene = this.playScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playScene");
        }
        mainWindow.setScene(gameScene);
    }

    @Override
    public void saveGame(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        this.doSave(fileName);
    }

    private final void doSave(String saveFileName) {
        DataFile dataFile = this.app.saveState();
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
        SaveFile saveFile = new SaveFile(saveFileName, localDateTime);
    }

    @Override
    public void loadGame(@NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
    }

    @Override
    public void loadGameFromLastSave() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveScreenshot() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        Image fxImage = mainWindow.takeScreenshot();
        BufferedImage img = SwingFXUtils.fromFXImage((Image)fxImage, null);
        String fileName = "./" + this.settings.getTitle() + this.settings.getVersion() + LocalDateTime.now();
        fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
        try {
            String name = StringsKt.endsWith$default((String)fileName, (String)".png", (boolean)false, (int)2, null) ? fileName : fileName + ".png";
            Closeable closeable = Files.newOutputStream(Paths.get(name, new String[0]), new OpenOption[0]);
            boolean bl = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl2 = false;
                boolean bl3 = ImageIO.write((RenderedImage)img, "png", it);
                return bl3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("saveScreenshot(" + fileName + ".png) failed: " + e);
            return false;
        }
    }

    @Override
    public void saveProfile() {
    }

    @Override
    public boolean loadFromProfile(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        if (!profile.isCompatible(this.settings.getTitle(), this.settings.getVersion())) {
            return false;
        }
        this.getEventBus$fxgl().fireEvent((Event)new LoadEvent(LoadEvent.LOAD_PROFILE, profile));
        return true;
    }

    @Override
    @NotNull
    public StringProperty profileNameProperty() {
        return (StringProperty)this.profileName;
    }

    @Override
    public void restoreDefaultProfileSettings() {
        this.log.debug("restoreDefaultSettings()");
        EventBus eventBus2 = this.getEventBus$fxgl();
        UserProfile userProfile = this.defaultProfile;
        if (userProfile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultProfile");
        }
        eventBus2.fireEvent((Event)new LoadEvent(LoadEvent.RESTORE_SETTINGS, userProfile));
    }

    private final UserProfile createProfile() {
        this.log.debug("Creating default profile");
        UserProfile profile = new UserProfile(this.settings.getTitle(), this.settings.getVersion());
        this.getEventBus$fxgl().fireEvent((Event)new SaveEvent(profile));
        return profile;
    }

    public void pushSubScene(@NotNull SubScene subScene) {
        Intrinsics.checkParameterIsNotNull((Object)subScene, (String)"subScene");
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.pushState(subScene);
    }

    public void popSubScene() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.popState();
    }

    @Override
    public void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkParameterIsNotNull((Object)vars, (String)"vars");
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onGameReady(vars);
        }
    }

    @Override
    public void exit() {
        this.log.debug("Exiting FXGL");
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EngineService it = (EngineService)element$iv;
            boolean bl = false;
            it.onExit();
        }
        this.settings.isMenuEnabled();
        this.log.debug("Shutting down background threads");
        this.getExecutor$fxgl().shutdownNow();
        if (!this.settings.isExperimentalNative()) {
            this.saveSystemData();
        }
        this.log.debug("Closing logger and exiting JavaFX");
        Logger.Companion.close();
        Platform.exit();
    }

    @NotNull
    public final GameApplication getApp$fxgl() {
        return this.app;
    }

    @NotNull
    public final ReadOnlyGameSettings getSettings$fxgl() {
        return this.settings;
    }

    public Engine(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull Stage stage) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
        this.app = app;
        this.settings = settings;
        this.stage = stage;
        this.log = Logger.Companion.get(this.getClass());
        this.loop = new LoopRunner((Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ Engine this$0;

            public final void invoke(double it) {
                Engine.access$loop(this.this$0, it);
            }
            {
                this.this$0 = engine;
                super(1);
            }
        }));
        Engine engine = this;
        boolean bl = false;
        Cloneable cloneable = new ArrayList();
        engine.services = cloneable;
        engine = this;
        bl = false;
        cloneable = new HashMap();
        engine.servicesCache = cloneable;
        this.assetLoader$delegate = LazyKt.lazy((Function0)assetLoader.2.INSTANCE);
        this.eventBus$delegate = LazyKt.lazy((Function0)eventBus.2.INSTANCE);
        this.display$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Display>(this){
            final /* synthetic */ Engine this$0;

            @NotNull
            public final Display invoke() {
                DialogSubState dialogSubState = Engine.access$getDialogScene$p(this.this$0);
                if (dialogSubState == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.ui.Display");
                }
                return dialogSubState;
            }
            {
                this.this$0 = engine;
                super(0);
            }
        }));
        this.executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);
        this.fs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FS>(this){
            final /* synthetic */ Engine this$0;

            @NotNull
            public final FS invoke() {
                return new FS(this.this$0.getSettings$fxgl().isDesktop());
            }
            {
                this.this$0 = engine;
                super(0);
            }
        }));
        this.local$delegate = LazyKt.lazy((Function0)local.2.INSTANCE);
        this.devPane$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DevPane>(this){
            final /* synthetic */ Engine this$0;

            @NotNull
            public final DevPane invoke() {
                return new DevPane(this.this$0.getPlayScene$fxgl(), this.this$0.getSettings$fxgl());
            }
            {
                this.this$0 = engine;
                super(0);
            }
        }));
        this.engineTimer = new Timer();
        this.overlayRoot = new Group();
        this.profileName = new SimpleStringProperty("no-profile");
        engine = this;
        bl = false;
        cloneable = new HashMap();
        engine.environmentVars = cloneable;
        this.log.debug("Initializing FXGL");
        this.logVersion();
        this.initEnvironmentVars();
    }

    public static final /* synthetic */ void access$initEngine(Engine $this) {
        $this.initEngine();
    }

    public static final /* synthetic */ void access$prepareToStartLoop(Engine $this) {
        $this.prepareToStartLoop();
    }

    public static final /* synthetic */ Logger access$getLog$p(Engine $this) {
        return $this.log;
    }

    public static final /* synthetic */ LoopRunner access$getLoop$p(Engine $this) {
        return $this.loop;
    }

    public static final /* synthetic */ boolean access$canShowCloseDialog(Engine $this) {
        return $this.canShowCloseDialog();
    }

    public static final /* synthetic */ void access$showConfirmExitDialog(Engine $this) {
        $this.showConfirmExitDialog();
    }

    public static final /* synthetic */ void access$removeOverlay(Engine $this, Scene scene) {
        $this.removeOverlay(scene);
    }

    public static final /* synthetic */ void access$addOverlay(Engine $this, Scene scene) {
        $this.addOverlay(scene);
    }

    public static final /* synthetic */ void access$handleFatalError(Engine $this, Throwable e) {
        $this.handleFatalError(e);
    }

    public static final /* synthetic */ void access$loadDefaultSystemData(Engine $this) {
        $this.loadDefaultSystemData();
    }

    public static final /* synthetic */ MainWindow access$getMainWindow$p(Engine $this) {
        MainWindow mainWindow = $this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        return mainWindow;
    }

    public static final /* synthetic */ void access$setMainWindow$p(Engine $this, MainWindow mainWindow) {
        $this.mainWindow = mainWindow;
    }

    public static final /* synthetic */ FXGLScene access$getGameMenu$p(Engine $this) {
        return $this.gameMenu;
    }

    public static final /* synthetic */ void access$setGameMenu$p(Engine $this, FXGLScene fXGLScene) {
        $this.gameMenu = fXGLScene;
    }

    public static final /* synthetic */ PauseMenu access$getPauseMenu$p(Engine $this) {
        return $this.pauseMenu;
    }

    public static final /* synthetic */ void access$setPauseMenu$p(Engine $this, PauseMenu pauseMenu) {
        $this.pauseMenu = pauseMenu;
    }

    public static final /* synthetic */ void access$loop(Engine $this, double tpf) {
        $this.loop(tpf);
    }

    public static final /* synthetic */ DialogSubState access$getDialogScene$p(Engine $this) {
        DialogSubState dialogSubState = $this.dialogScene;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogScene");
        }
        return dialogSubState;
    }

    public static final /* synthetic */ void access$setDialogScene$p(Engine $this, DialogSubState dialogSubState) {
        $this.dialogScene = dialogSubState;
    }
}

