/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.CSS;
import com.almasb.fxgl.app.Viewport;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.scene.Scene;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J(\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(H\u0016J\u0006\u0010,\u001a\u00020#J\u0006\u0010-\u001a\u00020#J\u000e\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020#2\u0006\u00102\u001a\u000203J\u000e\u00101\u001a\u00020#2\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020#2\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010\u00a8\u0006:"}, d2={"Lcom/almasb/fxgl/app/FXGLScene;", "Lcom/almasb/fxgl/scene/Scene;", "width", "", "height", "(II)V", "active", "Ljavafx/beans/property/SimpleBooleanProperty;", "effect", "Ljavafx/scene/effect/Effect;", "getEffect", "()Ljavafx/scene/effect/Effect;", "setEffect", "(Ljavafx/scene/effect/Effect;)V", "", "getHeight", "()D", "paddingBot", "Ljavafx/scene/shape/Rectangle;", "getPaddingBot", "()Ljavafx/scene/shape/Rectangle;", "paddingLeft", "getPaddingLeft", "paddingRight", "getPaddingRight", "paddingTop", "getPaddingTop", "viewport", "Lcom/almasb/fxgl/app/Viewport;", "getViewport", "()Lcom/almasb/fxgl/app/Viewport;", "getWidth", "activeProperty", "Ljavafx/beans/property/BooleanProperty;", "appendCSS", "", "css", "Lcom/almasb/fxgl/app/CSS;", "bindSize", "scaledWidth", "Ljavafx/beans/property/DoubleProperty;", "scaledHeight", "scaleRatioX", "scaleRatioY", "clearCSS", "clearEffect", "setBackgroundColor", "color", "Ljavafx/scene/paint/Paint;", "setBackgroundRepeat", "image", "Ljavafx/scene/image/Image;", "textureName", "", "setCursor", "hotspot", "Ljavafx/geometry/Point2D;", "setCursorInvisible", "fxgl"})
public abstract class FXGLScene
extends Scene {
    @NotNull
    private final Viewport viewport;
    @NotNull
    private final Rectangle paddingTop;
    @NotNull
    private final Rectangle paddingBot;
    @NotNull
    private final Rectangle paddingLeft;
    @NotNull
    private final Rectangle paddingRight;
    private final SimpleBooleanProperty active;

    @NotNull
    public final Viewport getViewport() {
        return this.viewport;
    }

    @NotNull
    public final Rectangle getPaddingTop() {
        return this.paddingTop;
    }

    @NotNull
    public final Rectangle getPaddingBot() {
        return this.paddingBot;
    }

    @NotNull
    public final Rectangle getPaddingLeft() {
        return this.paddingLeft;
    }

    @NotNull
    public final Rectangle getPaddingRight() {
        return this.paddingRight;
    }

    public final double getWidth() {
        return this.getRoot().getPrefWidth();
    }

    public final double getHeight() {
        return this.getRoot().getPrefHeight();
    }

    @Nullable
    public final Effect getEffect() {
        return this.getContentRoot().getEffect();
    }

    public final void setEffect(@Nullable Effect effect) {
        this.getContentRoot().setEffect(effect);
    }

    public final void clearEffect() {
        this.setEffect(null);
    }

    public final void setCursor(@NotNull Image image, @NotNull Point2D hotspot) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)hotspot, (String)"hotspot");
        this.getRoot().setCursor((Cursor)new ImageCursor(image, hotspot.getX(), hotspot.getY()));
    }

    public final void setCursorInvisible() {
        this.getRoot().setCursor(Cursor.NONE);
    }

    @NotNull
    public final BooleanProperty activeProperty() {
        return (BooleanProperty)this.active;
    }

    public final void appendCSS(@NotNull CSS css) {
        Intrinsics.checkParameterIsNotNull((Object)css, (String)"css");
        this.getRoot().getStylesheets().add((Object)css.getExternalForm());
    }

    public final void clearCSS() {
        this.getRoot().getStylesheets().clear();
    }

    public void bindSize(@NotNull DoubleProperty scaledWidth, @NotNull DoubleProperty scaledHeight, @NotNull DoubleProperty scaleRatioX, @NotNull DoubleProperty scaleRatioY) {
        Intrinsics.checkParameterIsNotNull((Object)scaledWidth, (String)"scaledWidth");
        Intrinsics.checkParameterIsNotNull((Object)scaledHeight, (String)"scaledHeight");
        Intrinsics.checkParameterIsNotNull((Object)scaleRatioX, (String)"scaleRatioX");
        Intrinsics.checkParameterIsNotNull((Object)scaleRatioY, (String)"scaleRatioY");
        super.bindSize(scaledWidth, scaledHeight, scaleRatioX, scaleRatioY);
        this.getContentRoot().translateXProperty().bind((ObservableValue)scaledWidth.divide(2).subtract((ObservableNumberValue)scaleRatioX.multiply(this.viewport.getWidth()).divide(2)));
        this.getContentRoot().translateYProperty().bind((ObservableValue)scaledHeight.divide(2).subtract((ObservableNumberValue)scaleRatioY.multiply(this.viewport.getHeight()).divide(2)));
    }

    public final void setBackgroundColor(@NotNull Paint color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.getRoot().setBackground(new Background(new BackgroundFill[]{new BackgroundFill(color, null, null)}));
    }

    public final void setBackgroundRepeat(@NotNull String textureName) {
        Intrinsics.checkParameterIsNotNull((Object)textureName, (String)"textureName");
        Image image = FXGL.Companion.texture(textureName).getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"FXGL.texture(textureName).image");
        this.setBackgroundRepeat(image);
    }

    public final void setBackgroundRepeat(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        this.getRoot().setBackground(new Background(new BackgroundImage[]{new BackgroundImage(image, BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT, null, null)}));
    }

    @JvmOverloads
    public FXGLScene(int width, int height) {
        this.viewport = new Viewport(width, height);
        this.paddingTop = new Rectangle();
        this.paddingBot = new Rectangle();
        this.paddingLeft = new Rectangle();
        this.paddingRight = new Rectangle();
        this.paddingTop.widthProperty().bind((ObservableValue)this.getRoot().prefWidthProperty());
        this.paddingTop.heightProperty().bind((ObservableValue)this.getContentRoot().translateYProperty());
        this.paddingBot.translateYProperty().bind((ObservableValue)this.getRoot().prefHeightProperty().subtract((ObservableNumberValue)this.paddingTop.heightProperty()));
        this.paddingBot.widthProperty().bind((ObservableValue)this.getRoot().prefWidthProperty());
        this.paddingBot.heightProperty().bind((ObservableValue)this.paddingTop.heightProperty());
        this.paddingLeft.widthProperty().bind((ObservableValue)this.getContentRoot().translateXProperty());
        this.paddingLeft.heightProperty().bind((ObservableValue)this.getRoot().prefHeightProperty());
        this.paddingRight.translateXProperty().bind((ObservableValue)this.getRoot().prefWidthProperty().subtract((ObservableNumberValue)this.paddingLeft.widthProperty()));
        this.paddingRight.widthProperty().bind((ObservableValue)this.getContentRoot().translateXProperty());
        this.paddingRight.heightProperty().bind((ObservableValue)this.getRoot().prefHeightProperty());
        this.getRoot().getChildren().addAll((Object[])new Node[]{(Node)this.paddingTop, (Node)this.paddingBot, (Node)this.paddingLeft, (Node)this.paddingRight});
        this.active = new SimpleBooleanProperty(false);
    }

    public /* synthetic */ FXGLScene(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = FXGL.Companion.getAppWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = FXGL.Companion.getAppHeight();
        }
        this(n, n2);
    }

    @JvmOverloads
    public FXGLScene(int width) {
        this(width, 0, 2, null);
    }

    @JvmOverloads
    public FXGLScene() {
        this(0, 0, 3, null);
    }
}

