/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGLScene;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.sslogger.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/almasb/fxgl/app/LoadingScene;", "Lcom/almasb/fxgl/app/FXGLScene;", "()V", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "getDataFile$fxgl", "()Lcom/almasb/fxgl/saving/DataFile;", "setDataFile$fxgl", "(Lcom/almasb/fxgl/saving/DataFile;)V", "loadingFinished", "", "progress", "Ljavafx/scene/control/ProgressBar;", "text", "Ljavafx/scene/text/Text;", "getText", "()Ljavafx/scene/text/Text;", "bind", "", "task", "Ljavafx/concurrent/Task;", "onCreate", "onUpdate", "tpf", "", "InitAppTask", "fxgl"})
public class LoadingScene
extends FXGLScene {
    private final ProgressBar progress = new ProgressBar();
    @NotNull
    private final Text text = new Text();
    private boolean loadingFinished;
    @NotNull
    private DataFile dataFile = DataFile.Companion.getEMPTY();

    @NotNull
    protected final Text getText() {
        return this.text;
    }

    @NotNull
    public final DataFile getDataFile$fxgl() {
        return this.dataFile;
    }

    public final void setDataFile$fxgl(@NotNull DataFile dataFile) {
        Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"<set-?>");
        this.dataFile = dataFile;
    }

    public void bind(@NotNull Task<?> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        this.progress.progressProperty().bind((ObservableValue)task.progressProperty());
        this.text.textProperty().bind((ObservableValue)task.messageProperty());
    }

    public void onCreate() {
        InitAppTask initTask = new InitAppTask(FXGL.Companion.getApp(), this.dataFile);
        initTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(this){
            final /* synthetic */ LoadingScene this$0;

            public final void handle(WorkerStateEvent it) {
                LoadingScene.access$setLoadingFinished$p(this.this$0, true);
            }
            {
                this.this$0 = loadingScene;
            }
        });
        this.bind(initTask);
        FXGL.Companion.getExecutor().execute((Runnable)((Object)initTask));
    }

    protected void onUpdate(double tpf) {
        if (this.loadingFinished) {
            FXGL.Companion.getGameController().gotoPlay();
            this.loadingFinished = false;
        }
    }

    public LoadingScene() {
        super(0, 0, 3, null);
        ReadOnlyGameSettings settings = FXGL.Companion.getSettings();
        ProgressBar progressBar = this.progress;
        boolean bl = false;
        boolean bl2 = false;
        ProgressBar $this$with = progressBar;
        boolean bl3 = false;
        $this$with.setPrefSize((double)settings.getWidth() - 200.0, 10.0);
        $this$with.setTranslateX(100.0);
        $this$with.setTranslateY((double)settings.getHeight() - 100.0);
        progressBar = this.text;
        bl = false;
        bl2 = false;
        $this$with = progressBar;
        boolean bl4 = false;
        if (!settings.isExperimentalNative()) {
            $this$with.setFont(FXGL.Companion.getUIFactory().newFont(24.0));
        }
        $this$with.setFill((Paint)Color.WHITE);
        FXGL.Companion.centerTextBind(this.text, (double)settings.getWidth() / 2.0, (double)(settings.getHeight() * 4) / 5.0);
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{(Node)new Rectangle((double)settings.getWidth(), (double)settings.getHeight(), (Paint)Color.rgb((int)0, (int)0, (int)10)), (Node)this.progress, (Node)this.text});
    }

    public static final /* synthetic */ boolean access$getLoadingFinished$p(LoadingScene $this) {
        return $this.loadingFinished;
    }

    public static final /* synthetic */ void access$setLoadingFinished$p(LoadingScene $this, boolean bl) {
        $this.loadingFinished = bl;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/app/LoadingScene$InitAppTask;", "Ljavafx/concurrent/Task;", "Ljava/lang/Void;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/saving/DataFile;)V", "call", "clearPreviousGame", "", "failed", "initComplete", "initGame", "initPhysics", "initUI", "update", "message", "", "step", "", "Companion", "fxgl"})
    private static final class InitAppTask
    extends Task<Void> {
        private final GameApplication app;
        private final DataFile dataFile;
        private static final Logger log;
        public static final Companion Companion;

        @Nullable
        protected Void call() {
            long start = System.nanoTime();
            this.clearPreviousGame();
            this.initGame();
            this.initPhysics();
            this.initUI();
            this.initComplete();
            log.infof("Game initialization took: %.3f sec", new Object[]{(double)(System.nanoTime() - start) / 1.0E9});
            return null;
        }

        private final void clearPreviousGame() {
            log.debug("Clearing previous game");
            FXGL.Companion.getGameWorld().clear();
            FXGL.Companion.getPhysicsWorld().clear();
            FXGL.Companion.getPhysicsWorld().clearCollisionHandlers();
            FXGL.Companion.getGameScene().clear();
            FXGL.Companion.getGameState().clear();
            FXGL.Companion.getGameTimer().clear();
        }

        private final void initGame() {
            this.update("Initializing Game", 0);
            boolean bl = false;
            HashMap vars = new HashMap();
            this.app.initGameVars(vars);
            Map $this$forEach$iv = vars;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl2 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$name$value = element$iv = iterator.next();
                boolean bl3 = false;
                Map.Entry entry = $dstr$name$value;
                boolean bl4 = false;
                String name = (String)entry.getKey();
                entry = $dstr$name$value;
                bl4 = false;
                Object value = entry.getValue();
                FXGL.Companion.getGameState().setValue(name, value);
            }
            if (this.dataFile == DataFile.Companion.getEMPTY()) {
                this.app.initGame();
            } else {
                this.app.loadState(this.dataFile);
            }
        }

        private final void initPhysics() {
            this.update("Initializing Physics", 1);
            this.app.initPhysics();
        }

        private final void initUI() {
            this.update("Initializing UI", 2);
            this.app.initUI();
        }

        private final void initComplete() {
            this.update("Initialization Complete", 3);
            FXGL.Companion.getGameController().onGameReady(FXGL.Companion.getGameState().getProperties());
        }

        private final void update(String message, int step) {
            log.debug(message);
            this.updateMessage(message);
            this.updateProgress(step, 3L);
        }

        protected void failed() {
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread thread = Thread.currentThread();
            Throwable throwable = this.getException();
            if (throwable == null) {
                throwable = new RuntimeException("Initialization failed");
            }
            uncaughtExceptionHandler.uncaughtException(thread, throwable);
        }

        public InitAppTask(@NotNull GameApplication app, @NotNull DataFile dataFile) {
            Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
            Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"dataFile");
            this.app = app;
            this.dataFile = dataFile;
        }

        static {
            Companion = new Companion(null);
            Logger.Companion this_$iv = Logger.Companion;
            boolean $i$f$get = false;
            log = this_$iv.get(InitAppTask.class);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/LoadingScene$InitAppTask$Companion;", "", "()V", "log", "Lcom/almasb/sslogger/Logger;", "fxgl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

