/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.app.services.IOTaskExecutorService;
import com.almasb.fxgl.app.services.UpdaterService;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.net.NetService;
import com.almasb.fxgl.time.LocalTimer;
import com.almasb.sslogger.Logger;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/app/services/UpdaterService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "log", "Lcom/almasb/sslogger/Logger;", "netService", "Lcom/almasb/fxgl/net/NetService;", "taskService", "Lcom/almasb/fxgl/app/services/IOTaskExecutorService;", "updateCheckTimer", "Lcom/almasb/fxgl/time/LocalTimer;", "urlPOM", "", "checkForUpdates", "", "getLatestVersionTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "onInit", "shouldCheckForUpdate", "", "fxgl"})
public final class UpdaterService
extends EngineService {
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    private LocalTimer updateCheckTimer;
    private NetService netService;
    private IOTaskExecutorService taskService;
    @Inject(value="urlPOM")
    private String urlPOM;

    public void onInit() {
        if (this.shouldCheckForUpdate()) {
            this.checkForUpdates();
        }
    }

    private final boolean shouldCheckForUpdate() {
        return false;
    }

    private final void checkForUpdates() {
        this.log.debug("Checking for updates");
        IOTask task2 = this.getLatestVersionTask().onSuccess((Consumer)new Consumer<String>(this){
            final /* synthetic */ UpdaterService this$0;

            public final void accept(String latestVersion) {
                String currentVersion = FXGL.Companion.getVersion();
                if (Intrinsics.areEqual((Object)currentVersion, (Object)latestVersion)) {
                    UpdaterService.access$getLog$p(this.this$0).info("You are using latest FXGL version!");
                } else {
                    UpdaterService.access$getLog$p(this.this$0).info("Your current version:  " + currentVersion);
                    UpdaterService.access$getLog$p(this.this$0).info("Latest stable version: " + latestVersion);
                }
            }
            {
                this.this$0 = updaterService;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ UpdaterService this$0;

            public final void accept(Throwable error) {
                UpdaterService.access$getLog$p(this.this$0).warning("Failed to find updates: " + error);
            }
            {
                this.this$0 = updaterService;
            }
        });
        IOTaskExecutorService iOTaskExecutorService = this.taskService;
        if (iOTaskExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"taskService");
        }
        IOTask iOTask = task2;
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"task");
        iOTaskExecutorService.runAsync(iOTask);
    }

    @NotNull
    public final IOTask<String> getLatestVersionTask() {
        NetService netService = this.netService;
        if (netService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"netService");
        }
        String string = this.urlPOM;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"urlPOM");
        }
        IOTask iOTask = netService.openStreamTask(string).thenWrap((Function)getLatestVersionTask.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iOTask, (String)"netService\n            .\u2026          }\n            }");
        return iOTask;
    }

    public static final /* synthetic */ Logger access$getLog$p(UpdaterService $this) {
        return $this.log;
    }
}

