/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.GameScene;
import com.almasb.fxgl.app.scene.LoadingScene;
import com.almasb.fxgl.app.scene.PauseMenu;
import com.almasb.fxgl.app.scene.SceneFactory;
import com.almasb.fxgl.app.services.AssetLoaderService;
import com.almasb.fxgl.app.services.WindowService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.localization.LocalizationService;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.profile.DataFile;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.DialogService;
import com.almasb.sslogger.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u000206H\u0002J\u0006\u0010<\u001a\u000206J\u0006\u0010=\u001a\u000206J\u000e\u0010>\u001a\u0002062\u0006\u0010?\u001a\u00020@J\u0012\u0010>\u001a\u0002062\n\u0010?\u001a\u0006\u0012\u0002\b\u00030AJ\u0006\u0010B\u001a\u000206J\u0006\u0010C\u001a\u000206J\b\u0010D\u001a\u000206H\u0002J\u000e\u0010E\u001a\u0002062\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010F\u001a\u0002062\u0006\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u000206H\u0016J\b\u0010J\u001a\u000206H\u0016J\u0010\u0010K\u001a\u0002062\u0006\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u000206H\u0016J\u0010\u0010O\u001a\u0002062\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u000e\u0010S\u001a\u0002062\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010T\u001a\u00020:J\b\u0010U\u001a\u000206H\u0002J\u0006\u0010V\u001a\u000206R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020 8\u0000@\u0000X\u0081.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u00020,8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006W"}, d2={"Lcom/almasb/fxgl/app/services/WindowService;", "Lcom/almasb/fxgl/scene/SceneService;", "()V", "appHeight", "", "getAppHeight", "()I", "appWidth", "getAppWidth", "assetLoaderService", "Lcom/almasb/fxgl/app/services/AssetLoaderService;", "dataFile", "Lcom/almasb/fxgl/profile/DataFile;", "dialogService", "Lcom/almasb/fxgl/ui/DialogService;", "gameMenu", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "gameScene", "Lcom/almasb/fxgl/app/scene/GameScene;", "getGameScene$fxgl", "()Lcom/almasb/fxgl/app/scene/GameScene;", "setGameScene$fxgl", "(Lcom/almasb/fxgl/app/scene/GameScene;)V", "intro", "loadScene", "Lcom/almasb/fxgl/app/scene/LoadingScene;", "localService", "Lcom/almasb/fxgl/localization/LocalizationService;", "log", "Lcom/almasb/sslogger/Logger;", "mainMenu", "mainWindow", "Lcom/almasb/fxgl/app/MainWindow;", "getMainWindow$fxgl", "()Lcom/almasb/fxgl/app/MainWindow;", "setMainWindow$fxgl", "(Lcom/almasb/fxgl/app/MainWindow;)V", "overlayRoot", "Ljavafx/scene/Group;", "getOverlayRoot", "()Ljavafx/scene/Group;", "pauseMenu", "Lcom/almasb/fxgl/app/scene/PauseMenu;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "getSettings", "()Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "setSettings", "(Lcom/almasb/fxgl/app/ReadOnlyGameSettings;)V", "timer", "Lcom/almasb/fxgl/time/Timer;", "getTimer", "()Lcom/almasb/fxgl/time/Timer;", "addOverlay", "", "scene", "Lcom/almasb/fxgl/scene/Scene;", "canShowCloseDialog", "", "clearPreviousGame", "gotoGameMenu", "gotoIntro", "gotoLoading", "loadingTask", "Ljava/lang/Runnable;", "Ljavafx/concurrent/Task;", "gotoMainMenu", "gotoPlay", "initAppScenes", "loadGame", "onGameReady", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "onInit", "onMainLoopStarting", "onUpdate", "tpf", "", "popSubScene", "pushSubScene", "subScene", "Lcom/almasb/fxgl/scene/SubScene;", "removeOverlay", "saveGame", "saveScreenshot", "showConfirmExitDialog", "startNewGame", "fxgl"})
public final class WindowService
extends SceneService {
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    @Inject(value="settings")
    @NotNull
    public ReadOnlyGameSettings settings;
    @Inject(value="mainWindow")
    @NotNull
    public MainWindow mainWindow;
    private AssetLoaderService assetLoaderService;
    private LocalizationService localService;
    private DialogService dialogService;
    @NotNull
    private final Group overlayRoot = new Group();
    @NotNull
    private final Timer timer = new Timer();
    @NotNull
    public GameScene gameScene;
    private LoadingScene loadScene;
    private FXGLScene intro;
    private FXGLScene mainMenu;
    private FXGLScene gameMenu;
    private PauseMenu pauseMenu;
    private DataFile dataFile;

    @NotNull
    public final ReadOnlyGameSettings getSettings() {
        ReadOnlyGameSettings readOnlyGameSettings = this.settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        return readOnlyGameSettings;
    }

    public final void setSettings(@NotNull ReadOnlyGameSettings readOnlyGameSettings) {
        Intrinsics.checkParameterIsNotNull((Object)readOnlyGameSettings, (String)"<set-?>");
        this.settings = readOnlyGameSettings;
    }

    @NotNull
    public final MainWindow getMainWindow$fxgl() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        return mainWindow;
    }

    public final void setMainWindow$fxgl(@NotNull MainWindow mainWindow) {
        Intrinsics.checkParameterIsNotNull((Object)mainWindow, (String)"<set-?>");
        this.mainWindow = mainWindow;
    }

    @NotNull
    public Group getOverlayRoot() {
        return this.overlayRoot;
    }

    public int getAppWidth() {
        ReadOnlyGameSettings readOnlyGameSettings = this.settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        return readOnlyGameSettings.getWidth();
    }

    public int getAppHeight() {
        ReadOnlyGameSettings readOnlyGameSettings = this.settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        return readOnlyGameSettings.getHeight();
    }

    @NotNull
    public Timer getTimer() {
        return this.timer;
    }

    @NotNull
    public final GameScene getGameScene$fxgl() {
        GameScene gameScene = this.gameScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
        }
        return gameScene;
    }

    public final void setGameScene$fxgl(@NotNull GameScene gameScene) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)gameScene), (String)"<set-?>");
        this.gameScene = gameScene;
    }

    public void onInit() {
        ReadOnlyGameSettings readOnlyGameSettings = this.settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        Iterable $this$forEach$iv = readOnlyGameSettings.getCSSList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.log.debug("Applying CSS: " + it);
            MainWindow mainWindow = this.mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            CSS[] cSSArray = new CSS[1];
            AssetLoaderService assetLoaderService = this.assetLoaderService;
            if (assetLoaderService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
            }
            cSSArray[0] = assetLoaderService.loadCSS(it);
            mainWindow.addCSS(cSSArray);
        }
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.setOnClose((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WindowService this$0;

            public final void invoke() {
                if (this.this$0.getSettings().isCloseConfirmation()) {
                    if (WindowService.access$canShowCloseDialog(this.this$0)) {
                        WindowService.access$showConfirmExitDialog(this.this$0);
                    }
                } else {
                    FXGL.Companion.getGameController().exit();
                }
            }
            {
                this.this$0 = windowService;
                super(0);
            }
        }));
        MainWindow mainWindow2 = this.mainWindow;
        if (mainWindow2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow2.getCurrentSceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(this){
            final /* synthetic */ WindowService this$0;

            public final void changed(ObservableValue<? extends Scene> $noName_0, Scene oldScene, Scene newScene) {
                WindowService.access$getLog$p(this.this$0).debug("Removing overlay from " + oldScene + " and adding to " + newScene);
                Scene scene = oldScene;
                Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"oldScene");
                WindowService.access$removeOverlay(this.this$0, scene);
                Scene scene2 = newScene;
                Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"newScene");
                WindowService.access$addOverlay(this.this$0, scene2);
            }
            {
                this.this$0 = windowService;
            }
        });
        this.initAppScenes();
    }

    public void onUpdate(double tpf) {
        this.getTimer().update(tpf);
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.update(tpf);
    }

    private final void initAppScenes() {
        this.log.debug("Initializing application scenes");
        ReadOnlyGameSettings readOnlyGameSettings = this.settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        SceneFactory sceneFactory = readOnlyGameSettings.getSceneFactory();
        this.loadScene = sceneFactory.newLoadingScene();
        ReadOnlyGameSettings readOnlyGameSettings2 = this.settings;
        if (readOnlyGameSettings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        int n = readOnlyGameSettings2.getWidth();
        ReadOnlyGameSettings readOnlyGameSettings3 = this.settings;
        if (readOnlyGameSettings3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        int n2 = readOnlyGameSettings3.getHeight();
        GameWorld gameWorld = new GameWorld();
        ReadOnlyGameSettings readOnlyGameSettings4 = this.settings;
        if (readOnlyGameSettings4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        int n3 = readOnlyGameSettings4.getHeight();
        ReadOnlyGameSettings readOnlyGameSettings5 = this.settings;
        if (readOnlyGameSettings5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        GameScene gameScene = this.gameScene = new GameScene(n, n2, gameWorld, new PhysicsWorld(n3, readOnlyGameSettings5.getPixelsPerMeter()));
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
        }
        ReadOnlyGameSettings readOnlyGameSettings6 = this.settings;
        if (readOnlyGameSettings6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        gameScene.setSingleStep(readOnlyGameSettings6.isSingleStep());
        ReadOnlyGameSettings readOnlyGameSettings7 = this.settings;
        if (readOnlyGameSettings7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        if (readOnlyGameSettings7.isIntroEnabled()) {
            this.intro = sceneFactory.newIntro();
        }
        ReadOnlyGameSettings readOnlyGameSettings8 = this.settings;
        if (readOnlyGameSettings8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        if (readOnlyGameSettings8.isMenuEnabled()) {
            this.mainMenu = sceneFactory.newMainMenu();
            this.gameMenu = sceneFactory.newGameMenu();
            EventHandler<KeyEvent> menuKeyHandler2 = new EventHandler<KeyEvent>(this){
                private boolean canSwitchGameMenu;
                final /* synthetic */ WindowService this$0;

                private final void onMenuKey(boolean pressed) {
                    if (!pressed) {
                        this.canSwitchGameMenu = true;
                        return;
                    }
                    if (this.canSwitchGameMenu) {
                        if (this.this$0.getMainWindow$fxgl().getCurrentScene() == WindowService.access$getGameMenu$p(this.this$0)) {
                            this.canSwitchGameMenu = false;
                            this.this$0.gotoPlay();
                        } else if (this.this$0.getMainWindow$fxgl().getCurrentScene() == this.this$0.getGameScene$fxgl()) {
                            this.canSwitchGameMenu = false;
                            this.this$0.gotoGameMenu();
                        }
                    }
                }

                public void handle(@NotNull KeyEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    if (event.getCode() == this.this$0.getSettings().getMenuKey()) {
                        this.onMenuKey(Intrinsics.areEqual((Object)event.getEventType(), (Object)KeyEvent.KEY_PRESSED));
                    }
                }
                {
                    this.this$0 = $outer;
                    this.canSwitchGameMenu = true;
                }
            };
            GameScene gameScene2 = this.gameScene;
            if (gameScene2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            }
            Input input = gameScene2.getInput();
            EventType eventType = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"KeyEvent.ANY");
            input.addEventHandler(eventType, (EventHandler)menuKeyHandler2);
            FXGLScene fXGLScene = this.gameMenu;
            if (fXGLScene == null) {
                Intrinsics.throwNpe();
            }
            Input input2 = fXGLScene.getInput();
            EventType eventType2 = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType2, (String)"KeyEvent.ANY");
            input2.addEventHandler(eventType2, (EventHandler)menuKeyHandler2);
        } else {
            PauseMenu pauseMenu = this.pauseMenu = sceneFactory.newPauseMenu();
            if (pauseMenu == null) {
                Intrinsics.throwNpe();
            }
            DoubleProperty doubleProperty = pauseMenu.getContentRoot().translateXProperty();
            GameScene gameScene3 = this.gameScene;
            if (gameScene3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            }
            doubleProperty.bind((ObservableValue)gameScene3.getContentRoot().translateXProperty());
            GameScene gameScene4 = this.gameScene;
            if (gameScene4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
            }
            Input input = gameScene4.getInput();
            UserAction userAction = new UserAction(this, "Pause"){
                final /* synthetic */ WindowService this$0;

                protected void onActionBegin() {
                    PauseMenu pauseMenu = WindowService.access$getPauseMenu$p(this.this$0);
                    if (pauseMenu == null) {
                        Intrinsics.throwNpe();
                    }
                    pauseMenu.requestShow$fxgl((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ initAppScenes.1 this$0;

                        public final void invoke() {
                            MainWindow mainWindow = this.this$0.this$0.getMainWindow$fxgl();
                            PauseMenu pauseMenu = WindowService.access$getPauseMenu$p(this.this$0.this$0);
                            if (pauseMenu == null) {
                                Intrinsics.throwNpe();
                            }
                            mainWindow.pushState(pauseMenu);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }

                protected void onActionEnd() {
                    PauseMenu pauseMenu = WindowService.access$getPauseMenu$p(this.this$0);
                    if (pauseMenu == null) {
                        Intrinsics.throwNpe();
                    }
                    pauseMenu.unlockSwitch$fxgl();
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            };
            ReadOnlyGameSettings readOnlyGameSettings9 = this.settings;
            if (readOnlyGameSettings9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            Input.addAction$default((Input)input, (UserAction)userAction, (KeyCode)readOnlyGameSettings9.getMenuKey(), null, (int)4, null);
        }
        this.log.debug("Application scenes initialized");
    }

    public void onMainLoopStarting() {
        ReadOnlyGameSettings readOnlyGameSettings = this.settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        if (!readOnlyGameSettings.isExperimentalNative()) {
            MainWindow mainWindow = this.mainWindow;
            if (mainWindow == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            Image[] imageArray = new Image[1];
            AssetLoaderService assetLoaderService = this.assetLoaderService;
            if (assetLoaderService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
            }
            ReadOnlyGameSettings readOnlyGameSettings2 = this.settings;
            if (readOnlyGameSettings2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            }
            imageArray[0] = assetLoaderService.loadImage(readOnlyGameSettings2.getAppIcon());
            mainWindow.addIcons(imageArray);
            MainWindow mainWindow2 = this.mainWindow;
            if (mainWindow2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
            }
            AssetLoaderService assetLoaderService2 = this.assetLoaderService;
            if (assetLoaderService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoaderService");
            }
            mainWindow2.setDefaultCursor(new ImageCursor(assetLoaderService2.loadCursorImage("fxgl_default.png"), 7.0, 6.0));
        }
        GameScene gameScene = this.gameScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
        }
        SystemActions.INSTANCE.bind(gameScene.getInput());
    }

    private final void addOverlay(Scene scene) {
        Collection collection = (Collection)scene.getRoot().getChildren();
        Group group = this.getOverlayRoot();
        boolean bl = false;
        collection.add(group);
    }

    private final void removeOverlay(Scene scene) {
        Collection collection = (Collection)scene.getRoot().getChildren();
        Group group = this.getOverlayRoot();
        boolean bl = false;
        collection.remove(group);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canShowCloseDialog() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        Scene scene = mainWindow.getCurrentScene();
        LoadingScene loadingScene = this.loadScene;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        if (scene == loadingScene) return false;
        ReadOnlyGameSettings readOnlyGameSettings = this.settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        if (!readOnlyGameSettings.isIntroEnabled()) return true;
        MainWindow mainWindow2 = this.mainWindow;
        if (mainWindow2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        if (mainWindow2.getCurrentScene() != this.intro) return true;
        return false;
    }

    private final void showConfirmExitDialog() {
        DialogService dialogService = this.dialogService;
        if (dialogService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogService");
        }
        LocalizationService localizationService = this.localService;
        if (localizationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localService");
        }
        dialogService.showConfirmationBox(localizationService.getLocalizedString("dialog.exitGame"), (Consumer)showConfirmExitDialog.1.INSTANCE);
    }

    public final void startNewGame() {
        this.log.debug("Starting new game");
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene = this.loadScene;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        mainWindow.setScene(loadingScene);
        this.clearPreviousGame();
        LoadingScene loadingScene2 = this.loadScene;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        loadingScene2.pushNewTask(new GameApplication.InitAppTask());
    }

    private final void clearPreviousGame() {
        this.log.debug("Clearing previous game");
        GameScene gameScene = this.gameScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
        }
        gameScene.reset$fxgl();
    }

    public final void saveGame(@NotNull DataFile dataFile) {
        Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"dataFile");
    }

    public final void loadGame(@NotNull DataFile dataFile) {
        Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"dataFile");
    }

    public void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkParameterIsNotNull((Object)vars, (String)"vars");
    }

    public final void gotoIntro() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.intro;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    public final void gotoMainMenu() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.mainMenu;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    public final void gotoGameMenu() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.gameMenu;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    public final void gotoLoading(@NotNull Runnable loadingTask) {
        Intrinsics.checkParameterIsNotNull((Object)loadingTask, (String)"loadingTask");
        LoadingScene loadingScene = this.loadScene;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        loadingScene.pushNewTask(loadingTask);
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene2 = this.loadScene;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        mainWindow.setScene(loadingScene2);
    }

    public final void gotoLoading(@NotNull Task<?> loadingTask) {
        Intrinsics.checkParameterIsNotNull(loadingTask, (String)"loadingTask");
        LoadingScene loadingScene = this.loadScene;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        loadingScene.pushNewTask(loadingTask);
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene2 = this.loadScene;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadScene");
        }
        mainWindow.setScene(loadingScene2);
    }

    public final void gotoPlay() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        GameScene gameScene = this.gameScene;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gameScene");
        }
        mainWindow.setScene(gameScene);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveScreenshot() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        Image fxImage = mainWindow.takeScreenshot();
        BufferedImage img = SwingFXUtils.fromFXImage((Image)fxImage, null);
        StringBuilder stringBuilder = new StringBuilder().append("./");
        ReadOnlyGameSettings readOnlyGameSettings = this.settings;
        if (readOnlyGameSettings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        StringBuilder stringBuilder2 = stringBuilder.append(readOnlyGameSettings.getTitle());
        ReadOnlyGameSettings readOnlyGameSettings2 = this.settings;
        if (readOnlyGameSettings2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
        }
        String fileName = stringBuilder2.append(readOnlyGameSettings2.getVersion()).append(LocalDateTime.now()).toString();
        fileName = StringsKt.replace$default((String)fileName, (String)":", (String)"_", (boolean)false, (int)4, null);
        try {
            String name = StringsKt.endsWith$default((String)fileName, (String)".png", (boolean)false, (int)2, null) ? fileName : fileName + ".png";
            Closeable closeable = Files.newOutputStream(Paths.get(name, new String[0]), new OpenOption[0]);
            boolean bl = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl2 = false;
                boolean bl3 = ImageIO.write((RenderedImage)img, "png", it);
                return bl3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.log.warning("saveScreenshot(" + fileName + ".png) failed: " + e);
            return false;
        }
    }

    public void pushSubScene(@NotNull SubScene subScene) {
        Intrinsics.checkParameterIsNotNull((Object)subScene, (String)"subScene");
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.pushState(subScene);
    }

    public void popSubScene() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.popState();
    }

    public static final /* synthetic */ boolean access$canShowCloseDialog(WindowService $this) {
        return $this.canShowCloseDialog();
    }

    public static final /* synthetic */ void access$showConfirmExitDialog(WindowService $this) {
        $this.showConfirmExitDialog();
    }

    public static final /* synthetic */ Logger access$getLog$p(WindowService $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$removeOverlay(WindowService $this, Scene scene) {
        $this.removeOverlay(scene);
    }

    public static final /* synthetic */ void access$addOverlay(WindowService $this, Scene scene) {
        $this.addOverlay(scene);
    }

    public static final /* synthetic */ FXGLScene access$getGameMenu$p(WindowService $this) {
        return $this.gameMenu;
    }

    public static final /* synthetic */ void access$setGameMenu$p(WindowService $this, FXGLScene fXGLScene) {
        $this.gameMenu = fXGLScene;
    }

    public static final /* synthetic */ PauseMenu access$getPauseMenu$p(WindowService $this) {
        return $this.pauseMenu;
    }

    public static final /* synthetic */ void access$setPauseMenu$p(WindowService $this, PauseMenu pauseMenu) {
        $this.pauseMenu = pauseMenu;
    }
}

