/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.views;

import com.almasb.fxgl.app.scene.Viewport;
import com.almasb.fxgl.core.View;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.texture.Texture;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\bH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/almasb/fxgl/dsl/views/ScrollingBackgroundView;", "Ljavafx/scene/Parent;", "Lcom/almasb/fxgl/core/View;", "texture", "Lcom/almasb/fxgl/texture/Texture;", "orientation", "Ljavafx/geometry/Orientation;", "speed", "", "(Lcom/almasb/fxgl/texture/Texture;Ljavafx/geometry/Orientation;D)V", "canvas", "Ljavafx/scene/canvas/Canvas;", "g", "Ljavafx/scene/canvas/GraphicsContext;", "image", "Ljavafx/scene/image/Image;", "kotlin.jvm.PlatformType", "getOrientation", "()Ljavafx/geometry/Orientation;", "getSpeed", "()D", "sx", "sy", "dispose", "", "getNode", "Ljavafx/scene/Node;", "onUpdate", "tpf", "redraw", "redrawX", "redrawY", "fxgl"})
public final class ScrollingBackgroundView
extends Parent
implements View {
    private final Canvas canvas;
    private final GraphicsContext g;
    private final Image image;
    private double sx;
    private double sy;
    @NotNull
    private final Orientation orientation;
    private final double speed;

    private final void redraw() {
        this.g.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (this.orientation == Orientation.HORIZONTAL) {
            this.redrawX();
        } else {
            this.redrawY();
        }
    }

    private final void redrawX() {
        boolean overflowX;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        Image image = this.image;
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        boolean bl = overflowX = this.sx + w > image.getWidth();
        if (overflowX) {
            Image image2 = this.image;
            Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"image");
            w = image2.getWidth() - this.sx;
        }
        this.g.drawImage(this.image, this.sx, this.sy, w, h, 0.0, 0.0, w, h);
        if (overflowX) {
            this.g.drawImage(this.image, 0.0, 0.0, this.canvas.getWidth() - w, h, w, 0.0, this.canvas.getWidth() - w, h);
        }
    }

    private final void redrawY() {
        boolean overflowY;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        Image image = this.image;
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        boolean bl = overflowY = this.sy + h > image.getHeight();
        if (overflowY) {
            Image image2 = this.image;
            Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"image");
            h = image2.getHeight() - this.sy;
        }
        this.g.drawImage(this.image, this.sx, this.sy, w, h, 0.0, 0.0, w, h);
        if (overflowY) {
            this.g.drawImage(this.image, 0.0, 0.0, w, this.canvas.getHeight() - h, 0.0, h, w, this.canvas.getHeight() - h);
        }
    }

    public void onUpdate(double tpf) {
    }

    @NotNull
    public Node getNode() {
        return (Node)this;
    }

    public void dispose() {
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final double getSpeed() {
        return this.speed;
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture, @NotNull Orientation orientation, double speed) {
        Intrinsics.checkParameterIsNotNull((Object)texture, (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)orientation, (String)"orientation");
        this.orientation = orientation;
        this.speed = speed;
        this.image = texture.getImage();
        Viewport viewport = FXGL.Companion.getGameScene().getViewport();
        this.canvas = new Canvas(viewport.getWidth(), viewport.getHeight());
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphicsContext, (String)"canvas.graphicsContext2D");
        this.g = graphicsContext;
        if (this.orientation == Orientation.HORIZONTAL) {
            this.translateXProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number x) {
                    double d = x.doubleValue() * this.getSpeed();
                    Image image = image;
                    Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
                    sx = d % image.getWidth();
                    if (sx < 0.0) {
                        ScrollingBackgroundView scrollingBackgroundView = this;
                        double d2 = scrollingBackgroundView.sx;
                        Image image2 = image;
                        Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"image");
                        scrollingBackgroundView.sx = d2 + image2.getWidth();
                    }
                    this.redraw();
                }
            });
            this.translateXProperty().bind((ObservableValue)viewport.xProperty());
        } else {
            this.translateYProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number y) {
                    double d = y.doubleValue() * this.getSpeed();
                    Image image = image;
                    Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
                    sy = d % image.getHeight();
                    if (sy < 0.0) {
                        ScrollingBackgroundView scrollingBackgroundView = this;
                        double d2 = scrollingBackgroundView.sy;
                        Image image2 = image;
                        Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"image");
                        scrollingBackgroundView.sy = d2 + image2.getHeight();
                    }
                    this.redraw();
                }
            });
            this.translateYProperty().bind((ObservableValue)viewport.yProperty());
        }
        Collection collection = (Collection)this.getChildren();
        Canvas canvas = this.canvas;
        boolean bl = false;
        collection.add(canvas);
        this.redraw();
    }

    public /* synthetic */ ScrollingBackgroundView(Texture texture, Orientation orientation, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            orientation = Orientation.HORIZONTAL;
        }
        if ((n & 4) != 0) {
            d = 1.0;
        }
        this(texture, orientation, d);
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture, @NotNull Orientation orientation) {
        this(texture, orientation, 0.0, 4, null);
    }

    @JvmOverloads
    public ScrollingBackgroundView(@NotNull Texture texture) {
        this(texture, null, 0.0, 6, null);
    }
}

