/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.Engine;
import com.almasb.fxgl.app.GameSettings;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.RuntimeInfo;
import com.almasb.fxgl.app.scene.StartupScene;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.core.util.Platform;
import com.almasb.fxgl.dev.profiling.ProfilerService;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.logging.ConsoleOutput;
import com.almasb.fxgl.logging.FileOutput;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.LoggerConfig;
import com.almasb.fxgl.logging.LoggerLevel;
import com.almasb.fxgl.logging.LoggerOutput;
import com.almasb.fxgl.profile.DataFile;
import com.almasb.fxgl.profile.SaveLoadHandler;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactoryService;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Application;
import javafx.concurrent.Task;
import javafx.stage.Stage;

public abstract class GameApplication {
    private static final Logger log = Logger.get(GameApplication.class);

    public static void launch(String[] args) {
        try {
            GameApplication instance = GameApplication.newInstance();
            GameApplication.launch(instance, args);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
        }
    }

    public static void launch(Class<? extends GameApplication> appClass, String[] args) {
        try {
            GameApplication instance = (GameApplication)ReflectionUtils.newInstance(appClass);
            GameApplication.launch(instance, args);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
        }
    }

    public static void customLaunch(GameApplication app, Stage stage) {
        try {
            ReadOnlyGameSettings settings = app.takeUserSettings();
            app.initLogger(settings);
            FXGLApplication.customLaunchFX(app, settings, stage);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
        }
    }

    private static void launch(GameApplication app, String[] args) {
        ReadOnlyGameSettings settings = app.takeUserSettings();
        app.initLogger(settings);
        if (settings.isLinux()) {
            System.setProperty("quantum.multithreaded", "false");
        }
        FXGLApplication.launchFX(app, settings, args);
    }

    private static GameApplication newInstance() {
        Class appClass = ReflectionUtils.getCallingClass(GameApplication.class, (String)"launch");
        return (GameApplication)ReflectionUtils.newInstance((Class)appClass);
    }

    private static void printErrorAndExit(Exception e) {
        System.out.println("Error during launch:");
        e.printStackTrace();
        System.out.println("Application will now exit");
        System.exit(-1);
    }

    private ReadOnlyGameSettings takeUserSettings() {
        GameSettings localSettings = new GameSettings();
        this.initSettings(localSettings);
        if (localSettings.isProfilingEnabled()) {
            localSettings.getEngineServices().add(ProfilerService.class);
        }
        Platform platform = Platform.get();
        if (localSettings.getRuntimeInfo().getPlatform().isBrowser()) {
            platform = Platform.BROWSER;
        }
        RuntimeInfo runtimeInfo = new RuntimeInfo(platform, "11.9", "27.05.2020 17.06");
        localSettings.setRuntimeInfo(runtimeInfo);
        localSettings.setExperimentalNative(localSettings.isExperimentalNative() || platform.isMobile());
        return localSettings.toReadOnly();
    }

    private void initLogger(ReadOnlyGameSettings settings) {
        Logger.configure((LoggerConfig)new LoggerConfig());
        if (settings.isDesktop() && !settings.isExperimentalNative()) {
            Logger.addOutput((LoggerOutput)new FileOutput("FXGL"), (LoggerLevel)LoggerLevel.DEBUG);
        }
        Logger.addOutput((LoggerOutput)new ConsoleOutput(), (LoggerLevel)settings.getApplicationMode().getLoggerLevel());
        log.debug("Logger initialized");
        log.debug("Logging settings\n" + settings);
    }

    protected abstract void initSettings(GameSettings var1);

    protected void onPreInit() {
    }

    protected void initInput() {
    }

    protected void initGameVars(Map<String, Object> vars) {
    }

    protected void initGame() {
    }

    protected void initPhysics() {
    }

    protected void initUI() {
    }

    protected void onUpdate(double tpf) {
    }

    public static class InitAppTask
    extends Task<Void> {
        private GameApplication app = FXGLApplication.app;

        protected Void call() throws Exception {
            long start = System.nanoTime();
            log.debug("Initializing game");
            this.updateMessage("Initializing game");
            this.initGame();
            this.app.initPhysics();
            this.app.initUI();
            FXGLApplication.engine.onGameReady(FXGL.getWorldProperties());
            log.infof("Game initialization took: %.3f sec", new Object[]{(double)(System.nanoTime() - start) / 1.0E9});
            return null;
        }

        private void initGame() {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            this.app.initGameVars(vars);
            vars.forEach((name, value) -> FXGL.getWorldProperties().setValue(name, value));
            this.app.initGame();
        }

        protected void failed() {
            throw new RuntimeException("Initialization failed", this.getException());
        }
    }

    public static class GameApplicationService
    extends EngineService {
        private GameApplication app = FXGLApplication.app;

        public void onMainLoopStarting() {
            this.app.initInput();
            this.app.onPreInit();
        }

        public void onGameUpdate(double tpf) {
            this.app.onUpdate(tpf);
        }
    }

    public static final class FXGLApplication
    extends Application {
        public static GameApplication app;
        private static ReadOnlyGameSettings settings;
        private static Engine engine;
        private MainWindow mainWindow;
        private boolean isError = false;

        public void start(Stage stage) {
            Thread.setDefaultUncaughtExceptionHandler((thread, e) -> this.handleFatalError(e));
            log.debug("Initializing FXGL");
            engine = new Engine(settings);
            FXGL.inject$fxgl(engine, app, this);
            StartupScene startupScene = settings.getSceneFactory().newStartup();
            this.mainWindow = new MainWindow(stage, startupScene, settings);
            this.mainWindow.show();
            engine.getEnvironmentVars$fxgl().put("settings", settings);
            engine.getEnvironmentVars$fxgl().put("mainWindow", this.mainWindow);
            Task task2 = IOTask.ofVoid(() -> {
                engine.initServices();
                this.postServicesInit();
            }).onSuccess(n -> engine.startLoop()).onFailure(e -> this.handleFatalError((Throwable)e)).toJavaFXTask();
            Async.INSTANCE.execute((Runnable)task2);
        }

        private void postServicesInit() {
            this.initPauseResumeHandler();
            this.initSaveLoadHandler();
            this.initAndLoadLocalization();
            this.initAndRegisterFontFactories();
            FXGL.getGameScene().addListener(tpf -> engine.onGameUpdate(tpf));
        }

        private void initPauseResumeHandler() {
            if (!settings.isMobile()) {
                this.mainWindow.iconifiedProperty().addListener((obs, o, isMinimized) -> {
                    if (isMinimized.booleanValue()) {
                        engine.pauseLoop();
                    } else {
                        engine.resumeLoop();
                    }
                });
            }
        }

        private void initSaveLoadHandler() {
            FXGL.getSaveLoadService().addHandler(new SaveLoadHandler(){

                public void onSave(DataFile data) {
                    Bundle bundle = new Bundle("FXGLServices");
                    engine.write(bundle);
                    data.putBundle(bundle);
                }

                public void onLoad(DataFile data) {
                    Bundle bundle = data.getBundle("FXGLServices");
                    engine.read(bundle);
                }
            });
        }

        private void initAndLoadLocalization() {
            log.debug("Loading localizations");
            settings.getSupportedLanguages().forEach(lang -> {
                PropertyMap pMap = FXGL.getAssetLoader().loadPropertyMap("languages/" + lang.getName().toLowerCase() + ".lang");
                FXGL.getLocalizationService().addLanguageData(lang, pMap.toStringMap());
            });
            FXGL.getLocalizationService().selectedLanguageProperty().bind(settings.getLanguage());
        }

        private void initAndRegisterFontFactories() {
            log.debug("Registering font factories with UI factory");
            UIFactoryService uiFactory = FXGL.getUIFactoryService();
            uiFactory.registerFontFactory(FontType.UI, FXGL.getAssetLoader().loadFont(settings.getFontUI()));
            uiFactory.registerFontFactory(FontType.GAME, FXGL.getAssetLoader().loadFont(settings.getFontGame()));
            uiFactory.registerFontFactory(FontType.MONO, FXGL.getAssetLoader().loadFont(settings.getFontMono()));
            uiFactory.registerFontFactory(FontType.TEXT, FXGL.getAssetLoader().loadFont(settings.getFontText()));
        }

        private void handleFatalError(Throwable error) {
            if (this.isError) {
                return;
            }
            this.isError = true;
            engine.stopLoop();
            log.fatal("Uncaught Exception:", error);
            log.fatal("Application will now exit");
            if (this.mainWindow != null) {
                this.mainWindow.showFatalError(error, this::exitFXGL);
            } else {
                this.exitFXGL();
            }
        }

        public void exitFXGL() {
            log.debug("Exiting FXGL");
            if (engine != null && !this.isError) {
                engine.stopLoopAndExitServices();
            }
            log.debug("Shutting down background threads");
            Async.INSTANCE.shutdownNow();
            log.debug("Closing logger and exiting JavaFX");
            Logger.close();
            javafx.application.Platform.exit();
        }

        static void launchFX(GameApplication app, ReadOnlyGameSettings settings, String[] args) {
            FXGLApplication.app = app;
            FXGLApplication.settings = settings;
            FXGLApplication.launch((String[])args);
        }

        static void customLaunchFX(GameApplication app, ReadOnlyGameSettings settings, Stage stage) {
            FXGLApplication.app = app;
            FXGLApplication.settings = settings;
            new FXGLApplication().start(stage);
        }
    }
}

