/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.io.FileSystemService;
import com.almasb.fxgl.logging.Logger;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/app/services/SystemBundleService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "getBundle$fxgl", "()Lcom/almasb/fxgl/core/serialization/Bundle;", "setBundle$fxgl", "(Lcom/almasb/fxgl/core/serialization/Bundle;)V", "fs", "Lcom/almasb/fxgl/io/FileSystemService;", "isExperimentalNative", "", "log", "Lcom/almasb/fxgl/logging/Logger;", "createRequiredDirs", "", "loadDefaultSystemData", "loadSystemData", "onExit", "onInit", "saveSystemData", "fxgl"})
public final class SystemBundleService
extends EngineService {
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    @Inject(value="isExperimentalNative")
    private boolean isExperimentalNative;
    private FileSystemService fs;
    @NotNull
    public Bundle bundle;

    @NotNull
    public final Bundle getBundle$fxgl() {
        Bundle bundle = this.bundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        return bundle;
    }

    public final void setBundle$fxgl(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"<set-?>");
        this.bundle = bundle;
    }

    public void onInit() {
        boolean isFirstRun;
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        boolean bl = isFirstRun = !fileSystemService.exists("system/");
        if (!this.isExperimentalNative) {
            if (isFirstRun) {
                this.createRequiredDirs();
                this.loadDefaultSystemData();
            } else {
                this.loadSystemData();
            }
        } else {
            this.loadDefaultSystemData();
        }
    }

    public void onExit() {
        if (!this.isExperimentalNative) {
            this.saveSystemData();
        }
    }

    private final void createRequiredDirs() {
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        fileSystemService.createDirectoryTask("system/").then(new Function<T, IOTask<R>>(this){
            final /* synthetic */ SystemBundleService this$0;

            public final IOTask<Void> apply(Void it) {
                return SystemBundleService.access$getFs$p(this.this$0).writeDataTask(CollectionsKt.listOf((Object)"This directory contains FXGL system data files."), "system/Readme.txt");
            }
            {
                this.this$0 = systemBundleService;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ SystemBundleService this$0;

            public final void accept(Throwable e) {
                SystemBundleService.access$getLog$p(this.this$0).warning("Failed to create system dir: " + e);
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
            {
                this.this$0 = systemBundleService;
            }
        }).run();
    }

    private final void saveSystemData() {
        this.log.debug("Saving FXGL system data");
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        Bundle bundle = this.bundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        fileSystemService.writeDataTask((Serializable)bundle, "system/fxgl.bundle").onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ SystemBundleService this$0;

            public final void accept(Throwable it) {
                SystemBundleService.access$getLog$p(this.this$0).warning("Failed to save: " + it);
            }
            {
                this.this$0 = systemBundleService;
            }
        }).run();
    }

    private final void loadSystemData() {
        this.log.debug("Loading FXGL system data");
        FileSystemService fileSystemService = this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        fileSystemService.readDataTask("system/fxgl.bundle").onSuccess((Consumer)new Consumer<Bundle>(this){
            final /* synthetic */ SystemBundleService this$0;

            public final void accept(Bundle it) {
                Bundle bundle = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"it");
                this.this$0.setBundle$fxgl(bundle);
                SystemBundleService.access$getLog$p(this.this$0).debug(String.valueOf(this.this$0.getBundle$fxgl()));
            }
            {
                this.this$0 = systemBundleService;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ SystemBundleService this$0;

            public final void accept(Throwable it) {
                SystemBundleService.access$getLog$p(this.this$0).warning("Failed to load: " + it);
                SystemBundleService.access$loadDefaultSystemData(this.this$0);
            }
            {
                this.this$0 = systemBundleService;
            }
        }).run();
    }

    private final void loadDefaultSystemData() {
        this.log.debug("Loading default FXGL system data");
        this.bundle = new Bundle("FXGL");
    }

    public static final /* synthetic */ FileSystemService access$getFs$p(SystemBundleService $this) {
        FileSystemService fileSystemService = $this.fs;
        if (fileSystemService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fs");
        }
        return fileSystemService;
    }

    public static final /* synthetic */ void access$setFs$p(SystemBundleService $this, FileSystemService fileSystemService) {
        $this.fs = fileSystemService;
    }

    public static final /* synthetic */ Logger access$getLog$p(SystemBundleService $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$loadDefaultSystemData(SystemBundleService $this) {
        $this.loadDefaultSystemData();
    }
}

