/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.components;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lcom/almasb/fxgl/dsl/components/RandomMoveComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "bounds", "Ljavafx/geometry/Rectangle2D;", "moveSpeed", "", "tx", "(Ljavafx/geometry/Rectangle2D;DD)V", "angleAdjustRate", "getBounds", "()Ljavafx/geometry/Rectangle2D;", "setBounds", "(Ljavafx/geometry/Rectangle2D;)V", "directionAngle", "getDirectionAngle", "()D", "setDirectionAngle", "(D)V", "getMoveSpeed", "setMoveSpeed", "rotationSpeed", "", "getTx", "setTx", "velocity", "Lcom/almasb/fxgl/core/math/Vec2;", "getVelocity", "()Lcom/almasb/fxgl/core/math/Vec2;", "adjustAngle", "", "tpf", "checkBounds", "move", "onUpdate", "rotate", "fxgl"})
public final class RandomMoveComponent
extends Component {
    private final double angleAdjustRate;
    @NotNull
    private final Vec2 velocity;
    private double directionAngle;
    private final int rotationSpeed;
    @NotNull
    private Rectangle2D bounds;
    private double moveSpeed;
    private double tx;

    @NotNull
    public final Vec2 getVelocity() {
        return this.velocity;
    }

    public final double getDirectionAngle() {
        return this.directionAngle;
    }

    public final void setDirectionAngle(double d) {
        this.directionAngle = d;
    }

    public void onUpdate(double tpf) {
        this.adjustAngle(tpf);
        this.move(tpf);
        this.rotate(tpf);
        this.tx += tpf;
        this.checkBounds();
    }

    private final void adjustAngle(double tpf) {
        if (FXGLMath.randomBoolean((double)this.angleAdjustRate)) {
            this.directionAngle += FXGLMath.toDegrees((double)(FXGLMath.noise1D((double)this.tx) - 0.5));
        }
    }

    private final void move(double tpf) {
        Vec2 directionVector = Vec2.fromAngle((double)this.directionAngle).mulLocal(this.moveSpeed);
        this.velocity.addLocal(directionVector).mulLocal(tpf);
        this.entity.translate(this.velocity);
    }

    private final void checkBounds() {
        block3: {
            Point2D newDirectionVector;
            block2: {
                Entity entity = this.entity;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"entity");
                if (entity.getX() < this.bounds.getMinX()) break block2;
                Entity entity2 = this.entity;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"entity");
                if (entity2.getY() < this.bounds.getMinY()) break block2;
                Entity entity3 = this.entity;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity3, (String)"entity");
                if (entity3.getRightX() >= this.bounds.getMaxX()) break block2;
                Entity entity4 = this.entity;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity4, (String)"entity");
                if (!(entity4.getBottomY() >= this.bounds.getMaxY())) break block3;
            }
            Point2D point2D = new Point2D((this.bounds.getMinX() + this.bounds.getMaxX()) / (double)2, (this.bounds.getMinY() + this.bounds.getMaxY()) / (double)2);
            Entity entity = this.entity;
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"entity");
            Point2D point2D2 = newDirectionVector = point2D.subtract(entity.getCenter());
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D2, (String)"newDirectionVector");
            double angle = FXGLMath.toDegrees((double)Math.atan(point2D2.getY() / newDirectionVector.getX()));
            this.directionAngle = newDirectionVector.getX() > 0.0 ? angle : (double)180 + angle;
        }
    }

    private final void rotate(double tpf) {
        this.entity.rotateBy((double)this.rotationSpeed * tpf);
    }

    @NotNull
    public final Rectangle2D getBounds() {
        return this.bounds;
    }

    public final void setBounds(@NotNull Rectangle2D rectangle2D) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle2D, (String)"<set-?>");
        this.bounds = rectangle2D;
    }

    public final double getMoveSpeed() {
        return this.moveSpeed;
    }

    public final void setMoveSpeed(double d) {
        this.moveSpeed = d;
    }

    public final double getTx() {
        return this.tx;
    }

    public final void setTx(double d) {
        this.tx = d;
    }

    @JvmOverloads
    public RandomMoveComponent(@NotNull Rectangle2D bounds, double moveSpeed, double tx) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        this.bounds = bounds;
        this.moveSpeed = moveSpeed;
        this.tx = tx;
        this.angleAdjustRate = FXGLForKtKt.random(0.0, 0.5);
        this.velocity = new Vec2();
        this.directionAngle = FXGLMath.toDegrees((double)((double)FXGLForKtKt.random(-1, 1) * (Math.PI * 2)));
        this.rotationSpeed = FXGLForKtKt.random(-100, 100);
    }

    public /* synthetic */ RandomMoveComponent(Rectangle2D rectangle2D, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = FXGLForKtKt.random(100, 10000);
        }
        this(rectangle2D, d, d2);
    }

    @JvmOverloads
    public RandomMoveComponent(@NotNull Rectangle2D bounds, double moveSpeed) {
        this(bounds, moveSpeed, 0.0, 4, null);
    }
}

