/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.effects;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.dsl.components.Effect;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.texture.Texture;
import java.util.ArrayList;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0013j\b\u0012\u0004\u0012\u00020\u0003`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/almasb/fxgl/dsl/effects/WobbleEffect;", "Lcom/almasb/fxgl/dsl/components/Effect;", "texture", "Lcom/almasb/fxgl/texture/Texture;", "duration", "Ljavafx/util/Duration;", "radius", "", "numChunks", "orientation", "Ljavafx/geometry/Orientation;", "(Lcom/almasb/fxgl/texture/Texture;Ljavafx/util/Duration;IILjavafx/geometry/Orientation;)V", "newView", "Ljavafx/scene/Group;", "getNumChunks", "()I", "getOrientation", "()Ljavafx/geometry/Orientation;", "quads", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getRadius", "getTexture", "()Lcom/almasb/fxgl/texture/Texture;", "tick", "onEnd", "", "entity", "Lcom/almasb/fxgl/entity/Entity;", "onStart", "onUpdate", "tpf", "", "fxgl"})
public final class WobbleEffect
extends Effect {
    private final ArrayList<Texture> quads;
    private final Group newView;
    private int tick;
    @NotNull
    private final Texture texture;
    private final int radius;
    private final int numChunks;
    @NotNull
    private final Orientation orientation;

    @Override
    public void onStart(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.tick = 0;
        Iterable $this$forEach$iv = entity.getViewComponent().getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.setVisible(false);
        }
        ViewComponent.addChild$default((ViewComponent)entity.getViewComponent(), (Node)((Node)this.newView), (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(@NotNull Entity entity, double tpf) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        ++this.tick;
        Iterable $this$forEachIndexed$iv = this.quads;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void quad;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Texture texture = (Texture)item$iv;
            int index = n2;
            boolean bl2 = false;
            double value = FXGLMath.sin((double)((double)this.tick + (double)index / 0.5)) * (double)this.radius;
            if (this.orientation == Orientation.HORIZONTAL) {
                quad.setTranslateX(value);
                continue;
            }
            quad.setTranslateY(value);
        }
    }

    @Override
    public void onEnd(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        entity.getViewComponent().removeChild((Node)this.newView);
        Iterable $this$forEach$iv = entity.getViewComponent().getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.setVisible(true);
        }
    }

    @NotNull
    public final Texture getTexture() {
        return this.texture;
    }

    public final int getRadius() {
        return this.radius;
    }

    public final int getNumChunks() {
        return this.numChunks;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public WobbleEffect(@NotNull Texture texture, @NotNull Duration duration, int radius, int numChunks, @NotNull Orientation orientation) {
        double d;
        Intrinsics.checkParameterIsNotNull((Object)texture, (String)"texture");
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        Intrinsics.checkParameterIsNotNull((Object)orientation, (String)"orientation");
        super(duration);
        this.texture = texture;
        this.radius = radius;
        this.numChunks = numChunks;
        this.orientation = orientation;
        WobbleEffect wobbleEffect = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        wobbleEffect.quads = arrayList;
        this.newView = new Group();
        if (this.orientation == Orientation.HORIZONTAL) {
            Image image = this.texture.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"texture.image");
            d = image.getHeight() / (double)this.numChunks;
        } else {
            Image image = this.texture.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"texture.image");
            d = image.getWidth() / (double)this.numChunks;
        }
        double chunkSizeDouble = d;
        double chunkSize = (int)chunkSizeDouble;
        int n = 0;
        int n2 = this.numChunks;
        while (n < n2) {
            void i2;
            Texture quad = null;
            if (this.orientation == Orientation.HORIZONTAL) {
                double d2 = (double)i2 * chunkSize;
                Image image = this.texture.getImage();
                Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"texture.image");
                quad = this.texture.subTexture(new Rectangle2D(0.0, d2, image.getWidth(), chunkSize));
                quad.setTranslateY((double)i2 * chunkSize);
            } else {
                double d3 = (double)i2 * chunkSize;
                Image image = this.texture.getImage();
                Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"texture.image");
                quad = this.texture.subTexture(new Rectangle2D(d3, 0.0, chunkSize, image.getHeight()));
                quad.setTranslateX((double)i2 * chunkSize);
            }
            this.quads.add(quad);
            this.newView.getChildren().add((Object)quad);
            ++i2;
        }
    }

    public /* synthetic */ WobbleEffect(Texture texture, Duration duration, int n, int n2, Orientation orientation, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 2;
        }
        if ((n3 & 8) != 0) {
            n2 = 5;
        }
        if ((n3 & 0x10) != 0) {
            orientation = Orientation.HORIZONTAL;
        }
        this(texture, duration, n, n2, orientation);
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Texture texture, @NotNull Duration duration, int radius, int numChunks) {
        this(texture, duration, radius, numChunks, null, 16, null);
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Texture texture, @NotNull Duration duration, int radius) {
        this(texture, duration, radius, 0, null, 24, null);
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Texture texture, @NotNull Duration duration) {
        this(texture, duration, 0, 0, null, 28, null);
    }
}

