/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene3d;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.scene3d.CustomShape3D;
import java.util.Arrays;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.TriangleMesh;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u0014J\u0006\u0010\u001c\u001a\u00020\u0014R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/scene3d/Torus;", "Lcom/almasb/fxgl/scene3d/CustomShape3D;", "radius", "", "tubeRadius", "numDivisions", "", "(DDI)V", "value", "getNumDivisions", "()I", "setNumDivisions", "(I)V", "numDivisionsProp", "Ljavafx/beans/property/SimpleIntegerProperty;", "getRadius", "()D", "setRadius", "(D)V", "radiusProp", "Ljavafx/beans/property/SimpleDoubleProperty;", "getTubeRadius", "setTubeRadius", "tubeRadiusProp", "createMesh", "Ljavafx/scene/shape/Mesh;", "numDivisionsProperty", "radiusProperty", "tubeRadiusProperty", "fxgl"})
public final class Torus
extends CustomShape3D {
    @NotNull
    private final SimpleDoubleProperty radiusProp;
    @NotNull
    private final SimpleDoubleProperty tubeRadiusProp;
    @NotNull
    private final SimpleIntegerProperty numDivisionsProp;

    @JvmOverloads
    public Torus(double radius, double tubeRadius, int numDivisions) {
        this.radiusProp = this.newDoubleProperty(radius);
        this.tubeRadiusProp = this.newDoubleProperty(tubeRadius);
        this.numDivisionsProp = this.newIntProperty(numDivisions < 3 ? 3 : numDivisions);
        this.updateMesh();
    }

    public /* synthetic */ Torus(double d, double d2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            d = 0.6;
        }
        if ((n2 & 2) != 0) {
            d2 = d * 2.0 / 3.0;
        }
        if ((n2 & 4) != 0) {
            n = 64;
        }
        this(d, d2, n);
    }

    public final double getRadius() {
        Double d = this.radiusProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"radiusProp.value");
        return ((Number)d).doubleValue();
    }

    public final void setRadius(double value) {
        this.radiusProp.setValue((Number)value);
    }

    public final double getTubeRadius() {
        Double d = this.tubeRadiusProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"tubeRadiusProp.value");
        return ((Number)d).doubleValue();
    }

    public final void setTubeRadius(double value) {
        this.tubeRadiusProp.setValue((Number)value);
    }

    public final int getNumDivisions() {
        Integer n = this.numDivisionsProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"numDivisionsProp.value");
        return ((Number)n).intValue();
    }

    public final void setNumDivisions(int value) {
        this.numDivisionsProp.setValue((Number)value);
    }

    @NotNull
    public final SimpleDoubleProperty radiusProperty() {
        return this.radiusProp;
    }

    @NotNull
    public final SimpleDoubleProperty tubeRadiusProperty() {
        return this.tubeRadiusProp;
    }

    @NotNull
    public final SimpleIntegerProperty numDivisionsProperty() {
        return this.numDivisionsProp;
    }

    @Override
    @NotNull
    protected Mesh createMesh() {
        int tubeIndex;
        int radiusDivisions = this.getNumDivisions();
        int tubeDivisions = this.getNumDivisions();
        float R = (float)this.getRadius();
        float tR = (float)this.getTubeRadius();
        float tubeStartAngle = 0.0f;
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        float zOffset = 1.0f;
        int numVerts = tubeDivisions * radiusDivisions;
        int faceCount = numVerts * 2;
        float[] points = new float[numVerts * 3];
        float[] tPoints = new float[numVerts * 2];
        int[] faces = new int[faceCount * 6];
        int pPos = 0;
        int tPos = 0;
        float tubeFraction = 1.0f / (float)tubeDivisions;
        float radiusFraction = 1.0f / (float)radiusDivisions;
        int n = 0;
        while (n < tubeDivisions) {
            tubeIndex = n++;
            double radian = (double)tubeStartAngle + (double)(tubeFraction * (float)tubeIndex) * (Math.PI * 2);
            int n2 = 0;
            while (n2 < radiusDivisions) {
                int radiusIndex = n2++;
                double localRadian = (double)(radiusFraction * (float)radiusIndex) * (Math.PI * 2);
                points[pPos + 0] = (R + tR * FXGLMath.cosF((double)radian)) * (FXGLMath.cosF((double)localRadian) + xOffset);
                points[pPos + 1] = (R + tR * FXGLMath.cosF((double)radian)) * (FXGLMath.sinF((double)localRadian) + yOffset);
                points[pPos + 2] = tR * FXGLMath.sinF((double)radian) * zOffset;
                pPos += 3;
                double r = radiusIndex < tubeDivisions ? (double)(tubeFraction * (float)radiusIndex) * (Math.PI * 2) : 0.0;
                tPoints[tPos + 0] = FXGLMath.sinF((double)r) * 0.5f + 0.5f;
                tPoints[tPos + 1] = FXGLMath.cosF((double)r) * 0.5f + 0.5f;
                tPos += 2;
            }
        }
        int fIndex = 0;
        tubeIndex = 0;
        while (tubeIndex < tubeDivisions) {
            int point = tubeIndex++;
            int n3 = 0;
            while (n3 < radiusDivisions) {
                int crossSection;
                int p0;
                int p1 = (p0 = point * radiusDivisions + (crossSection = n3++)) >= 0 ? p0 + 1 : p0 - radiusDivisions;
                p1 = p1 % radiusDivisions != 0 ? p0 + 1 : p0 + 1 - radiusDivisions;
                int p0r = p0 + radiusDivisions;
                int p2 = p0r < numVerts ? p0r : p0r - numVerts;
                int p3 = p2 < numVerts - 1 ? p2 + 1 : p2 + 1 - numVerts;
                p3 = p3 % radiusDivisions != 0 ? p2 + 1 : p2 + 1 - radiusDivisions;
                faces[fIndex + 0] = p2;
                faces[fIndex + 1] = p3;
                faces[fIndex + 2] = p0;
                faces[fIndex + 3] = p2;
                faces[fIndex + 4] = p1;
                faces[fIndex + 5] = p0;
                faces[(fIndex += 6) + 0] = p2;
                faces[fIndex + 1] = p3;
                faces[fIndex + 2] = p1;
                faces[fIndex + 3] = p0;
                faces[fIndex + 4] = p3;
                faces[fIndex + 5] = p1;
                fIndex += 6;
            }
        }
        TriangleMesh mesh = new TriangleMesh();
        mesh.getPoints().setAll(Arrays.copyOf(points, points.length));
        mesh.getTexCoords().setAll(Arrays.copyOf(tPoints, tPoints.length));
        mesh.getFaces().setAll(Arrays.copyOf(faces, faces.length));
        return (Mesh)mesh;
    }

    @JvmOverloads
    public Torus(double radius, double tubeRadius) {
        this(radius, tubeRadius, 0, 4, null);
    }

    @JvmOverloads
    public Torus(double radius) {
        this(radius, 0.0, 0, 6, null);
    }

    @JvmOverloads
    public Torus() {
        this(0.0, 0.0, 0, 7, null);
    }
}

