/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.views;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020!H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020!H\u0016J\u0010\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020!H\u0016R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010\u001eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001e\u00a8\u0006."}, d2={"Lcom/almasb/fxgl/dsl/views/MinimapView;", "Ljavafx/scene/Parent;", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "world", "Lcom/almasb/fxgl/entity/GameWorld;", "worldWidth", "", "worldHeight", "width", "height", "(Lcom/almasb/fxgl/entity/GameWorld;DDDD)V", "value", "Ljavafx/scene/paint/Color;", "backgroundColor", "getBackgroundColor", "()Ljavafx/scene/paint/Color;", "setBackgroundColor", "(Ljavafx/scene/paint/Color;)V", "bg", "Ljavafx/scene/shape/Rectangle;", "bgColorProp", "Ljavafx/beans/property/SimpleObjectProperty;", "entityColor", "getEntityColor", "setEntityColor", "entityColorProp", "entitySize", "getEntitySize", "()D", "setEntitySize", "(D)V", "entityViews", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/entity/Entity;", "Ljavafx/scene/shape/Shape;", "Lkotlin/collections/HashMap;", "getWorldHeight", "setWorldHeight", "getWorldWidth", "setWorldWidth", "createView", "e", "onEntityAdded", "", "entity", "onEntityRemoved", "fxgl"})
@SourceDebugExtension(value={"SMAP\nMinimapView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinimapView.kt\ncom/almasb/fxgl/dsl/views/MinimapView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1855#2,2:86\n1#3:88\n*S KotlinDebug\n*F\n+ 1 MinimapView.kt\ncom/almasb/fxgl/dsl/views/MinimapView\n*L\n55#1:86,2\n*E\n"})
public final class MinimapView
extends Parent
implements EntityWorldListener {
    @NotNull
    private final GameWorld world;
    private double worldWidth;
    private double worldHeight;
    private final double width;
    private final double height;
    @NotNull
    private final HashMap<Entity, Shape> entityViews;
    @NotNull
    private final Rectangle bg;
    @NotNull
    private final SimpleObjectProperty<Color> bgColorProp;
    @NotNull
    private final SimpleObjectProperty<Color> entityColorProp;
    private double entitySize;

    public MinimapView(@NotNull GameWorld world, double worldWidth, double worldHeight, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.worldWidth = worldWidth;
        this.worldHeight = worldHeight;
        this.width = width;
        this.height = height;
        this.entityViews = new HashMap();
        this.bg = new Rectangle(this.width, this.height);
        this.bgColorProp = new SimpleObjectProperty((Object)Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.7));
        this.entityColorProp = new SimpleObjectProperty((Object)Color.RED);
        this.entitySize = 4.0;
        this.bg.fillProperty().bind((ObservableValue)this.bgColorProp);
        this.bg.setStroke((Paint)Color.BLACK);
        ObservableList observableList = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"children");
        Collection collection = (Collection)observableList;
        collection.add(this.bg);
        Iterable $this$forEach$iv = this.world.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            this.onEntityAdded(it);
        }
        this.world.addWorldListener((EntityWorldListener)this);
    }

    public final double getWorldWidth() {
        return this.worldWidth;
    }

    public final void setWorldWidth(double d) {
        this.worldWidth = d;
    }

    public final double getWorldHeight() {
        return this.worldHeight;
    }

    public final void setWorldHeight(double d) {
        this.worldHeight = d;
    }

    @NotNull
    public final Color getBackgroundColor() {
        Object object = this.bgColorProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bgColorProp.value");
        return (Color)object;
    }

    public final void setBackgroundColor(@NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.bgColorProp.setValue((Object)value);
    }

    @NotNull
    public final Color getEntityColor() {
        Object object = this.entityColorProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entityColorProp.value");
        return (Color)object;
    }

    public final void setEntityColor(@NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.entityColorProp.setValue((Object)value);
    }

    public final double getEntitySize() {
        return this.entitySize;
    }

    public final void setEntitySize(double d) {
        this.entitySize = d;
    }

    public void onEntityAdded(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Shape view2 = this.createView(entity);
        ((Map)this.entityViews).put(entity, view2);
        ObservableList observableList = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"children");
        ((Collection)observableList).add(view2);
    }

    private final Shape createView(Entity e) {
        Rectangle rectangle;
        Rectangle it = rectangle = new Rectangle(this.entitySize, this.entitySize);
        boolean bl = false;
        Observable[] observableArray = new Observable[]{(Observable)e.xProperty()};
        it.translateXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> MinimapView.createView$lambda$3$lambda$1(e, this), (Observable[])observableArray));
        observableArray = new Observable[]{(Observable)e.yProperty()};
        it.translateYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> MinimapView.createView$lambda$3$lambda$2(e, this), (Observable[])observableArray));
        it.fillProperty().bind((ObservableValue)this.entityColorProp);
        return (Shape)rectangle;
    }

    public void onEntityRemoved(@NotNull Entity entity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Shape shape = this.entityViews.remove(entity);
            if (shape == null) break block0;
            Shape it = shape;
            boolean bl = false;
            ObservableList observableList = this.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"children");
            ((Collection)observableList).remove(it);
        }
    }

    private static final Double createView$lambda$3$lambda$1(Entity $e, MinimapView this$0) {
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return FXGLMath.map((double)$e.getX(), (double)0.0, (double)this$0.worldWidth, (double)0.0, (double)this$0.width);
    }

    private static final Double createView$lambda$3$lambda$2(Entity $e, MinimapView this$0) {
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return FXGLMath.map((double)$e.getY(), (double)0.0, (double)this$0.worldHeight, (double)0.0, (double)this$0.height);
    }
}

