/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene3d;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.scene3d.CustomShape3D;
import java.util.Arrays;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.TriangleMesh;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B/\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001c\u001a\u00020\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u000fR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u000b\"\u0004\b\u001a\u0010\rR\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/scene3d/Prism;", "Lcom/almasb/fxgl/scene3d/CustomShape3D;", "bottomRadius", "", "topRadius", "height", "numDivisions", "", "(DDDI)V", "value", "getBottomRadius", "()D", "setBottomRadius", "(D)V", "bottomRadiusProp", "Ljavafx/beans/property/SimpleDoubleProperty;", "getHeight", "setHeight", "heightProp", "getNumDivisions", "()I", "setNumDivisions", "(I)V", "numDivisionsProp", "Ljavafx/beans/property/SimpleIntegerProperty;", "getTopRadius", "setTopRadius", "topRadiusProp", "bottomRadiusProperty", "createMesh", "Ljavafx/scene/shape/Mesh;", "heightProperty", "numDivisionsProperty", "topRadiusProperty", "fxgl"})
public class Prism
extends CustomShape3D {
    @NotNull
    private final SimpleDoubleProperty bottomRadiusProp;
    @NotNull
    private final SimpleDoubleProperty topRadiusProp;
    @NotNull
    private final SimpleDoubleProperty heightProp;
    @NotNull
    private final SimpleIntegerProperty numDivisionsProp;

    @JvmOverloads
    public Prism(double bottomRadius, double topRadius, double height, int numDivisions) {
        this.bottomRadiusProp = this.newDoubleProperty(bottomRadius);
        this.topRadiusProp = this.newDoubleProperty(topRadius);
        this.heightProp = this.newDoubleProperty(height);
        this.numDivisionsProp = this.newIntProperty(numDivisions < 3 ? 3 : numDivisions);
        this.updateMesh();
    }

    public /* synthetic */ Prism(double d, double d2, double d3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            d = 1.0;
        }
        if ((n2 & 2) != 0) {
            d2 = 1.0;
        }
        if ((n2 & 4) != 0) {
            d3 = 2.0;
        }
        if ((n2 & 8) != 0) {
            n = 3;
        }
        this(d, d2, d3, n);
    }

    public final double getBottomRadius() {
        Double d = this.bottomRadiusProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"bottomRadiusProp.value");
        return ((Number)d).doubleValue();
    }

    public final void setBottomRadius(double value) {
        this.bottomRadiusProp.setValue((Number)value);
    }

    public final double getTopRadius() {
        Double d = this.topRadiusProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"topRadiusProp.value");
        return ((Number)d).doubleValue();
    }

    public final void setTopRadius(double value) {
        this.topRadiusProp.setValue((Number)value);
    }

    public final double getHeight() {
        Double d = this.heightProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"heightProp.value");
        return ((Number)d).doubleValue();
    }

    public final void setHeight(double value) {
        this.heightProp.setValue((Number)value);
    }

    public final int getNumDivisions() {
        Integer n = this.numDivisionsProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"numDivisionsProp.value");
        return ((Number)n).intValue();
    }

    public final void setNumDivisions(int value) {
        this.numDivisionsProp.setValue((Number)value);
    }

    @NotNull
    public final SimpleDoubleProperty bottomRadiusProperty() {
        return this.bottomRadiusProp;
    }

    @NotNull
    public final SimpleDoubleProperty topRadiusProperty() {
        return this.topRadiusProp;
    }

    @NotNull
    public final SimpleDoubleProperty heightProperty() {
        return this.heightProp;
    }

    @NotNull
    public final SimpleIntegerProperty numDivisionsProperty() {
        return this.numDivisionsProp;
    }

    @Override
    @NotNull
    protected Mesh createMesh() {
        int i;
        int t2;
        int t0;
        int p2;
        int p0;
        double a;
        int i2;
        float h = (float)this.getHeight() * 0.5f;
        int div = this.getNumDivisions();
        float topR = (float)this.getTopRadius();
        float botR = (float)this.getBottomRadius();
        int nPoints = div * 2 + 2;
        int tcCount = (div + 1) * 4 + 1;
        int faceCount = div * 4;
        float textureDelta = 0.00390625f;
        float dA = 1.0f / (float)div;
        float[] points = new float[nPoints * 3];
        float[] tPoints = new float[tcCount * 2];
        int[] faces = new int[faceCount * 6];
        int[] smoothing = new int[faceCount];
        int pPos = 0;
        int tPos = 0;
        for (i2 = 0; i2 < div; ++i2) {
            a = (double)(dA * (float)i2) * (Math.PI * 2);
            points[pPos + 0] = FXGLMath.sinF((double)a) * botR;
            points[pPos + 2] = FXGLMath.cosF((double)a) * botR;
            points[pPos + 1] = h;
            tPoints[tPos + 0] = 1.0f - dA * (float)i2;
            tPoints[tPos + 1] = 1.0f - textureDelta;
            pPos += 3;
            tPos += 2;
        }
        tPoints[tPos + 0] = 0.0f;
        tPoints[tPos + 1] = 1.0f - textureDelta;
        tPos += 2;
        for (i2 = 0; i2 < div; ++i2) {
            a = (double)(dA * (float)i2) * (Math.PI * 2);
            points[pPos + 0] = FXGLMath.sinF((double)a) * topR;
            points[pPos + 2] = FXGLMath.cosF((double)a) * topR;
            points[pPos + 1] = -h;
            tPoints[tPos + 0] = 1.0f - dA * (float)i2;
            tPoints[tPos + 1] = textureDelta;
            pPos += 3;
            tPos += 2;
        }
        tPoints[tPos + 0] = 0.0f;
        tPoints[tPos + 1] = textureDelta;
        tPos += 2;
        points[pPos + 0] = 0.0f;
        points[pPos + 1] = h;
        points[pPos + 2] = 0.0f;
        points[pPos + 3] = 0.0f;
        points[pPos + 4] = -h;
        points[pPos + 5] = 0.0f;
        pPos += 6;
        i2 = 0;
        if (i2 <= div) {
            while (true) {
                a = i2 < div ? (double)(dA * (float)i2) * (Math.PI * 2) : 0.0;
                tPoints[tPos + 0] = 0.5f + FXGLMath.sinF((double)a) * 0.5f;
                tPoints[tPos + 1] = 0.5f + FXGLMath.cosF((double)a) * 0.5f;
                tPos += 2;
                if (i2 == div) break;
                ++i2;
            }
        }
        if ((i2 = 0) <= div) {
            while (true) {
                a = i2 < div ? (double)(dA * (float)i2) * (Math.PI * 2) : 0.0;
                tPoints[tPos + 0] = 0.5f + FXGLMath.sinF((double)a) * 0.5f;
                tPoints[tPos + 1] = 0.5f - FXGLMath.cosF((double)a) * 0.5f;
                tPos += 2;
                if (i2 == div) break;
                ++i2;
            }
        }
        tPoints[tPos + 0] = 0.5f;
        tPoints[tPos + 1] = 0.5f;
        tPos += 2;
        int fIndex = 0;
        for (int p02 = 0; p02 < div; ++p02) {
            int p1 = p02 + 1;
            int p22 = p02 + div;
            int p3 = p1 + div;
            faces[fIndex + 0] = p02;
            faces[fIndex + 1] = p02;
            faces[fIndex + 2] = p22;
            faces[fIndex + 3] = p22 + 1;
            faces[fIndex + 4] = p1 == div ? 0 : p1;
            faces[fIndex + 5] = p1;
            faces[(fIndex += 6) + 0] = p3 % div == 0 ? p3 - div : p3;
            faces[fIndex + 1] = p3 + 1;
            faces[fIndex + 2] = p1 == div ? 0 : p1;
            faces[fIndex + 3] = p1;
            faces[fIndex + 4] = p22;
            faces[fIndex + 5] = p22 + 1;
            fIndex += 6;
        }
        int tStart = (div + 1) * 2;
        int t1 = (div + 1) * 4;
        int p1 = div * 2;
        for (p0 = 0; p0 < div; ++p0) {
            p2 = p0 + 1;
            t0 = tStart + p0;
            t2 = t0 + 1;
            faces[fIndex + 0] = p0;
            faces[fIndex + 1] = t0;
            faces[fIndex + 2] = p2 == div ? 0 : p2;
            faces[fIndex + 3] = t2;
            faces[fIndex + 4] = p1;
            faces[fIndex + 5] = t1;
            fIndex += 6;
        }
        p1 = div * 2 + 1;
        tStart = (div + 1) * 3;
        for (p0 = 0; p0 < div; ++p0) {
            p2 = p0 + 1 + div;
            t0 = tStart + p0;
            t2 = t0 + 1;
            faces[fIndex + 0] = p0 + div;
            faces[fIndex + 1] = t0;
            faces[fIndex + 2] = p1;
            faces[fIndex + 3] = t1;
            faces[fIndex + 4] = p2 % div == 0 ? p2 - div : p2;
            faces[fIndex + 5] = t2;
            fIndex += 6;
        }
        int n = div * 2;
        for (i = 0; i < n; ++i) {
            smoothing[i] = 1;
        }
        n = div * 4;
        for (i = div * 2; i < n; ++i) {
            smoothing[i] = 2;
        }
        TriangleMesh m = new TriangleMesh();
        m.getPoints().setAll(Arrays.copyOf(points, points.length));
        m.getTexCoords().setAll(Arrays.copyOf(tPoints, tPoints.length));
        m.getFaces().setAll(Arrays.copyOf(faces, faces.length));
        m.getFaceSmoothingGroups().setAll(Arrays.copyOf(smoothing, smoothing.length));
        return (Mesh)m;
    }

    @JvmOverloads
    public Prism(double bottomRadius, double topRadius, double height) {
        this(bottomRadius, topRadius, height, 0, 8, null);
    }

    @JvmOverloads
    public Prism(double bottomRadius, double topRadius) {
        this(bottomRadius, topRadius, 0.0, 0, 12, null);
    }

    @JvmOverloads
    public Prism(double bottomRadius) {
        this(bottomRadius, 0.0, 0.0, 0, 14, null);
    }

    @JvmOverloads
    public Prism() {
        this(0.0, 0.0, 0.0, 0, 15, null);
    }
}

