/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Scene;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/app/SceneEventSubscriber;", "T", "Ljavafx/event/Event;", "", "fxScene", "Ljavafx/scene/Scene;", "eventType", "Ljavafx/event/EventType;", "eventHandler", "Ljavafx/event/EventHandler;", "isFilter", "", "(Ljavafx/scene/Scene;Ljavafx/event/EventType;Ljavafx/event/EventHandler;Z)V", "getEventHandler", "()Ljavafx/event/EventHandler;", "getEventType", "()Ljavafx/event/EventType;", "getFxScene", "()Ljavafx/scene/Scene;", "()Z", "unsubscribe", "", "fxgl"})
public final class SceneEventSubscriber<T extends Event> {
    @NotNull
    private final Scene fxScene;
    @NotNull
    private final EventType<T> eventType;
    @NotNull
    private final EventHandler<T> eventHandler;
    private final boolean isFilter;

    public SceneEventSubscriber(@NotNull Scene fxScene, @NotNull EventType<T> eventType, @NotNull EventHandler<T> eventHandler, boolean isFilter) {
        Intrinsics.checkNotNullParameter((Object)fxScene, (String)"fxScene");
        Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        this.fxScene = fxScene;
        this.eventType = eventType;
        this.eventHandler = eventHandler;
        this.isFilter = isFilter;
        if (this.isFilter) {
            this.fxScene.addEventFilter(this.eventType, this.eventHandler);
        } else {
            this.fxScene.addEventHandler(this.eventType, this.eventHandler);
        }
    }

    @NotNull
    public final Scene getFxScene() {
        return this.fxScene;
    }

    @NotNull
    public final EventType<T> getEventType() {
        return this.eventType;
    }

    @NotNull
    public final EventHandler<T> getEventHandler() {
        return this.eventHandler;
    }

    public final boolean isFilter() {
        return this.isFilter;
    }

    public final void unsubscribe() {
        if (this.isFilter) {
            this.fxScene.removeEventFilter(this.eventType, this.eventHandler);
        } else {
            this.fxScene.removeEventHandler(this.eventType, this.eventHandler);
        }
    }
}

