/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.app.GameController;
import com.almasb.fxgl.app.scene.FXGLMenu;
import com.almasb.fxgl.app.scene.MenuType;
import com.almasb.fxgl.app.services.IOTaskExecutorService;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.util.InputPredicates;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.profile.SaveFile;
import com.almasb.fxgl.profile.SaveLoadService;
import com.almasb.fxgl.scene.SubScene;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0004J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\b\u0010\u001f\u001a\u00020\u001aH\u0004J\b\u0010 \u001a\u00020\u001aH\u0004J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\b\u0010\"\u001a\u00020\u001aH\u0004J\b\u0010#\u001a\u00020\u001aH\u0004J\b\u0010$\u001a\u00020\u001aH\u0004J\b\u0010%\u001a\u00020\u001aH\u0004R\u001b\u0010\u0005\u001a\u00020\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLMenu;", "Lcom/almasb/fxgl/scene/SubScene;", "type", "Lcom/almasb/fxgl/app/scene/MenuType;", "(Lcom/almasb/fxgl/app/scene/MenuType;)V", "appHeight", "", "getAppHeight", "()I", "appHeight$delegate", "Lkotlin/Lazy;", "appWidth", "getAppWidth", "appWidth$delegate", "controller", "Lcom/almasb/fxgl/app/GameController;", "getController", "()Lcom/almasb/fxgl/app/GameController;", "controller$delegate", "saveLoadService", "Lcom/almasb/fxgl/profile/SaveLoadService;", "getSaveLoadService", "()Lcom/almasb/fxgl/profile/SaveLoadService;", "getType", "()Lcom/almasb/fxgl/app/scene/MenuType;", "doSave", "", "saveFile", "Lcom/almasb/fxgl/profile/SaveFile;", "fireContinue", "fireDelete", "fireExit", "fireExitToMainMenu", "fireLoad", "fireNewGame", "fireResume", "fireSave", "restoreDefaultSettings", "Companion", "fxgl"})
public abstract class FXGLMenu
extends SubScene {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MenuType type;
    @NotNull
    private final SaveLoadService saveLoadService;
    @NotNull
    private final Lazy controller$delegate;
    @NotNull
    private final Lazy appWidth$delegate;
    @NotNull
    private final Lazy appHeight$delegate;
    @NotNull
    private static final Logger log = Logger.Companion.get("Menu");

    public FXGLMenu(@NotNull MenuType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.saveLoadService = FXGL.Companion.getSaveLoadService();
        this.controller$delegate = LazyKt.lazy((Function0)controller.2.INSTANCE);
        this.appWidth$delegate = LazyKt.lazy((Function0)appWidth.2.INSTANCE);
        this.appHeight$delegate = LazyKt.lazy((Function0)appHeight.2.INSTANCE);
    }

    @NotNull
    protected final MenuType getType() {
        return this.type;
    }

    @NotNull
    protected final SaveLoadService getSaveLoadService() {
        return this.saveLoadService;
    }

    @NotNull
    protected final GameController getController() {
        Lazy lazy = this.controller$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (GameController)lazy.getValue();
    }

    protected final int getAppWidth() {
        Lazy lazy = this.appWidth$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    protected final int getAppHeight() {
        Lazy lazy = this.appHeight$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    protected final void fireNewGame() {
        log.debug("fireNewGame()");
        this.getController().startNewGame();
    }

    protected final void fireContinue() {
        log.debug("fireContinue()");
        IOTask task = this.saveLoadService.readLastModifiedSaveFileTask("./", FXGLForKtKt.getSettings().getSaveFileExt()).onSuccess(arg_0 -> FXGLMenu.fireContinue$lambda-1(this, arg_0));
        IOTaskExecutorService iOTaskExecutorService = FXGL.Companion.getTaskService();
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
        iOTaskExecutorService.runAsyncFXWithDialog(task, FXGLForKtKt.localize("menu.loading") + "...");
    }

    protected final void fireLoad(@NotNull SaveFile saveFile) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        log.debug("fireLoad()");
        String text = FXGLForKtKt.localize("menu.loadSave") + " [" + saveFile.getName() + "]?\n" + FXGLForKtKt.localize("menu.unsavedProgress");
        FXGLForKtKt.getDialogService().showConfirmationBox(text, arg_0 -> FXGLMenu.fireLoad$lambda-2(this, saveFile, arg_0));
    }

    protected final void fireSave() {
        log.debug("fireSave()");
        FXGLForKtKt.getDialogService().showInputBoxWithCancel(FXGLForKtKt.localize("menu.enterSaveName"), InputPredicates.ALPHANUM, arg_0 -> FXGLMenu.fireSave$lambda-4(this, arg_0));
    }

    private final void doSave(SaveFile saveFile) {
        this.getController().saveGame(saveFile.getData());
        FXGL.Companion.getTaskService().runAsyncFXWithDialog(this.saveLoadService.writeTask(saveFile.getName(), saveFile.getData()), FXGLForKtKt.localize("menu.savingData") + ": " + saveFile.getName());
    }

    protected final void fireDelete(@NotNull SaveFile saveFile) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        log.debug("fireDelete()");
        FXGLForKtKt.getDialogService().showConfirmationBox(FXGLForKtKt.localize("menu.deleteSave") + "[" + saveFile.getName() + "]?", arg_0 -> FXGLMenu.fireDelete$lambda-5(this, saveFile, arg_0));
    }

    protected final void fireResume() {
        log.debug("fireResume()");
        FXGL.Companion.getSceneService().popSubScene();
    }

    protected final void fireExit() {
        log.debug("fireExit()");
        String text = FXGLForKtKt.localize("dialog.exitGame");
        FXGLForKtKt.getDialogService().showConfirmationBox(text, arg_0 -> FXGLMenu.fireExit$lambda-6(this, arg_0));
    }

    protected final void fireExitToMainMenu() {
        log.debug("fireExitToMainMenu()");
        String text = FXGLForKtKt.localize("menu.exitMainMenu") + "\n" + FXGLForKtKt.localize("menu.unsavedProgress");
        FXGLForKtKt.getDialogService().showConfirmationBox(text, arg_0 -> FXGLMenu.fireExitToMainMenu$lambda-7(this, arg_0));
    }

    protected final void restoreDefaultSettings() {
        log.debug("restoreDefaultSettings()");
    }

    private static final void fireContinue$lambda-1$lambda-0(FXGLMenu this$0, SaveFile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fireLoad(it);
    }

    private static final void fireContinue$lambda-1(FXGLMenu this$0, Optional it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        it.ifPresent(arg_0 -> FXGLMenu.fireContinue$lambda-1$lambda-0(this$0, arg_0));
    }

    private static final void fireLoad$lambda-2(FXGLMenu this$0, SaveFile $saveFile, Boolean yes) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$saveFile, (String)"$saveFile");
        Intrinsics.checkNotNullExpressionValue((Object)yes, (String)"yes");
        if (yes.booleanValue()) {
            this$0.getController().loadGame($saveFile.getData());
        }
    }

    private static final void fireSave$lambda-4$lambda-3(FXGLMenu this$0, SaveFile $saveFile, Boolean yes) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$saveFile, (String)"$saveFile");
        Intrinsics.checkNotNullExpressionValue((Object)yes, (String)"yes");
        if (yes.booleanValue()) {
            this$0.doSave($saveFile);
        }
    }

    private static final void fireSave$lambda-4(FXGLMenu this$0, String saveFileName) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)saveFileName, (String)"saveFileName");
        CharSequence charSequence = saveFileName;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        SaveFile saveFile = new SaveFile(saveFileName + "." + FXGLForKtKt.getSettings().getSaveFileExt(), null, null, 6, null);
        if (this$0.getSaveLoadService().saveFileExists(saveFile.getName())) {
            FXGLForKtKt.getDialogService().showConfirmationBox(FXGLForKtKt.localize("menu.overwrite") + " [" + saveFileName + "]?", arg_0 -> FXGLMenu.fireSave$lambda-4$lambda-3(this$0, saveFile, arg_0));
        } else {
            this$0.doSave(saveFile);
        }
    }

    private static final void fireDelete$lambda-5(FXGLMenu this$0, SaveFile $saveFile, Boolean yes) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$saveFile, (String)"$saveFile");
        Intrinsics.checkNotNullExpressionValue((Object)yes, (String)"yes");
        if (yes.booleanValue()) {
            IOTask task = this$0.getSaveLoadService().deleteSaveFileTask($saveFile.getName());
            FXGL.Companion.getTaskService().runAsyncFXWithDialog(task, FXGLForKtKt.localize("menu.deleting") + ": " + $saveFile.getName());
        }
    }

    private static final void fireExit$lambda-6(FXGLMenu this$0, Boolean yes) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)yes, (String)"yes");
        if (yes.booleanValue()) {
            this$0.getController().exit();
        }
    }

    private static final void fireExitToMainMenu$lambda-7(FXGLMenu this$0, Boolean yes) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)yes, (String)"yes");
        if (yes.booleanValue()) {
            this$0.getController().gotoMainMenu();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/FXGLMenu$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

