/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.app.services.AssetLoader;
import com.almasb.fxgl.app.services.CSSAssetLoader;
import com.almasb.fxgl.app.services.DialogueGraphAssetLoader;
import com.almasb.fxgl.app.services.FontAssetLoader;
import com.almasb.fxgl.app.services.ImageAssetLoader;
import com.almasb.fxgl.app.services.LoadParams;
import com.almasb.fxgl.app.services.Model3DAssetLoader;
import com.almasb.fxgl.app.services.MusicAssetLoader;
import com.almasb.fxgl.app.services.PropertyMapAssetLoader;
import com.almasb.fxgl.app.services.ResizableImageAssetLoader;
import com.almasb.fxgl.app.services.ResizableImageParams;
import com.almasb.fxgl.app.services.ResourceBundleAssetLoader;
import com.almasb.fxgl.app.services.SoundAssetLoader;
import com.almasb.fxgl.app.services.TextAssetLoader;
import com.almasb.fxgl.app.services.UIAssetLoader;
import com.almasb.fxgl.app.services.UIParams;
import com.almasb.fxgl.app.services.VideoAssetLoader;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.asset.AssetLoaderService;
import com.almasb.fxgl.core.asset.AssetType;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.cutscene.Cutscene;
import com.almasb.fxgl.cutscene.dialogue.DialogueGraph;
import com.almasb.fxgl.cutscene.dialogue.DialogueGraphSerializer;
import com.almasb.fxgl.cutscene.dialogue.SerializableGraph;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.entity.level.LevelLoader;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene3d.Model3D;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.ui.FontFactory;
import com.almasb.fxgl.ui.UI;
import com.almasb.fxgl.ui.UIController;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.scene.image.Image;
import javafx.scene.media.MediaView;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 I2\u00020\u0001:\u0001IB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J#\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ#\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u0007J-\u0010*\u001a\n\u0012\u0006\u0012\u0004\b\u0002H\u00160+\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u001c\u001a\u00020\u00142\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00160\r\u00f8\u0001\u0000J-\u0010*\u001a\n\u0012\u0006\u0012\u0004\b\u0002H\u00160+\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00160\r\u00f8\u0001\u0000J\u0016\u0010-\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u00103\u001a\u0002042\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u00103\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u00105\u001a\u0002062\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u00107\u001a\u0002082\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u00107\u001a\u0002082\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u00109\u001a\u00020:2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u00109\u001a\u00020:2\u0006\u0010\u0012\u001a\u00020\u0007J\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u0010\u001c\u001a\u00020\u0014J\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010=\u001a\u00020>2\u0006\u0010\u001c\u001a\u00020\u0014J\u001e\u0010=\u001a\u00020>2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@J\u000e\u0010=\u001a\u00020>2\u0006\u0010\u0012\u001a\u00020\u0007J\u001e\u0010=\u001a\u00020>2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@J\u0016\u0010B\u001a\u00020C2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010D\u001a\u00020EJ\u0016\u0010B\u001a\u00020C2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020G2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010F\u001a\u00020G2\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010H\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006J"}, d2={"Lcom/almasb/fxgl/app/services/FXGLAssetLoaderService;", "Lcom/almasb/fxgl/core/asset/AssetLoaderService;", "()V", "audioService", "Lcom/almasb/fxgl/audio/AudioPlayer;", "cachedAssets", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "isMobile", "", "userAppClass", "Ljava/lang/Class;", "clearCache", "", "getStream", "Ljava/io/InputStream;", "name", "getURL", "Ljava/net/URL;", "load", "T", "assetType", "Lcom/almasb/fxgl/core/asset/AssetType;", "loadParams", "Lcom/almasb/fxgl/app/services/LoadParams;", "(Lcom/almasb/fxgl/core/asset/AssetType;Lcom/almasb/fxgl/app/services/LoadParams;)Ljava/lang/Object;", "url", "(Lcom/almasb/fxgl/core/asset/AssetType;Ljava/net/URL;)Ljava/lang/Object;", "fileName", "(Lcom/almasb/fxgl/core/asset/AssetType;Ljava/lang/String;)Ljava/lang/Object;", "loadCSS", "Lcom/almasb/fxgl/scene/CSS;", "loadCutscene", "Lcom/almasb/fxgl/cutscene/Cutscene;", "loadDialogueGraph", "Lcom/almasb/fxgl/cutscene/dialogue/DialogueGraph;", "loadFont", "Lcom/almasb/fxgl/ui/FontFactory;", "loadImage", "Ljavafx/scene/image/Image;", "loadJSON", "Ljava/util/Optional;", "type", "loadLevel", "Lcom/almasb/fxgl/entity/level/Level;", "levelLoader", "Lcom/almasb/fxgl/entity/level/LevelLoader;", "loadModel3D", "Lcom/almasb/fxgl/scene3d/Model3D;", "loadMusic", "Lcom/almasb/fxgl/audio/Music;", "loadPropertyMap", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "loadResourceBundle", "Ljava/util/ResourceBundle;", "loadSound", "Lcom/almasb/fxgl/audio/Sound;", "loadText", "", "loadTexture", "Lcom/almasb/fxgl/texture/Texture;", "width", "", "height", "loadUI", "Lcom/almasb/fxgl/ui/UI;", "controller", "Lcom/almasb/fxgl/ui/UIController;", "loadVideo", "Ljavafx/scene/media/MediaView;", "onInit", "Companion", "fxgl"})
public final class FXGLAssetLoaderService
extends AssetLoaderService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Inject(value="isMobile")
    private boolean isMobile;
    @Inject(value="userAppClass")
    private Class<?> userAppClass;
    private AudioPlayer audioService;
    @NotNull
    private final HashMap<String, Object> cachedAssets = new HashMap();
    @NotNull
    private static final URL NULL_URL = new URL("https://github.com/AlmasB/FXGL");
    @NotNull
    private static final Logger log = Logger.Companion.get(FXGLAssetLoaderService.class);
    @NotNull
    private static final EnumMap<AssetType, AssetLoader<?>> assetData = new EnumMap(AssetType.class);

    public void onInit() {
        Map map = assetData;
        AssetType assetType = AssetType.SOUND;
        AudioPlayer audioPlayer = this.audioService;
        if (audioPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioService");
            audioPlayer = null;
        }
        AssetLoader assetLoader = new SoundAssetLoader(audioPlayer, this.isMobile);
        map.put(assetType, assetLoader);
        map = assetData;
        assetType = AssetType.MUSIC;
        AudioPlayer audioPlayer2 = this.audioService;
        if (audioPlayer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioService");
            audioPlayer2 = null;
        }
        assetLoader = new MusicAssetLoader(audioPlayer2, this.isMobile);
        map.put(assetType, assetLoader);
        Class<?> clazz = this.userAppClass;
        if (clazz == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAppClass");
            clazz = null;
        }
        log.debug("User app class for loading assets: " + clazz);
    }

    @NotNull
    public final Texture loadTexture(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Texture(this.loadImage(name));
    }

    @NotNull
    public final Texture loadTexture(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new Texture(this.loadImage(url));
    }

    @NotNull
    public final Texture loadTexture(@NotNull String name, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        URL url = this.getURL("/assets/textures/" + name);
        return new Texture((Image)this.load(AssetType.RESIZABLE_IMAGE, new ResizableImageParams(url, width, height)));
    }

    @NotNull
    public final Texture loadTexture(@NotNull URL url, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new Texture((Image)this.load(AssetType.RESIZABLE_IMAGE, new ResizableImageParams(url, width, height)));
    }

    @NotNull
    public final Image loadImage(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Image)this.load(AssetType.IMAGE, name);
    }

    @NotNull
    public final Image loadImage(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (Image)this.load(AssetType.IMAGE, url);
    }

    @NotNull
    public final Sound loadSound(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Sound)this.load(AssetType.SOUND, name);
    }

    @NotNull
    public final Sound loadSound(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (Sound)this.load(AssetType.SOUND, url);
    }

    @NotNull
    public final Music loadMusic(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Music)this.load(AssetType.MUSIC, name);
    }

    @NotNull
    public final Music loadMusic(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (Music)this.load(AssetType.MUSIC, url);
    }

    @NotNull
    public final ResourceBundle loadResourceBundle(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (ResourceBundle)this.load(AssetType.RESOURCE_BUNDLE, name);
    }

    @NotNull
    public final ResourceBundle loadResourceBundle(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (ResourceBundle)this.load(AssetType.RESOURCE_BUNDLE, url);
    }

    @NotNull
    public final DialogueGraph loadDialogueGraph(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SerializableGraph graph = (SerializableGraph)this.load(AssetType.DIALOGUE, name);
        return DialogueGraphSerializer.INSTANCE.fromSerializable(graph);
    }

    @NotNull
    public final DialogueGraph loadDialogueGraph(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        SerializableGraph graph = (SerializableGraph)this.load(AssetType.DIALOGUE, url);
        return DialogueGraphSerializer.INSTANCE.fromSerializable(graph);
    }

    @NotNull
    public final Cutscene loadCutscene(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Cutscene(this.loadText(name));
    }

    @NotNull
    public final Cutscene loadCutscene(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new Cutscene(this.loadText(url));
    }

    @NotNull
    public final List<String> loadText(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (List)this.load(AssetType.TEXT, name);
    }

    @NotNull
    public final List<String> loadText(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (List)this.load(AssetType.TEXT, url);
    }

    @NotNull
    public final <T> Optional<T> loadJSON(@NotNull String name, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.loadJSON(this.getURL("/assets/" + name), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> Optional<T> loadJSON(@NotNull URL url, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (url == NULL_URL) {
            log.warning("Failed to load JSON: URL is not valid");
            Optional optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
            return optional;
        }
        log.debug("Loading JSON from: " + url);
        try {
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Object obj = new ObjectMapper().readValue(it, type);
                Optional<Object> optional = Optional.ofNullable(obj);
                Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(obj)");
                Optional<Object> optional2 = optional;
                return optional2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            log.warning("Loading failed: " + url, (Throwable)e);
            Optional optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
            return optional;
        }
    }

    @NotNull
    public final PropertyMap loadPropertyMap(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (PropertyMap)this.load(AssetType.PROPERTY_MAP, name);
    }

    @NotNull
    public final PropertyMap loadPropertyMap(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (PropertyMap)this.load(AssetType.PROPERTY_MAP, url);
    }

    @NotNull
    public final FontFactory loadFont(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (FontFactory)this.load(AssetType.FONT, name);
    }

    @NotNull
    public final FontFactory loadFont(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (FontFactory)this.load(AssetType.FONT, url);
    }

    @NotNull
    public final CSS loadCSS(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (CSS)this.load(AssetType.CSS, name);
    }

    @NotNull
    public final CSS loadCSS(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (CSS)this.load(AssetType.CSS, url);
    }

    @NotNull
    public final Level loadLevel(@NotNull String name, @NotNull LevelLoader levelLoader) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)levelLoader, (String)"levelLoader");
        URL url = this.getURL("/assets/levels/" + name);
        if (url == NULL_URL) {
            throw new IllegalArgumentException("Loading level failed. Asset not found: " + name);
        }
        return levelLoader.load(url, FXGL.Companion.getGameWorld());
    }

    @NotNull
    public final UI loadUI(@NotNull String name, @NotNull UIController controller2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
        URL url = this.getURL("/assets/ui/" + name);
        return (UI)this.load(AssetType.UI, new UIParams(url, controller2));
    }

    @NotNull
    public final UI loadUI(@NotNull URL url, @NotNull UIController controller2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
        return (UI)this.load(AssetType.UI, new UIParams(url, controller2));
    }

    @NotNull
    public final Model3D loadModel3D(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Model3D)((Object)this.load(AssetType.MODEL3D, name));
    }

    @NotNull
    public final Model3D loadModel3D(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (Model3D)((Object)this.load(AssetType.MODEL3D, url));
    }

    @NotNull
    public final MediaView loadVideo(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (MediaView)this.load(AssetType.VIDEO, name);
    }

    @NotNull
    public final MediaView loadVideo(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (MediaView)this.load(AssetType.VIDEO, url);
    }

    public <T> T load(@NotNull AssetType assetType, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)assetType, (String)"assetType");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        AssetLoader<?> assetLoader = assetData.get(assetType);
        Intrinsics.checkNotNull(assetLoader);
        return this.load(assetType, this.getURL(assetLoader.getDirectory() + fileName));
    }

    public <T> T load(@NotNull AssetType assetType, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)assetType, (String)"assetType");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.load(assetType, new LoadParams(url, null, false, 6, null));
    }

    private final <T> T load(AssetType assetType, LoadParams loadParams) {
        Object obj;
        AssetLoader<?> assetLoader = assetData.get(assetType);
        Intrinsics.checkNotNull(assetLoader, (String)"null cannot be cast to non-null type com.almasb.fxgl.app.services.AssetLoader<T of com.almasb.fxgl.app.services.FXGLAssetLoaderService.load>");
        AssetLoader<?> data = assetLoader;
        if (loadParams.getUrl() == NULL_URL) {
            log.warning("Failed to load " + assetType);
            return (T)data.getDummy();
        }
        String cacheKey = loadParams.getCacheKey();
        Object asset = this.cachedAssets.get(cacheKey);
        if (asset != null) {
            return (T)data.cast(asset);
        }
        try {
            log.debug("Loading from file system: " + loadParams.getUrl());
            Object loaded = data.load(loadParams);
            if (loadParams.isCacheEnabled()) {
                Map map = this.cachedAssets;
                Intrinsics.checkNotNull(loaded, (String)"null cannot be cast to non-null type kotlin.Any");
                map.put(cacheKey, loaded);
            }
            Intrinsics.checkNotNull(loaded, (String)"null cannot be cast to non-null type kotlin.Any");
            obj = data.cast(loaded);
        }
        catch (Exception e) {
            log.warning("Failed to load " + loadParams.getUrl(), (Throwable)e);
            obj = data.getDummy();
        }
        return (T)obj;
    }

    @NotNull
    public final InputStream getStream(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        URL url = this.getURL(name);
        if (url == NULL_URL) {
            throw new IllegalArgumentException("Asset \"" + name + "\" was not found!");
        }
        InputStream inputStream = url.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"url.openStream()");
        return inputStream;
    }

    @NotNull
    public URL getURL(@NotNull String name) {
        URL url;
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Class<?> clazz = this.userAppClass;
        if (clazz == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userAppClass");
            clazz = null;
        }
        if ((uRL = clazz.getResource(name)) == null) {
            Class<?> clazz2 = ((Object)((Object)this)).getClass();
            String string = name.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            uRL = clazz2.getResource("/fxgl" + string);
        }
        if ((url = uRL) == null) {
            log.warning("Asset \"" + name + "\" was not found!");
            return NULL_URL;
        }
        return url;
    }

    public final void clearCache() {
        log.debug("Clearing assets cache");
        this.cachedAssets.clear();
    }

    static {
        ((Map)assetData).put(AssetType.IMAGE, new ImageAssetLoader());
        ((Map)assetData).put(AssetType.RESIZABLE_IMAGE, new ResizableImageAssetLoader());
        ((Map)assetData).put(AssetType.TEXT, new TextAssetLoader());
        ((Map)assetData).put(AssetType.DIALOGUE, new DialogueGraphAssetLoader());
        ((Map)assetData).put(AssetType.RESOURCE_BUNDLE, new ResourceBundleAssetLoader());
        ((Map)assetData).put(AssetType.PROPERTY_MAP, new PropertyMapAssetLoader());
        ((Map)assetData).put(AssetType.UI, new UIAssetLoader());
        ((Map)assetData).put(AssetType.CSS, new CSSAssetLoader());
        ((Map)assetData).put(AssetType.FONT, new FontAssetLoader());
        ((Map)assetData).put(AssetType.MODEL3D, new Model3DAssetLoader());
        ((Map)assetData).put(AssetType.VIDEO, new VideoAssetLoader());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/almasb/fxgl/app/services/FXGLAssetLoaderService$Companion;", "", "()V", "NULL_URL", "Ljava/net/URL;", "assetData", "Ljava/util/EnumMap;", "Lcom/almasb/fxgl/core/asset/AssetType;", "Lcom/almasb/fxgl/app/services/AssetLoader;", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

