/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.Executor;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.ui.DialogBox;
import com.almasb.fxgl.ui.DialogService;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nJ\u001a\u0010\u000e\u001a\u00020\r\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nJ\"\u0010\u000f\u001a\u00020\r\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/almasb/fxgl/app/services/IOTaskExecutorService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "dialogService", "Lcom/almasb/fxgl/ui/DialogService;", "executor", "Lcom/almasb/fxgl/core/concurrent/Executor;", "run", "T", "task", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "(Lcom/almasb/fxgl/core/concurrent/IOTask;)Ljava/lang/Object;", "runAsync", "", "runAsyncFX", "runAsyncFXWithDialog", "message", "", "fxgl"})
public final class IOTaskExecutorService
extends EngineService {
    private DialogService dialogService;
    @NotNull
    private final Executor executor = (Executor)Async.INSTANCE;

    public final <T> T run(@NotNull IOTask<T> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        return (T)task2.run();
    }

    public final <T> void runAsync(@NotNull IOTask<T> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        this.executor.execute(() -> IOTaskExecutorService.runAsync$lambda$0(task2));
    }

    public final <T> void runAsyncFX(@NotNull IOTask<T> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Task fxTask = task2.toJavaFXTask();
        fxTask.setOnFailed(arg_0 -> IOTaskExecutorService.runAsyncFX$lambda$1(task2, this, fxTask, arg_0));
        this.executor.execute((Runnable)fxTask);
    }

    public final <T> void runAsyncFXWithDialog(@NotNull IOTask<T> task2, @NotNull String message) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        DialogService dialogService = this.dialogService;
        if (dialogService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogService");
            dialogService = null;
        }
        DialogBox dialog = dialogService.showProgressBox(message);
        Task fxTask = task2.toJavaFXTask();
        fxTask.setOnSucceeded(arg_0 -> IOTaskExecutorService.runAsyncFXWithDialog$lambda$2(dialog, arg_0));
        fxTask.setOnFailed(arg_0 -> IOTaskExecutorService.runAsyncFXWithDialog$lambda$3(dialog, task2, this, fxTask, arg_0));
        this.executor.execute((Runnable)fxTask);
    }

    private static final void runAsync$lambda$0(IOTask $task) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        $task.run();
    }

    private static final void runAsyncFX$lambda$1(IOTask $task, IOTaskExecutorService this$0, Task $fxTask, WorkerStateEvent it) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!$task.hasFailAction()) {
            Throwable throwable;
            DialogService dialogService = this$0.dialogService;
            if (dialogService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dialogService");
                dialogService = null;
            }
            if ((throwable = $fxTask.getException()) == null) {
                throwable = new RuntimeException("Unknown error");
            }
            dialogService.showErrorBox(throwable);
        }
    }

    private static final void runAsyncFXWithDialog$lambda$2(DialogBox $dialog, WorkerStateEvent it) {
        $dialog.close();
    }

    private static final void runAsyncFXWithDialog$lambda$3(DialogBox $dialog, IOTask $task, IOTaskExecutorService this$0, Task $fxTask, WorkerStateEvent it) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $dialog.close();
        if (!$task.hasFailAction()) {
            Throwable throwable;
            DialogService dialogService = this$0.dialogService;
            if (dialogService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dialogService");
                dialogService = null;
            }
            if ((throwable = $fxTask.getException()) == null) {
                throwable = new RuntimeException("Unknown error");
            }
            dialogService.showErrorBox(throwable);
        }
    }
}

