/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.multiplayer;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.collection.MovingAverageQueue;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.collection.PropertyMapChangeListener;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.MouseTrigger;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.TriggerListener;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.multiplayer.ActionBeginReplicationEvent;
import com.almasb.fxgl.multiplayer.ActionEndReplicationEvent;
import com.almasb.fxgl.multiplayer.EntityRemoveEvent;
import com.almasb.fxgl.multiplayer.EntitySpawnEvent;
import com.almasb.fxgl.multiplayer.EntityUpdateEvent;
import com.almasb.fxgl.multiplayer.MultiplayerService;
import com.almasb.fxgl.multiplayer.NetworkComponent;
import com.almasb.fxgl.multiplayer.PingReplicationEvent;
import com.almasb.fxgl.multiplayer.PongReplicationEvent;
import com.almasb.fxgl.multiplayer.PropertyRemoveReplicationEvent;
import com.almasb.fxgl.multiplayer.PropertyUpdateReplicationEvent;
import com.almasb.fxgl.multiplayer.ReplicationEvent;
import com.almasb.fxgl.net.Connection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0014\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0018\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ/\u0010\u001c\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J$\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\f0$H\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u00020)2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010*\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\tH\u0002J$\u0010-\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J$\u00102\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u00103\u001a\b\u0012\u0004\u0012\u00020/04H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0005\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/almasb/fxgl/multiplayer/MultiplayerService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "replicatedEntitiesMap", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/net/Connection;", "Lcom/almasb/fxgl/core/serialization/Bundle;", "Lcom/almasb/fxgl/multiplayer/MultiplayerService$ConnectionData;", "Lkotlin/collections/HashMap;", "addEntityReplicationReceiver", "", "connection", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "addEventReplicationReceiver", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "addEventReplicationSender", "addInputReplicationReceiver", "input", "Lcom/almasb/fxgl/input/Input;", "addInputReplicationSender", "addPropertyReplicationReceiver", "map", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "addPropertyReplicationSender", "fire", "events", "", "Lcom/almasb/fxgl/multiplayer/ReplicationEvent;", "(Lcom/almasb/fxgl/net/Connection;[Lcom/almasb/fxgl/multiplayer/ReplicationEvent;)V", "handleIfReplicationBundle", "bundle", "handler", "Lkotlin/Function1;", "onGameUpdate", "tpf", "", "pingProperty", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "registerConnection", "setUpNewConnection", "data", "spawn", "entity", "Lcom/almasb/fxgl/entity/Entity;", "entityName", "", "updateReplicatedEntities", "entities", "", "ConnectionData", "fxgl"})
@SourceDebugExtension(value={"SMAP\nMultiplayerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerService.kt\ncom/almasb/fxgl/multiplayer/MultiplayerService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,287:1\n1855#2,2:288\n1855#2,2:292\n37#3,2:290\n*S KotlinDebug\n*F\n+ 1 MultiplayerService.kt\ncom/almasb/fxgl/multiplayer/MultiplayerService\n*L\n88#1:288,2\n276#1:292,2\n100#1:290,2\n*E\n"})
public final class MultiplayerService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());
    @NotNull
    private final HashMap<Connection<Bundle>, ConnectionData> replicatedEntitiesMap = new HashMap();

    public final void registerConnection(@NotNull Connection<Bundle> connection) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        ConnectionData data = new ConnectionData(connection);
        this.setUpNewConnection(data);
        ((Map)this.replicatedEntitiesMap).put(connection, data);
    }

    private final void setUpNewConnection(ConnectionData data) {
        this.addEventReplicationReceiver(data.getConnection(), data.getEventBus());
        data.getEventBus().addEventHandler(ReplicationEvent.PING, new EventHandler(this, data){
            final /* synthetic */ MultiplayerService this$0;
            final /* synthetic */ ConnectionData $data;
            {
                this.this$0 = $receiver;
                this.$data = $data;
            }

            public final void handle(PingReplicationEvent ping) {
                long timeRecv = System.nanoTime();
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{new PongReplicationEvent(ping.getTimeSent(), timeRecv)};
                MultiplayerService.access$fire(this.this$0, this.$data.getConnection(), replicationEventArray);
            }
        });
        data.getEventBus().addEventHandler(ReplicationEvent.PONG, new EventHandler(data){
            final /* synthetic */ ConnectionData $data;
            {
                this.$data = $data;
            }

            public final void handle(PongReplicationEvent pong) {
                long timeNow = System.nanoTime();
                long roundTripTime = timeNow - pong.getTimeSent();
                this.$data.getPingBuffer().put((double)roundTripTime);
                this.$data.getPing().setValue((Number)this.$data.getPingBuffer().getAverage());
            }
        });
    }

    public void onGameUpdate(double tpf) {
        if (this.replicatedEntitiesMap.isEmpty()) {
            return;
        }
        long now = System.nanoTime();
        this.replicatedEntitiesMap.forEach((arg_0, arg_1) -> MultiplayerService.onGameUpdate$lambda$0((Function2)new Function2<Connection<Bundle>, ConnectionData, Unit>(this, now){
            final /* synthetic */ MultiplayerService this$0;
            final /* synthetic */ long $now;
            {
                this.this$0 = $receiver;
                this.$now = $now;
                super(2);
            }

            public final void invoke(@NotNull Connection<Bundle> conn, @NotNull ConnectionData data) {
                Intrinsics.checkNotNullParameter(conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{new PingReplicationEvent(this.$now)};
                MultiplayerService.access$fire(this.this$0, conn, replicationEventArray);
                if (!((Collection)data.getEntities()).isEmpty()) {
                    MultiplayerService.access$updateReplicatedEntities(this.this$0, conn, data.getEntities());
                }
            }
        }, arg_0, arg_1));
    }

    @NotNull
    public final ReadOnlyDoubleProperty pingProperty(@NotNull Connection<Bundle> connection) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        ConnectionData connectionData = this.replicatedEntitiesMap.get(connection);
        Intrinsics.checkNotNull((Object)connectionData);
        ReadOnlyDoubleProperty readOnlyDoubleProperty = connectionData.getPing().getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"replicatedEntitiesMap[co\u2026]!!.ping.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    private final void updateReplicatedEntities(Connection<Bundle> connection, List<Entity> entities) {
        ArrayList events = new ArrayList();
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            long networkID = ((NetworkComponent)it.getComponent(NetworkComponent.class)).getId();
            if (it.isActive()) {
                ((Collection)events).add(new EntityUpdateEvent(networkID, it.getX(), it.getY(), it.getZ()));
                continue;
            }
            ((Collection)events).add(new EntityRemoveEvent(networkID));
        }
        if (!((Collection)events).isEmpty()) {
            Collection $this$toTypedArray$iv = events;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ReplicationEvent[] replicationEventArray = thisCollection$iv.toArray(new ReplicationEvent[0]);
            this.fire(connection, Arrays.copyOf(replicationEventArray, replicationEventArray.length));
        }
        entities.removeIf(arg_0 -> MultiplayerService.updateReplicatedEntities$lambda$2(updateReplicatedEntities.2.INSTANCE, arg_0));
    }

    public final void spawn(@NotNull Connection<Bundle> connection, @NotNull Entity entity, @NotNull String entityName) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        if (!entity.hasComponent(NetworkComponent.class)) {
            this.log.warning("Attempted to network-spawn entity " + entityName + ", but it does not have NetworkComponent");
            return;
        }
        NetworkComponent networkComponent = (NetworkComponent)entity.getComponent(NetworkComponent.class);
        EntitySpawnEvent event = new EntitySpawnEvent(networkComponent.getId(), entityName, entity.getX(), entity.getY(), entity.getZ());
        ConnectionData connectionData = this.replicatedEntitiesMap.get(connection);
        Intrinsics.checkNotNull((Object)connectionData);
        ConnectionData data = connectionData;
        ((Collection)data.getEntities()).add(entity);
        ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
        this.fire(connection, replicationEventArray);
    }

    public final void addEntityReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull GameWorld gameWorld) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)gameWorld, (String)"gameWorld");
        connection.addMessageHandlerFX((arg_0, arg_1) -> MultiplayerService.addEntityReplicationReceiver$lambda$3(this, gameWorld, arg_0, arg_1));
    }

    public final void addInputReplicationSender(@NotNull Connection<Bundle> connection, @NotNull Input input) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        input.addTriggerListener(new TriggerListener(this, connection){
            final /* synthetic */ MultiplayerService this$0;
            final /* synthetic */ Connection<Bundle> $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            protected void onActionBegin(@NotNull Trigger trigger) {
                Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
                ActionBeginReplicationEvent event = trigger.isKey() ? new ActionBeginReplicationEvent(((KeyTrigger)trigger).getKey(), null, 2, null) : new ActionBeginReplicationEvent(null, ((MouseTrigger)trigger).getButton(), 1, null);
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }

            protected void onActionEnd(@NotNull Trigger trigger) {
                Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
                ActionEndReplicationEvent event = trigger.isKey() ? new ActionEndReplicationEvent(((KeyTrigger)trigger).getKey(), null, 2, null) : new ActionEndReplicationEvent(null, ((MouseTrigger)trigger).getButton(), 1, null);
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }
        });
    }

    public final void addPropertyReplicationSender(@NotNull Connection<Bundle> connection, @NotNull PropertyMap map) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        map.addListener(new PropertyMapChangeListener(this, connection){
            final /* synthetic */ MultiplayerService this$0;
            final /* synthetic */ Connection<Bundle> $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            public void onUpdated(@NotNull String propertyName, @NotNull Object propertyValue) {
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
                PropertyUpdateReplicationEvent event = new PropertyUpdateReplicationEvent(propertyName, propertyValue);
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }

            public void onRemoved(@NotNull String propertyName, @NotNull Object propertyValue) {
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
                PropertyRemoveReplicationEvent event = new PropertyRemoveReplicationEvent(propertyName);
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[]{event};
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }
        });
    }

    public final void addPropertyReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull PropertyMap map) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        connection.addMessageHandlerFX((arg_0, arg_1) -> MultiplayerService.addPropertyReplicationReceiver$lambda$4(this, map, arg_0, arg_1));
    }

    public final void addInputReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull Input input) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        connection.addMessageHandlerFX((arg_0, arg_1) -> MultiplayerService.addInputReplicationReceiver$lambda$5(this, input, arg_0, arg_1));
    }

    public final void addEventReplicationSender(@NotNull Connection<Bundle> connection, @NotNull EventBus eventBus) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        eventBus.addEventHandler(ReplicationEvent.ANY, new EventHandler(this, connection){
            final /* synthetic */ MultiplayerService this$0;
            final /* synthetic */ Connection<Bundle> $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            public final void handle(ReplicationEvent event) {
                ReplicationEvent[] replicationEventArray = new ReplicationEvent[1];
                Intrinsics.checkNotNullExpressionValue((Object)((Object)event), (String)"event");
                replicationEventArray[0] = event;
                MultiplayerService.access$fire(this.this$0, this.$connection, replicationEventArray);
            }
        });
    }

    public final void addEventReplicationReceiver(@NotNull Connection<Bundle> connection, @NotNull EventBus eventBus) {
        Intrinsics.checkNotNullParameter(connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        connection.addMessageHandlerFX((arg_0, arg_1) -> MultiplayerService.addEventReplicationReceiver$lambda$6(this, eventBus, arg_0, arg_1));
    }

    private final void fire(Connection<Bundle> connection, ReplicationEvent ... events) {
        if (!connection.isConnected()) {
            return;
        }
        Bundle bundle = new Bundle("REPLICATION_EVENT");
        ArrayList list = new ArrayList(ArraysKt.toList((Object[])events));
        bundle.put("events", (Serializable)list);
        connection.send((Object)bundle);
    }

    private final void handleIfReplicationBundle(Bundle bundle, Function1<? super ReplicationEvent, Unit> handler) {
        if (Intrinsics.areEqual((Object)bundle.getName(), (Object)"REPLICATION_EVENT")) {
            List events = (List)bundle.get("events");
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                handler.invoke(element$iv);
            }
        }
    }

    private static final void onGameUpdate$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final boolean updateReplicatedEntities$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void addEntityReplicationReceiver$lambda$3(MultiplayerService this$0, GameWorld $gameWorld, Connection connection, Bundle message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$gameWorld, (String)"$gameWorld");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.handleIfReplicationBundle(message, (Function1<? super ReplicationEvent, Unit>)((Function1)new Function1<ReplicationEvent, Unit>($gameWorld){
            final /* synthetic */ GameWorld $gameWorld;
            {
                this.$gameWorld = $gameWorld;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ReplicationEvent event) {
                block5: {
                    Map $this$filterValues$iv;
                    ReplicationEvent replicationEvent;
                    block6: {
                        void $this$forEach$iv;
                        Map $this$filterValues$iv2;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                            replicationEvent = event;
                            if (!(replicationEvent instanceof EntitySpawnEvent)) break block4;
                            long id = ((EntitySpawnEvent)event).getNetworkID();
                            String entityName = ((EntitySpawnEvent)event).getEntityName();
                            Entity e = this.$gameWorld.spawn(entityName, new SpawnData(((EntitySpawnEvent)event).getX(), ((EntitySpawnEvent)event).getY(), ((EntitySpawnEvent)event).getZ()));
                            e.getComponentOptional(NetworkComponent.class).ifPresent(arg_0 -> addEntityReplicationReceiver.1.1.invoke$lambda$0((Function1)new Function1<NetworkComponent, Unit>(id){
                                final /* synthetic */ long $id;
                                {
                                    this.$id = $id;
                                    super(1);
                                }

                                public final void invoke(@NotNull NetworkComponent it) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                    it.setId$fxgl(this.$id);
                                }
                            }, arg_0));
                            break block5;
                        }
                        if (!(replicationEvent instanceof EntityUpdateEvent)) break block6;
                        long id = ((EntityUpdateEvent)event).getNetworkID();
                        Map entityName = this.$gameWorld.getEntitiesByComponentMapped(NetworkComponent.class);
                        boolean $i$f$filterValues = false;
                        Object result$iv = new LinkedHashMap<K, V>();
                        for (Map.Entry<K, V> entry : $this$filterValues$iv2.entrySet()) {
                            NetworkComponent it = (NetworkComponent)((Object)entry.getValue());
                            boolean bl = false;
                            if (!(it.getId() == id)) continue;
                            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
                        }
                        $this$filterValues$iv2 = (Map)result$iv;
                        boolean $i$f$forEach = false;
                        result$iv = $this$forEach$iv.entrySet().iterator();
                        while (result$iv.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry entry = element$iv = (Map.Entry)result$iv.next();
                            boolean bl = false;
                            Entity e = (Entity)entry.getKey();
                            e.setPosition3D(((EntityUpdateEvent)event).getX(), ((EntityUpdateEvent)event).getY(), ((EntityUpdateEvent)event).getZ());
                        }
                        break block5;
                    }
                    if (!(replicationEvent instanceof EntityRemoveEvent)) break block5;
                    long id = ((EntityRemoveEvent)event).getNetworkID();
                    Map $this$forEach$iv = this.$gameWorld.getEntitiesByComponentMapped(NetworkComponent.class);
                    boolean $i$f$filterValues = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    Object element$iv = $this$filterValues$iv.entrySet().iterator();
                    while (element$iv.hasNext()) {
                        Map.Entry<K, V> entry = element$iv.next();
                        NetworkComponent it = (NetworkComponent)((Object)entry.getValue());
                        boolean bl = false;
                        if (!(it.getId() == id)) continue;
                        result$iv.put(entry.getKey(), entry.getValue());
                    }
                    $this$filterValues$iv = result$iv;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object object = element$iv = iterator.next();
                        boolean bl = false;
                        Entity e = (Entity)object.getKey();
                        e.removeFromWorld();
                    }
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }));
    }

    private static final void addPropertyReplicationReceiver$lambda$4(MultiplayerService this$0, PropertyMap $map, Connection connection, Bundle message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.handleIfReplicationBundle(message, (Function1<? super ReplicationEvent, Unit>)((Function1)new Function1<ReplicationEvent, Unit>($map){
            final /* synthetic */ PropertyMap $map;
            {
                this.$map = $map;
                super(1);
            }

            public final void invoke(@NotNull ReplicationEvent event) {
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                ReplicationEvent replicationEvent = event;
                if (replicationEvent instanceof PropertyUpdateReplicationEvent) {
                    this.$map.setValue(((PropertyUpdateReplicationEvent)event).getPropertyName(), ((PropertyUpdateReplicationEvent)event).getPropertyValue());
                } else if (replicationEvent instanceof PropertyRemoveReplicationEvent) {
                    this.$map.remove(((PropertyRemoveReplicationEvent)event).getPropertyName());
                }
            }
        }));
    }

    private static final void addInputReplicationReceiver$lambda$5(MultiplayerService this$0, Input $input, Connection connection, Bundle message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$input, (String)"$input");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.handleIfReplicationBundle(message, (Function1<? super ReplicationEvent, Unit>)((Function1)new Function1<ReplicationEvent, Unit>($input){
            final /* synthetic */ Input $input;
            {
                this.$input = $input;
                super(1);
            }

            public final void invoke(@NotNull ReplicationEvent event) {
                block4: {
                    KeyCode it;
                    Input input;
                    KeyCode keyCode;
                    block3: {
                        KeyCode it2;
                        Input input2;
                        KeyCode keyCode2;
                        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                        if (!(event instanceof ActionBeginReplicationEvent)) break block3;
                        KeyCode keyCode3 = ((ActionBeginReplicationEvent)event).getKey();
                        if (keyCode3 != null) {
                            keyCode2 = keyCode3;
                            input2 = this.$input;
                            it2 = keyCode2;
                            boolean bl = false;
                            input2.mockTriggerPress((Trigger)new KeyTrigger(it2, null, 2, null));
                        }
                        MouseButton mouseButton = ((ActionBeginReplicationEvent)event).getBtn();
                        if (mouseButton == null) break block4;
                        keyCode2 = mouseButton;
                        input2 = this.$input;
                        it2 = keyCode2;
                        boolean bl = false;
                        input2.mockTriggerPress((Trigger)new MouseTrigger((MouseButton)it2, null, 2, null));
                        break block4;
                    }
                    if (!(event instanceof ActionEndReplicationEvent)) break block4;
                    KeyCode keyCode4 = ((ActionEndReplicationEvent)event).getKey();
                    if (keyCode4 != null) {
                        keyCode = keyCode4;
                        input = this.$input;
                        it = keyCode;
                        boolean bl = false;
                        input.mockTriggerRelease((Trigger)new KeyTrigger(it, null, 2, null));
                    }
                    MouseButton mouseButton = ((ActionEndReplicationEvent)event).getBtn();
                    if (mouseButton != null) {
                        keyCode = mouseButton;
                        input = this.$input;
                        it = keyCode;
                        boolean bl = false;
                        input.mockTriggerRelease((Trigger)new MouseTrigger((MouseButton)it, null, 2, null));
                    }
                }
            }
        }));
    }

    private static final void addEventReplicationReceiver$lambda$6(MultiplayerService this$0, EventBus $eventBus, Connection connection, Bundle message) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eventBus, (String)"$eventBus");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        this$0.handleIfReplicationBundle(message, (Function1<? super ReplicationEvent, Unit>)((Function1)new Function1<ReplicationEvent, Unit>($eventBus){
            final /* synthetic */ EventBus $eventBus;
            {
                this.$eventBus = $eventBus;
                super(1);
            }

            public final void invoke(@NotNull ReplicationEvent it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                this.$eventBus.fireEvent((Event)it);
            }
        }));
    }

    public static final /* synthetic */ void access$fire(MultiplayerService $this, Connection connection, ReplicationEvent ... events) {
        $this.fire((Connection<Bundle>)connection, events);
    }

    public static final /* synthetic */ void access$updateReplicatedEntities(MultiplayerService $this, Connection connection, List entities) {
        $this.updateReplicatedEntities((Connection<Bundle>)connection, entities);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/almasb/fxgl/multiplayer/MultiplayerService$ConnectionData;", "", "connection", "Lcom/almasb/fxgl/net/Connection;", "Lcom/almasb/fxgl/core/serialization/Bundle;", "(Lcom/almasb/fxgl/net/Connection;)V", "getConnection", "()Lcom/almasb/fxgl/net/Connection;", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "getEntities", "()Ljava/util/ArrayList;", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "getEventBus", "()Lcom/almasb/fxgl/event/EventBus;", "ping", "Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "getPing", "()Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "pingBuffer", "Lcom/almasb/fxgl/core/collection/MovingAverageQueue;", "getPingBuffer", "()Lcom/almasb/fxgl/core/collection/MovingAverageQueue;", "fxgl"})
    @SourceDebugExtension(value={"SMAP\nMultiplayerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerService.kt\ncom/almasb/fxgl/multiplayer/MultiplayerService$ConnectionData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,287:1\n1#2:288\n*E\n"})
    private static final class ConnectionData {
        @NotNull
        private final Connection<Bundle> connection;
        @NotNull
        private final ArrayList<Entity> entities;
        @NotNull
        private final EventBus eventBus;
        @NotNull
        private final MovingAverageQueue pingBuffer;
        @NotNull
        private final ReadOnlyDoubleWrapper ping;

        /*
         * WARNING - void declaration
         */
        public ConnectionData(@NotNull Connection<Bundle> connection) {
            void it;
            EventBus eventBus;
            Intrinsics.checkNotNullParameter(connection, (String)"connection");
            this.connection = connection;
            this.entities = new ArrayList();
            EventBus eventBus2 = eventBus = new EventBus();
            ConnectionData connectionData = this;
            boolean bl = false;
            it.setLoggingEnabled(false);
            connectionData.eventBus = eventBus;
            this.pingBuffer = new MovingAverageQueue(1000);
            this.ping = new ReadOnlyDoubleWrapper();
        }

        @NotNull
        public final Connection<Bundle> getConnection() {
            return this.connection;
        }

        @NotNull
        public final ArrayList<Entity> getEntities() {
            return this.entities;
        }

        @NotNull
        public final EventBus getEventBus() {
            return this.eventBus;
        }

        @NotNull
        public final MovingAverageQueue getPingBuffer() {
            return this.pingBuffer;
        }

        @NotNull
        public final ReadOnlyDoubleWrapper getPing() {
            return this.ping;
        }
    }
}

