/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGLPane;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SceneEventSubscriber;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.Viewport;
import com.almasb.fxgl.input.MouseEventData;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.texture.ImagesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"\"\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020 H\u0016J\b\u0010&\u001a\u00020 H\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020 H\u0016J\b\u0010.\u001a\u00020/H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R\u0014\u0010\u001d\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011\u00a8\u00060"}, d2={"Lcom/almasb/fxgl/app/EmbeddedPaneWindow;", "Lcom/almasb/fxgl/app/MainWindow;", "fxglPane", "Lcom/almasb/fxgl/app/FXGLPane;", "scene", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "(Lcom/almasb/fxgl/app/FXGLPane;Lcom/almasb/fxgl/app/scene/FXGLScene;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;)V", "backgroundRect", "Ljavafx/scene/shape/Rectangle;", "clipRect", "getFxglPane", "()Lcom/almasb/fxgl/app/FXGLPane;", "height", "", "getHeight", "()D", "isFocused", "", "()Z", "stage", "Ljavafx/stage/Stage;", "getStage", "()Ljavafx/stage/Stage;", "width", "getWidth", "x", "getX", "y", "getY", "addCSS", "", "cssList", "", "Lcom/almasb/fxgl/scene/CSS;", "([Lcom/almasb/fxgl/scene/CSS;)V", "close", "computeScaledDimensions", "iconifiedProperty", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "onStageResize", "setRoot", "root", "Ljavafx/scene/layout/Pane;", "show", "takeScreenshot", "Ljavafx/scene/image/Image;", "fxgl"})
@SourceDebugExtension(value={"SMAP\nMainWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainWindow.kt\ncom/almasb/fxgl/app/EmbeddedPaneWindow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,763:1\n1#2:764\n11335#3:765\n11670#3,3:766\n800#4,11:769\n1855#4,2:780\n*S KotlinDebug\n*F\n+ 1 MainWindow.kt\ncom/almasb/fxgl/app/EmbeddedPaneWindow\n*L\n642#1:765\n642#1:766,3\n698#1:769,11\n699#1:780,2\n*E\n"})
public final class EmbeddedPaneWindow
extends MainWindow {
    @NotNull
    private final FXGLPane fxglPane;
    @NotNull
    private final Rectangle backgroundRect;
    @NotNull
    private final Rectangle clipRect;

    public EmbeddedPaneWindow(@NotNull FXGLPane fxglPane, @NotNull FXGLScene scene, @NotNull ReadOnlyGameSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)fxglPane), (String)"fxglPane");
        Intrinsics.checkNotNullParameter((Object)((Object)scene), (String)"scene");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(scene, settings, null);
        this.fxglPane = fxglPane;
        this.backgroundRect = new Rectangle();
        this.clipRect = new Rectangle();
        this.computeScaledDimensions();
        this.clipRect.widthProperty().bind((ObservableValue)this.fxglPane.renderWidthProperty());
        this.clipRect.heightProperty().bind((ObservableValue)this.fxglPane.renderHeightProperty());
        this.fxglPane.setClip((Node)this.clipRect);
        this.backgroundRect.widthProperty().bind((ObservableValue)this.fxglPane.renderWidthProperty());
        this.backgroundRect.heightProperty().bind((ObservableValue)this.fxglPane.renderHeightProperty());
        this.backgroundRect.fillProperty().bind((ObservableValue)this.fxglPane.renderFillProperty());
        ObservableList<Node> observableList = this.fxglPane.getAllChildren();
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"fxglPane.allChildren");
        Collection collection = (Collection)observableList;
        collection.add(this.backgroundRect);
        this.setInitialScene(scene);
        this.fxglPane.sceneProperty().addListener((arg_0, arg_1, arg_2) -> EmbeddedPaneWindow._init_$lambda$1((Function3)new Function3<ObservableValue<? extends javafx.scene.Scene>, javafx.scene.Scene, javafx.scene.Scene, Unit>(){

            public final void invoke(ObservableValue<? extends javafx.scene.Scene> observableValue, javafx.scene.Scene oldScene, javafx.scene.Scene newScene) {
                if (oldScene != null) {
                    this.removeAllEventFiltersAndHandlers(oldScene);
                }
                if (newScene != null) {
                    this.addKeyHandler(newScene, (Function1<? super KeyEvent, Unit>)((Function1)new Function1<KeyEvent, Unit>(){

                        public final void invoke(final @NotNull KeyEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            this.getInput$fxgl().onKeyEvent(e);
                            this.getStateMachine().runOnActiveStates((Function1)new Function1<Scene, Unit>(){

                                public final void invoke(@NotNull Scene it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    it.getInput().onKeyEvent(e);
                                }
                            });
                        }
                    }));
                    EventHandler mouseHandler2 = arg_0 -> 1.invoke$lambda$0(this, arg_0);
                    ArrayList<SceneEventSubscriber<?>> arrayList = this.getEventSubscribers();
                    EventType eventType = MouseEvent.ANY;
                    Intrinsics.checkNotNullExpressionValue((Object)eventType, (String)"ANY");
                    arrayList.add(new SceneEventSubscriber(newScene, eventType, mouseHandler2, false));
                    this.addGlobalHandler(newScene, (Function1<? super Event, Unit>)((Function1)new Function1<Event, Unit>(){

                        public final void invoke(final @NotNull Event e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            this.getInput$fxgl().fireEventViaFilters(e);
                            this.getStateMachine().runOnActiveStates((Function1)new Function1<Scene, Unit>(){

                                public final void invoke(@NotNull Scene it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    it.getInput().fireEventViaFilters(e);
                                }
                            });
                        }
                    }), (Function1<? super Event, Unit>)((Function1)new Function1<Event, Unit>(){

                        public final void invoke(final @NotNull Event e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            this.getInput$fxgl().fireEventViaHandlers(e);
                            this.getStateMachine().runOnActiveStates((Function1)new Function1<Scene, Unit>(){

                                public final void invoke(@NotNull Scene it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    it.getInput().fireEventViaHandlers(e);
                                }
                            });
                        }
                    }));
                }
            }

            private static final void invoke$lambda$0(EmbeddedPaneWindow this$0, MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Point2D point2D = this$0.getFxglPane().localToScene(0.0, 0.0).add(this$0.getCurrentFXGLScene().getContentRoot().getTranslateX(), this$0.getCurrentFXGLScene().getContentRoot().getTranslateY());
                Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"fxglPane.localToScene(0.\u2026e.contentRoot.translateY)");
                Point2D point2D2 = new Point2D(this$0.getCurrentFXGLScene().getViewport().getX(), this$0.getCurrentFXGLScene().getViewport().getY());
                double d = this$0.getCurrentFXGLScene().getViewport().getZoom();
                Double d2 = this$0.getScaleRatioX().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"scaleRatioX.value");
                double d3 = ((Number)d2).doubleValue();
                Double d4 = this$0.getScaleRatioY().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)d4, (String)"scaleRatioY.value");
                MouseEventData data = new MouseEventData(it, point2D, point2D2, d, d3, ((Number)d4).doubleValue());
                this$0.getInput$fxgl().onMouseEvent(data);
                this$0.getStateMachine().runOnActiveStates((Function1)new Function1<Scene, Unit>(data){
                    final /* synthetic */ MouseEventData $data;
                    {
                        this.$data = $data;
                        super(1);
                    }

                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.getInput().onMouseEvent(this.$data);
                    }
                });
            }
        }, arg_0, arg_1, arg_2));
    }

    @NotNull
    public final FXGLPane getFxglPane() {
        return this.fxglPane;
    }

    @Override
    @NotNull
    public Stage getStage() {
        FXGLPane fXGLPane = this.fxglPane;
        Stage stage = (Stage)(fXGLPane != null && (fXGLPane = fXGLPane.getScene()) != null ? fXGLPane.getWindow() : null);
        if (stage == null) {
            Stage stage2;
            Stage it = stage2 = new Stage();
            boolean bl = false;
            this.getLog().warning("EmbeddedPane not attached to Stage");
            stage = stage2;
        }
        return stage;
    }

    @Override
    public double getX() {
        return this.fxglPane.localToScene(0.0, 0.0).getX();
    }

    @Override
    public double getY() {
        return this.fxglPane.localToScene(0.0, 0.0).getY();
    }

    @Override
    public boolean isFocused() {
        return true;
    }

    @Override
    public double getWidth() {
        return this.fxglPane.getRenderWidth();
    }

    @Override
    public double getHeight() {
        return this.fxglPane.getRenderHeight();
    }

    private final void computeScaledDimensions() {
        double newH;
        Rectangle2D bounds;
        double newW = this.getSettings().getWidth();
        if (newW > (bounds = new Rectangle2D(0.0, 0.0, newW, newH = (double)this.getSettings().getHeight())).getWidth() || newH > bounds.getHeight()) {
            this.getLog().debug("Target size > screen size");
            double extraMargin = 25.0;
            double ratio = newW / newH;
            for (int newWidth = (int)bounds.getWidth(); 0 < newWidth; --newWidth) {
                if (!((double)newWidth / ratio <= bounds.getHeight())) continue;
                newW = (double)newWidth - extraMargin;
                newH = (double)newWidth / ratio;
                break;
            }
        }
        newW = (int)newW;
        newH = (int)newH;
        this.getScaledWidth().set(newW);
        this.getScaledHeight().set(newH);
        this.getScaleRatioX().set(this.getScaledWidth().getValue() / (double)this.getSettings().getWidth());
        this.getScaleRatioY().set(this.getScaledHeight().getValue() / (double)this.getSettings().getHeight());
        this.getLog().debug("Target settings size: " + (double)this.getSettings().getWidth() + " x " + (double)this.getSettings().getHeight());
        this.getLog().debug("Scaled scene size:    " + newW + " x " + newH);
        this.getLog().debug("Scaled ratio: (" + this.getScaleRatioX().getValue() + ", " + this.getScaleRatioY().getValue() + ")");
    }

    @Override
    @NotNull
    public ReadOnlyBooleanProperty iconifiedProperty() {
        ReadOnlyBooleanProperty readOnlyBooleanProperty = new ReadOnlyBooleanWrapper().getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyBooleanProperty, (String)"ReadOnlyBooleanWrapper().readOnlyProperty");
        return readOnlyBooleanProperty;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addCSS(CSS ... cssList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cssList, (String)"cssList");
        ObservableList observableList = this.fxglPane.getStylesheets();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"fxglPane.stylesheets");
        Collection collection = (Collection)observableList;
        CSS[] $this$map$iv = cssList;
        boolean $i$f$map = false;
        CSS[] cSSArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getExternalForm());
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }

    @Override
    protected void setRoot(@NotNull Pane root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object[] objectArray = new Node[]{(Node)this.backgroundRect, (Node)root};
        this.fxglPane.getAllChildren().setAll(objectArray);
    }

    @Override
    public void show() {
        this.getLog().debug("Opening embedded window");
        int windowBorderWidth = 0;
        int windowBorderHeight = 0;
        this.getScaledWidth().bind((ObservableValue)this.fxglPane.renderWidthProperty());
        this.getScaledHeight().bind((ObservableValue)this.fxglPane.renderHeightProperty());
        this.getSettings().getScaledWidthProp$fxgl().bind((ObservableValue)this.getScaledWidth());
        this.getSettings().getScaledHeightProp$fxgl().bind((ObservableValue)this.getScaledHeight());
        if (this.getSettings().isScaleAffectedOnResize()) {
            if (this.getSettings().isPreserveResizeRatio()) {
                this.getScaleRatioX().bind((ObservableValue)Bindings.min((ObservableNumberValue)((ObservableNumberValue)this.getScaledWidth().divide(this.getSettings().getWidth())), (ObservableNumberValue)((ObservableNumberValue)this.getScaledHeight().divide(this.getSettings().getHeight()))));
                this.getScaleRatioY().bind((ObservableValue)this.getScaleRatioX());
            } else {
                this.getScaleRatioX().bind((ObservableValue)this.getScaledWidth().divide(this.getSettings().getWidth()));
                this.getScaleRatioY().bind((ObservableValue)this.getScaledHeight().divide(this.getSettings().getHeight()));
            }
        } else {
            this.getScaleRatioX().setValue((Number)1.0);
            this.getScaleRatioY().setValue((Number)1.0);
            this.getScaledWidth().addListener((arg_0, arg_1, arg_2) -> EmbeddedPaneWindow.show$lambda$3((Function3)new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(this){
                final /* synthetic */ EmbeddedPaneWindow this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number newWidth) {
                    EmbeddedPaneWindow.access$onStageResize(this.this$0);
                }
            }, arg_0, arg_1, arg_2));
            this.getScaledHeight().addListener((arg_0, arg_1, arg_2) -> EmbeddedPaneWindow.show$lambda$4((Function3)new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(this){
                final /* synthetic */ EmbeddedPaneWindow this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number newHeight) {
                    EmbeddedPaneWindow.access$onStageResize(this.this$0);
                }
            }, arg_0, arg_1, arg_2));
        }
        this.getLog().debug("Window border size: (" + windowBorderWidth + ", " + windowBorderHeight + ")");
        this.getLog().debug("Scaled size: " + this.getScaledWidth().getValue() + " x " + this.getScaledHeight().getValue());
        this.getLog().debug("Scaled ratio: (" + this.getScaleRatioX().getValue() + ", " + this.getScaleRatioY().getValue() + ")");
    }

    /*
     * WARNING - void declaration
     */
    private final void onStageResize() {
        void $this$filterIsInstanceTo$iv$iv;
        Double newW = this.getScaledWidth().getValue();
        Double newH = this.getScaledHeight().getValue();
        this.getLog().debug("On Stage resize: " + newW + "x" + newH);
        Iterable $this$filterIsInstance$iv = this.getScenes();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FXGLScene)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FXGLScene it = (FXGLScene)((Object)element$iv);
            boolean bl = false;
            Viewport viewport = it.getViewport();
            Intrinsics.checkNotNullExpressionValue((Object)newW, (String)"newW");
            viewport.setWidth(newW);
            Viewport viewport2 = it.getViewport();
            Intrinsics.checkNotNullExpressionValue((Object)newH, (String)"newH");
            viewport2.setHeight(newH);
        }
    }

    @Override
    @NotNull
    public Image takeScreenshot() {
        return ImagesKt.toImage((Node)((Node)this.fxglPane));
    }

    @Override
    public void close() {
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void show$lambda$3(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void show$lambda$4(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    public static final /* synthetic */ void access$onStageResize(EmbeddedPaneWindow $this) {
        $this.onStageResize();
    }
}

