/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dev.profiling;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.ui.MDIWindow;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.collections.ObservableList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010 \u001a\u00020?J\u000e\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020\u0003R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0016\"\u0004\b)\u0010\u0018R\u001a\u0010*\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0016\"\u0004\b1\u0010\u0018R\u001a\u00102\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010$\"\u0004\b4\u0010&R\u001a\u00105\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0016\"\u0004\b7\u0010\u0018R\u000e\u00108\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00109\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u000e\"\u0004\b;\u0010\u0010R\u000e\u0010<\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00030>X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/almasb/fxgl/dev/profiling/ProfilerWindow;", "Lcom/almasb/fxgl/ui/MDIWindow;", "width", "", "height", "title", "", "(DDLjava/lang/String;)V", "allTimeHigh", "allTimeLow", "bgColor", "Ljavafx/scene/paint/Color;", "kotlin.jvm.PlatformType", "getBgColor", "()Ljavafx/scene/paint/Color;", "setBgColor", "(Ljavafx/scene/paint/Color;)V", "chartColor", "getChartColor", "setChartColor", "curValue", "getCurValue", "()D", "setCurValue", "(D)V", "durationX", "getDurationX", "setDurationX", "frames", "", "g", "Ljavafx/scene/canvas/GraphicsContext;", "log", "Lcom/almasb/fxgl/logging/Logger;", "maxBufferSize", "getMaxBufferSize", "()I", "setMaxBufferSize", "(I)V", "maxValue", "getMaxValue", "setMaxValue", "measuringUnitsName", "getMeasuringUnitsName", "()Ljava/lang/String;", "setMeasuringUnitsName", "(Ljava/lang/String;)V", "minValue", "getMinValue", "setMinValue", "numYTicks", "getNumYTicks", "setNumYTicks", "preferredMaxValue", "getPreferredMaxValue", "setPreferredMaxValue", "preferredUpdateCounter", "textColor", "getTextColor", "setTextColor", "totalValue", "valueBuffer", "Ljava/util/LinkedList;", "", "update", "value", "fxgl"})
@SourceDebugExtension(value={"SMAP\nProfilerWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerWindow.kt\ncom/almasb/fxgl/dev/profiling/ProfilerWindow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1855#2,2:173\n*S KotlinDebug\n*F\n+ 1 ProfilerWindow.kt\ncom/almasb/fxgl/dev/profiling/ProfilerWindow\n*L\n136#1:173,2\n*E\n"})
public final class ProfilerWindow
extends MDIWindow {
    @NotNull
    private final Logger log;
    @NotNull
    private final GraphicsContext g;
    @NotNull
    private String measuringUnitsName;
    private int numYTicks;
    private double durationX;
    private int maxBufferSize;
    @NotNull
    private final LinkedList<Double> valueBuffer;
    private double preferredMaxValue;
    private int preferredUpdateCounter;
    private double minValue;
    private double curValue;
    private double maxValue;
    private Color bgColor;
    private Color textColor;
    private Color chartColor;
    private double totalValue;
    private int frames;
    private double allTimeLow;
    private double allTimeHigh;

    public ProfilerWindow(double width, double height, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(null, 1, null);
        this.log = Logger.Companion.get(((Object)((Object)this)).getClass());
        this.measuringUnitsName = "";
        this.numYTicks = 10;
        this.durationX = 3.0;
        this.maxBufferSize = 180;
        this.valueBuffer = new LinkedList();
        this.bgColor = Color.color((double)0.25, (double)0.25, (double)0.25, (double)0.75);
        this.textColor = Color.WHITESMOKE;
        this.chartColor = Color.RED;
        this.frames = 1;
        this.allTimeLow = Double.MAX_VALUE;
        this.setCloseable(false);
        this.setMinimizable(true);
        this.setMovable(true);
        this.setManuallyResizable(false);
        this.setPrefSize(width, height);
        this.setTitle(title);
        Canvas canvas = new Canvas(width, height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsContext, (String)"canvas.graphicsContext2D");
        this.g = graphicsContext;
        ObservableList observableList = this.getContentPane().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"contentPane.children");
        ((Collection)observableList).add(canvas);
    }

    @NotNull
    public final String getMeasuringUnitsName() {
        return this.measuringUnitsName;
    }

    public final void setMeasuringUnitsName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.measuringUnitsName = string;
    }

    public final int getNumYTicks() {
        return this.numYTicks;
    }

    public final void setNumYTicks(int n) {
        this.numYTicks = n;
    }

    public final double getDurationX() {
        return this.durationX;
    }

    public final void setDurationX(double d) {
        this.durationX = d;
    }

    public final int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public final void setMaxBufferSize(int n) {
        this.maxBufferSize = n;
    }

    public final double getPreferredMaxValue() {
        return this.preferredMaxValue;
    }

    public final void setPreferredMaxValue(double d) {
        this.preferredMaxValue = d;
    }

    public final double getMinValue() {
        return this.minValue;
    }

    public final void setMinValue(double d) {
        this.minValue = d;
    }

    public final double getCurValue() {
        return this.curValue;
    }

    public final void setCurValue(double d) {
        this.curValue = d;
    }

    public final double getMaxValue() {
        return this.maxValue;
    }

    public final void setMaxValue(double d) {
        this.maxValue = d;
    }

    public final Color getBgColor() {
        return this.bgColor;
    }

    public final void setBgColor(Color color) {
        this.bgColor = color;
    }

    public final Color getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(Color color) {
        this.textColor = color;
    }

    public final Color getChartColor() {
        return this.chartColor;
    }

    public final void setChartColor(Color color) {
        this.chartColor = color;
    }

    public final void update(double value) {
        int n = this.frames;
        this.frames = n + 1;
        this.totalValue += value;
        this.valueBuffer.addLast(value);
        if (this.valueBuffer.size() > this.maxBufferSize) {
            this.valueBuffer.removeFirst();
        }
        if (value > this.maxValue) {
            this.maxValue = value;
        }
        if (value < this.minValue) {
            this.minValue = value;
        }
        if (value > this.allTimeHigh) {
            this.allTimeHigh = value;
        }
        if (value < this.allTimeLow) {
            this.allTimeLow = value;
        }
        if (this.maxValue > this.preferredMaxValue && value < this.preferredMaxValue) {
            n = this.preferredUpdateCounter;
            this.preferredUpdateCounter = n + 1;
            if (this.preferredUpdateCounter == 300) {
                this.maxValue = this.preferredMaxValue;
                this.preferredUpdateCounter = 0;
            }
        }
        this.g.setFill((Paint)this.bgColor);
        this.g.fillRect(0.0, 0.0, this.g.getCanvas().getWidth(), this.g.getCanvas().getHeight());
        this.g.setFill((Paint)this.textColor);
        this.g.setStroke((Paint)Color.web((String)"darkgray", (double)0.3));
        this.g.setLineWidth(1.0);
        double tickLength = (this.maxValue - this.minValue) * 1.0 / (double)this.numYTicks;
        for (int i = this.numYTicks; -1 < i; --i) {
            double tickValue = this.minValue + (double)i * tickLength;
            double y = FXGLMath.map((double)i, (double)this.numYTicks, (double)0.0, (double)15.0, (double)(this.g.getCanvas().getHeight() - (double)5));
            String string = "%.2f";
            Object[] objectArray = new Object[]{tickValue};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            this.g.fillText(string2, 0.0, y);
            this.g.strokeLine(0.0, y, this.g.getCanvas().getWidth(), y);
        }
        this.g.setStroke((Paint)this.chartColor);
        this.g.setLineWidth(2.0);
        double dx = (this.g.getCanvas().getWidth() - (double)30) / (double)this.maxBufferSize;
        double x = 0.0;
        x = 30.0;
        double lastX = 0.0;
        double lastY = 0.0;
        Iterable $this$forEach$iv = this.valueBuffer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double it = ((Number)element$iv).doubleValue();
            boolean bl = false;
            x += dx;
            double y = FXGLMath.map((double)it, (double)this.maxValue, (double)this.minValue, (double)15.0, (double)(this.g.getCanvas().getHeight() - (double)5));
            if (!(lastX == 0.0) && !(lastY == 0.0)) {
                this.g.strokeLine(lastX, lastY, x, y);
            }
            lastX = x;
            lastY = y;
        }
    }

    public final void log() {
        this.log.info("Profiler (" + this.getTitle() + ") - " + this.frames + " frames");
        this.log.info("Average: " + this.totalValue / (double)this.frames);
        this.log.info("Minimum: " + this.allTimeLow);
        this.log.info("Maximum: " + this.allTimeHigh);
    }
}

