/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import com.github.amlcurran.showcaseview.R;
import com.github.amlcurran.showcaseview.ShowcaseAreaCalculator;
import com.github.amlcurran.showcaseview.ShowcaseView;

class TextDrawer {
    private final TextPaint titlePaint;
    private final TextPaint textPaint;
    private final Context context;
    private final ShowcaseAreaCalculator calculator;
    private final float padding;
    private final float actionBarOffset;
    private CharSequence mTitle;
    private CharSequence mDetails;
    private float[] mBestTextPosition = new float[3];
    private DynamicLayout mDynamicTitleLayout;
    private DynamicLayout mDynamicDetailLayout;
    private TextAppearanceSpan mTitleSpan;
    private TextAppearanceSpan mDetailSpan;
    private boolean hasRecalculated;

    public TextDrawer(Resources resources, ShowcaseAreaCalculator calculator, Context context) {
        this.padding = resources.getDimension(R.dimen.text_padding);
        this.actionBarOffset = resources.getDimension(R.dimen.action_bar_offset);
        this.calculator = calculator;
        this.context = context;
        this.titlePaint = new TextPaint();
        this.titlePaint.setAntiAlias(true);
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
    }

    public void draw(Canvas canvas) {
        if (this.shouldDrawText()) {
            float[] textPosition = this.getBestTextPosition();
            if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
                canvas.save();
                if (this.hasRecalculated) {
                    this.mDynamicTitleLayout = new DynamicLayout(this.mTitle, this.titlePaint, (int)textPosition[2], Layout.Alignment.ALIGN_NORMAL, 1.0f, 1.0f, true);
                }
                if (this.mDynamicTitleLayout != null) {
                    canvas.translate(textPosition[0], textPosition[1]);
                    this.mDynamicTitleLayout.draw(canvas);
                    canvas.restore();
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.mDetails)) {
                float offsetForTitle;
                canvas.save();
                if (this.hasRecalculated) {
                    this.mDynamicDetailLayout = new DynamicLayout(this.mDetails, this.textPaint, (int)textPosition[2], Layout.Alignment.ALIGN_NORMAL, 1.2f, 1.0f, true);
                }
                float f = offsetForTitle = this.mDynamicTitleLayout != null ? (float)this.mDynamicTitleLayout.getHeight() : 0.0f;
                if (this.mDynamicDetailLayout != null) {
                    canvas.translate(textPosition[0], textPosition[1] + offsetForTitle);
                    this.mDynamicDetailLayout.draw(canvas);
                    canvas.restore();
                }
            }
        }
        this.hasRecalculated = false;
    }

    public void setContentText(CharSequence details) {
        if (details != null) {
            SpannableString ssbDetail = new SpannableString(details);
            ssbDetail.setSpan((Object)this.mDetailSpan, 0, ssbDetail.length(), 0);
            this.mDetails = ssbDetail;
        }
    }

    public void setContentTitle(CharSequence title) {
        if (title != null) {
            SpannableString ssbTitle = new SpannableString(title);
            ssbTitle.setSpan((Object)this.mTitleSpan, 0, ssbTitle.length(), 0);
            this.mTitle = ssbTitle;
        }
    }

    public void calculateTextPosition(int canvasW, int canvasH, ShowcaseView showcaseView, boolean shouldCentreText) {
        Rect showcase = showcaseView.hasShowcaseView() ? this.calculator.getShowcaseRect() : new Rect();
        int[] areas = new int[]{showcase.left * canvasH, showcase.top * canvasW, (canvasW - showcase.right) * canvasH, (canvasH - showcase.bottom) * canvasW};
        int largest = 0;
        for (int i = 1; i < areas.length; ++i) {
            if (areas[i] <= areas[largest]) continue;
            largest = i;
        }
        switch (largest) {
            case 0: {
                this.mBestTextPosition[0] = this.padding;
                this.mBestTextPosition[1] = this.padding;
                this.mBestTextPosition[2] = (float)showcase.left - 2.0f * this.padding;
                break;
            }
            case 1: {
                this.mBestTextPosition[0] = this.padding;
                this.mBestTextPosition[1] = this.padding + this.actionBarOffset;
                this.mBestTextPosition[2] = (float)canvasW - 2.0f * this.padding;
                break;
            }
            case 2: {
                this.mBestTextPosition[0] = (float)showcase.right + this.padding;
                this.mBestTextPosition[1] = this.padding;
                this.mBestTextPosition[2] = (float)(canvasW - showcase.right) - 2.0f * this.padding;
                break;
            }
            case 3: {
                this.mBestTextPosition[0] = this.padding;
                this.mBestTextPosition[1] = (float)showcase.bottom + this.padding;
                this.mBestTextPosition[2] = (float)canvasW - 2.0f * this.padding;
            }
        }
        if (shouldCentreText) {
            switch (largest) {
                case 0: 
                case 2: {
                    this.mBestTextPosition[1] = this.mBestTextPosition[1] + (float)(canvasH / 4);
                    break;
                }
                case 1: 
                case 3: {
                    this.mBestTextPosition[2] = this.mBestTextPosition[2] / 2.0f;
                    this.mBestTextPosition[0] = this.mBestTextPosition[0] + (float)(canvasW / 4);
                }
            }
        } else {
            switch (largest) {
                case 0: 
                case 2: {
                    this.mBestTextPosition[1] = this.mBestTextPosition[1] + this.actionBarOffset;
                }
            }
        }
        this.hasRecalculated = true;
    }

    public void setTitleStyling(int styleId) {
        this.mTitleSpan = new TextAppearanceSpan(this.context, styleId);
        this.setContentTitle(this.mTitle);
    }

    public void setDetailStyling(int styleId) {
        this.mDetailSpan = new TextAppearanceSpan(this.context, styleId);
        this.setContentText(this.mDetails);
    }

    public CharSequence getContentTitle() {
        return this.mTitle;
    }

    public CharSequence getContentText() {
        return this.mDetails;
    }

    public float[] getBestTextPosition() {
        return this.mBestTextPosition;
    }

    public boolean shouldDrawText() {
        return !TextUtils.isEmpty((CharSequence)this.mTitle) || !TextUtils.isEmpty((CharSequence)this.mDetails);
    }
}

