/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview.targets;

import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import java.lang.reflect.Field;

class ActionBarViewWrapper {
    private ViewParent mActionBarView;
    private Class mActionBarViewClass;
    private Class mAbsActionBarViewClass;

    public ActionBarViewWrapper(ViewParent actionBarView) {
        if (!actionBarView.getClass().getName().contains("ActionBarView")) {
            String previousP = actionBarView.getClass().getName();
            actionBarView = actionBarView.getParent();
            String throwP = actionBarView.getClass().getName();
            if (!actionBarView.getClass().getName().contains("ActionBarView")) {
                throw new IllegalStateException("Cannot find ActionBarView for Activity, instead found " + previousP + " and " + throwP);
            }
        }
        this.mActionBarView = actionBarView;
        this.mActionBarViewClass = actionBarView.getClass();
        this.mAbsActionBarViewClass = actionBarView.getClass().getSuperclass();
    }

    public View getSpinnerView() {
        try {
            Field spinnerField = this.mActionBarViewClass.getDeclaredField("mSpinner");
            spinnerField.setAccessible(true);
            return (View)spinnerField.get(this.mActionBarView);
        }
        catch (NoSuchFieldException e) {
            Log.e((String)"TAG", (String)"Failed to find actionbar spinner", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)"TAG", (String)"Failed to access actionbar spinner", (Throwable)e);
        }
        return null;
    }

    public View getTitleView() {
        try {
            Field mTitleViewField = this.mActionBarViewClass.getDeclaredField("mTitleView");
            mTitleViewField.setAccessible(true);
            return (View)mTitleViewField.get(this.mActionBarView);
        }
        catch (NoSuchFieldException e) {
            Log.e((String)"TAG", (String)"Failed to find actionbar title", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)"TAG", (String)"Failed to access actionbar title", (Throwable)e);
        }
        return null;
    }

    public View getOverflowView() {
        try {
            Field actionMenuPresenterField = this.mAbsActionBarViewClass.getDeclaredField("mActionMenuPresenter");
            actionMenuPresenterField.setAccessible(true);
            Object actionMenuPresenter = actionMenuPresenterField.get(this.mActionBarView);
            Field overflowButtonField = actionMenuPresenter.getClass().getDeclaredField("mOverflowButton");
            overflowButtonField.setAccessible(true);
            return (View)overflowButtonField.get(actionMenuPresenter);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public View getActionItem(int actionItemId) {
        try {
            Object[] mChs;
            Field actionMenuPresenterField = this.mAbsActionBarViewClass.getDeclaredField("mActionMenuPresenter");
            actionMenuPresenterField.setAccessible(true);
            Object actionMenuPresenter = actionMenuPresenterField.get(this.mActionBarView);
            Field menuViewField = actionMenuPresenter.getClass().getSuperclass().getDeclaredField("mMenuView");
            menuViewField.setAccessible(true);
            Object menuView = menuViewField.get(actionMenuPresenter);
            Field mChField = menuView.getClass().toString().contains("com.actionbarsherlock") ? menuView.getClass().getSuperclass().getSuperclass().getSuperclass().getSuperclass().getDeclaredField("mChildren") : (menuView.getClass().toString().contains("android.support.v7") ? menuView.getClass().getSuperclass().getSuperclass().getSuperclass().getDeclaredField("mChildren") : menuView.getClass().getSuperclass().getSuperclass().getDeclaredField("mChildren"));
            mChField.setAccessible(true);
            for (Object mCh : mChs = (Object[])mChField.get(menuView)) {
                View v;
                if (mCh == null || (v = (View)mCh).getId() != actionItemId) continue;
                return v;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }
}

