/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Point;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.github.amlcurran.showcaseview.AnimationFactory;
import com.github.amlcurran.showcaseview.ShowcaseView;

class AnimatorAnimationFactory
implements AnimationFactory {
    private static final String ALPHA = "alpha";
    private static final float INVISIBLE = 0.0f;
    private static final float VISIBLE = 1.0f;
    private final AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();

    @Override
    public void fadeInView(View target, long duration, final AnimationFactory.AnimationStartListener listener) {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)target, (String)ALPHA, (float[])new float[]{0.0f, 1.0f});
        oa.setDuration(duration).addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                listener.onAnimationStart();
            }

            public void onAnimationEnd(Animator animator) {
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        oa.start();
    }

    @Override
    public void fadeOutView(View target, long duration, final AnimationFactory.AnimationEndListener listener) {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)target, (String)ALPHA, (float[])new float[]{0.0f});
        oa.setDuration(duration).addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                listener.onAnimationEnd();
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        oa.start();
    }

    @Override
    public void animateTargetToPoint(ShowcaseView showcaseView, Point point) {
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator xAnimator = ObjectAnimator.ofInt((Object)showcaseView, (String)"showcaseX", (int[])new int[]{point.x});
        ObjectAnimator yAnimator = ObjectAnimator.ofInt((Object)showcaseView, (String)"showcaseY", (int[])new int[]{point.y});
        set.playTogether(new Animator[]{xAnimator, yAnimator});
        set.setInterpolator((TimeInterpolator)this.interpolator);
        set.start();
    }
}

