/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import com.github.amlcurran.showcaseview.R;
import com.github.amlcurran.showcaseview.ShowcaseDrawer;

class StandardShowcaseDrawer
implements ShowcaseDrawer {
    protected final Paint eraserPaint;
    protected final Drawable showcaseDrawable;
    private final Paint basicPaint;
    private final float showcaseRadius;
    protected int backgroundColour;

    public StandardShowcaseDrawer(Resources resources) {
        PorterDuffXfermode xfermode = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
        this.eraserPaint = new Paint();
        this.eraserPaint.setColor(0xFFFFFF);
        this.eraserPaint.setAlpha(0);
        this.eraserPaint.setXfermode((Xfermode)xfermode);
        this.eraserPaint.setAntiAlias(true);
        this.basicPaint = new Paint();
        this.showcaseRadius = resources.getDimension(R.dimen.showcase_radius);
        this.showcaseDrawable = resources.getDrawable(R.drawable.cling_bleached);
    }

    @Override
    public void setShowcaseColour(int color) {
        this.showcaseDrawable.setColorFilter(color, PorterDuff.Mode.MULTIPLY);
    }

    @Override
    public void drawShowcase(Bitmap buffer, float x, float y, float scaleMultiplier) {
        Canvas bufferCanvas = new Canvas(buffer);
        bufferCanvas.drawCircle(x, y, this.showcaseRadius, this.eraserPaint);
        int halfW = this.getShowcaseWidth() / 2;
        int halfH = this.getShowcaseHeight() / 2;
        int left = (int)(x - (float)halfW);
        int top = (int)(y - (float)halfH);
        this.showcaseDrawable.setBounds(left, top, left + this.getShowcaseWidth(), top + this.getShowcaseHeight());
        this.showcaseDrawable.draw(bufferCanvas);
    }

    @Override
    public int getShowcaseWidth() {
        return this.showcaseDrawable.getIntrinsicWidth();
    }

    @Override
    public int getShowcaseHeight() {
        return this.showcaseDrawable.getIntrinsicHeight();
    }

    @Override
    public float getBlockedRadius() {
        return this.showcaseRadius;
    }

    @Override
    public void setBackgroundColour(int backgroundColor) {
        this.backgroundColour = backgroundColor;
    }

    @Override
    public void erase(Bitmap bitmapBuffer) {
        bitmapBuffer.eraseColor(this.backgroundColour);
    }

    @Override
    public void drawToCanvas(Canvas canvas, Bitmap bitmapBuffer) {
        canvas.drawBitmap(bitmapBuffer, 0.0f, 0.0f, this.basicPaint);
    }
}

