/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import com.github.amlcurran.showcaseview.R;
import com.github.amlcurran.showcaseview.ShowcaseDrawer;

public class MaterialShowcaseDrawer
implements ShowcaseDrawer {
    private final float radius;
    private final Paint basicPaint;
    private final Paint eraserPaint;
    private int backgroundColor;

    public MaterialShowcaseDrawer(Resources resources) {
        this.radius = resources.getDimension(R.dimen.showcase_radius_material);
        this.eraserPaint = new Paint();
        this.eraserPaint.setColor(0xFFFFFF);
        this.eraserPaint.setAlpha(0);
        this.eraserPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY));
        this.eraserPaint.setAntiAlias(true);
        this.basicPaint = new Paint();
    }

    @Override
    public void setShowcaseColour(int color) {
    }

    @Override
    public void drawShowcase(Bitmap buffer, float x, float y, float scaleMultiplier) {
        Canvas bufferCanvas = new Canvas(buffer);
        bufferCanvas.drawCircle(x, y, this.radius, this.eraserPaint);
    }

    @Override
    public int getShowcaseWidth() {
        return (int)(this.radius * 2.0f);
    }

    @Override
    public int getShowcaseHeight() {
        return (int)(this.radius * 2.0f);
    }

    @Override
    public float getBlockedRadius() {
        return this.radius;
    }

    @Override
    public void setBackgroundColour(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void erase(Bitmap bitmapBuffer) {
        bitmapBuffer.eraseColor(this.backgroundColor);
    }

    @Override
    public void drawToCanvas(Canvas canvas, Bitmap bitmapBuffer) {
        canvas.drawBitmap(bitmapBuffer, 0.0f, 0.0f, this.basicPaint);
    }
}

