/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.github.amlcurran.showcaseview.R;
import com.github.amlcurran.showcaseview.StandardShowcaseDrawer;

class NewShowcaseDrawer
extends StandardShowcaseDrawer {
    private static final int ALPHA_60_PERCENT = 153;
    private final float outerRadius;
    private final float innerRadius;

    public NewShowcaseDrawer(Resources resources) {
        super(resources);
        this.outerRadius = resources.getDimension(R.dimen.showcase_radius_outer);
        this.innerRadius = resources.getDimension(R.dimen.showcase_radius_inner);
    }

    @Override
    public void setShowcaseColour(int color) {
        this.eraserPaint.setColor(color);
    }

    @Override
    public void drawShowcase(Bitmap buffer, float x, float y, float scaleMultiplier) {
        Canvas bufferCanvas = new Canvas(buffer);
        this.eraserPaint.setAlpha(153);
        bufferCanvas.drawCircle(x, y, this.outerRadius, this.eraserPaint);
        this.eraserPaint.setAlpha(0);
        bufferCanvas.drawCircle(x, y, this.innerRadius, this.eraserPaint);
    }

    @Override
    public int getShowcaseWidth() {
        return (int)(this.outerRadius * 2.0f);
    }

    @Override
    public int getShowcaseHeight() {
        return (int)(this.outerRadius * 2.0f);
    }

    @Override
    public float getBlockedRadius() {
        return this.innerRadius;
    }

    @Override
    public void setBackgroundColour(int backgroundColor) {
        this.backgroundColour = backgroundColor;
    }
}

