/*
 * Decompiled with CFR 0.152.
 */
package com.github.amlcurran.showcaseview;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.RelativeLayout;
import com.github.amlcurran.showcaseview.AnimationFactory;
import com.github.amlcurran.showcaseview.AnimatorAnimationFactory;
import com.github.amlcurran.showcaseview.ApiUtils;
import com.github.amlcurran.showcaseview.MaterialShowcaseDrawer;
import com.github.amlcurran.showcaseview.NewShowcaseDrawer;
import com.github.amlcurran.showcaseview.OnShowcaseEventListener;
import com.github.amlcurran.showcaseview.R;
import com.github.amlcurran.showcaseview.ShotStateStore;
import com.github.amlcurran.showcaseview.ShowcaseAreaCalculator;
import com.github.amlcurran.showcaseview.ShowcaseDrawer;
import com.github.amlcurran.showcaseview.ShowcaseViewApi;
import com.github.amlcurran.showcaseview.StandardShowcaseDrawer;
import com.github.amlcurran.showcaseview.TextDrawer;
import com.github.amlcurran.showcaseview.targets.Target;

public class ShowcaseView
extends RelativeLayout
implements View.OnTouchListener,
ShowcaseViewApi {
    private static final int HOLO_BLUE = Color.parseColor((String)"#33B5E5");
    public static final int UNDEFINED = -1;
    public static final int LEFT_OF_SHOWCASE = 0;
    public static final int RIGHT_OF_SHOWCASE = 2;
    public static final int ABOVE_SHOWCASE = 1;
    public static final int BELOW_SHOWCASE = 3;
    private Button mEndButton;
    private final TextDrawer textDrawer;
    private ShowcaseDrawer showcaseDrawer;
    private final ShowcaseAreaCalculator showcaseAreaCalculator;
    private final AnimationFactory animationFactory;
    private final ShotStateStore shotStateStore;
    private int showcaseX = -1;
    private int showcaseY = -1;
    private float scaleMultiplier = 1.0f;
    private boolean hasCustomClickListener = false;
    private boolean blockTouches = true;
    private boolean hideOnTouch = false;
    private OnShowcaseEventListener mEventListener = OnShowcaseEventListener.NONE;
    private boolean hasAlteredText = false;
    private boolean hasNoTarget = false;
    private boolean shouldCentreText;
    private Bitmap bitmapBuffer;
    private long fadeInMillis;
    private long fadeOutMillis;
    private boolean isShowing;
    private int backgroundColor;
    private int showcaseColor;
    private boolean blockAllTouches;
    private View.OnClickListener hideOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            ShowcaseView.this.hide();
        }
    };

    protected ShowcaseView(Context context, boolean newStyle) {
        this(context, null, R.styleable.CustomTheme_showcaseViewStyle, newStyle);
    }

    protected ShowcaseView(Context context, AttributeSet attrs, int defStyle, boolean newStyle) {
        super(context, attrs, defStyle);
        ApiUtils apiUtils = new ApiUtils();
        this.animationFactory = new AnimatorAnimationFactory();
        this.showcaseAreaCalculator = new ShowcaseAreaCalculator();
        this.shotStateStore = new ShotStateStore(context);
        apiUtils.setFitsSystemWindowsCompat((View)this);
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)new CalculateTextOnPreDraw());
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new UpdateOnGlobalLayout());
        TypedArray styled = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ShowcaseView, R.attr.showcaseViewStyle, R.style.ShowcaseView);
        this.fadeInMillis = this.getResources().getInteger(0x10E0001);
        this.fadeOutMillis = this.getResources().getInteger(0x10E0001);
        this.mEndButton = (Button)LayoutInflater.from((Context)context).inflate(R.layout.showcase_button, null);
        this.showcaseDrawer = newStyle ? new NewShowcaseDrawer(this.getResources()) : new StandardShowcaseDrawer(this.getResources());
        this.textDrawer = new TextDrawer(this.getResources(), this.showcaseAreaCalculator, this.getContext());
        this.updateStyle(styled, false);
        this.init();
    }

    private void init() {
        this.setOnTouchListener(this);
        if (this.mEndButton.getParent() == null) {
            int margin = (int)this.getResources().getDimension(R.dimen.button_margin);
            RelativeLayout.LayoutParams lps = (RelativeLayout.LayoutParams)this.generateDefaultLayoutParams();
            lps.addRule(12);
            lps.addRule(11);
            lps.setMargins(margin, margin, margin, margin);
            this.mEndButton.setLayoutParams((ViewGroup.LayoutParams)lps);
            this.mEndButton.setText(17039370);
            if (!this.hasCustomClickListener) {
                this.mEndButton.setOnClickListener(this.hideOnClickListener);
            }
            this.addView((View)this.mEndButton);
        }
    }

    private boolean hasShot() {
        return this.shotStateStore.hasShot();
    }

    void setShowcasePosition(Point point) {
        this.setShowcasePosition(point.x, point.y);
    }

    void setShowcasePosition(int x, int y) {
        if (this.shotStateStore.hasShot()) {
            return;
        }
        this.showcaseX = x;
        this.showcaseY = y;
        this.invalidate();
    }

    public void setTarget(Target target) {
        this.setShowcase(target, false);
    }

    public void setShowcase(final Target target, final boolean animate) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!ShowcaseView.this.shotStateStore.hasShot()) {
                    ShowcaseView.this.updateBitmap();
                    Point targetPoint = target.getPoint();
                    if (targetPoint != null) {
                        ShowcaseView.this.hasNoTarget = false;
                        if (animate) {
                            ShowcaseView.this.animationFactory.animateTargetToPoint(ShowcaseView.this, targetPoint);
                        } else {
                            ShowcaseView.this.setShowcasePosition(targetPoint);
                        }
                    } else {
                        ShowcaseView.this.hasNoTarget = true;
                        ShowcaseView.this.invalidate();
                    }
                }
            }
        }, 100L);
    }

    private void updateBitmap() {
        if (this.bitmapBuffer == null || this.haveBoundsChanged()) {
            if (this.bitmapBuffer != null) {
                this.bitmapBuffer.recycle();
            }
            this.bitmapBuffer = Bitmap.createBitmap((int)this.getMeasuredWidth(), (int)this.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    private boolean haveBoundsChanged() {
        return this.getMeasuredWidth() != this.bitmapBuffer.getWidth() || this.getMeasuredHeight() != this.bitmapBuffer.getHeight();
    }

    public boolean hasShowcaseView() {
        return this.showcaseX != 1000000 && this.showcaseY != 1000000 && !this.hasNoTarget;
    }

    public void setShowcaseX(int x) {
        this.setShowcasePosition(x, this.showcaseY);
    }

    public void setShowcaseY(int y) {
        this.setShowcasePosition(this.showcaseX, y);
    }

    public int getShowcaseX() {
        return this.showcaseX;
    }

    public int getShowcaseY() {
        return this.showcaseY;
    }

    public void overrideButtonClick(View.OnClickListener listener) {
        if (this.shotStateStore.hasShot()) {
            return;
        }
        if (this.mEndButton != null) {
            if (listener != null) {
                this.mEndButton.setOnClickListener(listener);
            } else {
                this.mEndButton.setOnClickListener(this.hideOnClickListener);
            }
        }
        this.hasCustomClickListener = true;
    }

    public void setOnShowcaseEventListener(OnShowcaseEventListener listener) {
        this.mEventListener = listener != null ? listener : OnShowcaseEventListener.NONE;
    }

    public void setButtonText(CharSequence text) {
        if (this.mEndButton != null) {
            this.mEndButton.setText(text);
        }
    }

    private void recalculateText() {
        boolean recalculateText;
        boolean recalculatedCling = this.showcaseAreaCalculator.calculateShowcaseRect(this.showcaseX, this.showcaseY, this.showcaseDrawer);
        boolean bl = recalculateText = recalculatedCling || this.hasAlteredText;
        if (recalculateText) {
            this.textDrawer.calculateTextPosition(this.getMeasuredWidth(), this.getMeasuredHeight(), this, this.shouldCentreText);
        }
        this.hasAlteredText = false;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.showcaseX < 0 || this.showcaseY < 0 || this.shotStateStore.hasShot() || this.bitmapBuffer == null) {
            super.dispatchDraw(canvas);
            return;
        }
        this.showcaseDrawer.erase(this.bitmapBuffer);
        if (!this.hasNoTarget) {
            this.showcaseDrawer.drawShowcase(this.bitmapBuffer, this.showcaseX, this.showcaseY, this.scaleMultiplier);
            this.showcaseDrawer.drawToCanvas(canvas, this.bitmapBuffer);
        }
        this.textDrawer.draw(canvas);
        super.dispatchDraw(canvas);
    }

    @Override
    public void hide() {
        this.clearBitmap();
        this.shotStateStore.storeShot();
        this.mEventListener.onShowcaseViewHide(this);
        this.fadeOutShowcase();
    }

    private void clearBitmap() {
        if (this.bitmapBuffer != null && !this.bitmapBuffer.isRecycled()) {
            this.bitmapBuffer.recycle();
            this.bitmapBuffer = null;
        }
    }

    private void fadeOutShowcase() {
        this.animationFactory.fadeOutView((View)this, this.fadeOutMillis, new AnimationFactory.AnimationEndListener(){

            @Override
            public void onAnimationEnd() {
                ShowcaseView.this.setVisibility(8);
                ShowcaseView.this.isShowing = false;
                ShowcaseView.this.mEventListener.onShowcaseViewDidHide(ShowcaseView.this);
            }
        });
    }

    @Override
    public void show() {
        this.isShowing = true;
        this.mEventListener.onShowcaseViewShow(this);
        this.fadeInShowcase();
    }

    private void fadeInShowcase() {
        this.animationFactory.fadeInView((View)this, this.fadeInMillis, new AnimationFactory.AnimationStartListener(){

            @Override
            public void onAnimationStart() {
                ShowcaseView.this.setVisibility(0);
            }
        });
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.blockAllTouches) {
            return true;
        }
        float xDelta = Math.abs(motionEvent.getRawX() - (float)this.showcaseX);
        float yDelta = Math.abs(motionEvent.getRawY() - (float)this.showcaseY);
        double distanceFromFocus = Math.sqrt(Math.pow(xDelta, 2.0) + Math.pow(yDelta, 2.0));
        if (1 == motionEvent.getAction() && this.hideOnTouch && distanceFromFocus > (double)this.showcaseDrawer.getBlockedRadius()) {
            this.hide();
            return true;
        }
        return this.blockTouches && distanceFromFocus > (double)this.showcaseDrawer.getBlockedRadius();
    }

    private static void insertShowcaseView(ShowcaseView showcaseView, ViewGroup parent, int parentIndex) {
        parent.addView((View)showcaseView, parentIndex);
        if (!showcaseView.hasShot()) {
            showcaseView.show();
        } else {
            showcaseView.hideImmediate();
        }
    }

    private void hideImmediate() {
        this.isShowing = false;
        this.setVisibility(8);
    }

    @Override
    public void setContentTitle(CharSequence title) {
        this.textDrawer.setContentTitle(title);
    }

    @Override
    public void setContentText(CharSequence text) {
        this.textDrawer.setContentText(text);
    }

    private void setScaleMultiplier(float scaleMultiplier) {
        this.scaleMultiplier = scaleMultiplier;
    }

    public void hideButton() {
        this.mEndButton.setVisibility(8);
    }

    public void showButton() {
        this.mEndButton.setVisibility(0);
    }

    private void setEndButton(Button button) {
        RelativeLayout.LayoutParams copyParams = (RelativeLayout.LayoutParams)this.mEndButton.getLayoutParams();
        this.mEndButton.setOnClickListener(null);
        this.removeView((View)this.mEndButton);
        this.mEndButton = button;
        button.setOnClickListener(this.hideOnClickListener);
        button.setLayoutParams((ViewGroup.LayoutParams)copyParams);
        this.addView((View)button);
    }

    private void setShowcaseDrawer(ShowcaseDrawer showcaseDrawer) {
        this.showcaseDrawer = showcaseDrawer;
        this.showcaseDrawer.setBackgroundColour(this.backgroundColor);
        this.showcaseDrawer.setShowcaseColour(this.showcaseColor);
        this.hasAlteredText = true;
        this.invalidate();
    }

    private void setContentTitlePaint(TextPaint textPaint) {
        this.textDrawer.setTitlePaint(textPaint);
        this.hasAlteredText = true;
        this.invalidate();
    }

    private void setContentTextPaint(TextPaint paint) {
        this.textDrawer.setContentPaint(paint);
        this.hasAlteredText = true;
        this.invalidate();
    }

    public void setShouldCentreText(boolean shouldCentreText) {
        this.shouldCentreText = shouldCentreText;
        this.hasAlteredText = true;
        this.invalidate();
    }

    private void setSingleShot(long shotId) {
        this.shotStateStore.setSingleShot(shotId);
    }

    @Override
    public void setButtonPosition(RelativeLayout.LayoutParams layoutParams) {
        this.mEndButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setDetailTextAlignment(Layout.Alignment textAlignment) {
        this.textDrawer.setDetailTextAlignment(textAlignment);
        this.hasAlteredText = true;
        this.invalidate();
    }

    public void setTitleTextAlignment(Layout.Alignment textAlignment) {
        this.textDrawer.setTitleTextAlignment(textAlignment);
        this.hasAlteredText = true;
        this.invalidate();
    }

    private void setFadeDurations(long fadeInMillis, long fadeOutMillis) {
        this.fadeInMillis = fadeInMillis;
        this.fadeOutMillis = fadeOutMillis;
    }

    public void forceTextPosition(int textPosition) {
        this.textDrawer.forceTextPosition(textPosition);
        this.hasAlteredText = true;
        this.invalidate();
    }

    @Override
    public void setHideOnTouchOutside(boolean hideOnTouch) {
        this.hideOnTouch = hideOnTouch;
    }

    @Override
    public void setBlocksTouches(boolean blockTouches) {
        this.blockTouches = blockTouches;
    }

    private void setBlockAllTouches(boolean blockAllTouches) {
        this.blockAllTouches = blockAllTouches;
    }

    @Override
    public void setStyle(int theme) {
        TypedArray array = this.getContext().obtainStyledAttributes(theme, R.styleable.ShowcaseView);
        this.updateStyle(array, true);
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    private void updateStyle(TypedArray styled, boolean invalidate) {
        this.backgroundColor = styled.getColor(R.styleable.ShowcaseView_sv_backgroundColor, Color.argb((int)128, (int)80, (int)80, (int)80));
        this.showcaseColor = styled.getColor(R.styleable.ShowcaseView_sv_showcaseColor, HOLO_BLUE);
        String buttonText = styled.getString(R.styleable.ShowcaseView_sv_buttonText);
        if (TextUtils.isEmpty((CharSequence)buttonText)) {
            buttonText = this.getResources().getString(17039370);
        }
        boolean tintButton = styled.getBoolean(R.styleable.ShowcaseView_sv_tintButtonColor, true);
        int titleTextAppearance = styled.getResourceId(R.styleable.ShowcaseView_sv_titleTextAppearance, R.style.TextAppearance_ShowcaseView_Title);
        int detailTextAppearance = styled.getResourceId(R.styleable.ShowcaseView_sv_detailTextAppearance, R.style.TextAppearance_ShowcaseView_Detail);
        styled.recycle();
        this.showcaseDrawer.setShowcaseColour(this.showcaseColor);
        this.showcaseDrawer.setBackgroundColour(this.backgroundColor);
        this.tintButton(this.showcaseColor, tintButton);
        this.mEndButton.setText((CharSequence)buttonText);
        this.textDrawer.setTitleStyling(titleTextAppearance);
        this.textDrawer.setDetailStyling(detailTextAppearance);
        this.hasAlteredText = true;
        if (invalidate) {
            this.invalidate();
        }
    }

    private void tintButton(int showcaseColor, boolean tintButton) {
        if (tintButton) {
            this.mEndButton.getBackground().setColorFilter(showcaseColor, PorterDuff.Mode.MULTIPLY);
        } else {
            this.mEndButton.getBackground().setColorFilter(HOLO_BLUE, PorterDuff.Mode.MULTIPLY);
        }
    }

    private class CalculateTextOnPreDraw
    implements ViewTreeObserver.OnPreDrawListener {
        private CalculateTextOnPreDraw() {
        }

        public boolean onPreDraw() {
            ShowcaseView.this.recalculateText();
            return true;
        }
    }

    private class UpdateOnGlobalLayout
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private UpdateOnGlobalLayout() {
        }

        public void onGlobalLayout() {
            if (!ShowcaseView.this.shotStateStore.hasShot()) {
                ShowcaseView.this.updateBitmap();
            }
        }
    }

    public static class Builder {
        final ShowcaseView showcaseView;
        private final Activity activity;
        private ViewGroup parent;
        private int parentIndex;

        public Builder(Activity activity) {
            this(activity, false);
        }

        @Deprecated
        public Builder(Activity activity, boolean useNewStyle) {
            this.activity = activity;
            this.showcaseView = new ShowcaseView((Context)activity, useNewStyle);
            this.showcaseView.setTarget(Target.NONE);
            this.parent = (ViewGroup)activity.getWindow().getDecorView();
            this.parentIndex = -1;
        }

        public ShowcaseView build() {
            ShowcaseView.insertShowcaseView(this.showcaseView, this.parent, this.parentIndex);
            return this.showcaseView;
        }

        public Builder withHoloShowcase() {
            return this.setShowcaseDrawer(new StandardShowcaseDrawer(this.activity.getResources()));
        }

        public Builder withNewStyleShowcase() {
            return this.setShowcaseDrawer(new NewShowcaseDrawer(this.activity.getResources()));
        }

        public Builder withMaterialShowcase() {
            return this.setShowcaseDrawer(new MaterialShowcaseDrawer(this.activity.getResources()));
        }

        public Builder setShowcaseDrawer(ShowcaseDrawer showcaseDrawer) {
            this.showcaseView.setShowcaseDrawer(showcaseDrawer);
            return this;
        }

        public Builder setContentTitle(int resId) {
            return this.setContentTitle(this.activity.getString(resId));
        }

        public Builder setContentTitle(CharSequence title) {
            this.showcaseView.setContentTitle(title);
            return this;
        }

        public Builder setContentText(int resId) {
            return this.setContentText(this.activity.getString(resId));
        }

        public Builder setContentText(CharSequence text) {
            this.showcaseView.setContentText(text);
            return this;
        }

        public Builder setTarget(Target target) {
            this.showcaseView.setTarget(target);
            return this;
        }

        public Builder setStyle(int theme) {
            this.showcaseView.setStyle(theme);
            return this;
        }

        public Builder setOnClickListener(View.OnClickListener onClickListener) {
            this.showcaseView.overrideButtonClick(onClickListener);
            return this;
        }

        public Builder doNotBlockTouches() {
            this.showcaseView.setBlocksTouches(false);
            return this;
        }

        public Builder hideOnTouchOutside() {
            this.showcaseView.setBlocksTouches(true);
            this.showcaseView.setHideOnTouchOutside(true);
            return this;
        }

        public Builder singleShot(long shotId) {
            this.showcaseView.setSingleShot(shotId);
            return this;
        }

        public Builder setShowcaseEventListener(OnShowcaseEventListener showcaseEventListener) {
            this.showcaseView.setOnShowcaseEventListener(showcaseEventListener);
            return this;
        }

        public Builder setParent(ViewGroup parent, int index) {
            this.parent = parent;
            this.parentIndex = index;
            return this;
        }

        public Builder setContentTextPaint(TextPaint textPaint) {
            this.showcaseView.setContentTextPaint(textPaint);
            return this;
        }

        public Builder setContentTitlePaint(TextPaint textPaint) {
            this.showcaseView.setContentTitlePaint(textPaint);
            return this;
        }

        public Builder replaceEndButton(Button button) {
            this.showcaseView.setEndButton(button);
            return this;
        }

        public Builder replaceEndButton(int buttonResourceId) {
            View view = LayoutInflater.from((Context)this.activity).inflate(buttonResourceId, (ViewGroup)this.showcaseView, false);
            if (!(view instanceof Button)) {
                throw new IllegalArgumentException("Attempted to replace showcase button with a layout which isn't a button");
            }
            return this.replaceEndButton((Button)view);
        }

        public Builder blockAllTouches() {
            this.showcaseView.setBlockAllTouches(true);
            return this;
        }
    }
}

